#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/utsname.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include "config.h"

static int sock;
extern char *basename __P((__const char *__name));

#ifndef TRUE
#define TRUE 1
#define FALSE (!TRUE)
#endif

char hostname[]="";
char compinfo[]=C_HOST;
char comptime[]=C_TIME;
char compuser[]=C_USER;
char wait_for_host=FALSE;
char opt_error=FALSE;
char first=FALSE;
char errorlevel=0;
int rettime=RETRYTIME;
char ownhostname[_SYS_NMLN];
size_t ownhostnamelength;
int i;
struct sockaddr_in addr;
struct hostent *hp;
struct utsname unamebuf;


int main(int argc, char *argv[])
{
	argv[0]=basename(argv[0]);
	for(i=1; i!=argc; i++) {
		if(!strcmp(argv[i], "--help")) {
			printf("\n  %s rev. 1.0 by Andreas H. Mueller in 1997.\n", argv[0]);
			printf("  Configured on %s,\n  %s by %s", compinfo, comptime, compuser);
#ifdef CONF_DEBUG
			printf(" with debug informations enabled.\n");
#else
			printf(".\n");
#endif
			printf("\n\n  Usage : %s [-w] <HOSTNAME> | <--help>\n\n", argv[0]);
			printf("   %s can be used to look for a host running the corresponding daemon.\n", argv[0]);
			printf("  %s works completely silent. If something goes wrong it wants to complain\n", argv[0]);
			printf("  about it uses stderr, except from this output.\n");
			printf("   The option -w tells %s to wait until the corresponding daemon on\n", argv[0]);
			printf("  <HOSTNAME> responds.\n\n");
			printf("   %s returns the following error-codes:\n\n", argv[0]);
			printf("    1 : Help called.			 16 : Socket open failed.\n");
			printf("    2 : Unknown option(s).		 32 : Bind socket failed.\n");
			printf("    4 : Hostname missed.		 64 : connect failed.\n");
			printf("    8 : Unknown host.			128 : <HOSTNAME> was localhost.\n\n");
			printf("   A failed connect means that <HOSTNAME> is not running the corresponding\n");
			printf("  daemon or that <HOSTNAME> is currently down.\n\n");
			return(1);
		}
		else
		{
			if(!strcmp(argv[i], "-w")) {
#ifdef CONF_DEBUG
				fprintf(stderr, "%s: DEBUG: wait_for_host=TRUE.\n", argv[0]);
#endif
				wait_for_host=TRUE;
			}
			else
			{
				if(!strcmp(argv[i], "-RN")) {
					printf("  The original name of this tool is sping, the revision is 1.0.\n");
					return(-1);
				}
				else
				{
					if(memcmp(argv[i], "-", 1)) {
						strcpy(hostname, argv[i]);
					}
					else
					{
						fprintf(stderr, "%s: Error: unrecognized option \"%s\"\n%s: Error: Try %s --help for usage information.\n", argv[0], argv[i], argv[0], argv[0]);
						opt_error=TRUE;
					}
				}
			}
		}
	}
	if(opt_error) {
		exit(2);
	}
	if(strcmp(hostname, "")==0) {
		fprintf(stderr, "%s: Error: need a hostname.\n", argv[0]);
		exit(4);
	}
	if((hp=gethostbyname(hostname))) {
		memcpy((char *)&addr.sin_addr, (char *)hp->h_addr, (size_t)hp->h_length);
		addr.sin_port=htons(PORT);
	}
	else {
		fprintf(stderr, "%s: Error: unknown host %s\n", argv[0], hostname);
		exit(8);
	}
	uname(&unamebuf);
	strcpy(ownhostname, strcat(strcat(unamebuf.nodename, "."), unamebuf.domainname));
#ifdef CONF_DEBUG
	fprintf(stderr, "%s: DEBUG: running at host %s.\n", argv[0], ownhostname);
	fprintf(stderr, "%s: DEBUG: should connect to %s.\n", argv[0], ((char *)hp->h_name));
#endif
	if(!strcmp(((char *)hp->h_name), unamebuf.nodename)) {
		fprintf(stderr, "%s: Error: unable to search for myself.\n", argv[0]);
		exit(128);
	}
	while(TRUE) {	
		if((sock=socket(AF_INET, SOCK_STREAM, 0))<0) {
			fprintf(stderr, "%s: Error: unable to open socket.\n", argv[0]);
			exit(16);
		}
		addr.sin_family=AF_INET;
		addr.sin_port=htons(0);
		addr.sin_addr.s_addr=htonl(0);
		i=sizeof addr;
		if(bind(sock, (struct sockaddr *)(&addr), i)<0) {
			fprintf(stderr, "%s: Error: unable to bind socket.\n", argv[0]);
			exit(32);
		}
			memcpy((char *)&addr.sin_addr, (char *)hp->h_addr, (size_t)hp->h_length);
			addr.sin_port=htons(PORT);
		if(connect(sock, (struct sockaddr *)(&addr), i)<0) {
			if(!wait_for_host) {
				fprintf(stderr, "%s: Error: connect failed.\n", argv[0]);
#ifdef CONF_DEBUG
				fprintf(stderr, "%s: DEBUG: exit(64) from single-run.\n", argv[0]);
#endif
				shutdown(sock, 2);
				close(sock);
				exit(64);
			}
			else
			{
				shutdown(sock, 2);
				close(sock);
			}
		}
		else {
#ifdef CONF_DEBUG
			fprintf(stderr, "%s: DEBUG: exit(0) from main: Host found.\n", argv[0]);
#endif
			usleep(1000);
			shutdown(sock, 2);
			close(sock);
			exit(0);
		}
		usleep(rettime*1000);
	}
#ifdef CONF_DEBUG
	fprintf(stderr, "%s: DEBUG: exit(255) from main: main loop exited! This should never happen.\n", argv[0]);
#endif
	return(128);
}

