/* pci-config-space.c: Read the PCI configuration space.

	Read the PCI configuration space using the Intel bus-bridge interface
	registers.  This bypasses the BIOS32 entry, and thus we are not assured
	of working on all systems.

	Copyright 1998 by Donald Becker.
	This version released under the Gnu Public Lincese, incorporated herein
	by reference.  Contact the author for use under other terms.

	The author may be reached as becker@cesdis.edu.
	C/O USRA-CESDIS, Code 930.5 Bldg. 28, Nimbus Rd., Greenbelt MD 20771
 */

#include <unistd.h>
#include <stdio.h>
#ifdef __linux__
#include <asm/io.h>
#endif

extern int pcibios_read_config_byte (unsigned char bus, unsigned char dev_fn,
				     unsigned char where, unsigned char *val);
extern int pcibios_read_config_dword (unsigned char bus, unsigned char dev_fn,
									  unsigned char regnum, unsigned int *val);

int
main(int argc, char **argv)
{
	int pci_bus = 0, pci_dev_fn;
	/* Get access to all of I/O space. */
	if (iopl(3) < 0) {
		perror("pci-config: iopl()");
		fprintf(stderr, "This program must be run as root.\n");
		return 2;
	}
	for (pci_dev_fn = 0; pci_dev_fn < 256; pci_dev_fn+=8) {
		/*unsigned char cb;*/
		unsigned int cdw;
		pcibios_read_config_dword(pci_bus, pci_dev_fn, 0, &cdw);
		printf(" %2.2x", cdw);
	}
	return 0;
}
#define PCI_CONFIG_ADDR 0x0cf8
#define PCI_CONFIG_DATA 0x0cfc

int pcibios_read_config_byte (unsigned char bus, unsigned char dev_fn,
							  unsigned char regnum, unsigned char *val)
{
	outl(0x80000000 | (bus<<16) | (dev_fn << 8) | (regnum & 0xfc),
		 PCI_CONFIG_ADDR);
	*val = inb(PCI_CONFIG_DATA + (regnum & 3));
	return 0;
}
int pcibios_read_config_word (unsigned char bus, unsigned char dev_fn,
							  unsigned char regnum, unsigned short *val)
{
	outl(0x80000000 | (bus<<16) | (dev_fn << 8) | (regnum & 0xfc),
		 PCI_CONFIG_ADDR);
	*val = inw(PCI_CONFIG_DATA + (regnum & 2));
	return 0;
}
int pcibios_read_config_dword (unsigned char bus, unsigned char dev_fn,
							   unsigned char regnum, unsigned int *val)
{
	outl(0x80000000 | (bus<<16) | (dev_fn << 8) | (regnum & 0xfc),
		 PCI_CONFIG_ADDR);
	*val = inl(PCI_CONFIG_DATA);
	return 0;
}


/*
 * Local variables:
 *  compile-command: "cc -O -Wall -o pci-config pci-config.c"
 *  tab-width: 4
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
