#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

int main(int argc, char *argv[])
{

  FILE *f;

  if (argc!=1)
  {
    if (argc==2)
    {
      if (!memcmp(argv[1], "-", 1))
      {
        if (!strcmp(argv[1], "--help"))
        {
          printf("\n  %s rev.1.0.1 by Andreas H. Mueller in 1994.\n", argv[0]);
          printf("  This program is public domain!\n");
          printf("  Any commercial spreading is strictly forbidden.\n");
          printf("\n\n  Usage : %s <DIR> | <--help>\n\n", argv[0]);
          printf("  fingerlogd is a daemon-utility that makes you able to record\n");
          printf("  the 'fingers' of other users on an account.\n");
          printf("  <DIR> means the directory in which fingerlogd should search\n");
          printf("  for the .plan- and .project- files, usually a home- directory.\n");
          printf("  Without this option, fingerlogd uses the actual directory.\n");
          printf("   fingerlogd uses no normal files, so you must create named\n");
          printf("  pipes, named ~/.plan and ~/.project.\n");
          printf("\n   fingerlogd returns the following error-codes:\n");
          printf("\n  1 : Help called\n");
          printf("  2 : Unknown option.\n");
          printf("  3 : Too much parameters\n");
          printf("  4 : At least one of .plan and .project is not a named pipe or is unaccessable\n");
          printf("  5 : Directory doesn't exist or is unaccessable\n");
          return 1;
        }
        else
        {
          if (!strcmp(argv[1], "-RN"))
          {
            printf("  The original name of this tool is fingerlogd, the revision is 1.0.1.\n");
            return 0xff;
          }
          else
          {
            fprintf(stderr, "%s: Error: Unknown option.\n", argv[0]);
            fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
            return 2;
          }
        }
      }
      else
      {
        if (chdir (argv[1])==0)
        {
          printf("%s: Active directory is now %s.\n", argv[0], argv[1]);
        }
        else
        {
          fprintf(stderr, "%s: Error: Directory doesn't exist or is unaccessable.\n", argv[0]);
          fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
          return 5;
        }
      }
    }
    else
    {
      fprintf(stderr, "%s: Error: Too much parameters.\n", argv[0]);
      fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
      return 3;
    }
  }
  if ((system("test -p .project")==0) & (system("test -p .plan")==0))
  {
    while ((system("test -p .project")==0) & (system("test -p .plan")==0))
    {
      f=fopen(".project", "w");
      fputs("Your finger command has been recorded.", f);   
      fclose(f);
      system("w -u | grep finger >> fingerlogd.log");
      system("date > .plan");
      system("date >> fingerlogd.log");
      system("./.fingerlogd.catchedrc");
    }
  }
  else
  {
    fprintf(stderr, "%s: Error: At least one of .plan and .project is not a named pipe or\nunaccessable.\n", argv[0]);
    fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
    return 4;
  }
  return 0;
}
