#include "imlib.h"

int ImlibBestColorMatch(ImlibData *id, int *r,int *g,int *b)
{
   int i;
   int dif;
   int dr,dg,db;
   int col;
   int mindif=0x7fffffff;
   int ddr,ddg,ddb;
   XColor xcl;
   
   if (!id)
     {
	fprintf(stderr,"ImLib ERROR: No ImlibData initialised\n");
	return -1;
     }
   if (id->render_type&RT_PLAIN_TRUECOL)
     {
	xcl.red=(unsigned short)((*r<<8)|(*r));
	xcl.green=(unsigned short)((*g<<8)|(*g));
	xcl.blue=(unsigned short)((*b<<8)|(*b));
	xcl.flags=DoRed|DoGreen|DoBlue;
	XAllocColor(id->x.disp,id->x.root_cmap,&xcl);
	*r=xcl.red>>8;
	*g=xcl.green>>8;
	*b=xcl.blue>>8;
	return xcl.pixel;
     }
   for (i=0;i<id->num_colors;i++)
     {
	dr=*r-id->palette[i].r;
	if (dr<0) dr=-dr;
	dg=*g-id->palette[i].g;
	if (dg<0) dg=-dg;
	db=*b-id->palette[i].b;
	if (db<0) db=-db;
	dif=dr+dg+db;
	if (dif<mindif)
	  {
	     mindif=dif;
	     col=id->palette[i].pixel;
	     ddr=*r-id->palette[i].r;
	     ddg=*g-id->palette[i].g;
	     ddb=*b-id->palette[i].b;
	  }
     }
   *r=ddr;*g=ddg;*b=ddb;
   return col;
}

int ImlibRender(ImlibData *id, Image *im, int w, int h)
{
   XImage *xim,*sxim;
   GC tgc,stgc;
   XGCValues gcv;
   int x,y,val,r,g,b;
   int inc__x,inc__y,pos_x,pos_y,w3;
   unsigned char *ptr1,*ptr2,*ptr22,*tmp,*stmp;
   int *error,*er1,*er2,*ter;
   int ex;
   int er,eg,eb;
   int bpp;
   int huge;
   XShmSegmentInfo shminfo;
   XShmSegmentInfo sshminfo;
   
   huge=0;
   if (w<=0) return 0;
   if (h<=0) return 0;
   inc__x=(im->rgb_width<<16)/w;
   inc__y=(im->rgb_height<<16)/h;
   pos_x=0;
   pos_y=0;
   if (id->x.depth==8) bpp=1;
   else if (id->x.depth==15) bpp=2;
   else if (id->x.depth==16) bpp=2;
   else if (id->x.depth==24) bpp=4;
   else if (id->x.depth==32) bpp=4;
   else bpp=1;
   if ((bpp*w*h)>id->max_shm) huge=1;
   im->width=w;
   im->height=h;
   if (im->pixmap) XFreePixmap(id->x.disp,im->pixmap);
   im->pixmap=XCreatePixmap(id->x.disp,id->x.root,w,h,id->x.depth);
   if ((im->shape_color.r>=0)&&(im->shape_color.g>=0)&&(im->shape_color.b>=0))
     {
	if (im->shape_mask) XFreePixmap(id->x.disp,im->shape_mask);
	im->shape_mask=XCreatePixmap(id->x.disp,id->x.root,w,h,1);
	if ((id->x.shm)&&(!huge))
	  {
	     sxim=XShmCreateImage(id->x.disp,id->x.visual,1,ZPixmap,NULL,&id->x.last_sshminfo,w,h);
	     if (!sxim)
	       {
		  fprintf(stderr,"Imlib ERROR: Mit-SHM can't create XImage\n");return 0;
	       }
	     id->x.last_sshminfo.shmid=shmget(IPC_PRIVATE,sxim->bytes_per_line*sxim->height,
					      IPC_CREAT|0777);
	     if (id->x.last_sshminfo.shmid==-1)
	       {
		  fprintf(stderr,"Imlib ERROR: SHM can't get SHM Identifier\n");return 0;
	       }
	     id->x.last_sshminfo.shmaddr=sxim->data=shmat(id->x.last_sshminfo.shmid,0,0);
	     if (!XShmAttach(id->x.disp,&id->x.last_sshminfo))
	       {
		  fprintf(stderr,"Imlib ERROR: MIT-SHM Can't attach SHM Identifier\n");exit(1);
	       }
	     stmp=sxim->data;
	     if (!stmp)
	       {
		  fprintf(stderr,"ERROR: Cannot allocate RAM for shape image data\n");
		  return 0;
	       }
	     id->x.last_sxim=sxim;
	  }
	else
	  {
	     stmp=(unsigned char *)malloc(w*h);
	     if (!stmp)
	       {
		  fprintf(stderr,"ERROR: Cannot allocate RAM for shape image data\n");
		  return 0;
	       }
	     sxim=XCreateImage(id->x.disp,id->x.visual,1,ZPixmap,0,stmp,w,h,8,0);
	     if (!sxim)
	       {
		  fprintf(stderr,"ERROR: Cannot allocate Ximage shape buffer\n");
		  return 0;
	       }
	  }
	stgc=XCreateGC(id->x.disp,im->shape_mask,(unsigned long)0,&gcv);
     }
   error=(int *)malloc(sizeof(int)*w*2*3);
   if (!error)
     {
	fprintf(stderr,"ERROR: Cannot allocate RAM for image dither buffer\n");
	return 0;
     }
   if ((id->x.shm)&&(!huge))
     {
	xim=XShmCreateImage(id->x.disp,id->x.visual,id->x.depth,ZPixmap,NULL,&id->x.last_shminfo,w,h);
	if (!xim)
	  {
	     fprintf(stderr,"Imlib ERROR: Mit-SHM can't create XImage\n");return 0;
	  }
	id->x.last_shminfo.shmid=shmget(IPC_PRIVATE,xim->bytes_per_line*xim->height,
					IPC_CREAT|0777);
	if (id->x.last_shminfo.shmid==-1)
	  {
	     fprintf(stderr,"Imlib ERROR: SHM can't get SHM Identifier\n");return 0;
	  }
	id->x.last_shminfo.shmaddr=xim->data=shmat(id->x.last_shminfo.shmid,0,0);
	if (!XShmAttach(id->x.disp,&id->x.last_shminfo))
	  {
	     fprintf(stderr,"Imlib ERROR: MIT-SHM Can't attach SHM Identifier\n");exit(1);
	  }
	tmp=xim->data;
	if (!tmp)
	  {
	     fprintf(stderr,"ERROR: Cannot allocate RAM for image data\n");
	     return 0;
	  }
	id->x.last_xim=xim;
     }
   else
     {
	if (id->x.depth<8) tmp=(unsigned char *)malloc(w*h);
	if (id->x.depth==8) tmp=(unsigned char *)malloc(w*h);
	else if (id->x.depth==15) tmp=(unsigned char *)malloc(w*h*2);
	else if (id->x.depth==16) tmp=(unsigned char *)malloc(w*h*2);
	else if (id->x.depth==24) tmp=(unsigned char *)malloc(w*h*4);
	else if (id->x.depth==32) tmp=(unsigned char *)malloc(w*h*4);
	if (!tmp)
	  {
	     fprintf(stderr,"ERROR: Cannot allocate RAM for image data\n");
	     return 0;
	  }
	xim=XCreateImage(id->x.disp,id->x.visual,id->x.depth,ZPixmap,0,tmp,w,h,8,0);
	if (!xim)
	  {
	     fprintf(stderr,"ERROR: Cannot allocate Ximage buffer\n");
	     return 0;
	  }
     }
   er1=error;
   er2=error+(w*3);
   ptr1=tmp;
   ptr22=im->rgb_data;
   w3=im->rgb_width*3;
   tgc=XCreateGC(id->x.disp,im->pixmap,(unsigned long)0,&gcv);
   for (ex=0;ex<(w*3*2);ex++) error[ex]=0;
   if ((im->shape_color.r>=0)&&(im->shape_color.g>=0)&&(im->shape_color.b>=0))
     {
	if (id->x.depth<=8)
	  {
	     switch (id->render_type)
	       {
		case RT_PLAIN_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=ImlibBestColorMatch(id,&r,&g,&b);
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		       
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_PLAIN_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=id->fast_rgb[r>>3][g>>3][b>>3];
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		       
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
				 ex+=3;
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
				 if (er>255) er=255;
				 if (er<0) er=0;
				 if (eg>255) eg=255;
				 if (eg<0) eg=0;
				 if (eb>255) eb=255;
				 if (eb<0) eb=0;
				 val=ImlibBestColorMatch(id,&er,&eg,&eb);
				 if (x<(w-1))
				   {
				      er1[ex+0]+=(er*7)>>4;
				      er1[ex+1]+=(eg*7)>>4;
				      er1[ex+2]+=(eb*7)>>4;
				   }
				 if (y<(h-1))
				   {
				      if (x>0)
					{
					   er2[ex-6]+=(er*3)>>4;
					   er2[ex-5]+=(eg*3)>>4;
					   er2[ex-4]+=(eb*3)>>4;
					}
				      er2[ex-3]+=(er*5)>>4;
				      er2[ex-2]+=(eg*5)>>4;
				      er2[ex-1]+=(eb*5)>>4;
				      if (x<(w-1))
					{
					   er2[ex+0]+=(er*1)>>4;
					   er2[ex+1]+=(eg*1)>>4;
					   er2[ex+2]+=(eb*1)>>4;
					}
				   }
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		       
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
				 ex+=3;
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
				 if (er>255) er=255;
				 if (er<0) er=0;
				 if (eg>255) eg=255;
				 if (eg<0) eg=0;
				 if (eb>255) eb=255;
				 if (eb<0) eb=0;
				 val=id->fast_rgb[er>>3][eg>>3][eb>>3];
				 r=id->fast_err[er>>3][eg>>3][eb>>3];
				 g=id->fast_erg[er>>3][eg>>3][eb>>3];
				 b=id->fast_erb[er>>3][eg>>3][eb>>3];
				 er=r;eg=g;eb=b;
				 if (x<(w-1))
				   {
				      er1[ex+0]+=(er*7)>>4;
				      er1[ex+1]+=(eg*7)>>4;
				      er1[ex+2]+=(eb*7)>>4;
				   }
				 if (y<(h-1))
				   {
				      if (x>0)
					{
					   er2[ex-6]+=(er*3)>>4;
					   er2[ex-5]+=(eg*3)>>4;
					   er2[ex-4]+=(eb*3)>>4;
					}
				      er2[ex-3]+=(er*5)>>4;
				      er2[ex-2]+=(eg*5)>>4;
				      er2[ex-1]+=(eb*5)>>4;
				      if (x<(w-1))
					{
					   er2[ex+0]+=(er*1)>>4;
					   er2[ex+1]+=(eg*1)>>4;
					   er2[ex+2]+=(eb*1)>>4;
					}
				   }
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		       
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		default:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=r;
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
	       }
	  }
	if (id->x.depth==15)
	  {
	     switch (id->render_type)
	       {
		case RT_PLAIN_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=ImlibBestColorMatch(id,&r,&g,&b);
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_PLAIN_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=id->fast_rgb[r>>3][g>>3][b>>3];
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
				 ex+=3;
			      }
			    else
			      {
				XPutPixel(sxim,x,y,1);
				 er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
				 if (er>255) er=255;
				 if (er<0) er=0;
				 if (eg>255) eg=255;
				 if (eg<0) eg=0;
				 if (eb>255) eb=255;
				 if (eb<0) eb=0;
				 val=ImlibBestColorMatch(id,&er,&eg,&eb);
				 if (x<(w-1))
				   {
				      er1[ex+0]+=(er*7)>>4;
				      er1[ex+1]+=(eg*7)>>4;
				      er1[ex+2]+=(eb*7)>>4;
				   }
				 if (y<(h-1))
				   {
				      if (x>0)
					{
					   er2[ex-6]+=(er*3)>>4;
					   er2[ex-5]+=(eg*3)>>4;
					   er2[ex-4]+=(eb*3)>>4;
					}
				      er2[ex-3]+=(er*5)>>4;
				      er2[ex-2]+=(eg*5)>>4;
				      er2[ex-1]+=(eb*5)>>4;
				      if (x<(w-1))
					{
					   er2[ex+0]+=(er*1)>>4;
					   er2[ex+1]+=(eg*1)>>4;
					   er2[ex+2]+=(eb*1)>>4;
					}
				   }
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
				 ex+=3;
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
				 if (er>255) er=255;
				 if (er<0) er=0;
				 if (eg>255) eg=255;
				 if (eg<0) eg=0;
				 if (eb>255) eb=255;
				 if (eb<0) eb=0;
				 val=id->fast_rgb[er>>3][eg>>3][eb>>3];
				 r=id->fast_err[er>>3][eg>>3][eb>>3];
				 g=id->fast_erg[er>>3][eg>>3][eb>>3];
				 b=id->fast_erb[er>>3][eg>>3][eb>>3];
				 er=r;eg=g;eb=b;
				 if (x<(w-1))
				   {
				      er1[ex+0]+=(er*7)>>4;
				      er1[ex+1]+=(eg*7)>>4;
				      er1[ex+2]+=(eb*7)>>4;
				   }
				 if (y<(h-1))
				   {
				      if (x>0)
					{
					   er2[ex-6]+=(er*3)>>4;
					   er2[ex-5]+=(eg*3)>>4;
					   er2[ex-4]+=(eb*3)>>4;
					}
				      er2[ex-3]+=(er*5)>>4;
				      er2[ex-2]+=(eg*5)>>4;
				      er2[ex-1]+=(eb*5)>>4;
				      if (x<(w-1))
					{
					   er2[ex+0]+=(er*1)>>4;
					   er2[ex+1]+=(eg*1)>>4;
					   er2[ex+2]+=(eb*1)>>4;
					}
				   }
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		default:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=((r&0xf8)<<7)|((g&0xf8)<<2)|((b&0xf8)>>3);
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
	       }
	  }
	if (id->x.depth==16)
	  {
	     switch (id->render_type)
	       {
		case RT_PLAIN_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=ImlibBestColorMatch(id,&r,&g,&b);
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_PLAIN_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
			      (g==im->shape_color.g)&&
			      (b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=id->fast_rgb[r>>3][g>>3][b>>3];
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
				 ex+=3;
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
				 if (er>255) er=255;
				 if (er<0) er=0;
				 if (eg>255) eg=255;
				 if (eg<0) eg=0;
				 if (eb>255) eb=255;
				 if (eb<0) eb=0;
				 val=ImlibBestColorMatch(id,&er,&eg,&eb);
				 if (x<(w-1))
				   {
				      er1[ex+0]+=(er*7)>>4;
				      er1[ex+1]+=(eg*7)>>4;
				      er1[ex+2]+=(eb*7)>>4;
				   }
				 if (y<(h-1))
				   {
				      if (x>0)
					{
					   er2[ex-6]+=(er*3)>>4;
					   er2[ex-5]+=(eg*3)>>4;
					   er2[ex-4]+=(eb*3)>>4;
					}
				      er2[ex-3]+=(er*5)>>4;
				      er2[ex-2]+=(eg*5)>>4;
				      er2[ex-1]+=(eb*5)>>4;
				      if (x<(w-1))
					{
					   er2[ex+0]+=(er*1)>>4;
					   er2[ex+1]+=(eg*1)>>4;
					   er2[ex+2]+=(eb*1)>>4;
					}
				   }
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
				 ex+=3;
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
				 if (er>255) er=255;
				 if (er<0) er=0;
				 if (eg>255) eg=255;
				 if (eg<0) eg=0;
				 if (eb>255) eb=255;
				 if (eb<0) eb=0;
				 val=id->fast_rgb[er>>3][eg>>3][eb>>3];
				 r=id->fast_err[er>>3][eg>>3][eb>>3];
				 g=id->fast_erg[er>>3][eg>>3][eb>>3];
				 b=id->fast_erb[er>>3][eg>>3][eb>>3];
				 er=r;eg=g;eb=b;
				 if (x<(w-1))
				   {
				      er1[ex+0]+=(er*7)>>4;
				      er1[ex+1]+=(eg*7)>>4;
				      er1[ex+2]+=(eb*7)>>4;
				   }
				 if (y<(h-1))
				   {
				      if (x>0)
					{
					   er2[ex-6]+=(er*3)>>4;
					   er2[ex-5]+=(eg*3)>>4;
					   er2[ex-4]+=(eb*3)>>4;
					}
				      er2[ex-3]+=(er*5)>>4;
				      er2[ex-2]+=(eg*5)>>4;
				      er2[ex-1]+=(eb*5)>>4;
				      if (x<(w-1))
					{
					   er2[ex+0]+=(er*1)>>4;
					   er2[ex+1]+=(eg*1)>>4;
					   er2[ex+2]+=(eb*1)>>4;
					}
				   }
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		default:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
			      (g==im->shape_color.g)&&
			      (b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=((r&0xf8)<<8)|((g&0xfc)<<3)|((b&0xf8)>>3);
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
	       }
	  }
	if ((id->x.depth==32)||(id->x.depth==24))
	  {
	     switch (id->render_type)
	       {
		case RT_PLAIN_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=ImlibBestColorMatch(id,&r,&g,&b);
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_PLAIN_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=id->fast_rgb[r>>3][g>>3][b>>3];
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
				 ex+=3;
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
				 if (er>255) er=255;
				 if (er<0) er=0;
				 if (eg>255) eg=255;
				 if (eg<0) eg=0;
				 if (eb>255) eb=255;
				 if (eb<0) eb=0;
				 val=ImlibBestColorMatch(id,&er,&eg,&eb);
				 if (x<(w-1))
				   {
				      er1[ex+0]+=(er*7)>>4;
				      er1[ex+1]+=(eg*7)>>4;
				      er1[ex+2]+=(eb*7)>>4;
				   }
				 if (y<(h-1))
				   {
				      if (x>0)
					{
					   er2[ex-6]+=(er*3)>>4;
					   er2[ex-5]+=(eg*3)>>4;
					   er2[ex-4]+=(eb*3)>>4;
					}
				      er2[ex-3]+=(er*5)>>4;
				      er2[ex-2]+=(eg*5)>>4;
				      er2[ex-1]+=(eb*5)>>4;
				      if (x<(w-1))
					{
					   er2[ex+0]+=(er*1)>>4;
					   er2[ex+1]+=(eg*1)>>4;
					   er2[ex+2]+=(eb*1)>>4;
					}
				   }
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
				 ex+=3;
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
				 if (er>255) er=255;
				 if (er<0) er=0;
				 if (eg>255) eg=255;
				 if (eg<0) eg=0;
				 if (eb>255) eb=255;
				 if (eb<0) eb=0;
				 val=id->fast_rgb[er>>3][eg>>3][eb>>3];
				 r=id->fast_err[er>>3][eg>>3][eb>>3];
				 g=id->fast_erg[er>>3][eg>>3][eb>>3];
				 b=id->fast_erb[er>>3][eg>>3][eb>>3];
				 er=r;eg=g;eb=b;
				 if (x<(w-1))
				   {
				      er1[ex+0]+=(er*7)>>4;
				      er1[ex+1]+=(eg*7)>>4;
				      er1[ex+2]+=(eb*7)>>4;
				   }
				 if (y<(h-1))
				   {
				      if (x>0)
					{
					   er2[ex-6]+=(er*3)>>4;
					   er2[ex-5]+=(eg*3)>>4;
					   er2[ex-4]+=(eb*3)>>4;
					}
				      er2[ex-3]+=(er*5)>>4;
				      er2[ex-2]+=(eg*5)>>4;
				      er2[ex-1]+=(eb*5)>>4;
				      if (x<(w-1))
					{
					   er2[ex+0]+=(er*1)>>4;
					   er2[ex+1]+=(eg*1)>>4;
					   er2[ex+2]+=(eb*1)>>4;
					}
				   }
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		default:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    if ((r==im->shape_color.r)&&
				(g==im->shape_color.g)&&
				(b==im->shape_color.b))
			      {
				 XPutPixel(sxim,x,y,0);
			      }
			    else
			      {
				 XPutPixel(sxim,x,y,1);
				 val=(r<<16)|(g<<8)|b;
				 XPutPixel(xim,x,y,val);
			      }
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
	       }
	  }
	if ((id->x.shm)&&(!huge))
	  {
	     XShmPutImage(id->x.disp,im->pixmap,tgc,xim,0,0,0,0,w,h,False);
	     XShmPutImage(id->x.disp,im->shape_mask,stgc,sxim,0,0,0,0,w,h,False);
	  }
	else
	  {
	     XPutImage(id->x.disp,im->pixmap,tgc,xim,0,0,0,0,w,h);
	     XPutImage(id->x.disp,im->shape_mask,stgc,sxim,0,0,0,0,w,h);
	     XFree(xim);
	     XFree(sxim);
	     free(tmp);
	     free(stmp);
	  }
	free(error);
	XFreeGC(id->x.disp,tgc);
	XFreeGC(id->x.disp,stgc);
     }
   else
     {
	if (id->x.depth<=8)
	  {
	     switch (id->render_type)
	       {
		case RT_PLAIN_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=ImlibBestColorMatch(id,&r,&g,&b);
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_PLAIN_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=id->fast_rgb[r>>3][g>>3][b>>3];
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
			    if (er>255) er=255;
			    if (er<0) er=0;
			    if (eg>255) eg=255;
			    if (eg<0) eg=0;
			    if (eb>255) eb=255;
			    if (eb<0) eb=0;
			    val=ImlibBestColorMatch(id,&er,&eg,&eb);
			    if (x<(w-1))
			      {
				 er1[ex+0]+=(er*7)>>4;
				 er1[ex+1]+=(eg*7)>>4;
				 er1[ex+2]+=(eb*7)>>4;
			      }
		       if (y<(h-1))
			      {
				 if (x>0)
				   {
				      er2[ex-6]+=(er*3)>>4;
				      er2[ex-5]+=(eg*3)>>4;
				      er2[ex-4]+=(eb*3)>>4;
				   }
				 er2[ex-3]+=(er*5)>>4;
				 er2[ex-2]+=(eg*5)>>4;
				 er2[ex-1]+=(eb*5)>>4;
				 if (x<(w-1))
				   {
				      er2[ex+0]+=(er*1)>>4;
				      er2[ex+1]+=(eg*1)>>4;
				      er2[ex+2]+=(eb*1)>>4;
				   }
			      }
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
			    if (er>255) er=255;
			    if (er<0) er=0;
			    if (eg>255) eg=255;
			    if (eg<0) eg=0;
			    if (eb>255) eb=255;
			    if (eb<0) eb=0;
			    val=id->fast_rgb[er>>3][eg>>3][eb>>3];
			    r=id->fast_err[er>>3][eg>>3][eb>>3];
			    g=id->fast_erg[er>>3][eg>>3][eb>>3];
			    b=id->fast_erb[er>>3][eg>>3][eb>>3];
			    er=r;eg=g;eb=b;
			    if (x<(w-1))
			      {
				 er1[ex+0]+=(er*7)>>4;
				 er1[ex+1]+=(eg*7)>>4;
				 er1[ex+2]+=(eb*7)>>4;
			      }
			    if (y<(h-1))
			      {
				 if (x>0)
				   {
				      er2[ex-6]+=(er*3)>>4;
				      er2[ex-5]+=(eg*3)>>4;
				      er2[ex-4]+=(eb*3)>>4;
				   }
				 er2[ex-3]+=(er*5)>>4;
				 er2[ex-2]+=(eg*5)>>4;
				 er2[ex-1]+=(eb*5)>>4;
				 if (x<(w-1))
				   {
				      er2[ex+0]+=(er*1)>>4;
				      er2[ex+1]+=(eg*1)>>4;
				      er2[ex+2]+=(eb*1)>>4;
				   }
			      }
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		default:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
		       ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=0;
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
	       }
	  }
	if (id->x.depth==15)
	  {
	     switch (id->render_type)
	       {
		case RT_PLAIN_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=ImlibBestColorMatch(id,&r,&g,&b);
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_PLAIN_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=id->fast_rgb[r>>3][g>>3][b>>3];
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
			    if (er>255) er=255;
			    if (er<0) er=0;
			    if (eg>255) eg=255;
			    if (eg<0) eg=0;
			    if (eb>255) eb=255;
			    if (eb<0) eb=0;
			    val=ImlibBestColorMatch(id,&er,&eg,&eb);
			    if (x<(w-1))
			      {
				 er1[ex+0]+=(er*7)>>4;
				 er1[ex+1]+=(eg*7)>>4;
				 er1[ex+2]+=(eb*7)>>4;
			      }
			    if (y<(h-1))
			      {
				 if (x>0)
				   {
				      er2[ex-6]+=(er*3)>>4;
				      er2[ex-5]+=(eg*3)>>4;
				      er2[ex-4]+=(eb*3)>>4;
				   }
				 er2[ex-3]+=(er*5)>>4;
				 er2[ex-2]+=(eg*5)>>4;
				 er2[ex-1]+=(eb*5)>>4;
				 if (x<(w-1))
				   {
				      er2[ex+0]+=(er*1)>>4;
				      er2[ex+1]+=(eg*1)>>4;
				      er2[ex+2]+=(eb*1)>>4;
				   }
			      }
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
			    if (er>255) er=255;
			    if (er<0) er=0;
			    if (eg>255) eg=255;
			    if (eg<0) eg=0;
			    if (eb>255) eb=255;
			    if (eb<0) eb=0;
			    val=id->fast_rgb[er>>3][eg>>3][eb>>3];
			    r=id->fast_err[er>>3][eg>>3][eb>>3];
			    g=id->fast_erg[er>>3][eg>>3][eb>>3];
			    b=id->fast_erb[er>>3][eg>>3][eb>>3];
			    er=r;eg=g;eb=b;
			    if (x<(w-1))
			      {
				 er1[ex+0]+=(er*7)>>4;
				 er1[ex+1]+=(eg*7)>>4;
				 er1[ex+2]+=(eb*7)>>4;
			      }
			    if (y<(h-1))
			      {
				 if (x>0)
				   {
				      er2[ex-6]+=(er*3)>>4;
				      er2[ex-5]+=(eg*3)>>4;
				      er2[ex-4]+=(eb*3)>>4;
				   }
				 er2[ex-3]+=(er*5)>>4;
				 er2[ex-2]+=(eg*5)>>4;
				 er2[ex-1]+=(eb*5)>>4;
				 if (x<(w-1))
				   {
				      er2[ex+0]+=(er*1)>>4;
				      er2[ex+1]+=(eg*1)>>4;
				      er2[ex+2]+=(eb*1)>>4;
				   }
			      }
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		default:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=((r&0xf8)<<7)|((g&0xf8)<<2)|((b&0xf8)>>3);
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
	       }
	  }
	if (id->x.depth==16)
	  {
	     switch (id->render_type)
	       {
		case RT_PLAIN_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=ImlibBestColorMatch(id,&r,&g,&b);
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_PLAIN_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=id->fast_rgb[r>>3][g>>3][b>>3];
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
			    if (er>255) er=255;
			    if (er<0) er=0;
			    if (eg>255) eg=255;
			    if (eg<0) eg=0;
			    if (eb>255) eb=255;
			    if (eb<0) eb=0;
			    val=ImlibBestColorMatch(id,&er,&eg,&eb);
			    if (x<(w-1))
			      {
				 er1[ex+0]+=(er*7)>>4;
				 er1[ex+1]+=(eg*7)>>4;
				 er1[ex+2]+=(eb*7)>>4;
			      }
			    if (y<(h-1))
			      {
				 if (x>0)
				   {
				      er2[ex-6]+=(er*3)>>4;
				      er2[ex-5]+=(eg*3)>>4;
				      er2[ex-4]+=(eb*3)>>4;
				   }
				 er2[ex-3]+=(er*5)>>4;
				 er2[ex-2]+=(eg*5)>>4;
				 er2[ex-1]+=(eb*5)>>4;
				 if (x<(w-1))
				   {
				      er2[ex+0]+=(er*1)>>4;
				      er2[ex+1]+=(eg*1)>>4;
				      er2[ex+2]+=(eb*1)>>4;
				   }
			      }
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
			    if (er>255) er=255;
			    if (er<0) er=0;
			    if (eg>255) eg=255;
			    if (eg<0) eg=0;
			    if (eb>255) eb=255;
			    if (eb<0) eb=0;
			    val=id->fast_rgb[er>>3][eg>>3][eb>>3];
			    r=id->fast_err[er>>3][eg>>3][eb>>3];
			    g=id->fast_erg[er>>3][eg>>3][eb>>3];
			    b=id->fast_erb[er>>3][eg>>3][eb>>3];
			    er=r;eg=g;eb=b;
			    if (x<(w-1))
			      {
				 er1[ex+0]+=(er*7)>>4;
				 er1[ex+1]+=(eg*7)>>4;
				 er1[ex+2]+=(eb*7)>>4;
			      }
			    if (y<(h-1))
			      {
				 if (x>0)
				   {
				      er2[ex-6]+=(er*3)>>4;
				      er2[ex-5]+=(eg*3)>>4;
				      er2[ex-4]+=(eb*3)>>4;
				   }
				 er2[ex-3]+=(er*5)>>4;
				 er2[ex-2]+=(eg*5)>>4;
				 er2[ex-1]+=(eb*5)>>4;
				 if (x<(w-1))
				   {
				      er2[ex+0]+=(er*1)>>4;
				      er2[ex+1]+=(eg*1)>>4;
				      er2[ex+2]+=(eb*1)>>4;
				   }
			      }
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		default:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=((r&0xf8)<<8)|((g&0xfc)<<3)|((b&0xf8)>>3);
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
	       }
	  }
	if ((id->x.depth==32)||(id->x.depth==24))
	  {
	     switch (id->render_type)
	       {
		case RT_PLAIN_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=ImlibBestColorMatch(id,&r,&g,&b);
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_PLAIN_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=id->fast_rgb[r>>3][g>>3][b>>3];
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
			    if (er>255) er=255;
			    if (er<0) er=0;
			    if (eg>255) eg=255;
			    if (eg<0) eg=0;
			    if (eb>255) eb=255;
			    if (eb<0) eb=0;
			    val=ImlibBestColorMatch(id,&er,&eg,&eb);
			    if (x<(w-1))
			      {
				 er1[ex+0]+=(er*7)>>4;
				 er1[ex+1]+=(eg*7)>>4;
				 er1[ex+2]+=(eb*7)>>4;
			      }
			    if (y<(h-1))
			      {
				 if (x>0)
				   {
				      er2[ex-6]+=(er*3)>>4;
				      er2[ex-5]+=(eg*3)>>4;
				      er2[ex-4]+=(eb*3)>>4;
				   }
				 er2[ex-3]+=(er*5)>>4;
				 er2[ex-2]+=(eg*5)>>4;
				 er2[ex-1]+=(eb*5)>>4;
				 if (x<(w-1))
				   {
				      er2[ex+0]+=(er*1)>>4;
				      er2[ex+1]+=(eg*1)>>4;
				      er2[ex+2]+=(eb*1)>>4;
				   }
			      }
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		case RT_DITHER_PALETTE_FAST:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       ter=er1;
		       er1=er2;
		       er2=ter;
		       for (ex=0;ex<w*3;ex++) er2[ex]=0;
		       ex=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    er=r+er1[ex++];eg=g+er1[ex++];eb=b+er1[ex++];
			    if (er>255) er=255;
			    if (er<0) er=0;
			    if (eg>255) eg=255;
			    if (eg<0) eg=0;
			    if (eb>255) eb=255;
			    if (eb<0) eb=0;
			    val=id->fast_rgb[er>>3][eg>>3][eb>>3];
			    r=id->fast_err[er>>3][eg>>3][eb>>3];
			    g=id->fast_erg[er>>3][eg>>3][eb>>3];
			    b=id->fast_erb[er>>3][eg>>3][eb>>3];
			    er=r;eg=g;eb=b;
			    if (x<(w-1))
			      {
				 er1[ex+0]+=(er*7)>>4;
				 er1[ex+1]+=(eg*7)>>4;
				 er1[ex+2]+=(eb*7)>>4;
			      }
			    if (y<(h-1))
			      {
				 if (x>0)
				   {
				      er2[ex-6]+=(er*3)>>4;
				      er2[ex-5]+=(eg*3)>>4;
				      er2[ex-4]+=(eb*3)>>4;
				   }
				 er2[ex-3]+=(er*5)>>4;
				 er2[ex-2]+=(eg*5)>>4;
				 er2[ex-1]+=(eb*5)>>4;
				 if (x<(w-1))
				   {
				      er2[ex+0]+=(er*1)>>4;
				      er2[ex+1]+=(eg*1)>>4;
				      er2[ex+2]+=(eb*1)>>4;
				   }
			      }
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
		default:
		  for(y=0;y<h;y++)
		    {
		       pos_x=0;
		       for(x=0;x<w;x++)
			 {
			    ptr2=ptr22+(pos_x>>16)+(pos_x>>16)+(pos_x>>16);
			    r=(int)*ptr2++;
			    g=(int)*ptr2++;
			    b=(int)*ptr2;
			    val=(r<<16)|(g<<8)|b;
			    XPutPixel(xim,x,y,val);
			    pos_x+=inc__x;
			 }
		        
		       pos_y+=inc__y;
		       ptr22=im->rgb_data+((pos_y>>16)*w3);
		    }
		  break;
	       }
	  }
	if ((id->x.shm)&&(!huge))
	  {
	     XShmPutImage(id->x.disp,im->pixmap,tgc,xim,0,0,0,0,w,h,False);
	  }
	else
	  {
	     XPutImage(id->x.disp,im->pixmap,tgc,xim,0,0,0,0,w,h);
	     XFree(xim);
	     free(tmp);
	  }
	free(error);
	XFreeGC(id->x.disp,tgc);
     }
   XSync(id->x.disp,False);
   if (id->x.last_xim)
     {
	XEvent ev;
	
/*	while (!XCheckTypedEvent(id->x.disp,id->x.shm_event,&ev));*/
	XShmDetach(id->x.disp,&id->x.last_shminfo);
	XDestroyImage(xim);
	shmdt(id->x.last_shminfo.shmaddr);
	shmctl(id->x.last_shminfo.shmid,IPC_RMID,0);
	id->x.last_xim=NULL;
     }
   if (id->x.last_sxim)
     {
	XEvent ev;
	
/*	while (!XCheckTypedEvent(id->x.disp,id->x.shm_event,&ev));*/
	XShmDetach(id->x.disp,&id->x.last_sshminfo);
	XDestroyImage(sxim);
	shmdt(id->x.last_sshminfo.shmaddr);
	shmctl(id->x.last_sshminfo.shmid,IPC_RMID,0);
	id->x.last_sxim=NULL;
     }
   return 1;
}

   
