#include "imlib.h"

int ImlibGetRenderType(ImlibData *id)
{
   if (id) return id->render_type;
   else
     {    
	fprintf(stderr,"ImLib ERROR: ImlibData struct not initialised\n");
	return -1;
     }
}

int ImlibSetRenderType(ImlibData *id, int rend_type)
{
   if (id)
     {
	if (id->x.depth>8) id->render_type=rend_type;
	else
	  {
	     if (rend_type==RT_PLAIN_TRUECOL)
	       id->render_type=RT_DITHER_PALETTE_FAST;
	     else
	       id->render_type=rend_type;
	  }
	return 1;
     }
   else
     {
	fprintf(stderr,"ImLib ERROR: ImlibData struct not initialised\n");
	return 0;
     }
}

ImlibData *ImlibInit(Display *disp)
{
   ImlibData *id;
   XWindowAttributes xwa;
   XVisualInfo xvi,*xvir;
   char *homedir;
   char file[4096];
   char s[4096],s1[1024],s2[1024];
   FILE *f;
   int override=0;
   int dither=0;
   int remap=1;
   int num;
   int i,max,maxn;
   int clas;
   
   id=(ImlibData *)malloc(sizeof(ImlibData));
   if (!id)
     {
	fprintf(stderr,"ImLib ERROR: Cannot alloc RAM for Initial data struct\n");
	return NULL;
     }
   id->x.disp=disp;
   id->x.screen=DefaultScreen(disp); /* the screen number */
   id->x.root=DefaultRootWindow(disp); /* the root window id */
   id->x.visual=DefaultVisual(disp,id->x.screen); /* the visual type */
   id->x.depth=DefaultDepth(disp,id->x.screen); /* the depth of the screen in bpp */
   if (XShmQueryExtension(id->x.disp)) 
     {
	id->x.shm=1;
	id->x.shm_event=XShmGetEventBase(id->x.disp)+ShmCompletion;
	id->x.last_xim=NULL;
	id->x.last_sxim=NULL;
	id->max_shm=0x7fffffff;
     }
   else id->x.shm=0;
   xvi.visual=id->x.visual;
   xvi.visualid=XVisualIDFromVisual(id->x.visual);
   xvi.screen=id->x.screen;
   xvir=XGetVisualInfo(disp,VisualScreenMask,&xvi,&num);
   if (xvir) 
     {
	max=0;
	maxn=0;
	clas=-1;
	for (i=0;i<num;i++)
	  {
	     if (xvir[i].depth>=max)
	       {
		  if (xvir[i].depth<8)
		    {
		       if ((xvir[i].class>=clas)&&(xvir[i].class!=DirectColor)&&(xvir[i].class!=TrueColor)&&(xvir[i].class!=PseudoColor))
			 {
			    clas=xvir[i].class;
			    maxn=i;
			    max=xvir[i].depth;
			 }
		    }
		  else if (xvir[i].depth==8)
		    {
		       if ((xvir[i].class>=clas)&&(xvir[i].class!=DirectColor)&&(xvir[i].class!=TrueColor))
			 {
			    clas=xvir[i].class;
			    maxn=i;
			    max=xvir[i].depth;
			 }
		    }
		  else
		    {
		       if ((xvir[i].class>=clas)&&(xvir[i].class!=DirectColor))
			 {
			    clas=xvir[i].class;
			    maxn=i;
			    max=xvir[i].depth;
			 }
		    }
	       }
	  }
	id->x.depth=xvir[maxn].depth;
	id->x.visual=xvir[maxn].visual;
	printf("<deubug> IMLIB: Chose the %i Bit depth Visual, ID 0x%x, to work with\n",id->x.depth,XVisualIDFromVisual(id->x.visual));
	XFree(xvir);
     }
   if (id->x.depth==16)
     {
	xvi.visual=id->x.visual;
	xvi.visualid=XVisualIDFromVisual(id->x.visual);
	xvir=XGetVisualInfo(disp,VisualIDMask,&xvi,&num);
	if (xvir) 
	  {
	     if (xvir->red_mask!=0xf800) id->x.depth=15;
	     XFree(xvir);
	  }
     }
   if (XGetWindowAttributes(disp,id->x.root,&xwa))
     {
	if (xwa.colormap) id->x.root_cmap=xwa.colormap;
	else id->x.root_cmap=0;
     }
   else id->x.root_cmap=0;
   id->num_colors=0;
   homedir=getenv("HOME");
   sprintf(file,"%s/.imrc",homedir);
   f=fopen(file,"r");
   if (!f) f=fopen(SYSTEM_IMRC,"r");
   if (f)
     {
	while (fgets(s,4096,f))
	  {
	     if (s[0]=='#') continue;
	     sscanf(s,"%s %s\n",s1,s2);
	     if (!strcasecmp("PaletteFile",s1))
	       {
		  ImlibLoadColors(id,s2);
	       }
	     if (!strcasecmp("PaletteOverride",s1))
	       {
		  if (!strcasecmp("yes",s2)) override=1;
		  else override=0;
	       }
	     if (!strcasecmp("Dither",s1))
	       {
		  if (!strcasecmp("yes",s2)) dither=1;
		  else dither=0;
	       }
	     if (!strcasecmp("Remap",s1))
	       {
		  if (!strcasecmp("fast",s2)) 
		    remap=1;
		  else 
		    remap=0;
	       }
	     if (!strcasecmp("Mit-Shm",s1))
	       {
		  if (!strcasecmp("off",s2)) id->x.shm=0;
	       }
	     if (!strcasecmp("Shm_Max_Size",s1))
	       {
		  sscanf(s,"%s %i",s1,&num);
		  id->max_shm=num;
	       }
	  }
	fclose(f);
     }
   if ((id->x.depth<=8)||(override==1)) 
     {
	if (dither==1)
	  {
	     if (remap==1) id->render_type=RT_DITHER_PALETTE_FAST;
	     else id->render_type=RT_DITHER_PALETTE;
	  }
	else
	  {
	     if (remap==1) id->render_type=RT_PLAIN_PALETTE_FAST;
	     else id->render_type=RT_PLAIN_PALETTE;
	  }
	if (id->num_colors==0)
	  {
	     fprintf(stderr,"IMLIB: Cannot Find Palette. A Palette is required for this mode\n");
	     free(id);
	     return NULL;
	  }
     }
   else 
     {
	id->render_type=RT_PLAIN_TRUECOL;
     }
   return id;
}

Pixmap ImlibCopyImageToPixmap(ImlibData *id, Image *im)
{
   Pixmap p;
   GC tgc;
   XGCValues gcv;
   
   if (!im->pixmap) return 0;
   p=XCreatePixmap(id->x.disp,id->x.root,im->width,im->height,id->x.depth);
   tgc=XCreateGC(id->x.disp,im->pixmap,(unsigned long)0,&gcv);
   XCopyArea(id->x.disp,im->pixmap,p,tgc,0,0,im->width,im->height,0,0);
   XFreeGC(id->x.disp,tgc);
   return p;
}

Pixmap ImlibMoveImageToPixmap(ImlibData *id, Image *im)
{
   Pixmap p;
   
   p=im->pixmap;
   im->pixmap=0;
   return p;
}

Pixmap ImlibCopyMaskToPixmap(ImlibData *id, Image *im)
{
   Pixmap p;
   GC tgc;
   XGCValues gcv;
   
   if (!im->shape_mask) return 0;
   p=XCreatePixmap(id->x.disp,id->x.root,im->width,im->height,1);
   tgc=XCreateGC(id->x.disp,im->shape_mask,(unsigned long)0,&gcv);
   XCopyArea(id->x.disp,im->shape_mask,p,tgc,0,0,im->width,im->height,0,0);
   XFreeGC(id->x.disp,tgc);
   return p;
}

Pixmap ImlibMoveMaskToPixmap(ImlibData *id, Image *im)
{
   Pixmap p;
   
   p=im->shape_mask;
   im->shape_mask=0;
   return p;
}

void ImlibDestroyImage(ImlibData *id, Image *im)
{
   if (im)
     {
	if (im->pixmap) XFreePixmap(id->x.disp,im->pixmap);
	if (im->shape_mask) XFreePixmap(id->x.disp,im->shape_mask);
	if (im->rgb_data) free(im->rgb_data);
	free(im);
     }
}

