#include "imlib.h"

void _ImlibGetExtension(char *file,char *ext)
{
   int len;
   int i,j,k;
   
   len=strlen(file);
   k=0;
   i=len-1;
   while ((file[i]!='.')&&(i>=0)) i--;
   if (i==0) ext[0]=0;
   else
     {
	for (j=i+1;j<len;j++)
	  {
	     ext[k++]=(char)tolower(file[j]);
	  }
	ext[k]=0;
     }
}

unsigned char *_LoadPPM(FILE *f,int *w, int *h)
{
   int done,x,y;
   unsigned char *ptr;
   unsigned char chr;
   char s[256];
   int a,b;
   int color;
   
   fgets(s,256,f);
   s[strlen(s)-1]=0;
   if (!strcmp(s,"P6")) color=1;
   else if (!strcmp(s,"P5")) color=0;
   else return NULL;
   done=1;
   while(done)
     {
	fgets(s,256,f);

	s[strlen(s)-1]=0;
	if (s[0]!='#')
	  {
	     done=0;
	     sscanf(s,"%i %i",w,h);
	     a=*w;
	     b=*h;
	     if (a>32767)
	       {
		  fprintf(stderr,"ImLib ERROR: Image width > 32767 pixels for file\n");
		  return NULL;
	       }
	     if (b>32767)
	       {
		  fprintf(stderr,"ImLib ERROR: Image height > 32767 pixels for file\n");
		  return NULL;
	       }
	     fgets(s,256,f);
	     s[strlen(s)-1]=0;
	     ptr=(unsigned char *)malloc(a*b*3);
	     if (!ptr)
	       {
		  fprintf(stderr,"ImLib ERROR: Cannot allocate RAM for RGB data in file");
		  return ptr;
	       }
	     if (color)
	       {
		  if (!fread(ptr,a*b*3,1,f)) return NULL;
	       }
	     else
	       {
		  b=(a*b*3);
		  a=0;
		  while((fread(&chr,1,1,f))&&(a<b))
		    {
		       ptr[a++]=chr;
		       ptr[a++]=chr;
		       ptr[a++]=chr;
		    }
	       }
	  }
     }
   return ptr;
}

Image *ImlibLoadImage(ImlibData *id, char *file, ImColor *icl)
{
   int w,h;
   int needs_conv = 1;
   unsigned char *data;
   Image *im;
   char s[256];
   char cmd[1024];
   FILE *p;

   _ImlibGetExtension(file,s);
   if (!strcmp(s,"ppm")) needs_conv = 0;
   if (!strcmp(s,"pgm")) needs_conv = 0;
   if (needs_conv)
     {
	sprintf(cmd,"convert %s pnm:-",file);
	p=popen(cmd,"r");
     }
   else
     p=fopen(file,"r");
   data=_LoadPPM(p,&w,&h);
   if (!data)
     {
	if (p)
	  {
	     if (needs_conv) pclose(p);
	     else fclose(p);
	  }
	if (!strcmp(s,"jpeg")) sprintf(cmd,"djpeg -targa %s | tgatoppm",file);
	else if (!strcmp(s,"jpg")) sprintf(cmd,"djpeg -targa %s | tgatoppm",file);
	else if (!strcmp(s,"bmp")) sprintf(cmd,"bmptoppm %s",file);
	else if (!strcmp(s,"ilbm")) sprintf(cmd,"ilbmtoppm %s",file);
	else if (!strcmp(s,"ilb")) sprintf(cmd,"ilbmtoppm %s",file);
	else if (!strcmp(s,"iff")) sprintf(cmd,"ilbmtoppm %s",file);
	else if (!strcmp(s,"img")) sprintf(cmd,"imgtoppm %s",file);
	else if (!strcmp(s,"mtv")) sprintf(cmd,"mtvtoppm %s",file);
	else if (!strcmp(s,"pcx")) sprintf(cmd,"pcxtoppm %s",file);
	else if (!strcmp(s,"pgm")) sprintf(cmd,"pgmtoppm rgb:ffff/ffff/ffff %s",file);
	else if (!strcmp(s,"pi1")) sprintf(cmd,"pi1toppm %s",file);
	else if (!strcmp(s,"pict")) sprintf(cmd,"picttoppm %s",file);
	else if (!strcmp(s,"pic")) sprintf(cmd,"picttoppm %s",file);
	else if (!strcmp(s,"pj")) sprintf(cmd,"pjtoppm %s",file);
	else if (!strcmp(s,"qrt")) sprintf(cmd,"qrttoppm %s",file);
	else if (!strcmp(s,"sld")) sprintf(cmd,"sldtoppm %s",file);
	else if (!strcmp(s,"spc")) sprintf(cmd,"spctoppm %s",file);
	else if (!strcmp(s,"spu")) sprintf(cmd,"sputoppm %s",file);
	else if (!strcmp(s,"tga")) sprintf(cmd,"tgatoppm %s",file);
	else if (!strcmp(s,"xim")) sprintf(cmd,"ximtoppm %s",file);
	else if (!strcmp(s,"xpm")) sprintf(cmd,"xpmtoppm %s",file);
	else if (!strcmp(s,"gif")) sprintf(cmd,"giftopnm %s",file);
	else if (!strcmp(s,"rast")) sprintf(cmd,"rasttopnm %s",file);
	else if (!strcmp(s,"ras")) sprintf(cmd,"rasttopnm %s",file);
	else if (!strcmp(s,"sgi")) sprintf(cmd,"sgitopnm %s",file);
	else if (!strcmp(s,"sir")) sprintf(cmd,"sirtopnm %s",file);
	else if (!strcmp(s,"tiff")) sprintf(cmd,"tifftopnm %s",file);
	else if (!strcmp(s,"tif")) sprintf(cmd,"tifftopnm %s",file);
	else if (!strcmp(s,"wxd")) sprintf(cmd,"wxdtopnm %s",file);
	else if (!strcmp(s,"zeiss")) sprintf(cmd,"zeisstopnm -ppm %s",file);
	else if (!strcmp(s,"zei")) sprintf(cmd,"zeisstopnm -ppm %s",file);
	else if (!strcmp(s,"zis")) sprintf(cmd,"zeisstopnm -ppm %s",file);
	else sprintf(cmd,"anytopnm %s",file);
	p=popen(cmd,"r"); 
	if (!p)
	  {
	     fprintf(stderr,"ImLib ERROR: Cannot exec %s to load image %s\n",cmd,file);
	     return NULL;
	  }
	data=_LoadPPM(p,&w,&h);
     }
   if (!data) 
     {
		  fprintf(stderr,"ImLib ERROR: Cannot load image: %s\n",file);
		  if (p)
			 {
				 if (needs_conv) pclose(p);
				 else fclose(p);
			 }
		  return NULL;
     }
   if (p)
     {
		  if (needs_conv) pclose(p);
		  else fclose(p);
     }
   
   im=(Image *)malloc(sizeof(Image));
   if (!im)
     {
	fprintf(stderr,"Imlib ERROR: Cannot allocate RAM for image data\n");
	return NULL;
     }
   im->rgb_data=data;
   im->rgb_width=w;
   im->rgb_height=h;
   im->pixmap=0;
   im->shape_mask=0;
   if (icl) 
     {
	im->shape_color.r=icl->r;
	im->shape_color.g=icl->g;
	im->shape_color.b=icl->b;
     }
   else
     {
	im->shape_color.r=-1;
	im->shape_color.g=-1;
	im->shape_color.b=-1;
     }
   return im;
}

