/*****************************************************************************/
/*                                  I M L I B                                */
/*****************************************************************************/
/* This is a general, all-purpose Image loading and rendering (Image data to */
/* screen data) library. It will only load PPM format images itself. If you  */
/* wish to load other formats, you will have to install the PBM PLUS         */
/* distribution. This consist of commands like "giftopnm", "tgatoppm",       */
/* "bmptoppm", "djpeg", "xpmtoppm", "ilbmtoppm", etc. Via using these        */
/* commands internally, imlib is capable of currently loading 25 different   */
/* image formats. It uses the extension to determine the Imageformat, but if */
/* that is not possible, it will ask the "anytopnm" program from the PBM     */
/* distribution to figrue it out for it. If you dont have the PBM PLUS       */
/* package, GET IT NOW! Try looking in sunsite (sunsite.unc.edu) in          */
/* /pub/Linux/apps/graphics/convert/    for the latest version you can find. */
/* Imlib works on the following display types:                               */
/*     8 bit pseudocolour                                                    */
/*     15 bit RGB (5/5/5) HiColour                                           */
/*     16 bit RGB (5/6/5) HiColour                                           */
/*     24/32 bit RGB (8/8/8) TrueColor                                       */
/* Imlib shoudl do the following displays, but is untested, as my X server   */
/* not capable of these (well i could run a different one... but have too    */
/* much else to do....)                                                      */
/*     1 bit monochrome                                                      */
/*     2 bit (whatever this is... rare but amigas can do it :-) )            */
/*     3 bit (same as above)                                                 */
/*     4 bit (amigas, and PC's do this too... 16 color mode......)           */
/*     5 bit (WOW 32 colors!!!!!!!1)                                         */
/*     6 bit (64 colors.. or even Extra Half Bright on Amigas.....)          */
/*     7 bit (128 colors.. well amigas can do this too.......)               */
/*     8 bit fixed. any fixed color visual chould, if its depth is supported */
/*  support for these bit depths above was an afterthought. I dont really    */
/*  support them. If they work. great, but i belive they wont be as fast as  */
/*  lets say 8bit, 15,16 and 24/32 bit support, whic I concentrated on....   */
/*  infact the only major one of these is monochrome.. see below as to what  */
/*  I think of B&W displays :-)                                              */
/* Why not Monochrome (1bit) ? Monochrome is outdated. SEVERELY so. Many     */
/* institutions still insist on running and purchasing mono display          */
/* terminals. Why this persists beats me. Admittedly they are cheap, but     */
/* crap. In an effort to get the Wrold to MOVE ON, I have decided to not     */
/* support mono displays. I almost tossed 8 bit support out, but decided to  */
/* keep it. Call me an elitist if you want, and I will gladly direct all     */
/* your flames to /dev/null, and reply with /dev/zero :-). The World has to  */
/* move on. In a few years everyone will be running absolute minimum 8 bit   */
/* displays, and most will; run 15/16 bit, and many will run 24/32 bit. I am */
/* desigining for the future, not the past.                                  */
/*                                                                           */
/* NOTE: If you are using an 8-bit display, or programming for one. You must */
/* load a palette via ImlibLoadColors BEFORE you Load or Render any Images.  */
/* If you don't they will all end up blank. This is necessary for Imlib to   */
/* allocate colours in X for you. On 15 bit displays and up this is only an  */
/* option.                                                                   */
/*****************************************************************************/
/* All Imlib source code it Copyright (C) 1997 Carsten Haitzler (Rasterman)  */
/* and falls, in its current version under the GNU Public LICENSE (GPL). If  */
/* you dont know what this means, go read up about it. Simply it means you   */
/* can freely copy it, modify it etc. Read the COPYING file for more details */
/*****************************************************************************/
/* To contact Me (The Author) You can find me:                               */
/* Email: s2154962@cse.unsw.edu.au                                           */
/*        raster@zip.com.au                                                  */
/* Web: http://www.cse.unsw.edu.au                                           */
/* IRC: #zip on Icenet (zipper.zip.com.au is a server on Icenet)             */
/* SnailMail: 16/67 St. Mark Rd.                                             */
/*            Randwick 2031                                                  */
/*            Sydney NSW Australia                                           */
/* Telephone: +61 2 9399 8786                                                */
/* This above contact information is as of Janruary 1997                     */
/*****************************************************************************/

#ifndef IMLIB_H
#define IMLIB_H

/* defines................... */

/*
 * This is where imlib will look for the system imrc config file if it cant
 * find a ~/.imrc file.... it NEEEEEEEEEEDS this file.
 */

#ifndef SYSTEM_IMRC
#define SYSTEM_IMRC "/etc/imrc"
#endif /* ndef SYSTEM_IMRC */

/*
 * X includes
 */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/extensions/XShm.h>
#include <X11/cursorfont.h>

/*
 * Standard system includes
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <time.h>                                                            
#include <sys/ipc.h>
#include <sys/shm.h>

/* Rendering methods */

#define RT_PLAIN_PALETTE       0
#define RT_PLAIN_PALETTE_FAST  1
#define RT_DITHER_PALETTE      2
#define RT_DITHER_PALETTE_FAST 3
#define RT_PLAIN_TRUECOL       4

/* Atructures used in Imlib */

/* A color in Imlib is stored in this structure */
typedef struct
{
   int r; /* Red value (0-255) */
   int g; /* Green value (0-255) */
   int b; /* Blue value (0-255) */
   int pixel; /* The actual pixel value on screen for the closest match to */
              /* this RGB color value. It may be an exact or very bad match. */
} ImColor;
/* This is a data struc where Imlib stores the info it needs about the */
/* display it is rendering for. This is used internally and need not be */
/* looked at and MUST NOT BE MODIFIED after executing ImlibInit. That could */
/* lead to a segfault and Imlib not working properly. If you want Imlib to */
/* render for multiple displays, create 1 ImlibData struct (via ImlibInit) */
/* per display you open, and when Rendering or Loading an Image, just use */
/* that ImlibData identifier, for that display. NOTE: If you are running */
/* in 8bpp you must also after initialising the ImlibData, load the pallette */
/* into the ImlibData via ImlibLoadColors */
typedef struct
{
   Display *disp; /* Display Imlib is rendering for */
   int screen; /* Screen Number Imlib is rendering for */
   Window root; /* The root window of the display where the Imlib images go */
   Visual *visual; /* The Visual Type of the diplay Imlib is rendering for */
   int depth; /* The depth in bits per pixel of the display for Imlib */
   Colormap root_cmap; /* The colormap of root, so Imlib can alloc colours */
   char shm; /* wether MIT SHM is available */
   int shm_event; /* event id of completion event */
   XImage *last_xim;
   XImage *last_sxim;
   XShmSegmentInfo last_shminfo;
   XShmSegmentInfo last_sshminfo;   
} Xdata;

/* Imlib Data. This is all internal and should not be altered. You may look */
/* at the data youself if you want, but this should be left for internal */
/* purposes only */
typedef struct
{
   int num_colors; /* Number of colours in the allocated Palette */
   ImColor palette[256]; /* The allocated Palette itself (MAX 256 Entries) */
   ImColor palette_orig[256]; /* The desired palette (what was wanted) */
   int fast_rgb[32][32][32]; /* A quick lookuptable for faster rendering */
   int fast_err[32][32][32]; /* Internal RGB error information */
   int fast_erg[32][32][32];
   int fast_erb[32][32][32];
   int render_type; /* What render method to use (see above) */
	int max_shm;
   Xdata x; /* data about the display Imlib is rendering for */
} ImlibData;

/* This is the data structure of an Image after Imlib is done with it. You */
/* will need thsi if you wish to re-render or rescale in imlib, if all you */
/* want is to load an Image, and get a pixmap, then use that only, you can */
/* copy the pixmap out of this data struct using ImlibCopyImageToPixmap and */
/* then Destroy this Image via ImlibDestroyImage. A similar story applies to */
/* the shape mask. */
typedef struct
{
   int rgb_width; /* width of the original image */
   int rgb_height; /* height of the original image */
   unsigned char *rgb_data; /* the original RGB data in the format RGBRGB... */
   int width; /* width (scaled) rendered Pixmap */
   int height; /* height of (scaled) rendered Pixmap */
   ImColor shape_color; /* RGB colour of the transparent pixel. RGB where */
                        /* value is < 0 means there is no transparency */
   Pixmap pixmap; /* rendered (and scaled) Color Pixmap data */
   Pixmap shape_mask; /* a 1 bit shape mask for the X Shape Extension */
} Image;

/* This routine initialises the Imlib  data structure with values for basic */
/* defaults, according to display. You must have already opened the Display */
/* for X before invoking this command. If NULL is returned, it was unable to */
/* properly intitialise the ImlibData data structure. Normally it will */
/* return a pointer to the ImlibData */
ImlibData 
*ImlibInit(Display *disp);

/* This will return the current Rendering method, or -1 if there was an */
/* error in obtaining the method */
int 
ImlibGetRenderType(ImlibData *id);

/* This sets the current rendering method to rend_type. If you are running */
/* on an 8 bit display, and you request TRUE COLOR rendering, the render */
/* method will be capped at FAST PALETTED DITHERING, due to you not being */
/* able to do truecolor rendiring on that display type. If an error occured */
/* this routine will return 0, otherwise 1 */
int 
ImlibSetRenderType(ImlibData *id, int rend_type);

/* This loads a palette file in and allocates the colors specified in it. */
/* you only need to and should to this once. If there was an error, it will */
/* return 0, otherwise 1 */
/* the palette file format is: */
/* 1 colour entry per line, lines starting wiht # are ignored, as follows: */
/* 0xRR 0xGG 0xBB */
/* 0xRR 0xGG 0xBB */
/* etc...... */
int 
ImlibLoadColors(ImlibData *id, char *file);

/* This loads an Image file and returns an Image structure. If NULL is */
/* returned instead, something went wrong. icl is a pointer to an ImColor */
/* that specifies the trasnapernt colour to be used. If this is NULL, no */
/* transparent color is used. Once the Image is loaded, it is rendered */
/* using the current render type at the image size specified in the file. */
/* this routine detrmines file-type from the extension. This is the list of */
/* extensions it recognises: */
/* jpeg,jpg : JPEG image file*/
/* bmp : Windows / OS/2 BMP file */
/* ilbm,ilb,iff: Amiga IFF ILBM format */
/* img: Img-whatnot file */
/* mtv: MTV raytracer file */
/* pcx: PCX file */
/* pgm: Protable Graymap file */
/* pi1: Atari Degas file */
/* pict,pic: Macintosh PICT file */
/* pj: HP PaintJet file */
/* qrt: QRT Raytracer file */
/* sld: AutoCad slide file */
/* spc: Atari compressed Spectrum file */
/* spu: Atari uncompressed Spectrum file */
/* tga: Truevison Targa file */
/* xim: Xim file */
/* xpm: X11 protablepixmap */
/* gif: GIF file (only color, not greyscale/b&w) */
/* rast,ras: Sun rasterfile (only color, not greyscale/b&w) */
/* sgi: SGI file (only color, not greyscale/b&w) */
/* sir: Solitare Image recorder file (only color, not greyscale/b&w) */
/* tiff,tif: TIFF file (only color, not greyscale/b&w) */
/* wxd: X10/X11 Window dump (only color, not greyscale/b&w) */
/* zeiss,zei,zis: Zeiss confocal file (only color, not greyscale/b&w) */
/* ppm: Portable Pixmap file */
Image 
*ImlibLoadImage(ImlibData *id, char *file, ImColor *icl);

/* This routine returns the closest match for the RGB color specified with */
/* r,g and b (0-255 each), and returns the pixel value for the screen and */
/* r,g, and b are modified to contain the RGB error of the match (0,0,0 */
/* means a perfect mactch. returns -1 if there was an error */
int 
ImlibBestColorMatch(ImlibData *id, int *r,int *g,int *b);

/* This Routine Re-Renders the image (destroying any old rendered pixmap) */
/* using the current render tpe, and at the width (w) and height (h) */
/* specified. If something went wrong, 0, will be returned, otherwise 1 */
int 
ImlibRender(ImlibData *id, Image *im, int w, int h);

/* This copies the rendered pixmap from and Image into a Pixmap, and retruns */
/* that. */
Pixmap 
ImlibCopyImageToPixmap(ImlibData *id, Image *im);

/* This is exactly the same as ImlibCopyImageToPixmap, but is faster, and */
/* makes the rescaled pixmap in the Image structure invalid */
Pixmap 
ImlibMoveImageToPixmap(ImlibData *id, Image *im);

/* This copies the rendered pixmap from and Image into a Pixmap, and retruns */
/* that. */
Pixmap 
ImlibCopyMaskToPixmap(ImlibData *id, Image *im);

/* This is exactly the same as ImlibCopyImageToPixmap, but is faster, and */
/* makes the rescaled pixmap in the Image structure invalid */
Pixmap 
ImlibMoveMaskToPixmap(ImlibData *id, Image *im);

/* This destroys an Image and all data associated wiht it, freeing up the */
/* memory it uses. */
void 
ImlibDestroyImage(ImlibData *id, Image *im);

/* This function frees all the colors allocated int he palette for imlib */
/* the nullifies the palette, so no colors exist anymore in the palette */
void
ImlibFreeColors(ImlibData *id);

#endif
