#include "imlib.h"

void _PaletteAlloc(ImlibData *id, int num, int *cols)
{
   XColor xcl;
   int i;
   int r,g,b;

   for(i=0;i<num;i++)
     {
	r=cols[(i*3)+0];
	g=cols[(i*3)+1];
	b=cols[(i*3)+2];
	xcl.red=(unsigned short)((r<<8)|(r));
	xcl.green=(unsigned short)((g<<8)|(g));
	xcl.blue=(unsigned short)((b<<8)|(b));
	xcl.flags=DoRed|DoGreen|DoBlue;
	XAllocColor(id->x.disp,id->x.root_cmap,&xcl);
	id->palette[i].r=xcl.red>>8;
	id->palette[i].g=xcl.green>>8;
	id->palette[i].b=xcl.blue>>8;
	id->palette[i].pixel=xcl.pixel;
	id->palette_orig[i].r=r;
	id->palette_orig[i].g=g;
	id->palette_orig[i].b=b;
	id->palette_orig[i].pixel=xcl.pixel;
     }
   id->num_colors=num;
}

int ImlibLoadColors(ImlibData *id, char *file)
{
   FILE *f;
   char s[256];
   int i;
   int pal[768];
   int r,g,b;
   int *cols;
   int rr,gg,bb;
   
   f=fopen(file,"r");
   if (!f) 
     {     
		  fprintf(stderr,"ImLib ERROR: Cannot find palette file %s\n",file);
		  return 0;
     }
   i=0;
   while(fgets(s,256,f))
     {
		  if (s[0]=='0')
			 {
				 sscanf(s,"%x %x %x",&r,&g,&b);
				 if (r<0) r=0; if (r>255) r=255;
				 if (g<0) g=0; if (g>255) g=255;
				 if (b<0) b=0; if (b>255) b=255;
				 pal[i++]=r;
				 pal[i++]=g;
				 pal[i++]=b;
			 }
		  if (i>=768) break;
     }
   fclose(f);
   _PaletteAlloc(id,(i/3),pal);
   for (r=0;r<32;r++)
     {
		  for (g=0;g<32;g++)
			 {
				 for (b=0;b<32;b++)
					{
						rr=(r<<3)|(r>>2);
						gg=(g<<3)|(g>>2);
						bb=(b<<3)|(b>>2);
						id->fast_rgb[r][g][b]=
						ImlibBestColorMatch(id,&rr,&gg,&bb);
						id->fast_err[r][g][b]=rr;
						id->fast_erg[r][g][b]=gg;
						id->fast_erb[r][g][b]=bb;
					}
			 }
     }
   return 1;
}

void ImlibFreeColors(ImlibData *id)
{
   int i;
   unsigned long pixels[256];
   
   for (i=0;i<id->num_colors;i++) pixels[i]=id->palette[i].pixel;
   XFreeColors(id->x.disp,id->x.root_cmap,pixels,id->num_colors,0);
   id->num_colors=0;
}

