#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include "../imlib.h"
Display *disp;
Window Root; 
Window win;
Visual *vis; 
int scr; 
GC fg,bg;
int blk,wht;
int width,height;

void OpenWindow()
{
   XGCValues gcvals;
   int i;
   int dummy;
   
   disp=XOpenDisplay(NULL);
   if (disp)
     {
	Root=DefaultRootWindow(disp);
	scr=DefaultScreen(disp);
	blk=BlackPixel(disp,scr);
	wht=WhitePixel(disp,scr);
	vis=DefaultVisual(disp,scr);
	win=XCreateSimpleWindow(disp,Root,0,0,width+2,height+2,0,blk,blk);
	XMapWindow(disp,win);
	XSync(disp,False);
	fg=XCreateGC(disp,win,(unsigned long)0,&gcvals);
	bg=XCreateGC(disp,win,(unsigned long)0,&gcvals);
	XSetForeground(disp,fg,wht);
	XSetBackground(disp,bg,blk);
     }
   else
     {
	printf("Cannot open display\n");
	exit(1);
     }
}

main(int argc, char **argv)
{  
   int i,j;
   ImlibData *id;
   Image *im;
   ImColor icl;
   Pixmap pmap;
   int sec1,usec1,sec2,usec2;
   struct timeval timev;
   int c;
   double tim;
   
   printf(".\n");
   width=256;
   height=256;
   pmap=0;
   OpenWindow();
   id=ImlibInit(disp);
   printf("..\n");
   
   icl.r=255,icl.g=0;icl.b=255;
   im=ImlibLoadImage(id,argv[1],&icl);
   printf("...\n");
   i=200,j=200;
   gettimeofday(&timev,NULL); 
   sec1=(int)timev.tv_sec; 
   usec1=(int)timev.tv_usec;
   c=0;
   while(1)
     {
	ImlibRender(id,im,i+(rand()%80),j+(rand()%80));
	if (pmap) XFreePixmap(disp,pmap);
	pmap=ImlibMoveImageToPixmap(id,im);
	XSetWindowBackgroundPixmap(disp,win,pmap);
	XClearWindow(disp,win);
	c++;
	if (c==128)
	  {  
	     gettimeofday(&timev,NULL);
	     sec2=(int)timev.tv_sec;
	     usec2=(int)timev.tv_usec;
	     tim=((double)sec2+((double)usec2/1000000))-
	       ((double)sec1+((double)usec1/1000000));
	     printf("time: %3.5f sec\nfps:  %3.5f\n",tim,(double)c/tim);
	     c=0;
	     gettimeofday(&timev,NULL);
	     sec1=(int)timev.tv_sec;
	     usec1=(int)timev.tv_usec;
	  }
     }
}
