/*
 * Always AL500 defines
 *
 * Copyright 1994, Don Weeks
 *	dweeks@netcom.com
 *
 * DISTRIBUTION RELEASE 1. 
 *
 * For more information, please consult 
 *
 * NCR 53C400 Family
 * SCSI Host Adapter
 * Databook
 *
 * NCR Microelectronics
 * 1635 Aeroplaza Drive
 * Colorado Springs, CO 80916
 * 1+ (719) 578-3400
 * 1+ (800) 334-5454
 */

/*
 * $Log: al500.h,v $
 */

#ifndef AL500_H
#define AL500_H

#define AL500_PUBLIC_RELEASE 1

#define TDEBUG_INIT	0x1
#define TDEBUG_TRANSFER 0x2

/*
 * The Always boards are memory mapped. They use an NCR53C400 which is a 53C80 with 
 * wrap around support logic.
 */

#define T_RAM_OFFSET		0x3800

#define A_CONTROL_REG_OFFSET	0x3980	/* rw */
#define A_CR_INT		0x10	/* Enable interrupts */
#define A_CR_CT			0x02	/* Reset watchdog timer */

#define A_STATUS_REG_OFFSET	0x3981 /* ro */
#define A_ST_BOOT		0x80	/* Boot switch */
#define A_ST_S3			0x40	/* User setable switches, */
#define A_ST_S2			0x20	/* read 0 when switch is on, 1 off */
#define A_ST_S1			0x10
#define A_ST_PS2		0x08	/* Set for Microchannel 228 */
#define A_ST_RDY		0x04	/* 5380 DRQ */
#define A_ST_TIM		0x02	/* indicates 40us watchdog timer fired */
#define A_ST_ZERO		0x01	/* Allways zero */

#define A_5380_OFFSET		0x3880	/* 8 registers here, see NCR5380.h */

#define A_DATA_REG_OFFSET	0x3900	/* rw 512 bytes long */

#ifndef ASM
int al500_abort(Scsi_Cmnd *);
int al500_biosparam(Disk *, int, int*);
int al500_detect(Scsi_Host_Template *);
const char *al500_info(void);
int al500_queue_command(Scsi_Cmnd *, void (*done)(Scsi_Cmnd *));
int al500_reset(Scsi_Cmnd *);

#ifndef NULL
#define NULL 0
#endif

#ifndef CMD_PER_LUN
#define CMD_PER_LUN 2
#endif

#ifndef CAN_QUEUE
#define CAN_QUEUE 32 
#endif

#ifdef HOSTS_C

#define ALWAYS_AL500 {NULL, NULL,"Always Technologies AL-500", al500_detect, NULL, \
	NULL,\
	NULL, al500_queue_command, al500_abort, al500_reset, NULL, 	\
	al500_biosparam, 						\
	/* can queue */ CAN_QUEUE, /* id */ 7, SG_ALL,			\
	/* cmd per lun */ CMD_PER_LUN , 0, 0, DISABLE_CLUSTERING}

#else

#define NCR5380_implementation_fields \
    volatile unsigned char *base

#define NCR5380_local_declare() \
    volatile unsigned char *base

#define NCR5380_setup(instance) \
    base = (volatile unsigned char *) (instance)->base

#define AL500_address(reg) (base + A_5380_OFFSET + reg)

#if !(TDEBUG & TDEBUG_TRANSFER) 
#define NCR5380_read(reg) (*(AL500_address(reg)))
#define NCR5380_write(reg, value) (*(AL500_address(reg)) = (value))
#else
#define NCR5380_read(reg)						\
    (((unsigned char) printk("scsi%d : read register %d at address %08x\n"\
    , instance->hostno, (reg), AL500_address(reg))), *(AL500_address(reg)))

#define NCR5380_write(reg, value) {					\
    printk("scsi%d : write %02x to register %d at address %08x\n", 	\
	    instance->hostno, (value), (reg), AL500_address(reg));	\
    *(AL500_address(reg)) = (value);					\
}
#endif

#define NCR5380_intr al500_intr
#define NCR5380_queue_command al500_queue_command
#define NCR5380_abort al500_abort
#define NCR5380_reset al500_reset

/* 0000 0000 1111 1110 
        0x00fe */

#define AL500_IRQS 0x00fe

#endif /* else def HOSTS_C */
#endif /* ndef ASM */
#endif 
