#define AUTOSENSE

/*
 * Always Technologies AL-500
 *
 * Copyright 1994, Don Weeks
 *       dweeks@netcom.com
 *       1 (214) 205-4390
 *
 * Portions of this code:
 * Copyright 1993, Drew Eckhardt
 *	Visionary Computing
 *	(Unix and Linux consulting and custom programming)
 *	drew@colorado.edu
 *      +1 (303) 440-4894
 *
 * DISTRIBUTION RELEASE 1.
 *
 * For more information, please consult 
 *
 * NCR SCSI Products
 * NCR 53C400
 * SCSI Host Adapter
 *
 * NCR Microelectronics
 * 1635 Aeroplaza Drive
 * Colorado Springs, CO 80916
 * 1+ (719) 578-3400
 * 1+ (800) 334-5454
 */

/*
 * $Log: al500.c,v $
 */

#include <asm/system.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include "../block/blk.h"
#include "scsi.h"
#include "hosts.h"
#include "al500.h"
#define AUTOPROBE_IRQ
#include "NCR5380.h"
#include "constants.h"
#include "sd.h"



static struct override {
    unsigned char *address;
    int irq;
} overrides 
#ifdef T128_OVERRIDE
    [] = T128_OVERRIDE;
#else
    [4] = {{NULL,IRQ_AUTO}, {NULL,IRQ_AUTO}, {NULL,IRQ_AUTO},
	{NULL,IRQ_AUTO}};
#endif

#define NO_OVERRIDES (sizeof(overrides) / sizeof(struct override))

static struct base {
    unsigned char *address;
    int noauto;
} bases[] = {{(unsigned char *) 0xcc000, 0}, {(unsigned char *) 0xc8000, 0},
    {(unsigned char *) 0xdc000, 0}, {(unsigned char *) 0xd8000, 0}};

#define NO_BASES (sizeof (bases) / sizeof (struct base))

static const struct signature {
    const char *string;
    int offset;
} signatures[] = {
{"AL-500", 0x0ba6},
};

#define NO_SIGNATURES (sizeof (signatures) /  sizeof (struct signature))

/*
 * Function : al500_setup(char *str, int *ints)
 *
 * Purpose : LILO command line initialization of the overrides array,
 * 
 * Inputs : str - unused, ints - array of integer paramters with ints[0]
 *	equal to the number of ints.
 *
 */

void al500_setup(char *str, int *ints) {
    static int commandline_current = 0;
    int i;
    if (ints[0] != 2) 
	printk("al500_setup : usage al500=address,irq\n");
    else 
	if (commandline_current < NO_OVERRIDES) {
	    overrides[commandline_current].address = (unsigned char *) ints[1];
	    overrides[commandline_current].irq = ints[2];
	    for (i = 0; i < NO_BASES; ++i)
		if (bases[i].address == (unsigned char *) ints[1]) {
		    bases[i].noauto = 1;
		    break;
		}
	    ++commandline_current;
	}
}

/* static struct sigaction al500_sigaction =  { al500_intr, 0, SA_INTERRUPT , NULL };
*/
/* 
 * Function : int al500_detect(int hostno)
 *
 * Purpose : detects and initializes T128,T128F, or T228 controllers
 *	that were autoprobed, overriden on the LILO command line, 
 *	or specified at compile time.
 *
 * Inputs : hostno - id of this SCSI adapter.
 * 
 * Returns : 1 if a host adapter was found, 0 if not.
 *
 */

int al500_detect(Scsi_Host_Template * tpnt) {
    static int current_override = 0, current_base = 0;
    struct Scsi_Host *instance;
    unsigned char *base;
    int sig, count;

    for (count = 0; current_override < NO_OVERRIDES; ++current_override) {
	base = NULL;

	if (overrides[current_override].address)
	    base = overrides[current_override].address;
	else 
	    for (; !base && (current_base < NO_BASES); ++current_base) {
/*    printk("scsi%d : probing address %08x\n", hostno, (unsigned int) bases[current_base].address); */
#if (TDEBUG & TDEBUG_INIT)
    printk("scsi : probing address %08x\n",  (unsigned int) bases[current_base].address);
#endif
		for (sig = 0; sig < NO_SIGNATURES; ++sig)
		{   
/*                    printk("looking for %s:\n",signatures[sig].string) ; */
		    if (!bases[current_base].noauto && !memcmp 
			(bases[current_base].address + signatures[sig].offset, 
			signatures[sig].string, strlen(signatures[sig].string))) {
			base = bases[current_base].address;
/*			printk("scsi-al500 : detected board.\n"); */
#if (TDEBUG & TDEBUG_INIT)
			printk("scsi-al500 : detected board.\n", hostno);
#endif
			break;
		    }
		    else printk("Not Found!\n");
		}
	    }

#if defined(TDEBUG) && (TDEBUG & TDEBUG_INIT)
	printk("scsi : base = %08x\n", (unsigned int) base);
#endif

	if (!base)
	    break;

	instance = scsi_register (tpnt, sizeof(struct NCR5380_hostdata));
	instance->base = base;

	NCR5380_init(instance,0);

	if (overrides[current_override].irq != IRQ_AUTO)
	    instance->irq = overrides[current_override].irq;
	else 
	    instance->irq = NCR5380_probe_irq(instance, AL500_IRQS);

	if (instance->irq != IRQ_NONE) 
	    if (request_irq (instance->irq, al500_intr, SA_INTERRUPT, "al500")) {
		printk("scsi-al500 : IRQ%d not free, interrupts disabled\n", 
		     instance->irq);
		instance->irq = IRQ_NONE;
	    } 

	if (instance->irq == IRQ_NONE) {
	    printk("scsi-al500 : interrupts not enabled. for better interactive performance,\n");
	    printk("scsi-al500 : please jumper the board for a free IRQ.\n");
	}

#if defined(TDEBUG) && (TDEBUG & TDEBUG_INIT)
	printk("scsi-al500 : irq = %d\n",  instance->irq);
#endif

	printk("scsi-al500 : at 0x%08x",  (int) 
	    instance->base);
	if (instance->irq == IRQ_NONE)
	    printk (" interrupts disabled");
	else 
	    printk (" irq %d", instance->irq);
	printk(" options CAN_QUEUE=%d  CMD_PER_LUN=%d release=%d",
	    CAN_QUEUE, CMD_PER_LUN, AL500_PUBLIC_RELEASE);
	NCR5380_print_options(instance);
	printk("\n");

	++current_override;
	++count;
    }
    return count;
}

/*
 * Function : int al500_biosparam(int size, int dev, int *ip)
 *
 * Purpose : Generates a BIOS / DOS compatable H-C-S mapping for 
 *	the specified device / size.
 * 
 * Inputs : size = size of device in sectors (512 bytes), dev = block device
 *	major / minor, ip[] = {heads, sectors, cylinders}  
 *
 * Returns : allways 0 (success), initializes ip
 *	
 */

/* 
 * XXX Most SCSI boards use this mapping, I could be incorrect.  Some one
 * using hard disks on a trantor should verify that this mapping corresponds
 * to that used by the BIOS / ASPI driver by running the linux fdisk program
 * and matching the H_C_S coordinates to what DOS uses.
 */

int al500_biosparam(Disk * disk, int dev, int * ip)
{
  int size = disk->capacity;
  ip[0] = 64;
  ip[1] = 32;
  ip[2] = size >> 11;
  return 0;
}

/*
 * Function : const char *al500_info(void)
 *
 * Purpose : provide furthur information about this driver.
 *
 */

const char *al500_info (void) {
    static const char string[]="";
    return string;
}

#include "NCR5380.c"
