#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>



#define X 720
#define Y 344
#define STEPS 2000
#define SR    (1.0/STEPS)
#define FAST  40000

void nextp(double *a,double *b) {
	static int s=0,t=0;
	static double fx, fy;
	static double dx=0, dy=0;
	static double ddx=0, ddy=0;
	double nx, ny, gx, gy, tt;

	if(s==0||s<=t) { 
		fx=*a; fy=*b;
TRY_AGAIN:
		nx=(drand48()*X+fx)/2;
		ny=(drand48()*Y+fy)/2;
		gx=nx-fx; gy=ny-fy;
		dx=dx+t*SR*ddx;
		dy=dy+t*SR*ddy;
		ddx=2*(gx-dx);
		ddy=2*(gy-dy);
		s=drand48()*STEPS;t=0;
		if((dx+s*SR*ddx)*(dx+s*SR*ddx)+(dy+s*SR*ddy)+(dy+s*SR*ddy)>FAST) goto TRY_AGAIN;
		/* printf("%d %d %8.3f %8.3f %8.3f %8.3f\n",s,t,dx,dy,ddx,ddy); */
	}
	/* printf("%8.3f %8.3f %8.3f %8.3f %8.3f %8.3f\n",*a,*b,dx,dy,ddx,ddy); */
	t++; /* *a+=dx*.01; *b+=dy*.01; */
	tt=t*SR;
	*a=fx+tt*(dx+tt*(ddx/2));
	*b=fy+tt*(dy+tt*(ddy/2));
	/* dx+=ddx*.01; dy+=ddy*.01; */
}
#define WHITE 1
#define BLACK 0
#define XOR  -1

#define byte_addr(x,y) (((y)/4)*90 + ((y)&3)*0x2000 + ((x)/8))
#define bit_pos(x)     (1 << (7 - ((x)&7)))
#define bit_num(x)     ((x)&7)

unsigned char *screen;
/* color: 1-dot on;  0-dot off -1 is xor	     */

inline void clear(void) {
	memset(screen,0,32768);
}

inline void dot(int x,int y,int color)
{
  int index;
  int bit_pos;

	if(x<0||x>=720||y<0||y>=344) return;
  index = byte_addr(x,y);
  bit_pos = bit_pos(x);
  if (color == WHITE) {
    screen[index] |= bit_pos;
  }
  else if (color == BLACK) {
    screen[index] &= ~bit_pos;
  }
  else /* if (color == XOR) */ {
    screen [index] ^= bit_pos;
  }
}
#define NCOL   (32)
#define EACH   (256)
#if 0
#define LIFE   (2)
#else
#define LIFE   (NCOL)
#endif
#define POINTS (NCOL*EACH)

#define JB 0

#define M(a,b) G ## a ## x ## b ## x256
#define MM(a,b) M(a,b)
#define MODE MM(X,Y)

#define F2X(x) ((int)((x)*(X/4)+(X/2)))
#define F2Y(y) ((int)((y)*(Y/4)+(Y/2)))

#define X2F(x) (((x)-(X/2))/(X/4.0))
#define Y2F(y) (((y)-(Y/2))/(Y/4.0))

#define move2(x,X,a) (fmod((x)+(drand48()*((a)*2))+(X-(a)),X))
#define move(x,X) move2(x,X,.5)
#define imove(x) ((x)+(lrand48()%3)-1)

#define REAL float

struct complex { REAL a, b; };

static inline REAL real(struct complex a) {
	return a.a;
}
	
static inline REAL imag(struct complex b) {
	return b.b;
}

static inline struct complex cmake(REAL a, REAL b) {
	register struct complex r;
	r.a=a;
	r.b=b;
	return r;
}

static inline struct complex add(struct complex a1, struct complex a2) {
	register struct complex r;
	r.a=a1.a+a2.a;
	r.b=a1.b+a2.b;
	return r;
}

static inline struct complex mul(struct complex a1, struct complex a2) {
	register struct complex r;
	r.a=a1.a*a2.a-a1.b*a2.b;
	r.b=a1.b*a2.a+a1.a*a2.b;
	return r;
}


static inline REAL mag2(struct complex a1) {
	register REAL d;
	d=a1.a*a1.a+a1.b*a1.b;
	return d;
}

/* MANDEL */
/* z(n+1)=z(n)**2+c */
inline int next(struct complex c[]) {
    c[0]=add(mul(c[0],c[0]),c[1]);
    return mag2(c[0])<8;
}

int do_stuff(void) {
    register int
	    x,y,d,e=0,h,c=1;
    double  a=X/2.0,b=Y/2.0;
    int     p[POINTS][2];
    struct complex
	    f[EACH  ][2];
    int     g[EACH  ];


    srand48(time(NULL));
    for(h=0;h<EACH;h++) {
	p[h][0]=p[h][1]=0;
	f[h][0]=cmake(0.,0.);
	nextp(&a,&b);
	f[h][1]=cmake(X2F(a),Y2F(b));
	g[h]=h*LIFE/EACH;
    }

    while(1) {
	for(d=e,h=e+EACH;d<h;d++) {
	    dot(p[d][0],p[d][1],0);
	    dot(p[d][0],Y-p[d][1]-1,0);
	} 
	for(h=0;h<EACH;h++,e++) {
	    if(++g[h]<LIFE&&next(f[h])) {
				x=F2X(real(f[h][0]));
				y=F2Y(imag(f[h][0]));
				dot(p[e][0]=x,p[e][1]=y,1);
				dot(x,Y-y-1,1);
	   	} else {  
				g[h]=0;
				f[h][0]=cmake(0.,0.);
				nextp(&a,&b);
				f[h][1]=cmake(X2F(a),X2F(b));
	    }
	}
	e%=POINTS;
	if(++c>NCOL) c=1;
		usleep(200);
  }
  return 0;
}

main(int cc, char **v) {
	int fd=open("/dev/monographic",O_RDWR);
	int c;

	srand48(time(NULL)^getpid());
	if(fd==-1) { perror("open(/dev/monographic)"); return 1; }
	screen=mmap(0, 0x8000, PROT_READ|PROT_WRITE, MAP_FILE|MAP_SHARED, fd, 0);
	if((unsigned long int)screen==-1) { perror("mmap(/dev/mono)"); return 1; }
	clear();
	do_stuff();
	read(0,&c,1);
	return 0;
}
