/* $Id: isdnlog.h,v 1.25 1995/11/14 17:54:16 akool Exp akool $
 *
 * ISDN accounting for isdn4linux.
 *
 * Copyright 1995 by Andreas Kool (akool@Kool.f.EUnet.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: isdnlog.h,v $
 * Revision 1.25  1995/11/14  17:54:16  akool
 *
 */


#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <time.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/times.h>
#include <sys/stat.h>
#include <ctype.h>
#include <limits.h>
#include <signal.h>


#undef  min
#undef  max
#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define min(a,b)        (((a) < (b)) ? (a) : (b))


#define NUMSIZE      20
#define RETSIZE      32
#define MAXRET	      2
#define MAXZONES      6

#define DIGITS 	     17
#define DEB           1

#define MAXUNKNOWN   50
#define MAXCONNECTS  50

#define CALLING       0
#define CALLED        1
#define DATETIME      2

#define YOUPAY	      0
#define IPAY	      1

#define DIALOUT	      0
#define DIALIN	      1


#define SHOWNUMBERS   1
#define SHOWAOCD      2
#define	SHOWCONNECT   4
#define	SHOWHANGUP    8
#define	SHOWCAUSE    16
#define	SHOWTIME     32

#define AOC_130	     -999990L

#define QCMASK  0377
#define QUOTE   0200
#define QMASK   (QCMASK &~QUOTE)
#define NOT     '!'


typedef struct {
  char    num[2][NUMSIZE];
  int	  tei;
  int     dialin;
  int	  eh;
  int     embryonic;
  int	  release;
  time_t  connect;
  time_t  disconnect;
  clock_t duration;
} CALL;


typedef struct {
  char   *num;
  char	 *who;
  char   *infoarg;
  int	  zone;
  int	  usage;
  double  dur[2];
  int     eh[2];
} KNOWN;


typedef struct {
  int     dialin;
  int	  channel;
  char    calling[NUMSIZE];
  char    called[NUMSIZE];
  char	  info[64];
} XINFO;


PUBLIC KNOWN **known;
PUBLIC int     mymsns;
PUBLIC int     knowns;
PUBLIC char   *hangup;
PUBLIC int     day;
PUBLIC int     month;
PUBLIC int     retnum;
PUBLIC char    retstr[MAXRET][RETSIZE];
PUBLIC char   *myname, *myfullname;
PUBLIC char   *Months[];


extern int   optind, errno;
extern char *optarg;


/* tools.c */
time_t atom(register char *p);
void   readconfig(char *myname);
int    match(register char *s, register char *p);
char  *num2nam(char *num);
char  *double2str(double n, int l, int d, int flags);

/* cheap.c */
double cheap96(time_t when, int zone);
double cheap(time_t when, int zone);
