#include "teles.h"

#ifdef DEF_VERSION
char kernel_version[]=UTS_RELEASE;
#endif

extern struct IsdnCard cards[];

int nrcards;

typedef struct {
  byte         *membase;
  int          interrupt;
  unsigned int ioaddr;
} io_type;

io_type io[] = {
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
{0,0,0},
};

void teles_mod_dec_use_count(void)
{
  MOD_DEC_USE_COUNT;
}

void teles_mod_inc_use_count(void)
{
  MOD_INC_USE_COUNT;
}

int init_module(void) 
{
  int i;

  nrcards = 0;
  for (i=0;i<16;i++) {
    if (io[i].membase) {
      cards[i].membase   = io[i].membase;
      cards[i].interrupt = io[i].interrupt;
      cards[i].ioaddr    = io[i].ioaddr;
      /* Some time, this will be configurable like the others */
      cards[i].protocol  = PROTO_EURO;
    }
  }
  for (i=0;i<16;i++) {
    if (cards[i].membase) {
      nrcards++;
      printk(KERN_INFO "teles: card #%d: mem=0x%08lx, irq=%d, io=0x%04x\n",
	     i+1,
	     (unsigned long)cards[i].membase,
	     cards[i].interrupt,
	     cards[i].ioaddr);
    }
  }
  printk(KERN_INFO "teles: Total %d card%s defined\n",nrcards,(nrcards>1)?"s":"");
  teles_inithardware();
  Isdnl2New();
  TeiNew();
  CallcNew();
  ll_init();
  printk(KERN_INFO "Teles module installed\n");
  return(0);
}

void cleanup_module( void) 
{

  ll_stop();
  TeiFree();
  Isdnl2Free();
  CallcFree();
  teles_closehardware();
  ll_unload();
  printk(KERN_INFO "Teles module removed\n");
  
}

