#include <linux/config.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/timer.h>
#include <linux/fs.h>
#include <asm/segment.h>

#define byte unsigned char

#include <linux/kernel.h>
#include <linux/mm.h>

#include "isdnif.h"
#include "teles.h"

static struct PStack *findces(struct PStack *st,int ces)
{
  struct PStack *ptr=*(st->l1.stlistp);

  while (ptr) 
    if (ptr->l2.ces==ces)
      return(ptr); 
    else
      ptr=ptr->next; 
  return(NULL);
}

static struct PStack *findtei(struct PStack *st,int tei)
{
  struct PStack *ptr=*(st->l1.stlistp);

  if (tei==127) return(NULL);
  
  while (ptr) 
    if (ptr->l2.tei==tei)
      return(ptr);
    else
      ptr=ptr->next; 
  return(NULL);
}

void tei_handler(struct PStack  *st,
  byte pr,struct BufHeader *ibh)
{
  byte *bp;
  unsigned int tces;
  struct PStack *otsp;
  unsigned int data;
   
  if (st->l2.debug)
    printk("teihandler %d\n",pr);  

  switch(pr) {
  case(MDL_ASSIGN):
    data=(unsigned int)ibh;
    BufPoolGet(&ibh,st->l1.smallpool,GFP_ATOMIC,(void *)st,6);
    if (!ibh) return;
    bp=DATAPTR(ibh);
    bp+=st->l2.uihsize;
    bp[0]=0xf;
    bp[1]=data>>8;bp[2]=data&0xff;
    bp[3]=0x1;bp[4]=0xff;
    ibh->datasize=8;
    st->l2.hdown(st,DL_UNIT_DATA,ibh);
    break;
  case(DL_UNIT_DATA):
    bp=DATAPTR(ibh);
    bp+=3;
    if (bp[0]!=0xf) break;   
    switch(bp[3]) {
    case(2):
      tces=(bp[1]<<8)|bp[2];
      BufPoolRelease(ibh);
      if (st->l3.debug)
	printk("tei identity assigned for %d=%d\n",tces,
           bp[4]>>1);
      if ((otsp=findces(st,tces)))  
        otsp->l2.hdown(otsp,MDL_ASSIGN,bp[4]>>1);
      break;
    case(4):
      if (st->l3.debug)
	printk("checking identity for %d\n",bp[4]>>1);
      otsp=findtei(st,bp[4]>>1);
      BufPoolRelease(ibh);
      if (!otsp) break;
      if (st->l3.debug)
	printk("ces is %d\n",otsp->l2.ces);
      if (BufPoolGet(&ibh,st->l1.smallpool,GFP_ATOMIC,(void *)st,7)) 
	break;        
      bp=DATAPTR(ibh);
      bp+=3;
      bp[0]=0xf;
      bp[1]=otsp->l2.ces>>8;bp[2]=otsp->l2.ces&0xff;
      bp[3]=0x5;bp[4]=(otsp->l2.tei<<1)|1;
      ibh->datasize=8;
      st->l2.hdown(st,DL_UNIT_DATA,ibh);
      break;
    default:
      BufPoolRelease(ibh);
      if (st->l3.debug)
	printk("tei message unknown %d ai %d\n",bp[3],bp[4]>>1);
    }
    break;
  default:
    printk("tei handler unknown primitive %d\n",pr);
    break;
  }
}

unsigned int randomces(void)
{ 
  int x=jiffies&0xffff;
  return(x);
}

