#include <linux/config.h>
#include <linux/module.h>

#include <asm/segment.h>

#define byte unsigned char

#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/timer.h>

#include "isdnif.h"
#include "teles.h"

void walkmessage(byte *p,int size)
{
  int l,i;
  byte *pend=p+size;

  printk("protocol discriminator %x\n",*p++);
  l=*p&0xf;
  printk("callref length %d\n",*p++); 
  for(i=0;i<l;i++)
    printk("callref byte %x\n",*p++);
  printk("message type %x\n",(*p++)&0x7f);
   
  while (p<pend) 
    if (*p&0x80)
      printk("single octect ie %x\n",*p++);
    else {
      printk("ie %x\n",*p++);
      l=*p++;
      p+=l;
    }

}

byte * findie(byte *p,int size,byte ie)
{
  int l;
  byte *pend=p+size;

  p++;
  l=(*p++)&0xf;
  p+=l;
  p++;
   
  while (p<pend) 
    if (*p&0x80)
      p++;
    else {
      if (*p==ie) return(p);
      if (*p>ie) return(NULL);
      p++;
      l=*p++;
      p+=l;
    }
  return(NULL);
}

void iecpy(byte *dest,byte *iestart,int ieoffset)
{
  byte *p;
  int l;

  p=iestart+ieoffset+2;
  l=iestart[1]-ieoffset;
  while (l--) *dest++=*p++;
  *dest++='\0';
}

int getcallref(byte *p)
{
  p++;  /* prot discr */
  p++;  /* callref length */
  return(*p); /* assuming one-byte callref */
}

struct MessageType {
  byte nr;
  char *descr; } mtlist[]={
  {0x1,"ALERTING"},
  {0x2,"CALL PROCEEDING"},
  {0x7,"CONNECT"},
  {0xf,"CONNECT ACKNOWLEDGE"},
  {0x3,"PROGRESS"},
  {0x5,"SETUP"},
  {0xd,"SETUP ACKNOWLEDGE"},
  {0x26,"RESUME"},
  {0x2e,"RESUME ACKNOWLEDGE"},
  {0x22,"RESUME REJECT"},
  {0x25,"SUSPEND"},
  {0x2d,"SUSPEND ACKNOWLEDGE"},
  {0x21,"SUSPEND REJECT"},
  {0x20,"USER INFORMATION"},
  {0x45,"DISCONNECT"},
  {0x4d,"RELEASE"},
  {0x5a,"RELEASE COMPLETE"},
  {0x46,"RESTART"},
  {0x4e,"RESTART ACKNOWLEDGE"},
  {0x60,"SEGMENT"},
  {0x79,"CONGESTION CONTROL"},
  {0x7b,"INFORMATION"},
  {0x62,"FACILITY"},
  {0x6e,"NOTIFY"},
  {0x7d,"STATUS"},
  {0x75,"STATUS ENQUIRY"}
};
#define MTSIZE sizeof(mtlist)/sizeof(struct MessageType)  

static int prbits(char *dest,byte b,int start,int len)
{
  char *dp=dest;

  b=b<<(8-start);
  while (len--) {
    if (b&0x80)
      dp+=sprintf(dp,"1");
    else
      dp+=sprintf(dp,"0");
    b=b<<1;
  }
  return(dp-dest);
}

byte *skipext(byte *p)
{
  while (!(*p++&0x80)) ;
  return(p);
}

int prcause(char *dest,byte *p)
{
  byte *end;
  char *dp=dest;
 
  dp+=sprintf(dp,"  cause\n");
  end=p+p[1]+1;
  p+=2;
  dp+=sprintf(dp,"    coding ");dp+=prbits(dp,*p,7,2);
  dp+=sprintf(dp," location ");dp+=prbits(dp,*p,4,4);
  dp+=sprintf(dp,"\n");
  p=skipext(p);
  dp+=sprintf(dp,"    cause value ");dp+=prbits(dp,*p++,7,7);
  dp+=sprintf(dp,"\n");
  while (!0) {
    if (p>end) break;
    dp+=sprintf(dp,"    diag attribute %d ",*p++&0x7f);
    dp+=sprintf(dp," rej %d ",*p&0x7f);
    if (*p&0x80) {
      dp+=sprintf(dp,"\n");
      break;
    }
    else
      dp+=sprintf(dp," av %d\n",(*++p)&0x7f);
  }
  return(dp-dest);

}

static unsigned int ul_channel;

int  prchident(char *dest,byte *p)
{
  char *dp=dest;

  dp+=sprintf(dp,"  channel identification\n");
  p+=2;
  dp+=sprintf(dp,"    octet 3 ");dp+=prbits(dp,*p,8,8);
  dp+=sprintf(dp,"\n");
  ul_channel=(*p)&0x3;
  return(dp-dest);
}

int prcalled(char *dest,byte *p)
{
  int l;
  char *dp=dest;

  dp+=sprintf(dp,"  called party number\n");
  p++;
  l=*p++-1;
  dp+=sprintf(dp,"    octet 3 ");dp+=prbits(dp,*p++,8,8);
  dp+=sprintf(dp,"\n");
  dp+=sprintf(dp,"    number digits ");
  while(l--) dp+=sprintf(dp,"%c",*p++);
  dp+=sprintf(dp,"\n");
  return(dp-dest);
}

int prcalling(char *dest,byte *p)
{
  int l;
  char *dp;

  dp=dest;
  dp+=sprintf(dp,"  calling party number\n");
  p++;
  l=*p++-1;
  dp+=sprintf(dp,"    octet 3 ");dp+=prbits(dp,*p,8,8);
  dp+=sprintf(dp,"\n");
  if (!(*p&0x80)) {
    dp+=sprintf(dp,"    octet 3a ");dp+=prbits(dp,*++p,8,8);
    dp+=sprintf(dp,"\n");
    p++;
    l--;
  }
  dp+=sprintf(dp,"    number digits ");
  while(l--) dp+=sprintf(dp,"%c",*p++);
  dp+=sprintf(dp,"\n");
  return(dp-dest);
}

int prbearer(char *dest,byte *p)
{
  char *dp;

  dp=dest; 
  dp+=sprintf(dp,"  bearer capability\n");
  p+=2;
  dp+=sprintf(dp,"    octet 3 ");dp+=prbits(dp,*p++,8,8);
  dp+=sprintf(dp,"\n");
  dp+=sprintf(dp,"    octet 4 ");dp+=prbits(dp,*p++,8,8);
  dp+=sprintf(dp,"\n");
  dp+=sprintf(dp,"    octet 5 ");dp+=prbits(dp,*p++,8,8);
  dp+=sprintf(dp,"\n");
  return(dp-dest);
}

struct InformationElement {
  byte nr;
  char *descr;
  int (*f)(); 
} ielist[]={
  {0x08,"Cause",prcause},
  {0x18,"Channel identification",prchident},
  {0x70,"Called party number",prcalled},
  {0x04,"Bearer capability",prbearer},
  {0x6c,"Calling party number",prcalling},
};
#define IESIZE sizeof(ielist)/sizeof(struct InformationElement)

void dlogframe(struct IsdnCardState *sp,byte *p,int size,
  char *comment)
{
  byte *dp,*buf=p,*ptr;
  int i,j,startm=4;
  
  dp=sp->dlogspace;
  dp+=sprintf(dp,"%s\n",comment);
  
  for(i=0;i<MTSIZE;i++) 
    if (mtlist[i].nr==buf[startm-1]) break;

  if (i==MTSIZE)
    dp+=sprintf(dp,"Unknown message type %x!\n",buf[startm-1]);
  else  
    dp+=sprintf(dp,"call reference %d size %d message type %s\n",
      buf[startm-2],size,mtlist[i].descr);

  ptr=buf+startm;
  while (ptr<buf+size) {
    for(j=0;j<IESIZE;j++) 
      if (*ptr==ielist[j].nr) break; 

    if (j!=IESIZE) 
      dp+=ielist[j].f(dp,ptr);
    else
      dp+=sprintf(dp,"  attribute %x attribute size %d\n",*ptr,
        (*ptr&0x80)?0:ptr[1]);
      
    if (*ptr&0x80) 
      ptr++;
    else
      ptr+=ptr[1]+2;
  }
 
  dp+=sprintf(dp,"\n");
  teles_putstatus(sp->dlogspace);       
}
