#include <linux/mm.h>
#include <linux/timer.h>

#define byte unsigned char
#include "isdnif.h"
#include "teles.h"

#include <linux/config.h>
#include <linux/version.h>
#include <linux/module.h>
#include <linux/fs.h>

static char kernel_version[] = UTS_RELEASE; 

extern int printk( const char* fmt, ...);
extern int nrcards;

int init_module(void) 
{
  kernel_version[0] = kernel_version[0];

  teles_inithardware();
  CallcNew();
  ll_init();
  printk("Teles module installed\n");
  return(0);
}

void cleanup_module( void) 
{
  ll_release();
  CallcFree();
  teles_closehardware();
  printk("Teles module removed\n");
  
}

