#include <linux/config.h>
#include <linux/module.h>

#include <asm/segment.h>

#define byte unsigned char

#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/timer.h>

#include "isdnif.h"
#include "teles.h"

static void i_down(struct PStack *st,
  struct BufHeader *ibh)
{
  st->l2.hdown(st,DL_DATA,ibh);
}  

static void newl3state(struct PStack *st,int state)
{
  if (st->l3.debug)
    printk("newl3state %d\n",state);
  st->l3.state=state;
}

static void l3_message(struct PStack *st,int mt)
{
  struct BufHeader *dibh;
  byte *p;
  int size;
  
  BufPoolGet(&dibh,st->l1.sbufpool,GFP_ATOMIC,(void *)st,18);
  p=DATAPTR(dibh);
  p+=st->l2.ihsize;
  size=st->l2.ihsize;
  
  *p++=0x8;
  *p++=0x1;
  *p++=st->l3.callref;
  *p++=mt;
  size+=4;

  dibh->datasize=size;
  i_down(st,dibh);
}

static void l3s3(struct PStack *st)
{
  l3_message(st,MT_RELEASE);
  newl3state(st,19);
}

static void l3s4(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  BufPoolRelease(ibh);
  newl3state(st,0);
  st->l4.hup(st,CC_RELEASE_CNF,NULL); 
}

static void l3s5(struct PStack *st,byte pr,
  void *arg)
{
  struct BufHeader *dibh;
  byte *p;
  int size;
  char *teln;

  if (st->l3.debug) printk("cc_setup voor %s\n",st->pa->called);

  st->l3.callref=st->pa->callref;
  BufPoolGet(&dibh,st->l1.sbufpool,GFP_ATOMIC,(void *)st,19);
  p=DATAPTR(dibh);
  p+=st->l2.ihsize;
  size=st->l2.ihsize;
  
  *p++=0x8;
  *p++=0x1;
  *p++=st->l3.callref;
  *p++=0x5;
  *p++=0xa1;
  size+=5;
      
  if (st->pa->itc==16) {
   *p++=0x4;
   *p++=0x3;
   *p++=0x80|st->pa->itc;
   *p++=0x90;
   *p++=0xa3;
    size+=5;
  }
  else {
    *p++=0x4;
    *p++=0x2;
    *p++=0x80|st->pa->itc;
    *p++=0x90;
     size+=4;
  }	

#if 0            /* user-user not allowed in The Netherlands! */ 
  *p++=0x7f;
  *p++=0x2;
  *p++=0x0;
  *p++=66;
  size+=4;
#endif
  
  *p++=0x70;
  *p++=strlen(st->pa->called)+1;
  *p++=0x80;
  size+=3;

  teln=st->pa->called;
  while (*teln) { *p++=*teln++;size++; };
  dibh->datasize=size;

  newl3state(st,1);
  i_down(st,dibh);

}

static void l3s6(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  byte *p;

  p=DATAPTR(ibh);
  if (p=findie(p+st->l2.ihsize,ibh->datasize-st->l2.ihsize,
    0x18)) {
    st->pa->bchannel=p[2]&0x3;
  }
  else
    printk("octect 3 not found\n");

  BufPoolRelease(ibh);  
  newl3state(st,3); 
  st->l4.hup(st,CC_PROCEEDING_IND,NULL);
}

static void l3s7(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  BufPoolRelease(ibh);
  newl3state(st,12); 
  st->l4.hup(st,CC_DISCONNECT_IND,NULL);
}

static void l3s8(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  BufPoolRelease(ibh);
  st->l4.hup(st,CC_SETUP_CNF,NULL); 
  newl3state(st,10);
}

static void l3s11(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  BufPoolRelease(ibh);
  newl3state(st,4); 
  st->l4.hup(st,CC_ALERTING_IND,NULL);
}

static void l3s12(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{ 
  byte *p;

  p=DATAPTR(ibh);
  p+=st->l2.uihsize;
  st->pa->callref=getcallref(p);
  st->l3.callref=0x80+st->pa->callref;
  
  p=DATAPTR(ibh);
  if (p=findie(p+st->l2.uihsize,ibh->datasize-st->l2.uihsize,
    0x18)) {
    st->pa->bchannel=p[2]&0x3;
  }
  else
    printk("l3s12: octect 3 not found\n");
  
  p=DATAPTR(ibh);
  if (p=findie(p+st->l2.uihsize,ibh->datasize-st->l2.uihsize,
    0x70))
    iecpy(st->pa->called,p,1);
  else
    strcpy(st->pa->called,"");

  p=DATAPTR(ibh);
  if (p=findie(p+st->l2.uihsize,ibh->datasize-st->l2.uihsize,
    0x6c))
    iecpy(st->pa->calling,p,2);
  else
    strcpy(st->pa->calling,"");
  BufPoolRelease(ibh);  
  
  newl3state(st,6);
  st->l4.hup(st,CC_SETUP_IND,NULL); 
}

static void l3s13(struct PStack *st)
{
  newl3state(st,0);
}

static void l3s15(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  newl3state(st,0); 
  st->l4.hup(st,CC_REJECT,NULL);
}

static void l3s16(struct PStack *st,byte pr,
  void *arg)
{
  st->l3.callref=0x80+st->pa->callref;
  l3_message(st,MT_CONNECT);
  newl3state(st,8);
}

static void l3s17(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  BufPoolRelease(ibh);
  st->l4.hup(st,CC_SETUP_COMPLETE_IND,NULL); 
  newl3state(st,10);
}

static void l3s18(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  struct BufHeader *dibh;
  byte *p;
  int size;
  
  BufPoolGet(&dibh,st->l1.sbufpool,GFP_ATOMIC,(void *)st,20);
  p=DATAPTR(dibh);
  p+=st->l2.ihsize;
  size=st->l2.ihsize;
  
  *p++=0x8;
  *p++=0x1;
  *p++=st->l3.callref;
  *p++=MT_DISCONNECT;
  size+=4;

  *p++=IE_CAUSE;
  *p++=0x2;
  *p++=0x80;
  *p++=0x90;
  size+=4;
  
  dibh->datasize=size;
  i_down(st,dibh);

  newl3state(st,11);
}

static void l3s19(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  BufPoolRelease(ibh);  
  newl3state(st,0);
  l3_message(st,MT_RELEASE_COMPLETE);
  st->l4.hup(st,CC_RELEASE_IND,NULL); 
}

static void l3s20(struct PStack *st,byte pr,
  void *arg)
{
  l3_message(st,MT_ALERTING);
  newl3state(st,7);
}

struct stateentry {
  int state;
  byte primitive;
  void (*rout)();
};

static struct stateentry downstatelist[]={
  {0,CC_SETUP_REQ,l3s5},
  {6,CC_REJECT_REQ,l3s13},
  {6,CC_SETUP_RSP,l3s16},
  {6,CC_ALERTING_REQ,l3s20},
  {7,CC_SETUP_RSP,l3s16},
  {10,CC_DISCONNECT_REQ,l3s18},
  {12,CC_RELEASE_REQ,l3s3},
};

static int downsllen=sizeof(downstatelist)/
  sizeof(struct stateentry);

static struct stateentry datastatelist[]={
  {0,MT_SETUP,l3s12},
  {1,MT_CALL_PROCEEDING,l3s6},
  {1,MT_RELEASE_COMPLETE,l3s7},
  {3,MT_DISCONNECT,l3s7},
  {3,MT_CONNECT,l3s8},
  {3,MT_ALERTING,l3s11},
  {4,MT_CONNECT,l3s8},
  {4,MT_DISCONNECT,l3s7},
  {4,MT_RELEASE,l3s19},
  {7,MT_RELEASE,l3s19},
  {8,MT_CONNECT_ACKNOWLEDGE,l3s17},
  {10,MT_DISCONNECT,l3s7},
  {11,MT_RELEASE,l3s19},
  {19,MT_RELEASE_COMPLETE,l3s4},
};

static int datasllen=sizeof(datastatelist)/
  sizeof(struct stateentry);

void l3up(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  int i,mt,size;
  byte *ptr;

  if (st->l3.debug) printk("l3up %d\n",pr);

  if (pr==DL_DATA) {
    ptr=DATAPTR(ibh);
    ptr+=st->l2.ihsize;
    size=ibh->datasize-st->l2.ihsize;
    mt=ptr[3];
    for(i=0;i<datasllen;i++) 
      if ( (st->l3.state==datastatelist[i].state) &&
         (mt==datastatelist[i].primitive))
        break;
    if (i==datasllen) {
      if (st->l3.debug)
	printk("l3 state/message type  unknown %d %d\n",st->l3.state,
          mt);
      BufPoolRelease(ibh);
    }
    else  
      datastatelist[i].rout(st,pr,ibh);   
  }
  else if (pr==DL_UNIT_DATA) {
    ptr=DATAPTR(ibh);
    ptr+=st->l2.uihsize;
    size=ibh->datasize-st->l2.uihsize;
    mt=ptr[3];
    for(i=0;i<datasllen;i++) 
      if ( (st->l3.state==datastatelist[i].state) &&
         (mt==datastatelist[i].primitive))
        break;
    if (i==datasllen) {
      if (st->l3.debug)
	printk("l3 state/message type  unknown %d %d\n",st->l3.state,
          mt);
      BufPoolRelease(ibh);
    }
    else 
      datastatelist[i].rout(st,pr,ibh);
  }
  else if (pr==DL_ESTABLISH) {
    st->l4.hup(st,CC_DLEST,NULL);
  }
  else if (pr==DL_RELEASE) {
    st->l4.hup(st,CC_DLRL,NULL);
  }

}

void l3down(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  int i;

  if (st->l3.debug) printk("l3down %d\n",pr);

  if (pr==CC_DLEST) 
    st->l2.hdown(st,DL_ESTABLISH,NULL); 
  else if (pr==CC_DLRL)
    st->l2.hdown(st,DL_RELEASE,NULL); 
  else {    
    for(i=0;i<downsllen;i++) 
      if ( (st->l3.state==downstatelist[i].state) &&
         (pr==downstatelist[i].primitive))
        break;
    if (i==downsllen) { 
      if (st->l3.debug) 
        printk("l3 state/pr unknown %d %d\n",st->l3.state,pr);
    }
    else 
      downstatelist[i].rout(st,pr,ibh);  
  }
}

void setstack_isdnl3(struct PStack *st)
{
  st->l3.hdown=(void *)l3down;
  st->l3.hup=(void *)l3up;
  st->l3.state=0;
  st->l3.callref=0;
  st->l3.debug=0;
}

