#include <linux/config.h>
#include <linux/module.h>

#include <asm/segment.h>

#define byte unsigned char

#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/timer.h>

#include "isdnif.h"
#include "teles.h"

#define TIMER_1 2000

int errcount=0;

static int l2addrsize(struct Layer2 *tsp);

static void start_timer_1(struct PStack *st)
{
  if (!st->l2.timer_1_running) {
    st->l2.timer_1.expires=TIMER_1*HZ/1000;
    init_timer(&st->l2.timer_1);
    add_timer(&st->l2.timer_1);
    st->l2.timer_1_running=!0;
  }
}

static void kill_timer_1(struct PStack *st)
{
#if 0
printk("kill_timer_1 met running %d\n",st->l2.timer_1_running);
#endif
  if (st->l2.timer_1_running) {
    st->l2.timer_1_running=0;
    del_timer(&st->l2.timer_1);
  }
}

static int cansend(struct PStack *st)
{
  int p1;

  p1=(st->l2.va+st->l2.window)%(st->l2.extended?128:8);
  return(st->l2.vs!=p1);
}

static void flushit(struct PStack *st)
{
  byte *ptr;
  struct Layer2 *l2;
  long flags;
  struct BufHeader *ibh;
  int p1,flushed;

  save_flags(flags);cli();
  l2=&st->l2;
  flushed=0;
  while (!0) {
    if (!cansend(st)) break;
    if (BufQueueUnlink(&ibh,&l2->i_queue)) break;

if (l2->debug>1)
  printk("stack %x flushit: send seq %d\n",st,l2->vs);

    flushed=!0;
    p1=l2->vs-l2->va;
    if (p1<0) p1+=l2->extended?128:8;
    p1=(p1+l2->sow)%l2->window;
    l2->windowar[p1]=ibh;
    
    ptr=DATAPTR(ibh);
    ptr+=l2addrsize(l2);

    if (l2->extended) {
      *ptr++=l2->vs<<1;
      *ptr++=(l2->vr<<1)|0x1;
      l2->vs=(l2->vs+1)%128;
    }
    else {
      *ptr++=(l2->vr<<5)|(l2->vs<<1)|0x10; 
      l2->vs=(l2->vs+1)%8;
    } 

    ibh->primitive=0;
    st->l1.xmitframe(st,ibh);
  }
  restore_flags(flags);

  if (flushed)
    start_timer_1(st);  
}

static void reflushit(struct PStack *st)
{
  byte *ptr;
  struct Layer2 *l2;
  struct BufHeader *ibh;
  int p1,i,p2;

  l2=&st->l2;
  p1=l2->vs-l2->va;
  if (p1<0) p1+=l2->extended?128:8;
  l2->vs=l2->va;

  for(i=0;i<p1;i++) {
    p2=(i+l2->sow)%l2->window;
    ibh=l2->windowar[p2];
    l2->windowar[p1]=ibh;      /* why??? */

    if (l2->debug>1)
      printk("stack %x resending seq %d\n",st,l2->vs);
    ptr=DATAPTR(ibh);
    ptr+=l2addrsize(l2);

    if (l2->extended) {
      *ptr++=l2->vs<<1;
      *ptr++=(l2->vr<<1)|0x1;
      l2->vs=(l2->vs+1)%128;
    }
    else {
      *ptr++=(l2->vr<<5)|(l2->vs<<1)|0x10;
      l2->vs=(l2->vs+1)%8;
    } 

    ibh->primitive=0;
    st->l1.xmitframe(st,ibh);
  }
  start_timer_1(st);  
}

static void discard_i_queue(struct PStack *st)
{
  struct BufHeader *ibh;

  while (!BufQueueUnlink(&ibh,&st->l2.i_queue)) { 
    printk("discard_i_queue releasing a buf\n");
    BufPoolRelease(ibh);
  }
}

static void discard_window(struct PStack *st)
{
  struct BufHeader *ibh;
  struct Layer2 *l2;
  int i,p1,p2;

  l2=&st->l2;
  p1=l2->vs-l2->va;
  if (p1<0) p1+=l2->extended?128:8;

  for(i=0;i<p1;i++) {
    p2=(i+l2->sow)%l2->window;
    ibh=l2->windowar[p2];
#if 0
    printk("discard_window releasing a buf\n");
#endif
    BufPoolRelease(ibh);
  }
}

int l2headersize(struct Layer2 *tsp,int UI)
{
  return((tsp->extended&&(!UI)?2:1)+(tsp->laptype==LAPD?2:1));
}

int l2addrsize(struct Layer2 *tsp)
{
  return(tsp->laptype==LAPD?2:1);
}

static int sethdraddr(struct Layer2 *tsp,
  struct BufHeader *ibh,int rsp)
{
  byte *ptr=DATAPTR(ibh);
  int crbit;

  if (tsp->laptype==LAPD) {
    crbit=rsp;
    if (!tsp->orig) crbit=!crbit;
    *ptr++=(tsp->sap<<2)|(crbit?2:0);
    *ptr++=(tsp->tei<<1)|1;
    return(2);
  }
  else {
    crbit=rsp;
    if (tsp->orig) crbit=!crbit;
    if (crbit) 
      *ptr++=1;
    else
      *ptr++=3;
    return(1);
  }     
}

static void newl2state(struct Layer2 *tsp,int state)
{
  tsp->state=state;
  if (tsp->debug) printk("newl2state %d\n",state);
}

static void enqueue_ui(struct PStack *st,
  struct BufHeader *ibh)
{
  ibh->primitive=!0;
  st->l1.xmitframe(st,ibh);
}

static void enqueue_i(struct PStack *st,
  struct BufHeader *ibh)
{
  BufQueueLink(&(st->l2.i_queue),ibh);
  flushit(st);
}

static void i_retransmission(struct PStack *st)
{
  long flags;
  
  save_flags(flags);cli();
  st->l1.discardq(st,0,st,0); 
  reflushit(st);  
  restore_flags(flags);
}

static void enqueue_super(struct PStack *st,
  struct BufHeader *ibh)
{
  ibh->primitive=!0;
  st->l1.xmitframe(st,ibh);
}

static void processnr(struct PStack *st,int seq,int doflush)
{
  struct Layer2 *l2=&st->l2;
  int ack_some;
  
  ack_some=0;
  if (l2->va!=seq) {
    ack_some=!0;
    kill_timer_1(st);
    l2->ack_retry=0;
  }

  while (l2->va!=seq) {
    l2->va=(l2->va+1)%(l2->extended?128:8);
    BufPoolRelease(l2->windowar[l2->sow]);
    l2->sow=(l2->sow+1)%l2->window;
    if (l2->va==l2->vs) break;
  }
  
  if (doflush)
    flushit(st);

  if (ack_some&&st->l4.writewakeup)
    st->l4.writewakeup(st); 
}

static void l2s1(struct PStack *st,byte pr)
{
  st->l1.teistack->l3.hdown(st->l1.teistack,MDL_ASSIGN,
    st->l2.ces);
  newl2state(&(st->l2),3);  
}
 
static void l2s2(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  byte *ptr;
  int i;

  i=sethdraddr(&(st->l2),ibh,0);
  ptr=DATAPTR(ibh);
  ptr+=i;
  *ptr=0x3;

  enqueue_ui(st,ibh);
}
 
static void l2s3(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  st->l3.hup(st,DL_UNIT_DATA,ibh);  
}

static void l2s11(struct PStack *st,
  byte pr,int data)
{
  byte *ptr;
  struct BufHeader *ibh;
  int i;

  if (BufPoolGet(&ibh,st->l1.smallpool,GFP_ATOMIC,(void *)st,8)) return;
  i=sethdraddr(&(st->l2),ibh,0);
  ptr=DATAPTR(ibh);
  ptr+=i;
  if (st->l2.extended)
    *ptr=0x7f;
  else 
    *ptr=0x3f;
  ibh->datasize=i+1;
  newl2state(&(st->l2),5);
  enqueue_super(st,ibh);
}

static void l2s13(struct PStack *st,
  byte pr,int data)
{
  byte *ptr;
  struct BufHeader *ibh;
  int i;
 
  kill_timer_1(st);

  if (BufPoolGet(&ibh,st->l1.smallpool,GFP_ATOMIC,(void *)st,9)) return;
  i=sethdraddr(&(st->l2),ibh,0);
  ptr=DATAPTR(ibh);
  ptr+=i;
  *ptr=0x53;
  ibh->datasize=i+1;
  newl2state(&st->l2,6);

  discard_i_queue(st);
  discard_window(st);
  enqueue_super(st,ibh);
}

static void l2s12(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  byte *ptr;
  int i;

  BufPoolRelease(ibh);
  st->l2.vs=0;
  st->l2.va=0;
  st->l2.vr=0;
  st->l2.sow=0;
  newl2state(&(st->l2),7);
  st->l3.hup(st,DL_ESTABLISH,NULL);

  if (BufPoolGet(&ibh,st->l1.smallpool,GFP_ATOMIC,(void *)st,10)) return;
  i=sethdraddr(&(st->l2),ibh,0);
  ptr=DATAPTR(ibh);
  ptr+=i;
  *ptr=0x73;
  ibh->datasize=i+1;
  enqueue_super(st,ibh);

}

static void l2s14(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  byte *ptr;
  int i,p;

  ptr=DATAPTR(ibh);
  ptr+=l2addrsize(&(st->l2));
  p=(*ptr)&0x10;
  BufPoolRelease(ibh);
  
  newl2state(&(st->l2),4);
  
  if (BufPoolGet(&ibh,st->l1.smallpool,GFP_ATOMIC,(void *)st,11)) return;
  i=sethdraddr(&(st->l2),ibh,0);
  ptr=DATAPTR(ibh);
  ptr+=i;
  *ptr=0x63|(p?0x10:0x0);
  ibh->datasize=i+1;
  enqueue_super(st,ibh);

  st->l3.hup(st,DL_RELEASE,NULL);

}

static void l2s5(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  int f;
  byte *data;

  data=DATAPTR(ibh);
  data+=l2addrsize(&(st->l2));
  
  f=*data&0x10;
  BufPoolRelease(ibh);
  
  if (f) {
    st->l2.vs=0;
    st->l2.va=0;
    st->l2.vr=0;
    st->l2.sow=0;
    newl2state(&(st->l2),7);
    st->l3.hup(st,DL_ESTABLISH,NULL);
  }
}

static void l2s15(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  int f;
  byte *data;

  data=DATAPTR(ibh);
  data+=l2addrsize(&st->l2);
  
  f=*data&0x10;
  BufPoolRelease(ibh);
  
  if (f) {
    newl2state(&(st->l2),4);
    st->l3.hup(st,DL_RELEASE,NULL);
  }
}

static void l2s6(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  int p,i,seq,rsp;
  byte *ptr;
  struct Layer2 *l2;
 
  l2=&(st->l2);
  ptr=DATAPTR(ibh);

  if (l2->laptype==LAPD) {
    rsp=ptr[0]&0x2;
    if (l2->orig) rsp=!rsp;
  }
  else {
    rsp=ptr[0]==0x3;
    if (l2->orig) rsp=!rsp;
  }

  ptr+=l2addrsize(l2);

  if (l2->extended) {
    p=(ptr[1]&0x1)==0x1;
    seq=ptr[1]>>1;
  }
  else {
    p=(ptr[0]&0x10);
    seq=(ptr[0]>>5)&0x7;
  }
  BufPoolRelease(ibh);

  if (st->l2.debug>1) 
    printk("RR ontvangen met seq %d rsp is %d en p/f is %d\n",seq,
      rsp,p);

  if ((!rsp)&&p) {
    if (!BufPoolGet(&ibh,st->l1.smallpool,GFP_ATOMIC,(void *)st,12)) {
      i=sethdraddr(l2,ibh,!0);
      ptr=DATAPTR(ibh);
      ptr+=i;

      if (l2->extended) {
        *ptr++=0x1;
        *ptr++=(l2->vr<<1)|(p?1:0);
        i+=2;
      }
      else {
        *ptr++=(l2->vr<<5)|0x1|(p?0x10:0x0);
        i+=1;
      }	  
      ibh->datasize=i;
      enqueue_super(st,ibh);
    }
    else
      if (st->l2.debug>1) 
	printk("Buffer vol! Geen antwoord verstuurd!\n");
  }

  processnr(st,seq,!0);  

}

static void l2s7(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  int i;
  byte *ptr;
  struct IsdnCardState *sp=st->l1.hardware;
  char str[64];

  i=sethdraddr(&st->l2,ibh,0);
  ptr=DATAPTR(ibh);

  if (st->l2.laptype==LAPD)
    if (sp->dlogflag) {
      sprintf(str,"Q.931 frame user->network tei %d",st->l2.tei);
      dlogframe(sp,ptr+st->l2.ihsize,ibh->datasize-st->l2.ihsize,
        str);
    }

  enqueue_i(st,ibh);
}

static void l2s8(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  byte *ptr;
  struct BufHeader *ibh2;
  struct IsdnCardState *sp=st->l1.hardware;
  struct Layer2 *l2=&(st->l2);
  int i,p,seq,nr;
  char str[64];
 
  ptr=DATAPTR(ibh);
  ptr+=l2addrsize(l2);
  if (l2->extended) {
    p=(ptr[1]&0x1)==0x1;
    seq=ptr[0]>>1;      
    nr=(ptr[1]>>1)&0x7f;
  }
  else {
    p=(ptr[0]&0x10);
    seq=(ptr[0]>>1)&0x7;
    nr=(ptr[0]>>5)&0x7;
  }

  if (l2->vr==seq) {
    if (st->l2.debug>1)
      printk("i_frame correct seq %d\n",seq);
    l2->vr=(l2->vr+1)%(l2->extended?128:8);
    l2->rejexp=0;

    ptr=DATAPTR(ibh);
    if (st->l2.laptype==LAPD)
      if (sp->dlogflag) {       
        sprintf(str,"Q.931 frame network->user tei %d",st->l2.tei);
        dlogframe(st->l1.hardware,ptr+l2->ihsize,
          ibh->datasize-l2->ihsize,str);
      }

    st->l3.hup(st,DL_DATA,ibh);

label8_1:  
    if (!BufPoolGet(&ibh2,st->l1.smallpool,GFP_ATOMIC,(void *)st,13)) {
      i=sethdraddr(&(st->l2),ibh2,p);
      ptr=DATAPTR(ibh2);
      ptr+=i;

      if (l2->extended) {
        *ptr++=0x1;
        *ptr++=(l2->vr<<1)|(p?1:0);
        i+=2;
      }
      else {
        *ptr++=(l2->vr<<5)|0x1|(p?0x10:0x0);
        i+=1;
      }	  
      ibh2->datasize=i;
      enqueue_super(st,ibh2);
    }
    else
      if (st->l2.debug>1)
        printk("buffer vol! geen antwoord verstuurd\n");
  }
  else { /* n(s)!=v(r) */
    if (st->l2.debug>0)
      printk("i_frame out of sequence: %d instead of %d\n",seq,l2->vr);
    BufPoolRelease(ibh);
    if (st->l2.rejexp) {
      if (p) 
        goto label8_1;
    }
    else {
      st->l2.rejexp=!0;
      if (!BufPoolGet(&ibh2,st->l1.smallpool,GFP_ATOMIC,(void *)st,14)) {
        i=sethdraddr(&(st->l2),ibh2,p);
        ptr=DATAPTR(ibh2);
        ptr+=i;

        if (l2->extended) {
          *ptr++=0x9;
          *ptr++=(l2->vr<<1)|(p?1:0);
          i+=2;
        }
        else {
          *ptr++=(l2->vr<<5)|0x9|(p?0x10:0x0);
          i+=1;
        }	  
        ibh2->datasize=i;
        enqueue_super(st,ibh2);
      }
      else
        if (st->l2.debug>1)
	  printk("buffer vol! geen antwoord verstuurd\n");
    } 
  }

  processnr(st,nr,!0);    
}

static void establishlink(struct PStack *st)
{
  struct BufHeader *ibh;
  int i;
  byte *ptr;
  
  if (BufPoolGet(&ibh,st->l1.smallpool,GFP_ATOMIC,(void *)st,15)) return;
  i=sethdraddr(&(st->l2),ibh,0);
  ptr=DATAPTR(ibh);
  ptr+=i;
  if (st->l2.extended)
    *ptr=0x7f;
  else 
    *ptr=0x3f;
  ibh->datasize=i+1;
  newl2state(&(st->l2),5);

  enqueue_super(st,ibh);
}

static void l2s17(struct PStack *st,byte pr,int data)
{
  st->l2.tei=data;
  if (st->l2.debug>1) printk("tei assigned: %d\n",st->l2.tei);
  establishlink(st);  
}

static void enquiry_response(struct PStack *st)
{
  struct BufHeader *ibh2;
  int i;
  byte *ptr;
  struct Layer2 *l2;
  
  l2=&(st->l2);
  if (!BufPoolGet(&ibh2,st->l1.smallpool,GFP_ATOMIC,(void *)st,16)) {
    i=sethdraddr(&(st->l2),ibh2,!0);
    ptr=DATAPTR(ibh2);
    ptr+=i;

    if (l2->extended) {
      *ptr++=0x1;
      *ptr++=(l2->vr<<1)|0x1;
      i+=2;
    }
    else {
      *ptr++=(l2->vr<<5)|0x1|0x10;
      i+=1;
    }	  
    ibh2->datasize=i;
    enqueue_super(st,ibh2);
  }
}

static void l2s16(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  int p,seq,rsp;
  byte *ptr;
  struct Layer2 *l2;
 
  l2=&(st->l2);
  ptr=DATAPTR(ibh);

  if (l2->laptype==LAPD) {
    rsp=ptr[0]&0x2;
    if (l2->orig) rsp=!rsp;
  }
  else {
    rsp=ptr[0]==0x3;
    if (l2->orig) rsp=!rsp;
  }


  ptr+=l2addrsize(l2);

  if (l2->extended) {
    p=(ptr[1]&0x1)==0x1;
    seq=ptr[1]>>1;
  }
  else {
    p=(ptr[0]&0x10);
    seq=(ptr[0]>>5)&0x7;
  }
  BufPoolRelease(ibh);

  if (st->l2.debug>0)
    printk("REJ frame ontvangen met seq %d rsp %d p %d \n",seq,rsp,p);
  
  if ((!rsp)&&p) 
    enquiry_response(st);

  processnr(st,seq,0);       
  i_retransmission(st);
}

static void l2s18(struct PStack *st,byte pr,
  struct BufHeader *ibh)
{
  byte *datap;
  
  datap=DATAPTR(ibh);
  datap+=l2addrsize(&(st->l2));
  if (st->l2.debug)
    printk("FRMR received info field %x %x %x\n",
      datap[1],datap[2],datap[3]);
}

static int IsUIData(byte *data,int ext)
{
  return((data[0]&0xef)==0x3);  
}
  
static int IsUA(byte *data,int ext)
{
  return((data[0]&0xef)==0x63);  
}
  
static int IsDISC(byte *data,int ext)
{
  return((data[0]&0xef)==0x43);  
}
  
static int IsRR(byte *data,int ext)
{
  if (ext)
    return(data[0]==0x1);
  else
    return((data[0]&0xf)==1);
}

static int IsI(byte *data,int ext)
{
  return((data[0]&0x1)==0x0);  
}
  
static int IsSAB(byte *data,int ext)
{
  return( ext? data[0]==0x7f : data[0]==0x3f );  
}
  
static int IsREJ(byte *data,int ext)
{
  return( ext? data[0]==0x9 : (data[0]&0xf)==0x9 );  
}

static int IsFRMR(byte *data,int ext)
{
  return( (data[0]&0xef)==0x87 );  
}
  
struct stateentry {
  int state;
  byte primitive;
  int istest;
  int (*testdata)();
  void (*rout)();
};

void isdnl2_acceptph(struct PStack *st,struct BufHeader *ibh)
{
  st->l2.hup(st,PH_DATA,ibh);
}

static struct stateentry downstatelist[]={
  {1,DL_ESTABLISH,0,(void *)NULL,(void *)l2s1},
  {3,MDL_ASSIGN,0,(void *)NULL,(void *)l2s17},		    
  {4,DL_UNIT_DATA,0,(void *)NULL,(void *)l2s2},
  {4,DL_ESTABLISH,0,(void *)NULL,(void *)l2s11},
  {7,DL_UNIT_DATA,0,(void *)NULL,(void *)l2s2},
  {7,DL_DATA,0,(void *)NULL,(void *)l2s7},
  {7,DL_RELEASE,0,(void *)NULL,(void *)l2s13},
};

static int downsllen=sizeof(downstatelist)/
  sizeof(struct stateentry);

static struct stateentry upstatelist[]={
  {1,PH_DATA,!0,(void *)IsUIData,(void *)l2s3},
  {4,PH_DATA,!0,(void *)IsUIData,(void *)l2s3},
  {4,PH_DATA,!0,(void *)IsSAB,(void *)l2s12},
  {5,PH_DATA,!0,(void *)IsUA,(void *)l2s5},
  {6,PH_DATA,!0,(void *)IsUA,(void *)l2s15},
  {7,PH_DATA,!0,(void *)IsUIData,(void *)l2s3},
  {7,PH_DATA,!0,(void *)IsDISC,(void *)l2s14},
  {7,PH_DATA,!0,(void *)IsI,(void *)l2s8},
  {7,PH_DATA,!0,(void *)IsRR,(void *)l2s6},
  {7,PH_DATA,!0,(void *)IsREJ,(void *)l2s16},
  {7,PH_DATA,!0,(void *)IsFRMR,(void *)l2s18},
};

static int upsllen=sizeof(upstatelist)/
  sizeof(struct stateentry);

void l2up(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  byte *datap;  
  int i;

  if (st->l2.debug>0) 
    printk("stack %x l2up %d %s vs %d vr %d va %d\n",
      (int)st,pr,
      st->l2.laptype==LAPD?"LAPD":"LAPB",
      st->l2.vs,st->l2.vr,st->l2.va);

  datap=DATAPTR(ibh);
  datap+=l2addrsize(&(st->l2));

  for(i=0;i<upsllen;i++) 
    if ( (st->l2.state==upstatelist[i].state) &&
         (pr==upstatelist[i].primitive))
      if (upstatelist[i].istest) {
        if (upstatelist[i].testdata(datap,st->l2.extended))
          break;
      }
      else
        break;
  if (i==upsllen) {
    if (st->l2.debug>0)
      printk("l2 state/pr unknown %d %d bytes %d %d %d %d\n",
        st->l2.state,pr,
	datap[0],datap[1],datap[2],datap[3]);
    if (pr==PH_DATA) 
       BufPoolRelease(ibh);
  }
  else { 
if (st->l2.debug>0) 
  printk("stack %x l2up routineindex %d\n",st,i);
  upstatelist[i].rout(st,pr,ibh);  
  }
}

void l2down(struct PStack *st,
  byte pr,struct BufHeader *ibh)
{
  byte *datap;  
  int i;

  if (st->l2.debug>0) 
    printk("stack %x l2down state %d prim %d %s\n",
      st,st->l2.state,pr,st->l2.laptype==LAPD?"LAPD":"LAPB");

  datap=DATAPTR(ibh);
  for(i=0;i<downsllen;i++) 
    if ( (st->l2.state==downstatelist[i].state) &&
         (pr==downstatelist[i].primitive))
      break;
  if (i==downsllen) {
    if (st->l2.debug>1)
      printk("l2 state/pr unknown %d %d\n",
        st->l2.state,pr);
     if ((pr==DL_DATA)||(pr==DL_UNIT_DATA))
       BufPoolRelease(ibh);
  }
  else 
    downstatelist[i].rout(st,pr,ibh);  
}

void releasestack_isdnl2(struct PStack *st)
{
  kill_timer_1(st);
}

static void exp_timer_1(struct PStack *st)
{
  struct BufHeader *ibh;
  byte *ptr;
  struct Layer2 *l2=&st->l2;
  int i,p;
  struct IsdnCardState *sp;
  
  sp=(struct IsdnCardState *)st->l1.hardware;

#if 0  
  teles_report(sp);
  sp->debug=!0;
#endif 
  
  printk("timer 1 expired stack %x %s\n",
    st,st->l2.laptype==LAPD?"LAPD":"LAPB");  
  st->l2.timer_1_running=0;
  
  if (l2->ack_retry) {
    printk("ack_retry\n");
    l2->ack_retry=0;
    i_retransmission(st);
  }
  else {
    p=!0;
    if (!BufPoolGet(&ibh,st->l1.smallpool,GFP_ATOMIC,(void *)st,17)) {
      i=sethdraddr(l2,ibh,0);
      ptr=DATAPTR(ibh);
      ptr+=i;

      if (l2->extended) {
        *ptr++=0x1;
        *ptr++=(l2->vr<<1)|(p?1:0);
        i+=2;
      }
      else {
        *ptr++=(l2->vr<<5)|0x1|(p?0x10:0x0);
        i+=1;
      }	  
      ibh->datasize=i;
      enqueue_super(st,ibh);
    }
    l2->ack_retry++;
  }
  start_timer_1(st);
}

void setstack_isdnl2(struct PStack *st)
{
  st->l1.acceptph=isdnl2_acceptph;
  st->l2.hdown=(void *)l2down;
  st->l2.hup=(void *)l2up;
  st->l2.uihsize=l2headersize(&st->l2,!0);
  st->l2.ihsize=l2headersize(&st->l2,0);
  BufQueueInit(&(st->l2.i_queue));
  st->l2.rejexp=0;
  st->l2.debug=0;

  st->l2.timer_1.data=(unsigned long)st;
  st->l2.timer_1.function=(void *)(unsigned long)exp_timer_1;
  st->l2.timer_1_running=0;
  st->l2.ack_retry=0;

}


static void trans_acceptph(struct PStack *st,struct BufHeader *ibh)
{
  st->l3.hup(st,DL_DATA,ibh);
}

static void transdown(struct PStack *st,int pr,
  struct BufHeader *ibh)
{
  if (pr==DL_DATA) {
    ibh->primitive=!0;
    st->l1.xmitframe(st,ibh); 
  }
}
    
void setstack_transl2(struct PStack *st)
{
  st->l1.acceptph=trans_acceptph;
  st->l2.hdown=(void *)transdown;
  st->l2.ihsize=0;
  st->l2.debug=0;
}

void releasestack_transl2(struct PStack *st)
{
}
