#include <linux/config.h>
#include <linux/module.h>

#include <asm/segment.h>

#define byte unsigned char

#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/timer.h>

#include "isdnif.h"
#include "teles.h"


void FsmNew(struct Fsm *fsm,
  int state_count,int event_count,
  struct FsmNode *fnlist,int fncount)
{
  int i;
    
  fsm->state_count=state_count;
  fsm->event_count=event_count;

  fsm->jumpmatrix=Smalloc(4L*state_count*event_count,GFP_KERNEL,
    "Fsm jumpmatrix");
  memset(fsm->jumpmatrix,0,4L*state_count*event_count);

  for(i=0;i<fncount;i++)
    fsm->jumpmatrix[state_count*fnlist[i].event+
      fnlist[i].state]=fnlist[i].routine;
}
  
void FsmFree(struct Fsm *fsm)
{
  Sfree((void *)fsm->jumpmatrix);
}
  
int FsmEvent(struct FsmInst *fi,
  int event,void *arg)
{
  void (*r)();
  char str[32];
  
  r=fi->fsm->jumpmatrix[fi->fsm->state_count*event+fi->state];
  if (r) {
    if (fi->debug) {
      sprintf(str,"State %d Event %d",fi->state,event);
      fi->printdebug(fi,str);
    }
    r(fi,event,arg);
    return(0);
  }
  else {
    if (fi->debug) {
      sprintf(str,"State %d Event %d no routine",fi->state,event);
      fi->printdebug(fi,str);
    }
    return(!0);
  }  
}
  
void FsmChangeState(struct FsmInst *fi,
  int newstate)
{
  fi->state=newstate;
}
  
