/* $Id: isdn.h,v 1.8 1995/04/29 13:14:23 fritz Exp fritz $
 *
 * ISDN driver for Linux (linklevel-module).
 *
 * Copyright 1994 by Fritz Elfert (fritz@wuemaus.franken.de)
 * Copyright 1995 Thinking Objects Software GmbH Wuerzburg
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Log: isdn.h,v $
 * Revision 1.8  1995/04/29  13:14:23  fritz
 * Added constant ISDN_IOCTL_SET_VERBOSE.
 * Added maxbufsize and net_verbose.
 *
 * Revision 1.7  1995/04/23  13:44:16  fritz
 * Added constants for timer-handling.
 * Changed EAZ/MSN-storage.
 *
 * Revision 1.6  1995/03/25  23:37:18  fritz
 * Added include of isdnconfig.h for auto-configuration.
 *
 * Revision 1.5  1995/02/01  11:00:55  fritz
 * Added constants for timer-flags, counters for modem-escape-handling.
 *
 * Revision 1.4  1995/01/29  23:29:41  fritz
 * Added variables for hangup-timeout-handling, protocol- and encap-features.
 * Changed timer-variables.
 *
 * Revision 1.3  1995/01/09  07:36:27  fritz
 * Added GPL-Notice
 *
 * Revision 1.2  1995/01/04  05:11:27  fritz
 * removed include linux/asm/string.h for compiling with Linux 1.1.76
 *
 * Revision 1.1  1995/01/04  05:09:57  fritz
 * Initial revision
 *
 */

#ifndef isdn_h
#define isdn_h

#include "isdnconfig.h"
/* user-accessable definitions */
#ifndef ISDN_MAJOR
#define ISDN_MAJOR        31
#endif
#ifndef ISDN_TTY_MAJOR
#define ISDN_TTY_MAJOR    (ISDN_MAJOR-1)
#endif
#ifndef ISDN_TTYAUX_MAJOR
#define ISDN_TTYAUX_MAJOR (ISDN_MAJOR-2)
#endif

/* The minor-devicenumbers for Channel 0 and 1 are used as arguments for
 * physical Channel-Mapping, so they MUST NOT be changed without changing
 * the correspondent code in isdn.c
 */

#define ISDN_MAX_DRIVERS    16
#define ISDN_MAX_CHANNELS   16
#define ISDN_MINOR_B        0
#define ISDN_MINOR_BMAX     (ISDN_MAX_CHANNELS-1)
#define ISDN_MINOR_CTRL     ISDN_MAX_CHANNELS
#define ISDN_MINOR_CTRLMAX  (2*ISDN_MAX_CHANNELS-1)
#define ISDN_MINOR_STATUS   128

#define ISDN_IOCTL_DRVIOCTL    0x100  /* Offset to add for Device-ioctl */
#define ISDN_IOCTL_NET_ADDIF    1
#define ISDN_IOCTL_NET_DELIF    2
#define ISDN_IOCTL_NET_SETCFG   3
#define ISDN_IOCTL_NET_GETCFG   4
#define ISDN_IOCTL_NET_ADDNUM   5
#define ISDN_IOCTL_NET_DELNUM   6
#define ISDN_IOCTL_NET_GETNUM   7
#define ISDN_IOCTL_GET_SETUP    8
#define ISDN_IOCTL_SET_SETUP    9
#define ISDN_IOCTL_SET_VERBOSE 10

#ifdef  ISDN_DEBUG_MODEM_SENDOPT
#define ISDN_IOCTL_GETMAX    98
#define ISDN_IOCTL_RESETMAX  99
#endif

#define ISDN_NET_ENCAP_ETHER 0
#define ISDN_NET_ENCAP_RAWIP 1
#define ISDN_NET_ENCAP_IPTYP 2

typedef struct {
  char name[10];
  char phone[20];
  int  outgoing;
} isdn_net_ioctl_phone;

typedef struct {
  char name[10];
  char eaz[20];
  int  secure;
  int  callback;
  int  onhtime;
  int  charge;
  int  chargehup;
  int  l2_proto;
  int  l3_proto;
  int  p_encap;
  int  ihup;
} isdn_net_ioctl_cfg;

#ifdef __KERNEL__
/* Kernel includes */
#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/major.h>
#include <asm/segment.h>
#include <asm/io.h>
#include <linux/kernel.h>
#include <linux/signal.h>
#include <linux/malloc.h>
#include <linux/mm.h>
#include <linux/timer.h>
#include <linux/wait.h>
#include <linux/tty.h>
#include <linux/tty_flip.h>
#include <linux/serial_reg.h>
#include <linux/fcntl.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/ip.h>
#include <linux/in.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>

#include <isdnif.h>

char kernel_version[] = UTS_RELEASE;

/* Until now unused */
#define ISDN_SERVICE_VOICE 1
#define ISDN_SERVICE_AB    1<<1 
#define ISDN_SERVICE_X21   1<<2
#define ISDN_SERVICE_G4    1<<3
#define ISDN_SERVICE_BTX   1<<4
#define ISDN_SERVICE_DFUE  1<<5
#define ISDN_SERVICE_X25   1<<6
#define ISDN_SERVICE_TTX   1<<7
#define ISDN_SERVICE_MIXED 1<<8
#define ISDN_SERVICE_FW    1<<9
#define ISDN_SERVICE_GTEL  1<<10
#define ISDN_SERVICE_BTXN  1<<11
#define ISDN_SERVICE_BTEL  1<<12

/* Facility which currently uses an ISDN-channel */
#define ISDN_USAGE_NONE       0
#define ISDN_USAGE_RAW        1
#define ISDN_USAGE_MODEM      2
#define ISDN_USAGE_NET        3
#define ISDN_USAGE_VOICE      4
#define ISDN_USAGE_FAX        5
#define ISDN_USAGE_OUTGOING 128 /* This bit is set, if channel is outgoing */
#define ISDN_USAGE_MASK       7 /* Mask to get plain usage */
/* Macros checking plain usage */
#define USG_NONE(x)     ((x & ISDN_USAGE_MASK)==ISDN_USAGE_NONE)
#define USG_RAW(x)      ((x & ISDN_USAGE_MASK)==ISDN_USAGE_RAW)
#define USG_MODEM(x)    ((x & ISDN_USAGE_MASK)==ISDN_USAGE_MODEM)
#define USG_NET(x)      ((x & ISDN_USAGE_MASK)==ISDN_USAGE_NET)
#define USG_OUTGOING(x) ((x & ISDN_USAGE_OUTGOING)==ISDN_USAGE_OUTGOING)

/* Timer-delays and scheduling-flags */
#define ISDN_TIMER_RES       3                     /* Main Timer-Resolution  */
#define ISDN_TIMER_02SEC     (HZ/ISDN_TIMER_RES/5) /* Slow-Timer1 (0.2 sec.) */
#define ISDN_TIMER_1SEC      (HZ/ISDN_TIMER_RES)   /* Slow-Timer2 (1 sec.)   */
#define ISDN_TIMER_MODEMREAD 1
#define ISDN_TIMER_MODEMPLUS 2
#define ISDN_TIMER_MODEMRING 4
#define ISDN_TIMER_MODEMXMIT 8
#define ISDN_TIMER_NETDIAL   16
#define ISDN_TIMER_NETHANGUP 32
#define ISDN_TIMER_FAST      (ISDN_TIMER_MODEMREAD | ISDN_TIMER_MODEMPLUS | \
                              ISDN_TIMER_MODEMXMIT)
#define ISDN_TIMER_SLOW      (ISDN_TIMER_MODEMRING | ISDN_TIMER_NETHANGUP | \
                              ISDN_TIMER_NETDIAL)

/* Timeout-Values for isdn_net_dial() */
#define ISDN_TIMER_DTIMEOUT10 (10*HZ/(ISDN_TIMER_02SEC*ISDN_TIMER_RES))
#define ISDN_TIMER_DTIMEOUT15 (15*HZ/(ISDN_TIMER_02SEC*ISDN_TIMER_RES))
/*=================== Start of ip-over-ISDN stuff =========================*/

/* Feature- and status-flags for a net-interface */
#define ISDN_NET_CONNECTED 1	       /* Bound to ISDN-Channel            */
#define ISDN_NET_SECURE    2	       /* Accept calls from phonelist only */
#define ISDN_NET_CALLBACK  4           /* callback incoming phonenumber    */

/* Phone-list-element */
typedef struct {
  void *next;
  char num[20];
} isdn_net_phone;

/* Local interface-data */
typedef struct {
  struct enet_statistics stats;        /* Ethernet Statistics              */
  char                   name[10];     /* Name of device                   */
  int                    isdn_device;  /* Index to isdn-device             */
  int                    isdn_channel; /* Index to isdn-channel            */
  int                    flags;        /* Connection-flags                 */
  int                    dialstate;    /* State for dialing                */
  int                    dialretry;    /* Counter for Dialout-retries      */
  int                    dialmax;      /* Max. Nuber of Dial-retries       */
/*  int                    eaz;	        ISDN-EAZ for this interface      */
  char                   msn[20];      /* MSN/EAZ for this interface       */
  int                    dtimer;       /* Timeout-counter for dialing      */
  u_char                 p_encap;      /* Packet encapsulation             */
                                       /*   0 = Ethernet over ISDN         */
				       /*   1 = RAW-IP                     */
                                       /*   2 = IP with type field         */
  u_char                 l2_proto;     /* Layer-2-protocol                 */
				       /* See ISDN_PROTO_L2..-constants in */
                                       /* isdnif.h                         */
                                       /*   0 = X75/LAPB with I-Frames     */
				       /*   1 = X75/LAPB with UI-Frames    */
				       /*   2 = X75/LAPB with BUI-Frames   */
				       /*   3 = HDLC                       */
  u_char                 l3_proto;     /* Layer-3-protocol                 */
				       /* See ISDN_PROTO_L3..-constants in */
                                       /* isdnif.h                         */
                                       /*   0 = Transparent                */
  int                    huptimer;     /* Timeout-counter for auto-hangup  */
  int                    charge;       /* Counter for charging units       */
  int                    chargetime;   /* Timer for Charging info          */
  int                    hupflags;     /* Flags for charge-unit-hangup:    */
				       /* bit0: chargeint is invalid       */
				       /* bit1: Getting charge-interval    */
                                       /* bit2: Do charge-unit-hangup      */
  int                    outgoing;     /* Flag: outgoing call              */
  int                    onhtime;      /* Time to keep link up             */
  int                    chargeint;    /* Interval between charge-infos    */
  int                    onum;         /* Flag: at least 1 outgoing number */
  isdn_net_phone         *phone[2];    /* List of remote-phonenumbers      */
				       /* phone[0] = Incoming Numbers      */
				       /* phone[1] = Outgoing Numbers      */
  isdn_net_phone         *dial;        /* Pointer to dialed number         */
} isdn_net_local;

/* the interface itself */
typedef struct {
  isdn_net_local  local;
  void           *next;                /* Pointer to next isdn-interface   */
  struct device   dev;		       /* interface to upper levels        */
} isdn_net_dev;

/*===================== End of ip-over-ISDN stuff ===========================*/

/*======================= Start of ISDN-tty stuff ===========================*/

#define ISDN_MAGIC                0x01020304 /* for paranoia-checking        */
#define ISDN_ASYNC_INITIALIZED	  0x80000000 /* port was initialized         */
#define ISDN_ASYNC_CALLOUT_ACTIVE 0x40000000 /* Call out device active       */
#define ISDN_ASYNC_NORMAL_ACTIVE  0x20000000 /* Normal device active         */
#define ISDN_ASYNC_CLOSING	  0x08000000 /* Serial port is closing       */
#define ISDN_ASYNC_CTS_FLOW	  0x04000000 /* Do CTS flow control          */
#define ISDN_ASYNC_CHECK_CD	  0x02000000 /* i.e., CLOCAL                 */
#define ISDN_ASYNC_HUP_NOTIFY         0x0001 /* Notify tty on hangups/closes */
#define ISDN_ASYNC_SESSION_LOCKOUT    0x0100 /* Lock cua opens on session    */
#define ISDN_ASYNC_PGRP_LOCKOUT       0x0200 /* Lock cua opens on pgrp       */
#define ISDN_ASYNC_CALLOUT_NOHUP      0x0400 /* No hangup for cui            */
#define ISDN_ASYNC_SPLIT_TERMIOS      0x0008 /* Sep. termios for dialin/out  */
#define ISDN_PORT_16550A                   4 /* Type of faked Hardware       */
#define ISDN_SERIAL_XMIT_SIZE           4000 /* Maximum bufsize for write    */
#define ISDN_SERIAL_TYPE_NORMAL	           1 /* tty-type                     */
#define ISDN_SERIAL_TYPE_CALLOUT           2 /* cua-type                     */

static char *ttyI = "ttyI";
static char *cui  = "cui";

/* Private data (similar to async_struct in <linux/serial.h>) */
typedef struct {
  int			magic;
  int			flags;		 /* defined in tty.h               */
  int			type;		 /* UART type                      */
  struct tty_struct 	*tty;
  int			x_char;		 /* xon/xoff character             */
  int			close_delay;
  int			MCR;		 /* Modem control register         */
  int			line;
  int			count;		 /* # of fd on device              */
  int			blocked_open;	 /* # of blocked opens             */
  long			session;	 /* Session of opening process     */
  long			pgrp;		 /* pgrp of opening process        */
  int                   isdn_driver;	 /* Index to isdn-driver           */
  int                   isdn_channel;    /* Index to isdn-channel          */
  int                   drv_index;       /* Index to dev->usage            */
#if FUTURE
  int                   send_outstanding;/* # of outstanding send-requests */
#endif
  int                   xmit_size;       /* max. # of chars in xmit_buf    */
  int                   xmit_count;      /* # of chars in xmit_buf         */
  u_char                *xmit_buf;       /* transmit-buffer                */
  struct termios	normal_termios;
  struct termios	callout_termios;
  struct wait_queue	*open_wait;
  struct wait_queue	*close_wait;
} modem_info;

/* Private data of AT-command-interpreter */
typedef struct {
  u_char              mdmreg[17];      /* Modem-Registers                  */
  char                msn[20];         /* EAZ/MSN                          */
  int                 mdmcmdl;         /* Length of Modem-Commandbuffer    */
  int                 pluscount;       /* Counter for +++ sequence         */
  int                 lastplus;        /* Timestamp of last +              */
  char                mdmcmd[255];     /* Modem-Commandbuffer              */
} atemu;

/* Descripion of one ISDN-tty */
typedef struct {
  atemu              atmodem[ISDN_MAX_CHANNELS];  /* AT-Command-parser      */
  int                msr[ISDN_MAX_CHANNELS];	  /* Modem-statusregister   */
  int                mlr[ISDN_MAX_CHANNELS];	  /* Line-statusregister    */
  int                refcount;			  /* Number of opens        */
  int                online[ISDN_MAX_CHANNELS];	  /* B-Channel is up        */
  int                dialing[ISDN_MAX_CHANNELS];  /* Dial in progress       */
  int                rcvsched[ISDN_MAX_CHANNELS]; /* Receive needs schedule */
  int                ncarrier[ISDN_MAX_CHANNELS]; /* Output NO CARRIER      */
  struct tty_driver  tty_modem;			  /* tty-device             */
  struct tty_driver  cua_modem;			  /* cua-device             */
  struct tty_struct  *modem_table[ISDN_MAX_CHANNELS]; /* ?? copied from Orig */
  struct termios     *modem_termios[ISDN_MAX_CHANNELS];
  struct termios     *modem_termios_locked[ISDN_MAX_CHANNELS];
  modem_info         info[ISDN_MAX_CHANNELS];	  /* Private data           */
} modem;

/*======================= End of ISDN-tty stuff ============================*/

/*======================= Start of general stuff ===========================*/

/* Packet-queue-element */
typedef struct pqueue {
  char   *next;				/* Pointer to next packet           */
  short   length;			/* Packetlength                     */
  short   size;                         /* Allocated size                   */
  u_char *rptr;				/* Read-pointer for stream-reading  */
  u_char  buffer[1];			/* The data (will be alloc'd)       */
} pqueue;

/* Description of hardware-level-driver */
typedef struct {
  ulong               flags;            /* Flags                            */
  int                 channels;         /* Number of channels               */
  struct wait_queue  *st_waitq;         /* Wait-Queue for status-read's     */
  int                 maxbufsize;       /* Maximum Buffersize supported     */
  unsigned long       pktcount;         /* Until now: unused                */
  int                 running;          /* Flag: Protocolcode running       */
  int                 loaded;           /* Flag: Driver loaded              */
  int                 stavail;          /* Chars avail on Status-device     */
  isdn_if            *interface;        /* Interface to driver              */
  int                *rcverr;           /* Error-counters for B-Ch.-receive */
  int                *rcvcount;         /* Byte-counters for B-Ch.-receive  */
  pqueue             **rpqueue;         /* Pointers to start of Rcv-Queue   */
  struct wait_queue  **rcv_waitq;       /* Wait-Queues for B-Channel-Reads  */
  struct wait_queue  **snd_waitq;       /* Wait-Queue for B-Channel-Send's  */
} driver;

/* Main driver-data */
typedef struct isdn_devt {
  unsigned short    flags;		       /*   */
  int               drivers;		       /* Current number of drivers  */
  int               channels;		       /* Current number of channels */
  int               net_verbose;               /* Verbose-Flag for Network   */
  int               modempoll;		       /* Flag: tty-read active      */
  int               tflags;                    /* Timer-Flags:               */
				               /*  see ISDN_TIMER_..defines  */
  struct timer_list timer;		       /* Misc.-function Timer       */
  int               chanmap[ISDN_MAX_CHANNELS];/* Map minor->device-channel  */
  int               drvmap[ISDN_MAX_CHANNELS]; /* Map minor->driver-index    */
  int               usage[ISDN_MAX_CHANNELS];  /* Used by tty/ip/voice       */
  char              num[ISDN_MAX_CHANNELS][20];/* Remote number of active ch.*/
  int               m_idx[ISDN_MAX_CHANNELS];  /* Index for mdm....          */
  driver            *drv[ISDN_MAX_DRIVERS];    /* Linked list of drivers     */
  isdn_net_dev      *netdev;		       /* Linked list of net-if's    */
  modem             mdm;		       /* tty-driver-data            */
} isdn_dev;

static isdn_dev *dev = (isdn_dev *)0;

/* Utility-Macros */
#define MIN(a,b) ((a<b)?a:b)
#define MAX(a,b) ((a>b)?a:b)

#endif /* __KERNEL__ */
#endif /* isdn_h */

