/* $Id: icnctrl.c,v 1.4 1995/04/23 13:43:02 fritz Exp fritz $
 *
 * ICN-ISDN driver for Linux. (Control-Utility)
 *
 * Copyright 1994,95 by Fritz Elfert (fritz@wuemaus.franken.de)
 * Copyright 1995 Thinking Objects Software GmbH Wuerzburg
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Log: icnctrl.c,v $
 * Revision 1.4  1995/04/23  13:43:02  fritz
 * Changed Copyright.
 *
 * Revision 1.3  1995/02/01  11:03:26  fritz
 * Added Messages, when loading bootcode and protocol.
 *
 * Revision 1.2  1995/01/09  07:41:59  fritz
 * Added GPL-Notice
 *
 *
 */

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include <isdn.h>
#include "icn.h"

char *cmd;

void usage() {
  fprintf(stderr,"usage: %s io [mmio port]             (get/set hw-io)\n",cmd);
  fprintf(stderr,"   or: %s load <bootcode> <protocol> (load firmware)\n",cmd);
  exit(-1);
}

int main(int argc, char **argv) {
  int fd;
  FILE *code;
  int mmio,port;
  u_char buf[0x10000];

  cmd = argv[0];
  if (argc==2 || argc==4) {
    fd = open("/dev/isdnctrl",O_RDWR);
    if (fd < 0) {
      perror("/dev/isdnctrl");
      exit(-1);
    }
    if (!strcmp(argv[1],"io")) {
      if (argc == 4) {
	if (sscanf(argv[2],"%i",&mmio)!=1)
	  usage();
	if (sscanf(argv[3],"%i",&port)!=1)
	  usage();
	if ((mmio = ioctl(fd,ICN_IOCTL_SETMMIO+ISDN_IOCTL_DRVIOCTL,mmio))<0) {
	  perror("ioctl SETMMIO");
	  exit(-1);
	}
	if ((port = ioctl(fd,ICN_IOCTL_SETPORT+ISDN_IOCTL_DRVIOCTL,port))<0) {
	  perror("ioctl SETPORT");
	  exit(-1);
	}
      }
      if ((mmio = ioctl(fd,ICN_IOCTL_GETMMIO+ISDN_IOCTL_DRVIOCTL,0))<0) {
	perror("ioctl GETMMIO");
	exit(-1);
      }
      if ((port = ioctl(fd,ICN_IOCTL_GETPORT+ISDN_IOCTL_DRVIOCTL,0))<0) {
	perror("ioctl GETPORT");
	exit(-1);
      }
      printf("Memory-mapped io at 0x%08lx, port 0x%03x\n",
	     (unsigned long)mmio,(unsigned short)port);
      close(fd);
      return 0;
    }
    if (!strcmp(argv[1],"load")) {
      if (argc == 4) {
	if (!(code=fopen(argv[2],"r"))) {
	  perror(argv[2]);
	  exit(-1);
	}
	if (fread(buf,4096,1,code)<1) {
	  fprintf(stderr,"Read error on %s\n",argv[2]);
	  exit(-1);
	}
	printf("Loading Bootcode %s ...\n",argv[2]);
	if (ioctl(fd,ICN_IOCTL_LOADBOOT+ISDN_IOCTL_DRVIOCTL,buf)<0) {
	  perror("ioctl LOADBOOT");
	  exit(-1);
	}
	fclose(code);
	if (!(code=fopen(argv[3],"r"))) {
	  perror(argv[3]);
	  exit(-1);
	}
	if (fread(buf,65536,1,code)<1) {
	  fprintf(stderr,"Read error on %s\n",argv[3]);
	  exit(-1);
	}
	printf("Loading Protocol %s ...\n",argv[3]);
	if (ioctl(fd,ICN_IOCTL_LOADPROTO+ISDN_IOCTL_DRVIOCTL,buf)<0) {
	  perror("ioctl SETPORT");
	  exit(-1);
	}
	fclose(code);
	close(fd);
	return 0;
      }
      usage();
    }
  }
  usage();
  return 0;
}
