/*  get/set6x86: a tool for changing Cyrix 6x86 configuration registers
 *
 *  Copyright (C) 1996  Koen Gadeyne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/***
 *** This is just a hacking tool! Use at your own risk. It was NOT intended to be 
 *** idiot proof! If you don't understand all this, then don't bother trying to use it.
 ***
 ***/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

#ifndef DOS
# include <asm/io.h>
#else
# ifdef DJGPP
#    include <pc.h>
#    define outb(data,port) outportb(port,data)
#    define outw(data,port) outportw(port,data)
#    define inb(port) inportb(port)
#    define inw(port) inportw(port)
#  else /* Borland C */
#    define outb(data,port) outp(port,data)
#    define outw(data,port) outpw(port,data)
#    define inb(port) inp(port)
#    define inw(port) inpw(port)
#  endif
#  define ioperm(x,y,z) (0)
#endif


typedef int bool;

#ifndef TRUE
#  define TRUE (1)
#endif
#ifndef FALSE
#  define FALSE (0)
#endif

char *CommandName;

void get_IO_range(int start, int len)
{
  if (ioperm(start, len, 1) != 0)
  {
    perror("I/O Permissions");
    fprintf(stderr,"Cannot get I/O permissions for hardware address range 0x%x-0x%x.\n\
             You must be superuser, or the program must be setuid root!\n", start, start+len-1);
    exit(1);
  }
}

char* int_to_bin(int num, int bits)
{
  static char binstr[sizeof(long int)+1];
  int i;
  
  for (i=0; i<bits; i++) binstr[i] = 0x30; /* char '0' */
  binstr[bits] = 0x00;
  
  for (i=0; i<bits; i++) binstr[bits-1-i] += ((num >> i) & 0x00000001);
  return(binstr);
}

char *size_str(int kb)
{
  static char size[20];
  if (kb < 1024) sprintf(size, "%d KB", kb);
  else if (kb < 1024*1024) sprintf(size, "%d MB", kb >> 10);
  else sprintf(size, "%d GB", kb >> 20);
  return size;
}


#define ARR_BASE 0xC4
#define RCR_BASE 0xDC

/***********************************************************************************************************/
 
int main (int argc, char* argv[])
{
  int i;
  unsigned int addr, size, rcr;
  int mapen;
  
/*
 * start doing something useful
 */
 
  get_IO_range(0x22, 2);

  printf("6x86 Address Region Register dump:\n");
  
  /* MAPEN */
  outb(0xC3, 0x22); mapen = inb(0x23);
  outb(0xC3, 0x22); outb(mapen | 0x10, 0x23);

  for (i=0; i<8; i++)
  {
    /* ARR */
    outb(ARR_BASE + i*3, 0x22); addr = inb(0x23) << 24;
    outb(ARR_BASE + i*3 + 1, 0x22); addr |= inb(0x23) << 16;
    outb(ARR_BASE + i*3 + 2, 0x22); size = inb(0x23);
    addr |= (size & 0xF0) << 8;
    size &= 0x0F;
    
    printf("  ARR%d: ", i);
    if (size == 0)
    {
      printf("disabled\n");
      continue;
    }
    else
      printf("address = 0x%X , size = ", addr);

    if (i<7)
    {
      if (size == 15) printf("%s\n", size_str(4*1024*1024));
      else printf("%s\n", size_str(2 << size));
    }
    else
    {
      printf("%s\n", size_str(128 << size));
    }

    /* RCR */
    outb(RCR_BASE + i, 0x22); rcr = inb(0x23);
    printf("    RCR = 0x%X : ", rcr);

    if (i != 7)
      printf("%scached, ",  (rcr & 0x01) ? "not " : "");
    else
      printf("%scached, ",  (rcr & 0x01) ? "" : "not ");
    if (rcr & 0x2) printf("weak write ordering, ");
    if (rcr & 0x4) printf("weak locking, ");
    if (rcr & 0x8) printf("write gathering, ");
    if (rcr & 0x10) printf("write through, ");
    if (rcr & 0x20) printf("no LBA#");

    printf("\n");
  }
  outb(0xC3, 0x22); outb(mapen, 0x23);
  return(0);
}
