/*
 * This is 'pwrm', the laptop power manager.
 *
 * Copyright (c) 1992,93 Hansruedi Heeb
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author's address: heeb@iis.ethz.ch
 */

/*#define DEBUG*/
#define S_PER_TIME_UNIT 5 /* n seconds for each unit of time-out */
#define MAX_TIMEOUT 0xff  /* max. timeout (which means timeout off) */

/*
 * WD 7600 ports
 */
#define FLOPPY_OPERATION_CHIP_SELECT		0x0372
#define FLOPPY_CHIP_SELECT_1			0x0374
#define FLOPPY_CHIP_SELECT_2			0x0375
#define FLOPPY_DUNNOW				0x0376
#define FLOPPY_CONTROL_CHIP_SELECT		0x0377

#define LOCK_STATUS_REGISTER_PORT		0xfc72
#define LOCK_UNLOCK_REGISTER_PORT		0xf073

#define CPU_CLOCK_CONTROL_REGISTER		0x1072

#define NMI_AND_REAL_TIME_CLOCK			0x070
#define REAL_TIME_CLOCK_DATA			0x071

#define PORT_CHIP_SELECT_PORT			0x2072
#define TIMING_DISK_CHIP_SELECT_PORT		0x2872
#define PROGRAMMABLE_CHIP_SELECT_PORT		0x3072

#define PMC_OUTPUT_CONTROL_REG_0_7_PORT		0x7072
#define PMC_OUTPUT_CONTROL_REG_8_15_PORT	0x7872
#define PMC_TIMERS_PORT				0x8072
#define PMC_INPUTS_PORT				0x8872
#define PMC_INTERRUPT_ENABLE_PORT		0xc872
#define NMI_STATUS_PORT				0x9072

/*
 * WD 7600 constants
 */
#define UNLOCK_VALUE				0xda
#define LOCK_VALUE				0x00

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#define INFINITE 99999
