/*
 * This is 'pwrm', the laptop power manager.
 *
 * Copyright (c) 1992,93 Hansruedi Heeb
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author's address: heeb@iis.ethz.ch
 */

#define SLOW_DOWN_IO __asm__ __volatile__("jmp 1f\n1:\tjmp 1f\n1:")

void inline outb_p(char value, unsigned short port);

void inline outw_p(char value, unsigned short port);

unsigned int inline inb_p(unsigned short port);

unsigned int inline inw_p(unsigned short port);

void inline unlock();

void inline lock();

void write_locked_port(int value, int port);

int read_locked_port(int port);

void write_locked_byte_port(int value, int port);

int read_locked_byte_port(int port);

int test_port_bit(int nr, int port);
/*
 * Return a bit in a port as boolean value.
 */

int test_byte_port_bit(int nr, int port);
/*
 * Return a bit in a port as boolean value.
 */
