#include <unistd.h>
#include <linux/sched.h>
#include <linux/errno.h>
#include <linux/major.h>
#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/module.h>

#define LCD_MAX 1

#define LCD_DATASIZE sizeof (struct LCD_DATA_TYPE)
#define LCD_TRUE 1
#define LCD_FALSE 0
#define LCD_D_PORT 0x378	/* i/o port for lcd data writes (8 bits) */
#define LCD_C_PORT 0x37A        /* i/o port for lcd control lines */
#define LCD_RS     0x02         /* RS line, 0=control  1=data */
#define LCD_EN     0x01         /* EN line, 0->1 enable */

#define LCD_SETCONTROL  0x01   /* sets subsequent writes to be ctrl writes */
#define LCD_SETDATA      0x02   /* sets subsequent writes to be data writes */

#define LCD_GET_ALL		0x07	/*get the whole LCD_DATA[minor] struct*/
#define LCD_SET_ALL		0x08	/*set the whole LCD_DATA[minor] struct
						  except LCD_BUSY!*/

#define LCD_INITSTRING "\74\74\1\2\6\14"
#define LCD_CLEARSTRING "\1\2"


#define MODE_CONTROL 0x01
#define MODE_DATA    0x02

struct LCD_DATA_TYPE {
  char text[81];
};

/* This struct is used for misc data about the lcd*/

struct LCD_DATA_SAVE_TYPE {
	int BUSY;		/*lcd is in use*/
	int mode;               /* mode (control or data) */
};

#define LCD_MAJOR		23






