/*
 *	bus.c
 *
 *	A quick hack to set the ISA bus speed for the SiS 471 chipset.
 *
 *	Compile with:
 *		 gcc -s -N -Wall -O bus.c -o bus
 *
 *	Released to the public under the GNU Public License,
 *	incorporated herein by reference.
 *
 *					Paul Gortmaker		07/95
 */


struct bustable
{
	int bits;
	char *speed;
};

#define PORT_SEL	0x22
#define PORT_DATA	0x23
#define ISA_DATA	0x60

#include <stdio.h>
#include <asm/io.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>

void usage(void);

struct bustable sis471[] = {
	{0,	"7.159 MHz"	},
	{0x20,	"1/10 CLKIN"	},
	{0x40,	"1/8 CLKIN"	},
	{0x60,	"1/6 CLKIN"	},
	{0x80,	"1/5 CLKIN"	},
	{0xA0,	"1/4 CLKIN"	},
	{0xC0,	"1/3 CLKIN"	},
	{0xE0,	"1/2 CLKIN"	},
	{0xFF,	NULL		}
};

void main(int argc, char **argv) {

unsigned short val, newval=0xFF;
struct bustable *bus;
char *speed=NULL;

if (argc > 2) usage();
if ((argc == 2) && !(isdigit(argv[1][0]))) usage();

val = ioperm(PORT_SEL, 2, 1);
if (val) {
	perror("ioperm");
	exit(errno);
}

if (argc == 2) {
	bus = sis471;
	do {
		if (bus->bits == (atoi(argv[1])<<5)) {
			newval = bus->bits;
			speed = bus->speed;
			break;
		}
		bus ++;
	} while (bus->speed != NULL);
	if (newval == 0xFF) usage();
}

printf("Present ISA bus clock is ");
bus = sis471;
outb(ISA_DATA, PORT_SEL);
val = inb(PORT_DATA);
do {
	if (bus->bits == (val & 0xE0)) {
		printf("%s.\n", bus->speed);
		break;
	}
	bus ++;
} while (bus->speed != NULL);

if (newval != 0xFF) {
	printf("Now setting ISA bus clock to %s.\n", speed);
	val&=~0xE0;			/* Clear upper 3 bits. */
	val|=newval;			/* Add in the users value. */
	outb(ISA_DATA, PORT_SEL);
	outb(val, PORT_DATA);
}

/* ioperm(PORT_SEL, 2, 0); */		/* Why bother... */

} /*end*/

void usage(void)
{

struct bustable *bus = sis471;
printf("\nUsage: bus [n] - report and/or set SiS 471 ISA bus clock frequency.\n");

printf("\n\tn\t\t\tBus Clock\n");
printf("\t-------------------------------------\n");
do {
	printf("\t%d\t\t\t%s.\n", (bus->bits>>5), bus->speed);
	bus ++;
} while (bus->speed != NULL);

printf("\n");
exit(-EINVAL);

} /* end usage() */
