/*
 *  super.c
 *
 *  Copyright (C) 1995 Martin von Lwis
 */

#include <stdio.h>
#include <fcntl.h>
#include "ntfs.h"
#include "config.h"

void init_volume(ntfs_volume *vol,char *boot)
{
	vol->blocksize=*(unsigned short*)(boot+0xB);
	vol->clusterfactor=*(unsigned char*)(boot+0xD);
	vol->clustersize=vol->blocksize*vol->clusterfactor;
	vol->mft_recordsize=max(vol->clustersize,1024); 
	vol->mft_clusters_per_record=vol->mft_recordsize/vol->clustersize;
	vol->index_recordsize=max(vol->clustersize,2048);
	vol->index_clusters_per_record=vol->index_recordsize/vol->clustersize;
	/* BUGBUG: long long value */
	vol->mft_cluster=*(int*)(boot+0x30);
}

int ntfs_get_volumesize(ntfs_volume *vol)
{
	char *cluster0=ntfs_allocate(vol->clustersize);
	int size;
	ntfs_get_clusters(vol,0,0,vol->clustersize,cluster0,ntfs_memcpy);
	size=*(int*)(cluster0+0x28);
	ntfs_free(cluster0);
	return size;
}

static int bc[256];
static void init_bit_counter()
{
	static int nc[16]={4,3,3,2,3,2,2,1,3,2,2,1,2,1,1,0};
	static int initialized=0;
	if(!initialized)
	{
		int i;
		for(i=0;i<256;i++)bc[i]=nc[i&15]+nc[i>>4];
		initialized=1;
	}
}

int ntfs_get_free_cluster_count(ntfs_volume* vol,char *bitmap)
{
	unsigned char bits[2048];
	int l,offset;
	int clusters=0;
	init_bit_counter();
	offset=0;
	while(1)
	{
		register int i;
		l=ntfs_read_attr(vol,bitmap,6,AT_DATA,NULL,offset,bits,2048,ntfs_memcpy);
		if(l==0)break;
		if(l<0 || l>2048)return 0; /* something wrong here */
		/* I never thought I would do loop unrolling some day */
		for(i=0;i<l-8;){
			clusters+=bc[bits[i++]];
			clusters+=bc[bits[i++]];
			clusters+=bc[bits[i++]];
			clusters+=bc[bits[i++]];
			clusters+=bc[bits[i++]];
			clusters+=bc[bits[i++]];
			clusters+=bc[bits[i++]];
			clusters+=bc[bits[i++]];
		}
		for(;i<l;)clusters+=bc[bits[i++]];
		offset+=l;
	}
	return clusters;
}
		
