/*
 *	OLE2NLS library
 *
 *	Copyright 1995	Martin von Loewis
 */

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "windows.h"
#include "heap.h"
#include "ole.h"
#include "options.h"
#include "winnls.h"
#include "winreg.h"
#include "winerror.h"
#include "stddebug.h"
#include "debug.h"

/* Locale name to id map. used by EnumSystemLocales, GetLocalInfoA 
 * MUST contain all #defines from winnls.h
 * last entry has NULL name, 0 id.
 */ 
#define LOCALE_ENTRY(x)	{#x,LOCALE_##x}
static struct tagLOCALE_NAME2ID {
	char	*name;
	DWORD	id;
} locale_name2id[]= {
	LOCALE_ENTRY(ILANGUAGE),
	LOCALE_ENTRY(SLANGUAGE),
	LOCALE_ENTRY(SENGLANGUAGE),
	LOCALE_ENTRY(SABBREVLANGNAME),
	LOCALE_ENTRY(SNATIVELANGNAME),
	LOCALE_ENTRY(ICOUNTRY),
	LOCALE_ENTRY(SCOUNTRY),
	LOCALE_ENTRY(SENGCOUNTRY),
	LOCALE_ENTRY(SABBREVCTRYNAME),
	LOCALE_ENTRY(SNATIVECTRYNAME),
	LOCALE_ENTRY(IDEFAULTLANGUAGE),
	LOCALE_ENTRY(IDEFAULTCOUNTRY),
	LOCALE_ENTRY(IDEFAULTCODEPAGE),
	LOCALE_ENTRY(IDEFAULTANSICODEPAGE),
	LOCALE_ENTRY(SLIST),
	LOCALE_ENTRY(IMEASURE),
	LOCALE_ENTRY(SDECIMAL),
	LOCALE_ENTRY(STHOUSAND),
	LOCALE_ENTRY(SGROUPING),
	LOCALE_ENTRY(IDIGITS),
	LOCALE_ENTRY(ILZERO),
	LOCALE_ENTRY(INEGNUMBER),
	LOCALE_ENTRY(SNATIVEDIGITS),
	LOCALE_ENTRY(SCURRENCY),
	LOCALE_ENTRY(SINTLSYMBOL),
	LOCALE_ENTRY(SMONDECIMALSEP),
	LOCALE_ENTRY(SMONTHOUSANDSEP),
	LOCALE_ENTRY(SMONGROUPING),
	LOCALE_ENTRY(ICURRDIGITS),
	LOCALE_ENTRY(IINTLCURRDIGITS),
	LOCALE_ENTRY(ICURRENCY),
	LOCALE_ENTRY(INEGCURR),
	LOCALE_ENTRY(SDATE),
	LOCALE_ENTRY(STIME),
	LOCALE_ENTRY(SSHORTDATE),
	LOCALE_ENTRY(SLONGDATE),
	LOCALE_ENTRY(STIMEFORMAT),
	LOCALE_ENTRY(IDATE),
	LOCALE_ENTRY(ILDATE),
	LOCALE_ENTRY(ITIME),
	LOCALE_ENTRY(ITIMEMARKPOSN),
	LOCALE_ENTRY(ICENTURY),
	LOCALE_ENTRY(ITLZERO),
	LOCALE_ENTRY(IDAYLZERO),
	LOCALE_ENTRY(IMONLZERO),
	LOCALE_ENTRY(S1159),
	LOCALE_ENTRY(S2359),
	LOCALE_ENTRY(ICALENDARTYPE),
	LOCALE_ENTRY(IOPTIONALCALENDAR),
	LOCALE_ENTRY(IFIRSTDAYOFWEEK),
	LOCALE_ENTRY(IFIRSTWEEKOFYEAR),
	LOCALE_ENTRY(SDAYNAME1),
	LOCALE_ENTRY(SDAYNAME2),
	LOCALE_ENTRY(SDAYNAME3),
	LOCALE_ENTRY(SDAYNAME4),
	LOCALE_ENTRY(SDAYNAME5),
	LOCALE_ENTRY(SDAYNAME6),
	LOCALE_ENTRY(SDAYNAME7),
	LOCALE_ENTRY(SABBREVDAYNAME1),
	LOCALE_ENTRY(SABBREVDAYNAME2),
	LOCALE_ENTRY(SABBREVDAYNAME3),
	LOCALE_ENTRY(SABBREVDAYNAME4),
	LOCALE_ENTRY(SABBREVDAYNAME5),
	LOCALE_ENTRY(SABBREVDAYNAME6),
	LOCALE_ENTRY(SABBREVDAYNAME7),
	LOCALE_ENTRY(SMONTHNAME1),
	LOCALE_ENTRY(SMONTHNAME2),
	LOCALE_ENTRY(SMONTHNAME3),
	LOCALE_ENTRY(SMONTHNAME4),
	LOCALE_ENTRY(SMONTHNAME5),
	LOCALE_ENTRY(SMONTHNAME6),
	LOCALE_ENTRY(SMONTHNAME7),
	LOCALE_ENTRY(SMONTHNAME8),
	LOCALE_ENTRY(SMONTHNAME9),
	LOCALE_ENTRY(SMONTHNAME10),
	LOCALE_ENTRY(SMONTHNAME11),
	LOCALE_ENTRY(SMONTHNAME12),
	LOCALE_ENTRY(SMONTHNAME13),
	LOCALE_ENTRY(SABBREVMONTHNAME1),
	LOCALE_ENTRY(SABBREVMONTHNAME2),
	LOCALE_ENTRY(SABBREVMONTHNAME3),
	LOCALE_ENTRY(SABBREVMONTHNAME4),
	LOCALE_ENTRY(SABBREVMONTHNAME5),
	LOCALE_ENTRY(SABBREVMONTHNAME6),
	LOCALE_ENTRY(SABBREVMONTHNAME7),
	LOCALE_ENTRY(SABBREVMONTHNAME8),
	LOCALE_ENTRY(SABBREVMONTHNAME9),
	LOCALE_ENTRY(SABBREVMONTHNAME10),
	LOCALE_ENTRY(SABBREVMONTHNAME11),
	LOCALE_ENTRY(SABBREVMONTHNAME12),
	LOCALE_ENTRY(SABBREVMONTHNAME13),
	LOCALE_ENTRY(SPOSITIVESIGN),
	LOCALE_ENTRY(SNEGATIVESIGN),
	LOCALE_ENTRY(IPOSSIGNPOSN),
	LOCALE_ENTRY(INEGSIGNPOSN),
	LOCALE_ENTRY(IPOSSYMPRECEDES),
	LOCALE_ENTRY(IPOSSEPBYSPACE),
	LOCALE_ENTRY(INEGSYMPRECEDES),
	LOCALE_ENTRY(INEGSEPBYSPACE),
/*	LOCALE_ENTRY(FONTSIGNATURE),*/
	{NULL,0},
};

const struct map_lcid2str {
	LCID		langid;
	const char	*langname;
} languages[]={
	{0x0401,"Arabisch"},
	{0x0402,"Bulgarisch"},
	{0x0403,"Katalanisch"},
	{0x0404,"Traditionales Chinesisch"},
	{0x0405,"Tschecisch"},
	{0x0406,"Ddnisch"},
	{0x0407,"Deutsch"},
	{0x0408,"Griechisch"},
	{0x0409,"Amerikanisches Englisch"},
	{0x040A,"Kastilisches Spanisch"},
	{0x040B,"Finnisch"},
	{0x040C,"Franzvsisch"},
	{0x040D,"Hebrdisch"},
	{0x040E,"Ungarisch"},
	{0x040F,"Isldndisch"},
	{0x0410,"Italienisch"},
	{0x0411,"Japanisch"},
	{0x0412,"Koreanisch"},
	{0x0413,"Niederldndisch"},
	{0x0414,"Norwegisch-Bokmal"},
	{0x0415,"Polnisch"},
	{0x0416,"Brasilianisches Portugiesisch"},
	{0x0417,"Rdtoromanisch"},
	{0x0418,"Rumdnisch"},
	{0x0419,"Russisch"},
	{0x041A,"Kroatoserbisch (lateinisch)"},
	{0x041B,"Slowenisch"},
	{0x041C,"Albanisch"},
	{0x041D,"Schwedisch"},
	{0x041E,"Thai"},
	{0x041F,"T|rkisch"},
	{0x0420,"Urdu"},
	{0x0421,"Bahasa"},
	{0x0804,"Vereinfachtes Chinesisch"},
	{0x0807,"Schweizerdeutsch"},
	{0x0809,"Britisches Englisch"},
	{0x080A,"Mexikanisches Spanisch"},
	{0x080C,"Belgisches Franzvsisch"},
	{0x0810,"Schweizerisches Italienisch"},
	{0x0813,"Belgisches Niederldndisch"},
	{0x0814,"Norgwegisch-Nynorsk"},
	{0x0816,"Portugiesisch"},
	{0x081A,"Serbokratisch (kyrillisch)"},
	{0x0C1C,"Kanadisches Franzvsisch"},
	{0x100C,"Schweizerisches Franzvsisch"},
	{0x0000,"Unbekannt"},
};

/***********************************************************************
 *           GetUserDefaultLCID       (OLE2NLS.1)
 */
LCID WINAPI GetUserDefaultLCID()
{
/* Default sorting, neutral sublanguage */
    switch(Options.language)
    {
 /* case LANG_Bu: return 0x02; */      /* Bulgarian */
 /* case LANG_Ch: return 0x04; */      /* Chinese */
    case LANG_Cz: return 0x05;         /* Czech */
    case LANG_Da: return 0x06;         /* Danish */
    case LANG_De: return 0x07;         /* German */
 /* case LANG_Gr: return 0x08; */      /* Greek */
    case LANG_En: return 0x09;         /* English */
    case LANG_Es: return 0x0a;         /* Spanish */
    case LANG_Fi: return 0x0b;         /* Finnish */
    case LANG_Fr: return 0x0c;         /* French */
    case LANG_Hu: return 0x0e;         /* Hungarian */
 /* case LANG_Ic: return 0x0f; */      /* Icelandic */
    case LANG_It: return 0x10;         /* Italian */
 /* case LANG_Jp: return 0x11; */      /* Japanese */
    case LANG_Ko: return 0x12;         /* Korean */
 /* case LANG_Du: return 0x13; */      /* Dutch */
    case LANG_No: return 0x14;         /* Norwegian */
    case LANG_Pl: return 0x15;         /* Polish */
    case LANG_Po: return 0x16;         /* Portuguese */
 /* case LANG_Ro: return 0x18; */      /* Romanian */
 /* case LANG_Ru: return 0x19; */      /* Russian */
 /* case LANG_Cr: return 0x1a; */      /* Croatian */
 /* case LANG_Sl: return 0x1b; */      /* Slovak */
 /* case LANG_Sw: return 0x1d; */      /* Swedish */
 /* case LANG_Tu: return 0x1f; */      /* Turkish */
 /* case LANG_Sv: return 0x24; */      /* Slovenian */
    case LANG_Eo: return 0x25;         /* Esperanto (not official) */

    default:
	return 0x00;                   /* Neutral language */
    }
}

/***********************************************************************
 *         GetSystemDefaultLCID       (OLE2NLS.2)
 */
LCID WINAPI GetSystemDefaultLCID()
{
	return GetUserDefaultLCID();
}

/***********************************************************************
 *         GetUserDefaultLangID       (OLE2NLS.3)
 */
LANGID WINAPI GetUserDefaultLangID()
{
	return (WORD)GetUserDefaultLCID();
}

/***********************************************************************
 *         GetSystemDefaultLangID     (OLE2NLS.4)
 */
LANGID WINAPI GetSystemDefaultLangID()
{
	return GetUserDefaultLangID();
}

/***********************************************************************
 *         GetLocaleInfoA             (OLE2NLS.5)
 * Is the last parameter really WORD for Win16?
 */
INT16 WINAPI GetLocaleInfo16(LCID lcid,LCTYPE LCType,LPSTR buf,INT16 len)
{
	return GetLocaleInfo32A(lcid,LCType,buf,len);
}

INT32 WINAPI GetLocaleInfo32A(LCID lcid,LCTYPE LCType,LPSTR buf,INT32 len)
{
	char	*retString;
	int	found,i;

	dprintf_ole(stddeb,"GetLocaleInfo32A(%8lX,%8lX,%p,%4X)\n",
			lcid,LCType,buf,len);

	LCType &= ~(LOCALE_NOUSEROVERRIDE|LOCALE_USE_CP_ACP);

	/* As an option, we could obtain the value from win.ini.
	   This would not match the Wine compile-time option.
	   Also, not all identifiers are available from win.ini */
	retString=0;
	/* If we are through all of this, retLen should not be zero anymore.
	   If it is, the value is not supported */
	i=0;
	while (locale_name2id[i].name!=NULL) {
		if (LCType == locale_name2id[i].id) {
			retString = locale_name2id[i].name;
			break;
		}
		i++;
	}
	if (!retString) {
		fprintf(stderr,"Unkown LC type %lX\n",LCType);
		return 0;
	}

#define LOCVAL(type,value) case type:retString=value;break;

/* Now, the language specific definitions. They don't have to be
   complete */
    found=1;
    switch(Options.language)
    {
    case LANG_De:
    	switch (LCType) {
/* This definitions apply to Germany only. Users in Austria 
   or Switzerland might want to modify them */
LOCVAL(LOCALE_ILANGUAGE,"9")
LOCVAL(LOCALE_SLANGUAGE,"Deutsch")
LOCVAL(LOCALE_SENGLANGUAGE,"German")
LOCVAL(LOCALE_SABBREVLANGNAME,"deu")
LOCVAL(LOCALE_SNATIVELANGNAME,"Deutsch")
LOCVAL(LOCALE_ICOUNTRY,"49")
LOCVAL(LOCALE_SCOUNTRY,"Deutschland")
LOCVAL(LOCALE_SENGCOUNTRY,"Deutschland")
LOCVAL(LOCALE_SABBREVCTRYNAME,"De")
LOCVAL(LOCALE_SNATIVECTRYNAME,"Deutschland")
LOCVAL(LOCALE_IDEFAULTLANGUAGE,"9")
LOCVAL(LOCALE_IDEFAULTCOUNTRY,"49")
LOCVAL(LOCALE_IDEFAULTCODEPAGE,"851")
/* Dunno
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE)
*/
LOCVAL(LOCALE_SLIST,";")
LOCVAL(LOCALE_IMEASURE,"0")
LOCVAL(LOCALE_SDECIMAL,",")
LOCVAL(LOCALE_STHOUSAND,".")
/*
LOCVAL(LOCALE_SGROUPING)
*/
LOCVAL(LOCALE_IDIGITS,"2")
LOCVAL(LOCALE_ILZERO,"1")
/*
LOCVAL(LOCALE_INEGNUMBER)
Is this "0123456789" ??
LOCVAL(LOCALE_SNATIVEDIGITS)
*/
LOCVAL(LOCALE_SCURRENCY,"DM")
/*
LOCVAL(LOCALE_SINTLSYMBOL)
LOCVAL(LOCALE_SMONDECIMALSEP)
LOCVAL(LOCALE_SMONTHOUSANDSEP)
LOCVAL(LOCALE_SMONGROUPING)
*/
LOCVAL(LOCALE_ICURRDIGITS,"2")
/*
LOCVAL(LOCALE_IINTLCURRDIGITS)
*/
LOCVAL(LOCALE_ICURRENCY,"3")
LOCVAL(LOCALE_INEGCURR,"8")
LOCVAL(LOCALE_SDATE,".")
LOCVAL(LOCALE_STIME,":")
LOCVAL(LOCALE_SSHORTDATE,"dd.MM.yyyy")
LOCVAL(LOCALE_SLONGDATE,"ddd, d. MMMM yyyy")
/*
LOCVAL(LOCALE_STIMEFORMAT)
*/
LOCVAL(LOCALE_IDATE,"1")
/*
LOCVAL(LOCALE_ILDATE)
*/
LOCVAL(LOCALE_ITIME,"1")
/*
LOCVAL(LOCALE_ITIMEMARKPOSN)
LOCVAL(LOCALE_ICENTURY)
*/
LOCVAL(LOCALE_ITLZERO,"1")
/*
LOCVAL(LOCALE_IDAYLZERO)
LOCVAL(LOCALE_IMONLZERO)
LOCVAL(LOCALE_S1159)
LOCVAL(LOCALE_S2359)
LOCVAL(LOCALE_ICALENDARTYPE)
LOCVAL(LOCALE_IOPTIONALCALENDAR)
LOCVAL(LOCALE_IFIRSTDAYOFWEEK)
LOCVAL(LOCALE_IFIRSTWEEKOFYEAR)
*/
LOCVAL(LOCALE_SDAYNAME1,"Montag")
LOCVAL(LOCALE_SDAYNAME2,"Dienstag")
LOCVAL(LOCALE_SDAYNAME3,"Mittwoch")
LOCVAL(LOCALE_SDAYNAME4,"Donnerstag")
LOCVAL(LOCALE_SDAYNAME5,"Freitag")
LOCVAL(LOCALE_SDAYNAME6,"Sonnabend")
LOCVAL(LOCALE_SDAYNAME7,"Sonntag")
LOCVAL(LOCALE_SABBREVDAYNAME1,"Mo")
LOCVAL(LOCALE_SABBREVDAYNAME2,"Di")
LOCVAL(LOCALE_SABBREVDAYNAME3,"Mi")
LOCVAL(LOCALE_SABBREVDAYNAME4,"Do")
LOCVAL(LOCALE_SABBREVDAYNAME5,"Fr")
LOCVAL(LOCALE_SABBREVDAYNAME6,"Sa")
LOCVAL(LOCALE_SABBREVDAYNAME7,"So")
LOCVAL(LOCALE_SMONTHNAME1,"Januar")
LOCVAL(LOCALE_SMONTHNAME2,"Februar")
LOCVAL(LOCALE_SMONTHNAME3,"Mrz")
LOCVAL(LOCALE_SMONTHNAME4,"April")
LOCVAL(LOCALE_SMONTHNAME5,"Mai")
LOCVAL(LOCALE_SMONTHNAME6,"Juni")
LOCVAL(LOCALE_SMONTHNAME7,"Juli")
LOCVAL(LOCALE_SMONTHNAME8,"August")
LOCVAL(LOCALE_SMONTHNAME9,"September")
LOCVAL(LOCALE_SMONTHNAME10,"Oktober")
LOCVAL(LOCALE_SMONTHNAME11,"November")
LOCVAL(LOCALE_SMONTHNAME12,"Dezember")
LOCVAL(LOCALE_SMONTHNAME13,"")
LOCVAL(LOCALE_SABBREVMONTHNAME1,"Jan")
LOCVAL(LOCALE_SABBREVMONTHNAME2,"Feb")
LOCVAL(LOCALE_SABBREVMONTHNAME3,"Mr")
LOCVAL(LOCALE_SABBREVMONTHNAME4,"Apr")
LOCVAL(LOCALE_SABBREVMONTHNAME5,"Mai")
LOCVAL(LOCALE_SABBREVMONTHNAME6,"Jun")
LOCVAL(LOCALE_SABBREVMONTHNAME7,"Jul")
LOCVAL(LOCALE_SABBREVMONTHNAME8,"Aug")
LOCVAL(LOCALE_SABBREVMONTHNAME9,"Sep")
LOCVAL(LOCALE_SABBREVMONTHNAME10,"Okt")
LOCVAL(LOCALE_SABBREVMONTHNAME11,"Nov")
LOCVAL(LOCALE_SABBREVMONTHNAME12,"Dez")
LOCVAL(LOCALE_SABBREVMONTHNAME13,"")
/*
LOCVAL(LOCALE_SPOSITIVESIGN)
LOCVAL(LOCALE_SNEGATIVESIGN)
LOCVAL(LOCALE_IPOSSIGNPOSN)
LOCVAL(LOCALE_INEGSIGNPOSN)
LOCVAL(LOCALE_IPOSSYMPRECEDES)
LOCVAL(LOCALE_IPOSSEPBYSPACE)
LOCVAL(LOCALE_INEGSYMPRECEDES)
LOCVAL(LOCALE_INEGSEPBYSPACE)
*/
	default: found=0;break;
	}
    break;  /* LANG(De) */

    case LANG_Da:
    	switch (LCType) {
LOCVAL(LOCALE_ILANGUAGE,"6")
LOCVAL(LOCALE_SLANGUAGE,"Dansk")
LOCVAL(LOCALE_SENGLANGUAGE,"Danish")
LOCVAL(LOCALE_SABBREVLANGNAME,"dan")
LOCVAL(LOCALE_SNATIVELANGNAME,"Dansk")
LOCVAL(LOCALE_ICOUNTRY,"45")
LOCVAL(LOCALE_SCOUNTRY,"Danmark")
LOCVAL(LOCALE_SENGCOUNTRY,"Denmark")
LOCVAL(LOCALE_SABBREVCTRYNAME,"DK")
LOCVAL(LOCALE_SNATIVECTRYNAME,"Danmark")
LOCVAL(LOCALE_IDEFAULTLANGUAGE,"6")
LOCVAL(LOCALE_IDEFAULTCOUNTRY,"45")
/* LOCVAL(LOCALE_IDEFAULTCODEPAGE) */
/* LOCVAL(LOCALE_IDEFAULTANSICODEPAGE) */
LOCVAL(LOCALE_SLIST,";")
LOCVAL(LOCALE_IMEASURE,"0")
LOCVAL(LOCALE_SDECIMAL,",")
LOCVAL(LOCALE_STHOUSAND,".")
/* LOCVAL(LOCALE_SGROUPING) */
LOCVAL(LOCALE_IDIGITS,"2")
LOCVAL(LOCALE_ILZERO,"1")
/* LOCVAL(LOCALE_INEGNUMBER) */
/* LOCVAL(LOCALE_SNATIVEDIGITS) */
LOCVAL(LOCALE_SCURRENCY,"kr")
/* LOCVAL(LOCALE_SINTLSYMBOL) */
LOCVAL(LOCALE_SMONDECIMALSEP,",")
LOCVAL(LOCALE_SMONTHOUSANDSEP,".")
/* LOCVAL(LOCALE_SMONGROUPING) */
LOCVAL(LOCALE_ICURRDIGITS,"2")
/* LOCVAL(LOCALE_IINTLCURRDIGITS) */
LOCVAL(LOCALE_ICURRENCY,"3")
LOCVAL(LOCALE_INEGCURR,"8")
LOCVAL(LOCALE_SDATE,".")
LOCVAL(LOCALE_STIME,":")
LOCVAL(LOCALE_SSHORTDATE,"dd/MM-yyyy")
LOCVAL(LOCALE_SLONGDATE,"ddd, d. MMMM yyyy")
/* LOCVAL(LOCALE_STIMEFORMAT) */
LOCVAL(LOCALE_IDATE,"1")
/* LOCVAL(LOCALE_ILDATE) */
LOCVAL(LOCALE_ITIME,"1")
/* LOCVAL(LOCALE_ITIMEMARKPOSN) */
/* LOCVAL(LOCALE_ICENTURY) */
LOCVAL(LOCALE_ITLZERO,"1")
/* LOCVAL(LOCALE_IDAYLZERO) */
/* LOCVAL(LOCALE_IMONLZERO) */
LOCVAL(LOCALE_S1159, "")
LOCVAL(LOCALE_S2359, "")
/* LOCVAL(LOCALE_ICALENDARTYPE) */
/* LOCVAL(LOCALE_IOPTIONALCALENDAR) */
/* LOCVAL(LOCALE_IFIRSTDAYOFWEEK) */
/* LOCVAL(LOCALE_IFIRSTWEEKOFYEAR) */
LOCVAL(LOCALE_SDAYNAME1,"Mandag")
LOCVAL(LOCALE_SDAYNAME2,"Tirsdag")
LOCVAL(LOCALE_SDAYNAME3,"Onsdag")
LOCVAL(LOCALE_SDAYNAME4,"Torsdag")
LOCVAL(LOCALE_SDAYNAME5,"Fredag")
LOCVAL(LOCALE_SDAYNAME6,"Lrdag")
LOCVAL(LOCALE_SDAYNAME7,"Sndag")
LOCVAL(LOCALE_SABBREVDAYNAME1,"Ma")
LOCVAL(LOCALE_SABBREVDAYNAME2,"Ti")
LOCVAL(LOCALE_SABBREVDAYNAME3,"On")
LOCVAL(LOCALE_SABBREVDAYNAME4,"To")
LOCVAL(LOCALE_SABBREVDAYNAME5,"Fr")
LOCVAL(LOCALE_SABBREVDAYNAME6,"L")
LOCVAL(LOCALE_SABBREVDAYNAME7,"S")
LOCVAL(LOCALE_SMONTHNAME1,"Januar")
LOCVAL(LOCALE_SMONTHNAME2,"Februar")
LOCVAL(LOCALE_SMONTHNAME3,"Marts")
LOCVAL(LOCALE_SMONTHNAME4,"April")
LOCVAL(LOCALE_SMONTHNAME5,"Maj")
LOCVAL(LOCALE_SMONTHNAME6,"Juni")
LOCVAL(LOCALE_SMONTHNAME7,"Juli")
LOCVAL(LOCALE_SMONTHNAME8,"August")
LOCVAL(LOCALE_SMONTHNAME9,"September")
LOCVAL(LOCALE_SMONTHNAME10,"Oktober")
LOCVAL(LOCALE_SMONTHNAME11,"November")
LOCVAL(LOCALE_SMONTHNAME12,"December")
LOCVAL(LOCALE_SMONTHNAME13,"")
LOCVAL(LOCALE_SABBREVMONTHNAME1,"Jan")
LOCVAL(LOCALE_SABBREVMONTHNAME2,"Feb")
LOCVAL(LOCALE_SABBREVMONTHNAME3,"Mar")
LOCVAL(LOCALE_SABBREVMONTHNAME4,"Apr")
LOCVAL(LOCALE_SABBREVMONTHNAME5,"Maj")
LOCVAL(LOCALE_SABBREVMONTHNAME6,"Jun")
LOCVAL(LOCALE_SABBREVMONTHNAME7,"Jul")
LOCVAL(LOCALE_SABBREVMONTHNAME8,"Aug")
LOCVAL(LOCALE_SABBREVMONTHNAME9,"Sep")
LOCVAL(LOCALE_SABBREVMONTHNAME10,"Okt")
LOCVAL(LOCALE_SABBREVMONTHNAME11,"Nov")
LOCVAL(LOCALE_SABBREVMONTHNAME12,"Dec")
LOCVAL(LOCALE_SABBREVMONTHNAME13,"")
LOCVAL(LOCALE_SPOSITIVESIGN, "")
LOCVAL(LOCALE_SNEGATIVESIGN, "-")
LOCVAL(LOCALE_IPOSSIGNPOSN, "3")
LOCVAL(LOCALE_INEGSIGNPOSN, "3")
LOCVAL(LOCALE_IPOSSYMPRECEDES, "1")
LOCVAL(LOCALE_IPOSSEPBYSPACE, "0")
LOCVAL(LOCALE_INEGSYMPRECEDES, "1")
LOCVAL(LOCALE_INEGSEPBYSPACE, "0")
	default: found=0;break;
	}
    break; /* LANG(Da) */

    case LANG_En:
    	switch (LCType) {
LOCVAL(LOCALE_ILANGUAGE,"9")
LOCVAL(LOCALE_SLANGUAGE,"English")
LOCVAL(LOCALE_SENGLANGUAGE,"English")
LOCVAL(LOCALE_SABBREVLANGNAME,"enu")
LOCVAL(LOCALE_SNATIVELANGNAME,"English")
LOCVAL(LOCALE_ICOUNTRY,"11")
LOCVAL(LOCALE_SCOUNTRY,"Deutschland")
LOCVAL(LOCALE_SENGCOUNTRY,"Deutschland")
LOCVAL(LOCALE_SABBREVCTRYNAME,"De")
LOCVAL(LOCALE_SNATIVECTRYNAME,"Deutschland")
LOCVAL(LOCALE_IDEFAULTLANGUAGE,"9")
LOCVAL(LOCALE_IDEFAULTCOUNTRY,"49")
LOCVAL(LOCALE_IDEFAULTCODEPAGE,"437")
/* Dunno
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE)
*/
LOCVAL(LOCALE_SLIST,";")
LOCVAL(LOCALE_IMEASURE,"0")
LOCVAL(LOCALE_SDECIMAL,",")
LOCVAL(LOCALE_STHOUSAND,".")
/*
LOCVAL(LOCALE_SGROUPING)
*/
LOCVAL(LOCALE_IDIGITS,"2")
LOCVAL(LOCALE_ILZERO,"1")
/*
LOCVAL(LOCALE_INEGNUMBER)
Is this "0123456789" ??
LOCVAL(LOCALE_SNATIVEDIGITS)
*/
LOCVAL(LOCALE_SCURRENCY,"DM")
/*
LOCVAL(LOCALE_SINTLSYMBOL)
LOCVAL(LOCALE_SMONDECIMALSEP)
LOCVAL(LOCALE_SMONTHOUSANDSEP)
LOCVAL(LOCALE_SMONGROUPING)
*/
LOCVAL(LOCALE_ICURRDIGITS,"2")
/*
LOCVAL(LOCALE_IINTLCURRDIGITS)
*/
LOCVAL(LOCALE_ICURRENCY,"3")
LOCVAL(LOCALE_INEGCURR,"8")
LOCVAL(LOCALE_SDATE,".")
LOCVAL(LOCALE_STIME,":")
LOCVAL(LOCALE_SSHORTDATE,"dd.MM.yyyy")
LOCVAL(LOCALE_SLONGDATE,"ddd, d. MMMM yyyy")
/*
LOCVAL(LOCALE_STIMEFORMAT)
*/
LOCVAL(LOCALE_IDATE,"1")
/*
LOCVAL(LOCALE_ILDATE)
*/
LOCVAL(LOCALE_ITIME,"1")
/*
LOCVAL(LOCALE_ITIMEMARKPOSN)
LOCVAL(LOCALE_ICENTURY)
*/
LOCVAL(LOCALE_ITLZERO,"1")
/*
LOCVAL(LOCALE_IDAYLZERO)
LOCVAL(LOCALE_IMONLZERO)
LOCVAL(LOCALE_S1159)
LOCVAL(LOCALE_S2359)
LOCVAL(LOCALE_ICALENDARTYPE)
LOCVAL(LOCALE_IOPTIONALCALENDAR)
LOCVAL(LOCALE_IFIRSTDAYOFWEEK)
LOCVAL(LOCALE_IFIRSTWEEKOFYEAR)
*/
LOCVAL(LOCALE_SDAYNAME1,"Montag")
LOCVAL(LOCALE_SDAYNAME2,"Dienstag")
LOCVAL(LOCALE_SDAYNAME3,"Mittwoch")
LOCVAL(LOCALE_SDAYNAME4,"Donnerstag")
LOCVAL(LOCALE_SDAYNAME5,"Freitag")
LOCVAL(LOCALE_SDAYNAME6,"Sonnabend")
LOCVAL(LOCALE_SDAYNAME7,"Sonntag")
LOCVAL(LOCALE_SABBREVDAYNAME1,"Mo")
LOCVAL(LOCALE_SABBREVDAYNAME2,"Di")
LOCVAL(LOCALE_SABBREVDAYNAME3,"Mi")
LOCVAL(LOCALE_SABBREVDAYNAME4,"Do")
LOCVAL(LOCALE_SABBREVDAYNAME5,"Fr")
LOCVAL(LOCALE_SABBREVDAYNAME6,"Sa")
LOCVAL(LOCALE_SABBREVDAYNAME7,"So")
LOCVAL(LOCALE_SMONTHNAME1,"Januar")
LOCVAL(LOCALE_SMONTHNAME2,"Februar")
LOCVAL(LOCALE_SMONTHNAME3,"Mrz")
LOCVAL(LOCALE_SMONTHNAME4,"April")
LOCVAL(LOCALE_SMONTHNAME5,"Mai")
LOCVAL(LOCALE_SMONTHNAME6,"Juni")
LOCVAL(LOCALE_SMONTHNAME7,"Juli")
LOCVAL(LOCALE_SMONTHNAME8,"August")
LOCVAL(LOCALE_SMONTHNAME9,"September")
LOCVAL(LOCALE_SMONTHNAME10,"Oktober")
LOCVAL(LOCALE_SMONTHNAME11,"November")
LOCVAL(LOCALE_SMONTHNAME12,"Dezember")
LOCVAL(LOCALE_SMONTHNAME13,"")
LOCVAL(LOCALE_SABBREVMONTHNAME1,"Jan")
LOCVAL(LOCALE_SABBREVMONTHNAME2,"Feb")
LOCVAL(LOCALE_SABBREVMONTHNAME3,"Mr")
LOCVAL(LOCALE_SABBREVMONTHNAME4,"Apr")
LOCVAL(LOCALE_SABBREVMONTHNAME5,"Mai")
LOCVAL(LOCALE_SABBREVMONTHNAME6,"Jun")
LOCVAL(LOCALE_SABBREVMONTHNAME7,"Jul")
LOCVAL(LOCALE_SABBREVMONTHNAME8,"Aug")
LOCVAL(LOCALE_SABBREVMONTHNAME9,"Sep")
LOCVAL(LOCALE_SABBREVMONTHNAME10,"Okt")
LOCVAL(LOCALE_SABBREVMONTHNAME11,"Nov")
LOCVAL(LOCALE_SABBREVMONTHNAME12,"Dez")
LOCVAL(LOCALE_SABBREVMONTHNAME13,"")
/*
LOCVAL(LOCALE_SPOSITIVESIGN)
LOCVAL(LOCALE_SNEGATIVESIGN)
LOCVAL(LOCALE_IPOSSIGNPOSN)
LOCVAL(LOCALE_INEGSIGNPOSN)
LOCVAL(LOCALE_IPOSSYMPRECEDES)
LOCVAL(LOCALE_IPOSSEPBYSPACE)
LOCVAL(LOCALE_INEGSYMPRECEDES)
LOCVAL(LOCALE_INEGSEPBYSPACE)
*/
	default: found=0;break;
	}
    break;  /* LANG(En) */

    case LANG_Eo:
    	switch (LCType) {
/* LOCVAL(LOCALE_ILANGUAGE,"9") ISO numerical ID for language TODO */
LOCVAL(LOCALE_SLANGUAGE,"Esperanto")
LOCVAL(LOCALE_SENGLANGUAGE,"Esperanto")
/* LOCVAL(LOCALE_SABBREVLANGNAME,"deu") */
LOCVAL(LOCALE_SNATIVELANGNAME,"Esperanto")
/* LOCVAL(LOCALE_ICOUNTRY,"49") not official in any one country */
/* LOCVAL(LOCALE_SCOUNTRY,"Deutschland") */
/* LOCVAL(LOCALE_SENGCOUNTRY,"Germany") */
/* LOCVAL(LOCALE_SABBREVCTRYNAME,"De") */
/* LOCVAL(LOCALE_SNATIVECTRYNAME,"Deutschland") */
/* LOCVAL(LOCALE_IDEFAULTLANGUAGE,"9") ISO ID of lang TODO */
/* LOCVAL(LOCALE_IDEFAULTCOUNTRY,"49") */
LOCVAL(LOCALE_IDEFAULTCODEPAGE,"3") /* is this right? TODO */
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE,"3") /* is this right? TODO */
LOCVAL(LOCALE_SLIST,";")
LOCVAL(LOCALE_IMEASURE,"0")
LOCVAL(LOCALE_SDECIMAL,",")
LOCVAL(LOCALE_STHOUSAND,".")
/* LOCVAL(LOCALE_SGROUPING) */
LOCVAL(LOCALE_IDIGITS,"2")
LOCVAL(LOCALE_ILZERO,"1")
/* LOCVAL(LOCALE_INEGNUMBER) */
/* LOCVAL(LOCALE_SNATIVEDIGITS) */
LOCVAL(LOCALE_SCURRENCY,"NLG") /* accounting currency of UEA */
/* LOCVAL(LOCALE_SINTLSYMBOL) */
/* LOCVAL(LOCALE_SMONDECIMALSEP) */
/* LOCVAL(LOCALE_SMONTHOUSANDSEP) */
/* LOCVAL(LOCALE_SMONGROUPING) */
/* LOCVAL(LOCALE_ICURRDIGITS,"2") */
/* LOCVAL(LOCALE_IINTLCURRDIGITS) */
LOCVAL(LOCALE_ICURRENCY,"3")
LOCVAL(LOCALE_INEGCURR,"8")
LOCVAL(LOCALE_SDATE,".")
LOCVAL(LOCALE_STIME,":")
LOCVAL(LOCALE_SSHORTDATE,"yyyy.mm.dd")
LOCVAL(LOCALE_SLONGDATE,"ddd, d. MMMM yyyy")
/* LOCVAL(LOCALE_STIMEFORMAT) */
LOCVAL(LOCALE_IDATE,"1")
/* LOCVAL(LOCALE_ILDATE) */
LOCVAL(LOCALE_ITIME,"1")
/* LOCVAL(LOCALE_ITIMEMARKPOSN) */
/* LOCVAL(LOCALE_ICENTURY) */
LOCVAL(LOCALE_ITLZERO,"1")
/* LOCVAL(LOCALE_IDAYLZERO) */
/* LOCVAL(LOCALE_IMONLZERO) */
/* LOCVAL(LOCALE_S1159) */
/* LOCVAL(LOCALE_S2359) */
/* LOCVAL(LOCALE_ICALENDARTYPE) */
/* LOCVAL(LOCALE_IOPTIONALCALENDAR) */
/* LOCVAL(LOCALE_IFIRSTDAYOFWEEK) */
/* LOCVAL(LOCALE_IFIRSTWEEKOFYEAR) */
LOCVAL(LOCALE_SDAYNAME1,"lundo")
LOCVAL(LOCALE_SDAYNAME2,"mardo")
LOCVAL(LOCALE_SDAYNAME3,"merkredo")
LOCVAL(LOCALE_SDAYNAME4,"ado")
LOCVAL(LOCALE_SDAYNAME5,"vendredo")
LOCVAL(LOCALE_SDAYNAME6,"sabato")
LOCVAL(LOCALE_SDAYNAME7,"dimano")
LOCVAL(LOCALE_SABBREVDAYNAME1,"lu")
LOCVAL(LOCALE_SABBREVDAYNAME2,"ma")
LOCVAL(LOCALE_SABBREVDAYNAME3,"me")
LOCVAL(LOCALE_SABBREVDAYNAME4,"a")
LOCVAL(LOCALE_SABBREVDAYNAME5,"ve")
LOCVAL(LOCALE_SABBREVDAYNAME6,"sa")
LOCVAL(LOCALE_SABBREVDAYNAME7,"di")
LOCVAL(LOCALE_SMONTHNAME1,"januaro")
LOCVAL(LOCALE_SMONTHNAME2,"februaro")
LOCVAL(LOCALE_SMONTHNAME3,"marto")
LOCVAL(LOCALE_SMONTHNAME4,"aprilo")
LOCVAL(LOCALE_SMONTHNAME5,"majo")
LOCVAL(LOCALE_SMONTHNAME6,"junio")
LOCVAL(LOCALE_SMONTHNAME7,"julio")
LOCVAL(LOCALE_SMONTHNAME8,"agusto")
LOCVAL(LOCALE_SMONTHNAME9,"septembro")
LOCVAL(LOCALE_SMONTHNAME10,"oktobro")
LOCVAL(LOCALE_SMONTHNAME11,"novembro")
LOCVAL(LOCALE_SMONTHNAME12,"decembro")
LOCVAL(LOCALE_SMONTHNAME13,"")
LOCVAL(LOCALE_SABBREVMONTHNAME1,"jan")
LOCVAL(LOCALE_SABBREVMONTHNAME2,"feb")
LOCVAL(LOCALE_SABBREVMONTHNAME3,"mar")
LOCVAL(LOCALE_SABBREVMONTHNAME4,"apr")
LOCVAL(LOCALE_SABBREVMONTHNAME5,"maj")
LOCVAL(LOCALE_SABBREVMONTHNAME6,"jun")
LOCVAL(LOCALE_SABBREVMONTHNAME7,"jul")
LOCVAL(LOCALE_SABBREVMONTHNAME8,"ag")
LOCVAL(LOCALE_SABBREVMONTHNAME9,"sep")
LOCVAL(LOCALE_SABBREVMONTHNAME10,"okt")
LOCVAL(LOCALE_SABBREVMONTHNAME11,"nov")
LOCVAL(LOCALE_SABBREVMONTHNAME12,"dec")
LOCVAL(LOCALE_SABBREVMONTHNAME13,"")
/* LOCVAL(LOCALE_SPOSITIVESIGN) */
/* LOCVAL(LOCALE_SNEGATIVESIGN) */
/* LOCVAL(LOCALE_IPOSSIGNPOSN) */
/* LOCVAL(LOCALE_INEGSIGNPOSN) */
/* LOCVAL(LOCALE_IPOSSYMPRECEDES) */
/* LOCVAL(LOCALE_IPOSSEPBYSPACE) */
/* LOCVAL(LOCALE_INEGSYMPRECEDES) */
/* LOCVAL(LOCALE_INEGSEPBYSPACE) */
	default: found=0;break;
	}
    break;  /* LANG(Eo) */

    case LANG_Fi:
    	switch (LCType) {
LOCVAL(LOCALE_ILANGUAGE,"11")
LOCVAL(LOCALE_SLANGUAGE,"Suomi")
LOCVAL(LOCALE_SENGLANGUAGE,"Finnish")
LOCVAL(LOCALE_SABBREVLANGNAME,"fin")
LOCVAL(LOCALE_SNATIVELANGNAME,"suomi")
LOCVAL(LOCALE_ICOUNTRY,"49")
LOCVAL(LOCALE_SCOUNTRY,"Suomi")
LOCVAL(LOCALE_SENGCOUNTRY,"Finland")
LOCVAL(LOCALE_SABBREVCTRYNAME,"Fin")
LOCVAL(LOCALE_SNATIVECTRYNAME,"Suomi")
LOCVAL(LOCALE_IDEFAULTLANGUAGE,"11")
LOCVAL(LOCALE_IDEFAULTCOUNTRY,"358")
/* 
LOCVAL(LOCALE_IDEFAULTCODEPAGE)
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE)
*/
LOCVAL(LOCALE_SLIST,";")
LOCVAL(LOCALE_IMEASURE,"0")
LOCVAL(LOCALE_SDECIMAL,",")
LOCVAL(LOCALE_STHOUSAND,".")
/*
LOCVAL(LOCALE_SGROUPING)
*/
LOCVAL(LOCALE_IDIGITS,"2")
LOCVAL(LOCALE_ILZERO,"1")
/*
LOCVAL(LOCALE_INEGNUMBER)
Is this "0123456789" ??
LOCVAL(LOCALE_SNATIVEDIGITS)
*/
LOCVAL(LOCALE_SCURRENCY,"mk")
/*
LOCVAL(LOCALE_SINTLSYMBOL)
LOCVAL(LOCALE_SMONDECIMALSEP)
LOCVAL(LOCALE_SMONTHOUSANDSEP)
LOCVAL(LOCALE_SMONGROUPING)
*/
LOCVAL(LOCALE_ICURRDIGITS,"2")
/*
LOCVAL(LOCALE_IINTLCURRDIGITS)
*/
LOCVAL(LOCALE_ICURRENCY,"3")
LOCVAL(LOCALE_INEGCURR,"8")
LOCVAL(LOCALE_SDATE,".")
LOCVAL(LOCALE_STIME,":")
LOCVAL(LOCALE_SSHORTDATE,"dd.MM.yyyy")
LOCVAL(LOCALE_SLONGDATE,"ddd, d. MMMM yyyy")
/*
LOCVAL(LOCALE_STIMEFORMAT)
*/
LOCVAL(LOCALE_IDATE,"1")
/*
LOCVAL(LOCALE_ILDATE)
*/
LOCVAL(LOCALE_ITIME,"1")
/*
LOCVAL(LOCALE_ITIMEMARKPOSN)
LOCVAL(LOCALE_ICENTURY)
*/
LOCVAL(LOCALE_ITLZERO,"1")
/*
LOCVAL(LOCALE_IDAYLZERO)
LOCVAL(LOCALE_IMONLZERO)
LOCVAL(LOCALE_S1159)
LOCVAL(LOCALE_S2359)
LOCVAL(LOCALE_ICALENDARTYPE)
LOCVAL(LOCALE_IOPTIONALCALENDAR)
LOCVAL(LOCALE_IFIRSTDAYOFWEEK)
LOCVAL(LOCALE_IFIRSTWEEKOFYEAR)
*/
LOCVAL(LOCALE_SDAYNAME1,"maanantai")
LOCVAL(LOCALE_SDAYNAME2,"tiistai")
LOCVAL(LOCALE_SDAYNAME3,"keskiviikko")
LOCVAL(LOCALE_SDAYNAME4,"torstai")
LOCVAL(LOCALE_SDAYNAME5,"perjantai")
LOCVAL(LOCALE_SDAYNAME6,"lauantai")
LOCVAL(LOCALE_SDAYNAME7,"sunnuntai")
LOCVAL(LOCALE_SABBREVDAYNAME1,"Ma")
LOCVAL(LOCALE_SABBREVDAYNAME2,"Ti")
LOCVAL(LOCALE_SABBREVDAYNAME3,"Ke")
LOCVAL(LOCALE_SABBREVDAYNAME4,"To")
LOCVAL(LOCALE_SABBREVDAYNAME5,"Pe")
LOCVAL(LOCALE_SABBREVDAYNAME6,"La")
LOCVAL(LOCALE_SABBREVDAYNAME7,"Su")
LOCVAL(LOCALE_SMONTHNAME1,"tammikuu")
LOCVAL(LOCALE_SMONTHNAME2,"helmikuu")
LOCVAL(LOCALE_SMONTHNAME3,"maaliskuu")
LOCVAL(LOCALE_SMONTHNAME4,"huhtikuu")
LOCVAL(LOCALE_SMONTHNAME5,"toukokuu")
LOCVAL(LOCALE_SMONTHNAME6,"keskuu")
LOCVAL(LOCALE_SMONTHNAME7,"heinkuu")
LOCVAL(LOCALE_SMONTHNAME8,"elokuu")
LOCVAL(LOCALE_SMONTHNAME9,"syyskuu")
LOCVAL(LOCALE_SMONTHNAME10,"lokakuu")
LOCVAL(LOCALE_SMONTHNAME11,"marraskuu")
LOCVAL(LOCALE_SMONTHNAME12,"joulukuu")
LOCVAL(LOCALE_SMONTHNAME13,"")
LOCVAL(LOCALE_SABBREVMONTHNAME1,"tammi")
LOCVAL(LOCALE_SABBREVMONTHNAME2,"helmi")
LOCVAL(LOCALE_SABBREVMONTHNAME3,"maalis")
LOCVAL(LOCALE_SABBREVMONTHNAME4,"huhti")
LOCVAL(LOCALE_SABBREVMONTHNAME5,"touko")
LOCVAL(LOCALE_SABBREVMONTHNAME6,"kes")
LOCVAL(LOCALE_SABBREVMONTHNAME7,"hein")
LOCVAL(LOCALE_SABBREVMONTHNAME8,"elo")
LOCVAL(LOCALE_SABBREVMONTHNAME9,"syys")
LOCVAL(LOCALE_SABBREVMONTHNAME10,"loka")
LOCVAL(LOCALE_SABBREVMONTHNAME11,"marras")
LOCVAL(LOCALE_SABBREVMONTHNAME12,"joulu")
LOCVAL(LOCALE_SABBREVMONTHNAME13,"")
/*
LOCVAL(LOCALE_SPOSITIVESIGN)
LOCVAL(LOCALE_SNEGATIVESIGN)
LOCVAL(LOCALE_IPOSSIGNPOSN)
LOCVAL(LOCALE_INEGSIGNPOSN)
LOCVAL(LOCALE_IPOSSYMPRECEDES)
LOCVAL(LOCALE_IPOSSEPBYSPACE)
LOCVAL(LOCALE_INEGSYMPRECEDES)
LOCVAL(LOCALE_INEGSEPBYSPACE)
*/
	default: found=0;break;
	}
    break;  /* LANG(Fi) */

    case LANG_It:
    	switch (LCType) {
LOCVAL(LOCALE_ILANGUAGE,"9")
LOCVAL(LOCALE_SLANGUAGE,"Italiano")
LOCVAL(LOCALE_SENGLANGUAGE,"Italian")
LOCVAL(LOCALE_SABBREVLANGNAME,"ita")
LOCVAL(LOCALE_SNATIVELANGNAME,"Italiano")
LOCVAL(LOCALE_ICOUNTRY,"39")
LOCVAL(LOCALE_SCOUNTRY,"Italia")
LOCVAL(LOCALE_SENGCOUNTRY,"Italy")
LOCVAL(LOCALE_SABBREVCTRYNAME,"It")
LOCVAL(LOCALE_SNATIVECTRYNAME,"Italia")
LOCVAL(LOCALE_IDEFAULTLANGUAGE,"9")
LOCVAL(LOCALE_IDEFAULTCOUNTRY,"39")
/* Dunno
LOCVAL(LOCALE_IDEFAULTCODEPAGE)
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE)
*/
LOCVAL(LOCALE_SLIST,";")
LOCVAL(LOCALE_IMEASURE,"0")
LOCVAL(LOCALE_SDECIMAL,",")
LOCVAL(LOCALE_STHOUSAND,".")
/*
LOCVAL(LOCALE_SGROUPING)
*/
LOCVAL(LOCALE_IDIGITS,"2")
LOCVAL(LOCALE_ILZERO,"1")
/*
LOCVAL(LOCALE_INEGNUMBER)
Is this "0123456789" ??
LOCVAL(LOCALE_SNATIVEDIGITS)
*/
LOCVAL(LOCALE_SCURRENCY,"Lit.")
/*
LOCVAL(LOCALE_SINTLSYMBOL)
LOCVAL(LOCALE_SMONDECIMALSEP)
LOCVAL(LOCALE_SMONTHOUSANDSEP)
LOCVAL(LOCALE_SMONGROUPING)
*/
LOCVAL(LOCALE_ICURRDIGITS,"2")
/*
LOCVAL(LOCALE_IINTLCURRDIGITS)
*/
LOCVAL(LOCALE_ICURRENCY,"3")
LOCVAL(LOCALE_INEGCURR,"8")
LOCVAL(LOCALE_SDATE,".")
LOCVAL(LOCALE_STIME,":")
LOCVAL(LOCALE_SSHORTDATE,"dd.MM.yyyy")
LOCVAL(LOCALE_SLONGDATE,"ddd, d. MMMM yyyy")
/*
LOCVAL(LOCALE_STIMEFORMAT)
*/
LOCVAL(LOCALE_IDATE,"1")
/*
LOCVAL(LOCALE_ILDATE)
*/
LOCVAL(LOCALE_ITIME,"1")
/*
LOCVAL(LOCALE_ITIMEMARKPOSN)
LOCVAL(LOCALE_ICENTURY)
*/
LOCVAL(LOCALE_ITLZERO,"1")
/*
LOCVAL(LOCALE_IDAYLZERO)
LOCVAL(LOCALE_IMONLZERO)
LOCVAL(LOCALE_S1159)
LOCVAL(LOCALE_S2359)
LOCVAL(LOCALE_ICALENDARTYPE)
LOCVAL(LOCALE_IOPTIONALCALENDAR)
LOCVAL(LOCALE_IFIRSTDAYOFWEEK)
LOCVAL(LOCALE_IFIRSTWEEKOFYEAR)
*/
LOCVAL(LOCALE_SDAYNAME1,"Lunedi'")
LOCVAL(LOCALE_SDAYNAME2,"Martedi'")
LOCVAL(LOCALE_SDAYNAME3,"Mercoledi'")
LOCVAL(LOCALE_SDAYNAME4,"Giovedi'")
LOCVAL(LOCALE_SDAYNAME5,"Venerdi'")
LOCVAL(LOCALE_SDAYNAME6,"Sabato")
LOCVAL(LOCALE_SDAYNAME7,"Domenica")
LOCVAL(LOCALE_SABBREVDAYNAME1,"Lu")
LOCVAL(LOCALE_SABBREVDAYNAME2,"Ma")
LOCVAL(LOCALE_SABBREVDAYNAME3,"Me")
LOCVAL(LOCALE_SABBREVDAYNAME4,"Gi")
LOCVAL(LOCALE_SABBREVDAYNAME5,"Ve")
LOCVAL(LOCALE_SABBREVDAYNAME6,"Sa")
LOCVAL(LOCALE_SABBREVDAYNAME7,"Do")
LOCVAL(LOCALE_SMONTHNAME1,"Gennaio")
LOCVAL(LOCALE_SMONTHNAME2,"Febbraio")
LOCVAL(LOCALE_SMONTHNAME3,"Marzo")
LOCVAL(LOCALE_SMONTHNAME4,"Aprile")
LOCVAL(LOCALE_SMONTHNAME5,"Maggio")
LOCVAL(LOCALE_SMONTHNAME6,"Giugno")
LOCVAL(LOCALE_SMONTHNAME7,"Luglio")
LOCVAL(LOCALE_SMONTHNAME8,"Agosto")
LOCVAL(LOCALE_SMONTHNAME9,"Settembre")
LOCVAL(LOCALE_SMONTHNAME10,"Ottobre")
LOCVAL(LOCALE_SMONTHNAME11,"Novembre")
LOCVAL(LOCALE_SMONTHNAME12,"Dicembre")
LOCVAL(LOCALE_SMONTHNAME13,"")
LOCVAL(LOCALE_SABBREVMONTHNAME1,"Gen")
LOCVAL(LOCALE_SABBREVMONTHNAME2,"Feb")
LOCVAL(LOCALE_SABBREVMONTHNAME3,"Mar")
LOCVAL(LOCALE_SABBREVMONTHNAME4,"Apr")
LOCVAL(LOCALE_SABBREVMONTHNAME5,"Mag")
LOCVAL(LOCALE_SABBREVMONTHNAME6,"Giu")
LOCVAL(LOCALE_SABBREVMONTHNAME7,"Lug")
LOCVAL(LOCALE_SABBREVMONTHNAME8,"Ago")
LOCVAL(LOCALE_SABBREVMONTHNAME9,"Set")
LOCVAL(LOCALE_SABBREVMONTHNAME10,"Ott")
LOCVAL(LOCALE_SABBREVMONTHNAME11,"Nov")
LOCVAL(LOCALE_SABBREVMONTHNAME12,"Dic")
LOCVAL(LOCALE_SABBREVMONTHNAME13,"")
/*
LOCVAL(LOCALE_SPOSITIVESIGN)
LOCVAL(LOCALE_SNEGATIVESIGN)
LOCVAL(LOCALE_IPOSSIGNPOSN)
LOCVAL(LOCALE_INEGSIGNPOSN)
LOCVAL(LOCALE_IPOSSYMPRECEDES)
LOCVAL(LOCALE_IPOSSEPBYSPACE)
LOCVAL(LOCALE_INEGSYMPRECEDES)
LOCVAL(LOCALE_INEGSEPBYSPACE)
*/
	default: found=0;break;
	}
    break;  /* LANG(It) */

    case 0x0409:
    	switch (LCType) {
LOCVAL(LOCALE_ILANGUAGE, "0409")
LOCVAL(LOCALE_SLANGUAGE, "English (United States)")
LOCVAL(LOCALE_SENGLANGUAGE, "English")
LOCVAL(LOCALE_SABBREVLANGNAME, "ENU")
LOCVAL(LOCALE_SNATIVELANGNAME, "English")
LOCVAL(LOCALE_ICOUNTRY, "1")
LOCVAL(LOCALE_SCOUNTRY, "United States")
LOCVAL(LOCALE_SENGCOUNTRY, "United States")
LOCVAL(LOCALE_SABBREVCTRYNAME, "USA")
LOCVAL(LOCALE_SNATIVECTRYNAME, "United States")
LOCVAL(LOCALE_IDEFAULTLANGUAGE, "0409")
LOCVAL(LOCALE_IDEFAULTCOUNTRY, "1")
LOCVAL(LOCALE_IDEFAULTCODEPAGE, "437")
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE, "1252")
LOCVAL(LOCALE_SLIST, ",")
LOCVAL(LOCALE_IMEASURE, "1")
LOCVAL(LOCALE_SDECIMAL, ".")
LOCVAL(LOCALE_STHOUSAND, ",")
LOCVAL(LOCALE_SGROUPING, "3;0")
LOCVAL(LOCALE_IDIGITS, "2")
LOCVAL(LOCALE_ILZERO, "1")
LOCVAL(LOCALE_INEGNUMBER, "1")
LOCVAL(LOCALE_SNATIVEDIGITS, "0123456789")
LOCVAL(LOCALE_SCURRENCY, "$")
LOCVAL(LOCALE_SINTLSYMBOL, "USD")
LOCVAL(LOCALE_SMONDECIMALSEP, ".")
LOCVAL(LOCALE_SMONTHOUSANDSEP, ",")
LOCVAL(LOCALE_SMONGROUPING, "3;0")
LOCVAL(LOCALE_ICURRDIGITS, "2")
LOCVAL(LOCALE_IINTLCURRDIGITS, "2")
LOCVAL(LOCALE_ICURRENCY, "0")
LOCVAL(LOCALE_INEGCURR, "0")
LOCVAL(LOCALE_SDATE, "/")
LOCVAL(LOCALE_STIME, ":")
LOCVAL(LOCALE_SSHORTDATE, "M/d/yy")
LOCVAL(LOCALE_SLONGDATE, "dddd, MMMM dd, yyyy")
LOCVAL(LOCALE_STIMEFORMAT, "h:mm:ss tt")
LOCVAL(LOCALE_IDATE, "0")
LOCVAL(LOCALE_ILDATE, "0")
LOCVAL(LOCALE_ITIME, "0")
LOCVAL(LOCALE_ITIMEMARKPOSN, "0")
LOCVAL(LOCALE_ICENTURY, "0")
LOCVAL(LOCALE_ITLZERO, "0")
LOCVAL(LOCALE_IDAYLZERO, "0")
LOCVAL(LOCALE_IMONLZERO, "0")
LOCVAL(LOCALE_S1159, "AM")
LOCVAL(LOCALE_S2359, "PM")
LOCVAL(LOCALE_ICALENDARTYPE, "1")
LOCVAL(LOCALE_IOPTIONALCALENDAR, "0")
LOCVAL(LOCALE_IFIRSTDAYOFWEEK, "6")
LOCVAL(LOCALE_IFIRSTWEEKOFYEAR, "0")
LOCVAL(LOCALE_SDAYNAME1, "Monday")
LOCVAL(LOCALE_SDAYNAME2, "Tuesday")
LOCVAL(LOCALE_SDAYNAME3, "Wednesday")
LOCVAL(LOCALE_SDAYNAME4, "Thursday")
LOCVAL(LOCALE_SDAYNAME5, "Friday")
LOCVAL(LOCALE_SDAYNAME6, "Saturday")
LOCVAL(LOCALE_SDAYNAME7, "Sunday")
LOCVAL(LOCALE_SABBREVDAYNAME1, "Mon")
LOCVAL(LOCALE_SABBREVDAYNAME2, "Tue")
LOCVAL(LOCALE_SABBREVDAYNAME3, "Wed")
LOCVAL(LOCALE_SABBREVDAYNAME4, "Thu")
LOCVAL(LOCALE_SABBREVDAYNAME5, "Fri")
LOCVAL(LOCALE_SABBREVDAYNAME6, "Sat")
LOCVAL(LOCALE_SABBREVDAYNAME7, "Sun")
LOCVAL(LOCALE_SMONTHNAME1, "January")
LOCVAL(LOCALE_SMONTHNAME2, "February")
LOCVAL(LOCALE_SMONTHNAME3, "March")
LOCVAL(LOCALE_SMONTHNAME4, "April")
LOCVAL(LOCALE_SMONTHNAME5, "May")
LOCVAL(LOCALE_SMONTHNAME6, "June")
LOCVAL(LOCALE_SMONTHNAME7, "July")
LOCVAL(LOCALE_SMONTHNAME8, "August")
LOCVAL(LOCALE_SMONTHNAME9, "September")
LOCVAL(LOCALE_SMONTHNAME10, "October")
LOCVAL(LOCALE_SMONTHNAME11, "November")
LOCVAL(LOCALE_SMONTHNAME12, "December")
LOCVAL(LOCALE_SMONTHNAME13, "")
LOCVAL(LOCALE_SABBREVMONTHNAME1, "Jan")
LOCVAL(LOCALE_SABBREVMONTHNAME2, "Feb")
LOCVAL(LOCALE_SABBREVMONTHNAME3, "Mar")
LOCVAL(LOCALE_SABBREVMONTHNAME4, "Apr")
LOCVAL(LOCALE_SABBREVMONTHNAME5, "May")
LOCVAL(LOCALE_SABBREVMONTHNAME6, "Jun")
LOCVAL(LOCALE_SABBREVMONTHNAME7, "Jul")
LOCVAL(LOCALE_SABBREVMONTHNAME8, "Aug")
LOCVAL(LOCALE_SABBREVMONTHNAME9, "Sep")
LOCVAL(LOCALE_SABBREVMONTHNAME10, "Oct")
LOCVAL(LOCALE_SABBREVMONTHNAME11, "Nov")
LOCVAL(LOCALE_SABBREVMONTHNAME12, "Dec")
LOCVAL(LOCALE_SABBREVMONTHNAME13, "")
LOCVAL(LOCALE_SPOSITIVESIGN, "")
LOCVAL(LOCALE_SNEGATIVESIGN, "-")
LOCVAL(LOCALE_IPOSSIGNPOSN, "3")
LOCVAL(LOCALE_INEGSIGNPOSN, "0")
LOCVAL(LOCALE_IPOSSYMPRECEDES, "1")
LOCVAL(LOCALE_IPOSSEPBYSPACE, "0")
LOCVAL(LOCALE_INEGSYMPRECEDES, "1")
LOCVAL(LOCALE_INEGSEPBYSPACE, "0")
	default: found=0;break;
	}
    break; /* LANG(0x0409) (U.S. English) */

    case 0x0809:
    	switch (LCType) {
LOCVAL(LOCALE_ILANGUAGE, "0809")
LOCVAL(LOCALE_SLANGUAGE, "English (United Kingdom)")
LOCVAL(LOCALE_SENGLANGUAGE, "English")
LOCVAL(LOCALE_SABBREVLANGNAME, "ENG")
LOCVAL(LOCALE_SNATIVELANGNAME, "English")
LOCVAL(LOCALE_ICOUNTRY, "44")
LOCVAL(LOCALE_SCOUNTRY, "United Kingdom")
LOCVAL(LOCALE_SENGCOUNTRY, "United Kingdom")
LOCVAL(LOCALE_SABBREVCTRYNAME, "GBR")
LOCVAL(LOCALE_SNATIVECTRYNAME, "United Kingdom")
LOCVAL(LOCALE_IDEFAULTLANGUAGE, "0809")
LOCVAL(LOCALE_IDEFAULTCOUNTRY, "44")
LOCVAL(LOCALE_IDEFAULTCODEPAGE, "850")
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE, "1252")
LOCVAL(LOCALE_SLIST, ",")
LOCVAL(LOCALE_IMEASURE, "0")
LOCVAL(LOCALE_SDECIMAL, ".")
LOCVAL(LOCALE_STHOUSAND, ",")
LOCVAL(LOCALE_SGROUPING, "3;0")
LOCVAL(LOCALE_IDIGITS, "2")
LOCVAL(LOCALE_ILZERO, "1")
LOCVAL(LOCALE_INEGNUMBER, "1")
LOCVAL(LOCALE_SNATIVEDIGITS, "0123456789")
LOCVAL(LOCALE_SCURRENCY, "")
LOCVAL(LOCALE_SINTLSYMBOL, "GBP")
LOCVAL(LOCALE_SMONDECIMALSEP, ".")
LOCVAL(LOCALE_SMONTHOUSANDSEP, ",")
LOCVAL(LOCALE_SMONGROUPING, "3;0")
LOCVAL(LOCALE_ICURRDIGITS, "2")
LOCVAL(LOCALE_IINTLCURRDIGITS, "2")
LOCVAL(LOCALE_ICURRENCY, "0")
LOCVAL(LOCALE_INEGCURR, "1")
LOCVAL(LOCALE_SDATE, "/")
LOCVAL(LOCALE_STIME, ":")
LOCVAL(LOCALE_SSHORTDATE, "dd/MM/yy")
LOCVAL(LOCALE_SLONGDATE, "dd MMMM yyyy")
LOCVAL(LOCALE_STIMEFORMAT, "HH:mm:ss")
LOCVAL(LOCALE_IDATE, "1")
LOCVAL(LOCALE_ILDATE, "1")
LOCVAL(LOCALE_ITIME, "1")
LOCVAL(LOCALE_ITIMEMARKPOSN, "0")
LOCVAL(LOCALE_ICENTURY, "0")
LOCVAL(LOCALE_ITLZERO, "1")
LOCVAL(LOCALE_IDAYLZERO, "1")
LOCVAL(LOCALE_IMONLZERO, "1")
LOCVAL(LOCALE_S1159, "")
LOCVAL(LOCALE_S2359, "")
LOCVAL(LOCALE_ICALENDARTYPE, "1")
LOCVAL(LOCALE_IOPTIONALCALENDAR, "0")
LOCVAL(LOCALE_IFIRSTDAYOFWEEK, "0")
LOCVAL(LOCALE_IFIRSTWEEKOFYEAR, "0")
LOCVAL(LOCALE_SDAYNAME1, "Monday")
LOCVAL(LOCALE_SDAYNAME2, "Tuesday")
LOCVAL(LOCALE_SDAYNAME3, "Wednesday")
LOCVAL(LOCALE_SDAYNAME4, "Thursday")
LOCVAL(LOCALE_SDAYNAME5, "Friday")
LOCVAL(LOCALE_SDAYNAME6, "Saturday")
LOCVAL(LOCALE_SDAYNAME7, "Sunday")
LOCVAL(LOCALE_SABBREVDAYNAME1, "Mon")
LOCVAL(LOCALE_SABBREVDAYNAME2, "Tue")
LOCVAL(LOCALE_SABBREVDAYNAME3, "Wed")
LOCVAL(LOCALE_SABBREVDAYNAME4, "Thu")
LOCVAL(LOCALE_SABBREVDAYNAME5, "Fri")
LOCVAL(LOCALE_SABBREVDAYNAME6, "Sat")
LOCVAL(LOCALE_SABBREVDAYNAME7, "Sun")
LOCVAL(LOCALE_SMONTHNAME1, "January")
LOCVAL(LOCALE_SMONTHNAME2, "February")
LOCVAL(LOCALE_SMONTHNAME3, "March")
LOCVAL(LOCALE_SMONTHNAME4, "April")
LOCVAL(LOCALE_SMONTHNAME5, "May")
LOCVAL(LOCALE_SMONTHNAME6, "June")
LOCVAL(LOCALE_SMONTHNAME7, "July")
LOCVAL(LOCALE_SMONTHNAME8, "August")
LOCVAL(LOCALE_SMONTHNAME9, "September")
LOCVAL(LOCALE_SMONTHNAME10, "October")
LOCVAL(LOCALE_SMONTHNAME11, "November")
LOCVAL(LOCALE_SMONTHNAME12, "December")
LOCVAL(LOCALE_SMONTHNAME13, "")
LOCVAL(LOCALE_SABBREVMONTHNAME1, "Jan")
LOCVAL(LOCALE_SABBREVMONTHNAME2, "Feb")
LOCVAL(LOCALE_SABBREVMONTHNAME3, "Mar")
LOCVAL(LOCALE_SABBREVMONTHNAME4, "Apr")
LOCVAL(LOCALE_SABBREVMONTHNAME5, "May")
LOCVAL(LOCALE_SABBREVMONTHNAME6, "Jun")
LOCVAL(LOCALE_SABBREVMONTHNAME7, "Jul")
LOCVAL(LOCALE_SABBREVMONTHNAME8, "Aug")
LOCVAL(LOCALE_SABBREVMONTHNAME9, "Sep")
LOCVAL(LOCALE_SABBREVMONTHNAME10, "Oct")
LOCVAL(LOCALE_SABBREVMONTHNAME11, "Nov")
LOCVAL(LOCALE_SABBREVMONTHNAME12, "Dec")
LOCVAL(LOCALE_SABBREVMONTHNAME13, "")
LOCVAL(LOCALE_SPOSITIVESIGN, "")
LOCVAL(LOCALE_SNEGATIVESIGN, "-")
LOCVAL(LOCALE_IPOSSIGNPOSN, "3")
LOCVAL(LOCALE_INEGSIGNPOSN, "3")
LOCVAL(LOCALE_IPOSSYMPRECEDES, "1")
LOCVAL(LOCALE_IPOSSEPBYSPACE, "0")
LOCVAL(LOCALE_INEGSYMPRECEDES, "1")
LOCVAL(LOCALE_INEGSEPBYSPACE, "0")
	default: found=0;break;
	}
    break; /* LANG(0x0809) (U.K. English) */

    case LANG_Ko: /* string using codepage 949 */
        switch (LCType) {
LOCVAL(LOCALE_ILANGUAGE,"18")
LOCVAL(LOCALE_SLANGUAGE,"\307\321\261\271\276\356")
LOCVAL(LOCALE_SENGLANGUAGE,"Korean")
LOCVAL(LOCALE_SABBREVLANGNAME,"KOR")
LOCVAL(LOCALE_SNATIVELANGNAME,"\307\321\261\271\276\356")
LOCVAL(LOCALE_ICOUNTRY,"82")
LOCVAL(LOCALE_SCOUNTRY,"\264\353\307\321\271\316\261\271")
LOCVAL(LOCALE_SENGCOUNTRY,"Korea (South)")
LOCVAL(LOCALE_SABBREVCTRYNAME,"KOR")
LOCVAL(LOCALE_SNATIVECTRYNAME,"\264\353\307\321\271\316\261\271")
LOCVAL(LOCALE_IDEFAULTLANGUAGE,"18")
LOCVAL(LOCALE_IDEFAULTCOUNTRY,"82")
LOCVAL(LOCALE_IDEFAULTCODEPAGE,"949")
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE,"949")
LOCVAL(LOCALE_SLIST,",")
LOCVAL(LOCALE_IMEASURE,"0")
LOCVAL(LOCALE_SDECIMAL,".")
LOCVAL(LOCALE_STHOUSAND,",")
LOCVAL(LOCALE_SGROUPING,"3;0")
LOCVAL(LOCALE_IDIGITS,"2")
LOCVAL(LOCALE_ILZERO,"0")
LOCVAL(LOCALE_INEGNUMBER,"1")
LOCVAL(LOCALE_SNATIVEDIGITS,"0123456789")
LOCVAL(LOCALE_SCURRENCY,"\\")
LOCVAL(LOCALE_SINTLSYMBOL,"Won")
LOCVAL(LOCALE_SMONDECIMALSEP,".")
LOCVAL(LOCALE_SMONTHOUSANDSEP,",")
LOCVAL(LOCALE_SMONGROUPING,"3;0")
LOCVAL(LOCALE_ICURRDIGITS,"2")
LOCVAL(LOCALE_IINTLCURRDIGITS,"2")
LOCVAL(LOCALE_ICURRENCY,"3")
LOCVAL(LOCALE_INEGCURR,"8")
LOCVAL(LOCALE_SDATE,"/")
LOCVAL(LOCALE_STIME,":")
LOCVAL(LOCALE_SSHORTDATE,"yyyy/MM/dd")
LOCVAL(LOCALE_SLONGDATE,"yyyy/MM/dd")
LOCVAL(LOCALE_STIMEFORMAT,"h:mm:ss tt")
LOCVAL(LOCALE_IDATE,"1")
LOCVAL(LOCALE_ILDATE,"1")
LOCVAL(LOCALE_ITIME,"1")
LOCVAL(LOCALE_ITIMEMARKPOSN,"0")
LOCVAL(LOCALE_ICENTURY,"0")
LOCVAL(LOCALE_ITLZERO,"0")
LOCVAL(LOCALE_IDAYLZERO,"0")
LOCVAL(LOCALE_IMONLZERO,"0")
LOCVAL(LOCALE_S1159,"\277\300\300\374")
LOCVAL(LOCALE_S2359,"\277\300\310\304")
LOCVAL(LOCALE_ICALENDARTYPE,"1")
/* Korean Tangun Era calendar */
LOCVAL(LOCALE_IOPTIONALCALENDAR,"5")
LOCVAL(LOCALE_IFIRSTDAYOFWEEK,"6")
LOCVAL(LOCALE_IFIRSTWEEKOFYEAR,"0")
LOCVAL(LOCALE_SDAYNAME1,"\277\371\277\344\300\317")
LOCVAL(LOCALE_SDAYNAME2,"\310\255\277\344\300\317")
LOCVAL(LOCALE_SDAYNAME3,"\274\366\277\344\300\317")
LOCVAL(LOCALE_SDAYNAME4,"\270\361\277\344\300\317")
LOCVAL(LOCALE_SDAYNAME5,"\261\335\277\344\300\317")
LOCVAL(LOCALE_SDAYNAME6,"\305\344\277\344\300\317")
LOCVAL(LOCALE_SDAYNAME7,"\300\317\277\344\300\317")
LOCVAL(LOCALE_SABBREVDAYNAME1,"\277\371")
LOCVAL(LOCALE_SABBREVDAYNAME2,"\310\255")
LOCVAL(LOCALE_SABBREVDAYNAME3,"\274\366")
LOCVAL(LOCALE_SABBREVDAYNAME4,"\270\361")
LOCVAL(LOCALE_SABBREVDAYNAME5,"\261\335")
LOCVAL(LOCALE_SABBREVDAYNAME6,"\305\344")
LOCVAL(LOCALE_SABBREVDAYNAME7,"\300\317")
LOCVAL(LOCALE_SMONTHNAME1,"1\277\371")
LOCVAL(LOCALE_SMONTHNAME2,"2\277\371")
LOCVAL(LOCALE_SMONTHNAME3,"3\277\371")
LOCVAL(LOCALE_SMONTHNAME4,"4\277\371")
LOCVAL(LOCALE_SMONTHNAME5,"5\277\371")
LOCVAL(LOCALE_SMONTHNAME6,"6\277\371")
LOCVAL(LOCALE_SMONTHNAME7,"7\277\371")
LOCVAL(LOCALE_SMONTHNAME8,"8\277\371")
LOCVAL(LOCALE_SMONTHNAME9,"9\277\371")
LOCVAL(LOCALE_SMONTHNAME10,"10\277\371")
LOCVAL(LOCALE_SMONTHNAME11,"11\277\371")
LOCVAL(LOCALE_SMONTHNAME12,"12\277\371")
LOCVAL(LOCALE_SMONTHNAME13,"")
LOCVAL(LOCALE_SABBREVMONTHNAME1,"1\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME2,"2\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME3,"3\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME4,"4\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME5,"5\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME6,"6\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME7,"7\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME8,"8\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME9,"9\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME10,"10\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME11,"11\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME12,"12\277\371")
LOCVAL(LOCALE_SABBREVMONTHNAME13,"")
LOCVAL(LOCALE_SPOSITIVESIGN,"")
LOCVAL(LOCALE_SNEGATIVESIGN,"-")
LOCVAL(LOCALE_IPOSSIGNPOSN,"3")
LOCVAL(LOCALE_INEGSIGNPOSN,"0")
LOCVAL(LOCALE_IPOSSYMPRECEDES,"3")
LOCVAL(LOCALE_IPOSSEPBYSPACE,"0")
LOCVAL(LOCALE_INEGSYMPRECEDES,"3")
LOCVAL(LOCALE_INEGSEPBYSPACE,"0")
        default: found=0;break;
        }
    break;  /* LANG(Ko) */

    case LANG_Hu:
    	switch (LCType) {
LOCVAL(LOCALE_ILANGUAGE,"9")
LOCVAL(LOCALE_SLANGUAGE,"Magyar")
LOCVAL(LOCALE_SENGLANGUAGE,"Hungarian")
LOCVAL(LOCALE_SABBREVLANGNAME,"hun")
LOCVAL(LOCALE_SNATIVELANGNAME,"Magyar")
LOCVAL(LOCALE_ICOUNTRY,"36")
LOCVAL(LOCALE_SCOUNTRY,"Magyarorszg")
LOCVAL(LOCALE_SENGCOUNTRY,"Hungary")
LOCVAL(LOCALE_SABBREVCTRYNAME,"Hu")
LOCVAL(LOCALE_SNATIVECTRYNAME,"Magyarorszg")
LOCVAL(LOCALE_IDEFAULTLANGUAGE,"9")
LOCVAL(LOCALE_IDEFAULTCOUNTRY,"36")
LOCVAL(LOCALE_IDEFAULTCODEPAGE,"852")
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE,"852")
LOCVAL(LOCALE_SLIST,";")
LOCVAL(LOCALE_IMEASURE,"0")
LOCVAL(LOCALE_SDECIMAL,".")
LOCVAL(LOCALE_STHOUSAND,",")
/*
LOCVAL(LOCALE_SGROUPING)
*/
LOCVAL(LOCALE_IDIGITS,"2")
LOCVAL(LOCALE_ILZERO,"1")
/*
LOCVAL(LOCALE_INEGNUMBER)
Is this "0123456789" ??
LOCVAL(LOCALE_SNATIVEDIGITS)
*/
LOCVAL(LOCALE_SCURRENCY,"Ft")
/*
LOCVAL(LOCALE_SINTLSYMBOL)
LOCVAL(LOCALE_SMONDECIMALSEP)
LOCVAL(LOCALE_SMONTHOUSANDSEP)
LOCVAL(LOCALE_SMONGROUPING)
*/
LOCVAL(LOCALE_ICURRDIGITS,"0")
/*
LOCVAL(LOCALE_IINTLCURRDIGITS)
*/
LOCVAL(LOCALE_ICURRENCY,"3")
LOCVAL(LOCALE_INEGCURR,"8")
LOCVAL(LOCALE_SDATE,"/")
LOCVAL(LOCALE_STIME,":")
LOCVAL(LOCALE_SSHORTDATE,"yyyy.MM.dd")
LOCVAL(LOCALE_SLONGDATE,"ddd, yyyy. MMMM d")
/*
LOCVAL(LOCALE_STIMEFORMAT)
*/
LOCVAL(LOCALE_IDATE,"1")
/*
LOCVAL(LOCALE_ILDATE)
*/
LOCVAL(LOCALE_ITIME,"1")
/*
LOCVAL(LOCALE_ITIMEMARKPOSN)
LOCVAL(LOCALE_ICENTURY)
*/
LOCVAL(LOCALE_ITLZERO,"1")
/*
LOCVAL(LOCALE_IDAYLZERO)
LOCVAL(LOCALE_IMONLZERO)
LOCVAL(LOCALE_S1159)
LOCVAL(LOCALE_S2359)
LOCVAL(LOCALE_ICALENDARTYPE)
LOCVAL(LOCALE_IOPTIONALCALENDAR)
LOCVAL(LOCALE_IFIRSTDAYOFWEEK)
LOCVAL(LOCALE_IFIRSTWEEKOFYEAR)
*/
LOCVAL(LOCALE_SDAYNAME1,"Htf")
LOCVAL(LOCALE_SDAYNAME2,"Kedd")
LOCVAL(LOCALE_SDAYNAME3,"Szerda")
LOCVAL(LOCALE_SDAYNAME4,"Cstrtk")
LOCVAL(LOCALE_SDAYNAME5,"Pntek")
LOCVAL(LOCALE_SDAYNAME6,"Szombat")
LOCVAL(LOCALE_SDAYNAME7,"Vasrnap")
LOCVAL(LOCALE_SABBREVDAYNAME1,"H")
LOCVAL(LOCALE_SABBREVDAYNAME2,"Ke")
LOCVAL(LOCALE_SABBREVDAYNAME3,"Se")
LOCVAL(LOCALE_SABBREVDAYNAME4,"Cs")
LOCVAL(LOCALE_SABBREVDAYNAME5,"P")
LOCVAL(LOCALE_SABBREVDAYNAME6,"So")
LOCVAL(LOCALE_SABBREVDAYNAME7,"Va")
LOCVAL(LOCALE_SMONTHNAME1,"Janur")
LOCVAL(LOCALE_SMONTHNAME2,"Februr")
LOCVAL(LOCALE_SMONTHNAME3,"Mrcius")
LOCVAL(LOCALE_SMONTHNAME4,"prilis")
LOCVAL(LOCALE_SMONTHNAME5,"Mjus")
LOCVAL(LOCALE_SMONTHNAME6,"Jnius")
LOCVAL(LOCALE_SMONTHNAME7,"Jlius")
LOCVAL(LOCALE_SMONTHNAME8,"Augusztus")
LOCVAL(LOCALE_SMONTHNAME9,"Szeptember")
LOCVAL(LOCALE_SMONTHNAME10,"Oktber")
LOCVAL(LOCALE_SMONTHNAME11,"November")
LOCVAL(LOCALE_SMONTHNAME12,"December")
LOCVAL(LOCALE_SMONTHNAME13,"")
LOCVAL(LOCALE_SABBREVMONTHNAME1,"Jan")
LOCVAL(LOCALE_SABBREVMONTHNAME2,"Feb")
LOCVAL(LOCALE_SABBREVMONTHNAME3,"Mr")
LOCVAL(LOCALE_SABBREVMONTHNAME4,"pr")
LOCVAL(LOCALE_SABBREVMONTHNAME5,"Mj")
LOCVAL(LOCALE_SABBREVMONTHNAME6,"Jn")
LOCVAL(LOCALE_SABBREVMONTHNAME7,"Jl")
LOCVAL(LOCALE_SABBREVMONTHNAME8,"Aug")
LOCVAL(LOCALE_SABBREVMONTHNAME9,"Sze")
LOCVAL(LOCALE_SABBREVMONTHNAME10,"Okt")
LOCVAL(LOCALE_SABBREVMONTHNAME11,"Nov")
LOCVAL(LOCALE_SABBREVMONTHNAME12,"Dec")
LOCVAL(LOCALE_SABBREVMONTHNAME13,"")
/*
LOCVAL(LOCALE_SPOSITIVESIGN)
LOCVAL(LOCALE_SNEGATIVESIGN)
LOCVAL(LOCALE_IPOSSIGNPOSN)
LOCVAL(LOCALE_INEGSIGNPOSN)
LOCVAL(LOCALE_IPOSSYMPRECEDES)
LOCVAL(LOCALE_IPOSSEPBYSPACE)
LOCVAL(LOCALE_INEGSYMPRECEDES)
LOCVAL(LOCALE_INEGSEPBYSPACE)
*/
	default: found=0;break;
	}
    break;  /* LANG(En) */

    case LANG_Pl:
    	switch (LCType) {
LOCVAL(LOCALE_ILANGUAGE,"9")
LOCVAL(LOCALE_SLANGUAGE,"Polski")
LOCVAL(LOCALE_SENGLANGUAGE,"Polish")
LOCVAL(LOCALE_SABBREVLANGNAME, "pol")
LOCVAL(LOCALE_SNATIVELANGNAME,"Polski")
LOCVAL(LOCALE_ICOUNTRY,"49")
LOCVAL(LOCALE_SCOUNTRY,"Polska")
LOCVAL(LOCALE_SENGCOUNTRY,"Poland")
LOCVAL(LOCALE_SABBREVCTRYNAME,"Pl")
LOCVAL(LOCALE_SNATIVECTRYNAME,"Polska")
LOCVAL(LOCALE_IDEFAULTLANGUAGE,"9")
LOCVAL(LOCALE_IDEFAULTCOUNTRY,"49")
LOCVAL(LOCALE_IDEFAULTCODEPAGE,"1252")
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE,"1252")
LOCVAL(LOCALE_SLIST,";")
LOCVAL(LOCALE_IMEASURE,"0")
LOCVAL(LOCALE_SDECIMAL,",")
LOCVAL(LOCALE_STHOUSAND," ")
/*
LOCVAL(LOCALE_SGROUPING)
*/
LOCVAL(LOCALE_IDIGITS,"2")
LOCVAL(LOCALE_ILZERO,"1")
/*
LOCVAL(LOCALE_INEGNUMBER)
Is this "0123456789" ??
LOCVAL(LOCALE_SNATIVEDIGITS)
*/
LOCVAL(LOCALE_SCURRENCY,"z\xB3")
/*
LOCVAL(LOCALE_SINTLSYMBOL)
LOCVAL(LOCALE_SMONDECIMALSEP)
LOCVAL(LOCALE_SMONTHOUSANDSEP)
LOCVAL(LOCALE_SMONGROUPING)
*/
LOCVAL(LOCALE_ICURRDIGITS,"2")
/*
LOCVAL(LOCALE_IINTLCURRDIGITS)
*/
LOCVAL(LOCALE_ICURRENCY,"3")
LOCVAL(LOCALE_INEGCURR,"8")
LOCVAL(LOCALE_SDATE,".")
LOCVAL(LOCALE_STIME,":")
LOCVAL(LOCALE_SSHORTDATE,"dd.MM.yyyy")
LOCVAL(LOCALE_SLONGDATE,"ddd, d. MMMM yyyy")
/*
LOCVAL(LOCALE_STIMEFORMAT)
*/
LOCVAL(LOCALE_IDATE,"1")
/*
LOCVAL(LOCALE_ILDATE)
*/
LOCVAL(LOCALE_ITIME,"1")
/*
LOCVAL(LOCALE_ITIMEMARKPOSN)
LOCVAL(LOCALE_ICENTURY)
*/
LOCVAL(LOCALE_ITLZERO,"1")
/*
LOCVAL(LOCALE_IDAYLZERO)
LOCVAL(LOCALE_IMONLZERO)
LOCVAL(LOCALE_S1159)
LOCVAL(LOCALE_S2359)
LOCVAL(LOCALE_ICALENDARTYPE)
LOCVAL(LOCALE_IOPTIONALCALENDAR)
LOCVAL(LOCALE_IFIRSTDAYOFWEEK)
LOCVAL(LOCALE_IFIRSTWEEKOFYEAR)
*/
LOCVAL(LOCALE_SDAYNAME1,"Poniedzia\263ek")
LOCVAL(LOCALE_SDAYNAME2,"Wtorek")
LOCVAL(LOCALE_SDAYNAME3,"Sroda")
LOCVAL(LOCALE_SDAYNAME4,"Czwartek")
LOCVAL(LOCALE_SDAYNAME5,"Pi\xB9tek")
LOCVAL(LOCALE_SDAYNAME6,"Sobota")
LOCVAL(LOCALE_SDAYNAME7,"Niedziela")
LOCVAL(LOCALE_SABBREVDAYNAME1,"Po")
LOCVAL(LOCALE_SABBREVDAYNAME2,"Wt")
LOCVAL(LOCALE_SABBREVDAYNAME3,"Sr")
LOCVAL(LOCALE_SABBREVDAYNAME4,"Cz")
LOCVAL(LOCALE_SABBREVDAYNAME5,"Pt")
LOCVAL(LOCALE_SABBREVDAYNAME6,"So")
LOCVAL(LOCALE_SABBREVDAYNAME7,"Ni")
LOCVAL(LOCALE_SMONTHNAME1,"Stycze\xF1")
LOCVAL(LOCALE_SMONTHNAME2,"Luty")
LOCVAL(LOCALE_SMONTHNAME3,"Marzec")
LOCVAL(LOCALE_SMONTHNAME4,"Kwiecie\xF1")
LOCVAL(LOCALE_SMONTHNAME5,"Maj")
LOCVAL(LOCALE_SMONTHNAME6,"Czerwiec")
LOCVAL(LOCALE_SMONTHNAME7,"Lipiec")
LOCVAL(LOCALE_SMONTHNAME8,"Sierpie\xF1")
LOCVAL(LOCALE_SMONTHNAME9,"Wrzesie\xF1")
LOCVAL(LOCALE_SMONTHNAME10,"Pa\237dziernik")
LOCVAL(LOCALE_SMONTHNAME11,"Listapad")
LOCVAL(LOCALE_SMONTHNAME12,"Grudzie\xF1")
LOCVAL(LOCALE_SMONTHNAME13,"")
LOCVAL(LOCALE_SABBREVMONTHNAME1,"Sty")
LOCVAL(LOCALE_SABBREVMONTHNAME2,"Lut")
LOCVAL(LOCALE_SABBREVMONTHNAME3,"Mar")
LOCVAL(LOCALE_SABBREVMONTHNAME4,"Kwi")
LOCVAL(LOCALE_SABBREVMONTHNAME5,"Maj")
LOCVAL(LOCALE_SABBREVMONTHNAME6,"Cze")
LOCVAL(LOCALE_SABBREVMONTHNAME7,"Lip")
LOCVAL(LOCALE_SABBREVMONTHNAME8,"Sie")
LOCVAL(LOCALE_SABBREVMONTHNAME9,"Wrz")
LOCVAL(LOCALE_SABBREVMONTHNAME10,"Pa\x9F")
LOCVAL(LOCALE_SABBREVMONTHNAME11,"Lis")
LOCVAL(LOCALE_SABBREVMONTHNAME12,"Gru")
LOCVAL(LOCALE_SABBREVMONTHNAME13,"")
/*
LOCVAL(LOCALE_SPOSITIVESIGN)
LOCVAL(LOCALE_SNEGATIVESIGN)
LOCVAL(LOCALE_IPOSSIGNPOSN)
LOCVAL(LOCALE_INEGSIGNPOSN)
LOCVAL(LOCALE_IPOSSYMPRECEDES)
LOCVAL(LOCALE_IPOSSEPBYSPACE)
LOCVAL(LOCALE_INEGSYMPRECEDES)
LOCVAL(LOCALE_INEGSEPBYSPACE)
*/
	default: found=0;break;
	}
    break;  /* LANG(Pl) */

    case LANG_Po:
    	switch (LCType) {
LOCVAL(LOCALE_ILANGUAGE, "0416")
LOCVAL(LOCALE_SLANGUAGE, "Portugu\352s (Brasil)")
LOCVAL(LOCALE_SENGLANGUAGE, "Protuguese")
LOCVAL(LOCALE_SABBREVLANGNAME, "POR")
LOCVAL(LOCALE_SNATIVELANGNAME, "Portugu\352s")
LOCVAL(LOCALE_ICOUNTRY, "1")
LOCVAL(LOCALE_SCOUNTRY, "Brasil")
LOCVAL(LOCALE_SENGCOUNTRY, "Brazil")
LOCVAL(LOCALE_SABBREVCTRYNAME, "BRA")
LOCVAL(LOCALE_SNATIVECTRYNAME, "Brasil")
LOCVAL(LOCALE_IDEFAULTLANGUAGE, "0409")
LOCVAL(LOCALE_IDEFAULTCOUNTRY, "1")
LOCVAL(LOCALE_IDEFAULTCODEPAGE, "437")
LOCVAL(LOCALE_IDEFAULTANSICODEPAGE, "1252")
LOCVAL(LOCALE_SLIST, ";")
LOCVAL(LOCALE_IMEASURE, "1")
LOCVAL(LOCALE_SDECIMAL, ",")
LOCVAL(LOCALE_STHOUSAND, ".")
LOCVAL(LOCALE_SGROUPING, "3;0")
LOCVAL(LOCALE_IDIGITS, "2")
LOCVAL(LOCALE_ILZERO, "1")
LOCVAL(LOCALE_INEGNUMBER, "1")
LOCVAL(LOCALE_SNATIVEDIGITS, "0123456789")
LOCVAL(LOCALE_SCURRENCY, "$")
LOCVAL(LOCALE_SINTLSYMBOL, "USD")
LOCVAL(LOCALE_SMONDECIMALSEP, ",")
LOCVAL(LOCALE_SMONTHOUSANDSEP, ".")
LOCVAL(LOCALE_SMONGROUPING, "3;0")
LOCVAL(LOCALE_ICURRDIGITS, "2")
LOCVAL(LOCALE_IINTLCURRDIGITS, "2")
LOCVAL(LOCALE_ICURRENCY, "0")
LOCVAL(LOCALE_INEGCURR, "0")
LOCVAL(LOCALE_SDATE, "/")
LOCVAL(LOCALE_STIME, ":")
LOCVAL(LOCALE_SSHORTDATE, "dd/MM/yy")
LOCVAL(LOCALE_SLONGDATE, "dddd, MMMM dd, yyyy")
LOCVAL(LOCALE_STIMEFORMAT, "h:mm:ss tt")
LOCVAL(LOCALE_IDATE, "0")
LOCVAL(LOCALE_ILDATE, "0")
LOCVAL(LOCALE_ITIME, "0")
LOCVAL(LOCALE_ITIMEMARKPOSN, "0")
LOCVAL(LOCALE_ICENTURY, "0")
LOCVAL(LOCALE_ITLZERO, "0")
LOCVAL(LOCALE_IDAYLZERO, "0")
LOCVAL(LOCALE_IMONLZERO, "0")
LOCVAL(LOCALE_S1159, "AM")
LOCVAL(LOCALE_S2359, "PM")
LOCVAL(LOCALE_ICALENDARTYPE, "1")
LOCVAL(LOCALE_IOPTIONALCALENDAR, "0")
LOCVAL(LOCALE_IFIRSTDAYOFWEEK, "6")
LOCVAL(LOCALE_IFIRSTWEEKOFYEAR, "0")
LOCVAL(LOCALE_SDAYNAME1, "Segunda")
LOCVAL(LOCALE_SDAYNAME2, "Ter\347a")
LOCVAL(LOCALE_SDAYNAME3, "Quarta")
LOCVAL(LOCALE_SDAYNAME4, "Quinta")
LOCVAL(LOCALE_SDAYNAME5, "Sexta")
LOCVAL(LOCALE_SDAYNAME6, "S\341bado")
LOCVAL(LOCALE_SDAYNAME7, "Domingo")
LOCVAL(LOCALE_SABBREVDAYNAME1, "Seg")
LOCVAL(LOCALE_SABBREVDAYNAME2, "Ter")
LOCVAL(LOCALE_SABBREVDAYNAME3, "Qua")
LOCVAL(LOCALE_SABBREVDAYNAME4, "Qui")
LOCVAL(LOCALE_SABBREVDAYNAME5, "Sex")
LOCVAL(LOCALE_SABBREVDAYNAME6, "S\341b")
LOCVAL(LOCALE_SABBREVDAYNAME7, "Dom")
LOCVAL(LOCALE_SMONTHNAME1, "Janeiro")
LOCVAL(LOCALE_SMONTHNAME2, "Fevereiro")
LOCVAL(LOCALE_SMONTHNAME3, "Mar\347o")
LOCVAL(LOCALE_SMONTHNAME4, "Abril")
LOCVAL(LOCALE_SMONTHNAME5, "Maio")
LOCVAL(LOCALE_SMONTHNAME6, "Junho")
LOCVAL(LOCALE_SMONTHNAME7, "Julho")
LOCVAL(LOCALE_SMONTHNAME8, "Agosto")
LOCVAL(LOCALE_SMONTHNAME9, "Setembro")
LOCVAL(LOCALE_SMONTHNAME10, "Outubro")
LOCVAL(LOCALE_SMONTHNAME11, "Novembro")
LOCVAL(LOCALE_SMONTHNAME12, "Dezembro")
LOCVAL(LOCALE_SMONTHNAME13, "")
LOCVAL(LOCALE_SABBREVMONTHNAME1, "Jan")
LOCVAL(LOCALE_SABBREVMONTHNAME2, "Fev")
LOCVAL(LOCALE_SABBREVMONTHNAME3, "Mar")
LOCVAL(LOCALE_SABBREVMONTHNAME4, "Abr")
LOCVAL(LOCALE_SABBREVMONTHNAME5, "Mai")
LOCVAL(LOCALE_SABBREVMONTHNAME6, "Jun")
LOCVAL(LOCALE_SABBREVMONTHNAME7, "Jul")
LOCVAL(LOCALE_SABBREVMONTHNAME8, "Ago")
LOCVAL(LOCALE_SABBREVMONTHNAME9, "Set")
LOCVAL(LOCALE_SABBREVMONTHNAME10, "Out")
LOCVAL(LOCALE_SABBREVMONTHNAME11, "Nov")
LOCVAL(LOCALE_SABBREVMONTHNAME12, "Dez")
LOCVAL(LOCALE_SABBREVMONTHNAME13, "")
LOCVAL(LOCALE_SPOSITIVESIGN, "")
LOCVAL(LOCALE_SNEGATIVESIGN, "-")
LOCVAL(LOCALE_IPOSSIGNPOSN, "3")
LOCVAL(LOCALE_INEGSIGNPOSN, "0")
LOCVAL(LOCALE_IPOSSYMPRECEDES, "1")
LOCVAL(LOCALE_IPOSSEPBYSPACE, "0")
LOCVAL(LOCALE_INEGSYMPRECEDES, "1")
LOCVAL(LOCALE_INEGSEPBYSPACE, "0")
	default: found=0;break;
	}
    break; /* LANG(Po) */


/*Insert other languages here*/

    default:
    	found=0;
	break;
    }  /* switch */

	if(!found) {
		fprintf(stderr,"'%s' not supported for your language.\n",
			retString);
		retString = "<WINE-NLS-unknown>";
		/*return 0;*/
	}
	if (buf)
		lstrcpyn32A(buf,retString,len);
	return strlen(retString)+1;
}

/***********************************************************************
 *         GetLocaleInfo32W             (KERNEL32.230)
 * Is the last parameter really WORD for Win16?
 */
INT32 WINAPI GetLocaleInfo32W(LCID lcid,LCTYPE LCType,LPWSTR wbuf,INT32 len)
{
	LPSTR abuf = (LPSTR)HeapAlloc(GetProcessHeap(),0,len);

	INT32 n = GetLocaleInfo32A(lcid, LCType, abuf, len);
	if (wbuf)
		lstrcpynAtoW(wbuf,abuf,len);
	HeapFree(GetProcessHeap(),0,abuf);
	return n;
}

/***********************************************************************
 *           CompareString16       (OLE2NLS.8)
 */
UINT16 WINAPI CompareString16(DWORD lcid,DWORD fdwStyle,
                              LPCSTR s1,DWORD l1,LPCSTR s2,DWORD l2)
{
	return (UINT16)CompareString32A(lcid,fdwStyle,s1,l1,s2,l2);
}

/***********************************************************************
 *           CompareString32A   (KERNEL32.29)
 * This implementation ignores the locale
 * FIXME
 */
UINT32 WINAPI CompareString32A(DWORD lcid, DWORD fdwStyle, 
                               LPCSTR s1, DWORD l1, LPCSTR s2,DWORD l2)
{
	int len,ret;
	if(fdwStyle & NORM_IGNORENONSPACE)
	{
		fprintf(stdnimp, "CompareStringA: IGNORENONSPACE not supprted\n");
	}
	if(fdwStyle & NORM_IGNORESYMBOLS)
		fprintf(stdnimp, "CompareStringA: IGNORESYMBOLS not supported\n");
	/* Is strcmp defaulting to string sort or to word sort?? */
	/* FIXME: Handle NORM_STRINGSORT */
	l1 = (l1==-1)?strlen(s1):l1;
	l2 = (l2==-1)?strlen(s2):l2;
	len = l1<l2 ? l1:l2;
	ret = (fdwStyle & NORM_IGNORECASE) ?
		lstrncmpi32A(s1,s2,len)	: lstrncmp32A(s1,s2,len);
	/* not equal, return 1 or 3 */
	if(ret!=0)return ret+2;
	/* same len, return 2 */
	if(l1==l2)return 2;
	/* the longer one is lexically greater */
	return (l1<l2)? 1 : 3;
}

/***********************************************************************
 *           CompareString32W       (KERNEL32.30)
 * This implementation ignores the locale
 * FIXME
 */
UINT32 WINAPI CompareString32W(DWORD lcid, DWORD fdwStyle, 
                               LPCWSTR s1, DWORD l1, LPCWSTR s2,DWORD l2)
{
	int len,ret;
	if(fdwStyle & NORM_IGNORENONSPACE)
		fprintf(stdnimp,"CompareStringW:IGNORENONSPACE not supprted\n");
	if(fdwStyle & NORM_IGNORESYMBOLS)
		fprintf(stdnimp,"CompareStringW:IGNORESYMBOLS not supported\n");

	/* Is strcmp defaulting to string sort or to word sort?? */
	/* FIXME: Handle NORM_STRINGSORT */
	l1 = (l1==-1)?lstrlen32W(s1):l1;
	l2 = (l2==-1)?lstrlen32W(s2):l2;
	len = l1<l2 ? l1:l2;
	ret = (fdwStyle & NORM_IGNORECASE) ?
		lstrncmpi32W(s1,s2,len)	: lstrncmp32W(s1,s2,len);
	/* not equal, return 1 or 3 */
	if(ret!=0) return ret+2;
	/* same len, return 2 */
	if(l1==l2) return 2;
	/* the longer one is lexically greater */
	return (l1<l2)? 1 : 3;
}

/***********************************************************************
 *           SetLocalInfoA       (KERNEL32.499)
 */
BOOL16 WINAPI SetLocaleInfoA(DWORD lcid, DWORD lctype, LPCSTR data)
{
    fprintf(stdnimp,"SetLocaleInfoA(%ld,%ld,%s)\n",lcid,lctype,data);
    return TRUE;
}

/***********************************************************************
 *           IsValidLocale       (KERNEL32.361)
 */
BOOL32 WINAPI IsValidLocale(LCID lcid,DWORD flags)
{
	/* we support ANY language. Well, at least say that...*/
	return TRUE;
}

/***********************************************************************
 *              EnumSystemLocales32W                (KERNEL32.93)
 */
BOOL32 WINAPI EnumSystemLocales32W( LOCALE_ENUMPROC32W lpfnLocaleEnum,
                                    DWORD flags )
{
	int	i;
	BOOL32	ret;
	WCHAR	buffer[200];
	HKEY	xhkey;

	dprintf_win32(stddeb,"EnumSystemLocales32W(%p,%08lx)\n",
                      lpfnLocaleEnum,flags );
	/* see if we can reuse the Win95 registry entries.... */
	if (ERROR_SUCCESS==RegOpenKey32A(HKEY_LOCAL_MACHINE,"\\System\\CurrentControlSet\\control\\Nls\\Locale\\",&xhkey)) {
		i=0;
		while (1) {
			if (ERROR_SUCCESS!=RegEnumKey32W(xhkey,i,buffer,sizeof(buffer)))
				break;
            		if (!lpfnLocaleEnum(buffer))
				break;
			i++;
		}
		RegCloseKey(xhkey);
		return TRUE;
	}

	i=0;
	while (languages[i].langname!=NULL)
        {
            LPWSTR cp;
	    char   xbuffer[10];
  	
	    sprintf(xbuffer,"%08lx",(DWORD)languages[i].langid);

	    cp = HEAP_strdupAtoW( GetProcessHeap(), 0, xbuffer );
            ret = lpfnLocaleEnum(cp);
            HeapFree( GetProcessHeap(), 0, cp );
            if (!ret) break;
            i++;
	}
	return TRUE;
}

/***********************************************************************
 *              EnumSystemLocales32A                (KERNEL32.92)
 */
BOOL32 WINAPI EnumSystemLocales32A(LOCALE_ENUMPROC32A lpfnLocaleEnum,
                                   DWORD flags)
{
	int	i;
	CHAR	buffer[200];
	HKEY	xhkey;

	dprintf_win32(stddeb,"EnumSystemLocales32A(%p,%08lx)\n",
		lpfnLocaleEnum,flags
	);
	if (ERROR_SUCCESS==RegOpenKey32A(HKEY_LOCAL_MACHINE,"\\System\\CurrentControlSet\\control\\Nls\\Locale\\",&xhkey)) {
		i=0;
		while (1) {
			if (ERROR_SUCCESS!=RegEnumKey32A(xhkey,i,buffer,sizeof(buffer)))
				break;
            		if (!lpfnLocaleEnum(buffer))
				break;
			i++;
		}
		RegCloseKey(xhkey);
		return TRUE;
	}
	i=0;
	while (languages[i].langname!=NULL) {
		sprintf(buffer,"%08lx",(DWORD)languages[i].langid);
		if (!lpfnLocaleEnum(buffer))
			break;
		i++;
	}
	return TRUE;
}

/***********************************************************************
 *              GetStringTypeA                (OLE2NLS.7)
 */
BOOL16 WINAPI GetStringType16(LCID locale,DWORD dwInfoType,LPCSTR src,
                              INT16 cchSrc,LPWORD chartype)
{
	return GetStringTypeEx32A(locale,dwInfoType,src,cchSrc,chartype);
}
/***********************************************************************
 *              GetStringTypeA                (KERNEL32.277)
 */
BOOL32 WINAPI GetStringType32A(LCID locale,DWORD dwInfoType,LPCSTR src,
                               INT32 cchSrc,LPWORD chartype)
{
	return GetStringTypeEx32A(locale,dwInfoType,src,cchSrc,chartype);
}
/***********************************************************************
 *              GetStringTypeExA                (KERNEL32.276)
 */
BOOL32 WINAPI GetStringTypeEx32A(LCID locale,DWORD dwInfoType,LPCSTR src,
                                 INT32 cchSrc,LPWORD chartype)
{
	int	i;

	switch (dwInfoType) {
	case CT_CTYPE2:
		fprintf(stderr,"GetStringType32A:CT_CTYPE2 not supported.\n");
		return FALSE;
	case CT_CTYPE3:
		fprintf(stderr,"GetStringType32A:CT_CTYPE3 not supported.\n");
		return FALSE;
	default:break;
	}
	if (cchSrc==-1)
		cchSrc=lstrlen32A(src);
	for (i=0;i<cchSrc;i++) {
		chartype[i] = 0;
		if (isdigit(src[i])) chartype[i]|=C1_DIGIT;
		if (isalpha(src[i])) chartype[i]|=C1_ALPHA;
		if (islower(src[i])) chartype[i]|=C1_LOWER;
		if (isupper(src[i])) chartype[i]|=C1_UPPER;
		if (isspace(src[i])) chartype[i]|=C1_SPACE;
		if (ispunct(src[i])) chartype[i]|=C1_PUNCT;
		if (iscntrl(src[i])) chartype[i]|=C1_CNTRL;
/* FIXME: isblank() is a GNU extension */
/*		if (isblank(src[i])) chartype[i]|=C1_BLANK; */
                if ((src[i] == ' ') || (src[i] == '\t')) chartype[i]|=C1_BLANK;
		/* C1_XDIGIT */
	}
	return TRUE;
}

/***********************************************************************
 *              GetStringTypeW                (KERNEL32.279)
 * Yes, this is missing LCID locale. MS fault.
 */
BOOL32 WINAPI GetStringType32W(DWORD dwInfoType,LPCWSTR src,INT32 cchSrc,
                               LPWORD chartype)
{
	return GetStringTypeEx32W(0/*defaultlocale*/,dwInfoType,src,cchSrc,chartype);
}

/***********************************************************************
 *              GetStringTypeW                (KERNEL32.278)
 * FIXME: unicode chars are assumed chars
 */
BOOL32 WINAPI GetStringTypeEx32W(LCID locale,DWORD dwInfoType,LPCWSTR src,
                                 INT32 cchSrc,LPWORD chartype)
{
	int	i;

	switch (dwInfoType) {
	case CT_CTYPE2:
		fprintf(stderr,"GetStringType32W:CT_CTYPE2 not supported.\n");
		return FALSE;
	case CT_CTYPE3:
		fprintf(stderr,"GetStringType32W:CT_CTYPE3 not supported.\n");
		return FALSE;
	default:break;
	}
	if (cchSrc==-1)
		cchSrc=lstrlen32W(src);
	for (i=0;i<cchSrc;i++) {
		chartype[i] = 0;
		if (isdigit(src[i])) chartype[i]|=C1_DIGIT;
		if (isalpha(src[i])) chartype[i]|=C1_ALPHA;
		if (islower(src[i])) chartype[i]|=C1_LOWER;
		if (isupper(src[i])) chartype[i]|=C1_UPPER;
		if (isspace(src[i])) chartype[i]|=C1_SPACE;
		if (ispunct(src[i])) chartype[i]|=C1_PUNCT;
		if (iscntrl(src[i])) chartype[i]|=C1_CNTRL;
/* FIXME: isblank() is a GNU extension */
/*		if (isblank(src[i])) chartype[i]|=C1_BLANK; */
                if ((src[i] == ' ') || (src[i] == '\t')) chartype[i]|=C1_BLANK;
		/* C1_XDIGIT */
	}
	return TRUE;
}

/* VerLanguageName				[VER.10] */
DWORD WINAPI VerLanguageName16(UINT16 langid,LPSTR langname,UINT16 langnamelen)
{
	int	i;
	char	*buf;

	dprintf_ver(stddeb,"VerLanguageName(%d,%p,%d)\n",langid,langname,langnamelen);
	/* First, check \System\CurrentControlSet\control\Nls\Locale\<langid>
	 * from the registry. 
	 */
	buf=(char*)malloc(strlen("\\System\\CurrentControlSet\\control\\Nls\\Locale\\")+9);
	sprintf(buf,"\\System\\CurrentControlSet\\control\\Nls\\Locale\\%08x",langid);
	if (ERROR_SUCCESS==RegQueryValue16(HKEY_LOCAL_MACHINE,buf,langname,(LPDWORD)&langnamelen)) {
		langname[langnamelen-1]='\0';
		return langnamelen;
	}
	/* if that fails, use the interal table */
	for (i=0;languages[i].langid!=0;i++)
		if (langid==languages[i].langid)
			break;
	strncpy(langname,languages[i].langname,langnamelen);
	langname[langnamelen-1]='\0';
	return strlen(languages[i].langname);
}

/* VerLanguageNameA				[VERSION.9] */
DWORD WINAPI VerLanguageName32A(UINT32 langid,LPSTR langname,
                                UINT32 langnamelen)
{
	return VerLanguageName16(langid,langname,langnamelen);
}

/* VerLanguageNameW				[VERSION.10] */
DWORD WINAPI VerLanguageName32W(UINT32 langid,LPWSTR langname,
                                UINT32 langnamelen)
{
	int	i;
	char	buffer[80];
	LPWSTR	keyname;

	/* First, check \System\CurrentControlSet\control\Nls\Locale\<langid>
	 * from the registry. 
	 */
	sprintf(buffer,"\\System\\CurrentControlSet\\control\\Nls\\Locale\\%08x",langid);
	keyname = HEAP_strdupAtoW( GetProcessHeap(), 0, buffer );
	if (ERROR_SUCCESS==RegQueryValue32W(HKEY_LOCAL_MACHINE,keyname,langname,(LPDWORD)&langnamelen)) {
		HeapFree( GetProcessHeap(), 0, keyname );
		return langnamelen;
	}
        HeapFree( GetProcessHeap(), 0, keyname );
	/* if that fails, use the interal table */
	for (i=0;languages[i].langid!=0;i++)
		if (langid==languages[i].langid)
			break;
        lstrcpyAtoW( langname, languages[i].langname );
	return strlen(languages[i].langname); /* same as strlenW(langname); */
}


INT32 WINAPI LCMapString32A(
	LCID lcid,DWORD mapflags,LPCSTR srcstr,INT32 srclen,LPSTR dststr,
	INT32 dstlen
) {
	int	i,len;

	dprintf_string(stderr,"LCMapStringA(0x%04lx,0x%08lx,%s,%d,%p,%d)\n",
		lcid,mapflags,srcstr,srclen,dststr,dstlen);
	if (!dstlen || !dststr) {
		dststr = (LPSTR)srcstr;
	}
	if (!srclen) srclen = strlen(srcstr);
	if (!dstlen) dstlen = strlen(dststr);
	len = dstlen;
	if (srclen < len)
		len = srclen;
	if (mapflags & LCMAP_LOWERCASE) {
		for (i=0;i<len;i++)
			dststr[i]=tolower(srcstr[i]);
		mapflags &= ~LCMAP_LOWERCASE;
	}
	if (mapflags & LCMAP_UPPERCASE) {
		for (i=0;i<len;i++)
			dststr[i]=toupper(srcstr[i]);
		mapflags &= ~LCMAP_UPPERCASE;
	}
	if (mapflags)
	  {
	    fprintf(stderr,
		    "LCMapStringA(0x%04lx,0x%08lx,%p,%d,%p,%d)\n",
		    lcid,mapflags,srcstr,srclen,dststr,dstlen);
		fprintf(stderr,"	unimplemented flags: 0x%08lx\n",mapflags);
	  }
	return len;
}

/* FIXME: implement everyhting & correct */

INT32 WINAPI LCMapString32W(
	LCID lcid,DWORD mapflags,LPCWSTR srcstr,INT32 srclen,LPWSTR dststr,
	INT32 dstlen
) {
	int	i,len;

	dprintf_string(stderr,"LCMapStringW(0x%04lx,0x%08lx,%p,%d,%p,%d)\n",
		lcid,mapflags,srcstr,srclen,dststr,dstlen
	);
	if (!dstlen || !dststr) {
		dststr = (LPWSTR)srcstr;
	}
	if (!srclen) srclen = lstrlen32W(srcstr);
	if (!dstlen) dstlen = lstrlen32W(dststr);
	len = dstlen;
	if (srclen < len)
		len = srclen;
	if (mapflags & LCMAP_LOWERCASE) {
		for (i=0;i<len;i++)
			dststr[i]=tolower(srcstr[i]);
		mapflags &= ~LCMAP_LOWERCASE;
	}
	if (mapflags & LCMAP_UPPERCASE) {
		for (i=0;i<len;i++)
			dststr[i]=toupper(srcstr[i]);
		mapflags &= ~LCMAP_UPPERCASE;
	}
	if (mapflags)
	  {
	    fprintf(stderr,
		    "LCMapStringW(0x%04lx,0x%08lx,%p,%d,%p,%d)\n",
		    lcid,mapflags,srcstr,srclen,dststr,dstlen);
		fprintf(stderr,"	unimplemented flags: 0x%08lx\n",mapflags);
	  }
	return len;
}


INT32 WINAPI GetDateFormat32A(LCID locale,DWORD flags,LPSYSTEMTIME xtime,
			      LPCSTR format, LPSTR date,INT32 datelen
) {
	fprintf(stderr,"GetDateFormat(0x%04lx,0x%08lx,%p,%s,%p,%d), stub\n",
		locale,flags,xtime,format,date,datelen
	);
	lstrcpyn32A(date,"1.4.1997",datelen);
	return strlen("1.4.1997");
}

INT32 WINAPI GetTimeFormat32A(LCID locale,DWORD flags,LPSYSTEMTIME xtime,
			      LPCSTR format, LPSTR timestr,INT32 timelen
) {
	fprintf(stderr,"GetDateFormat(0x%04lx,0x%08lx,%p,%s,%p,%d), stub\n",
		locale,flags,xtime,format,timestr,timelen
	);
	lstrcpyn32A(timestr,"00:00:42",timelen);
	return strlen("00:00:42");
}
