#
#  This Makefile is designed to work on the old "make" program.
#
#	@(#)Makefile.m4	8.12	(Berkeley)	5/13/98
#

# C compiler
CC=	confCC

# Shell
SHELL=	confSHELL

# use O=-O (usual) or O=-g (debugging)
O=	ifdef(`confOPTIMIZE', `confOPTIMIZE', `-O')

# location of sendmail source directory
SRCDIR=	ifdef(`confSRCDIR', `confSRCDIR', `../../src')

# environment definitions (e.g., -D_AIX3)
ENVDEF=	ifdef(`confENVDEF', `confENVDEF')

# see also conf.h for additional compilation flags

# include directories
INCDIRS=-I${SRCDIR} confINCDIRS

# loader options
LDOPTS=	ifdef(`confLDOPTS', `confLDOPTS')

# library directories
LIBDIRS=confLIBDIRS

# libraries required on your system
LIBS=	ifdef(`confLIBS', `confLIBS')

# location of rmail binary (usually /usr/sbin or /usr/etc)
BINDIR=	${DESTDIR}ifdef(`confUBINDIR', `confUBINDIR', `/usr/bin')

# additional .o files needed
OBJADD=	ifdef(`confOBJADD', `confOBJADD')

undivert(1)

###################  end of user configuration flags  ######################

BUILDBIN=confBUILDBIN
COPTS=	-I. ${INCDIRS} ${ENVDEF}
CFLAGS=	$O ${COPTS}

BEFORE= snprintf.c confBEFORE
OBJS=	rmail.o snprintf.o ${OBJADD}

ALL=	rmail rmail.0

all: ${ALL}

rmail: ${BEFORE} ${OBJS}
	${CC} -o rmail ${LDOPTS} ${OBJS} ${LIBDIRS} ${LIBS}

snprintf.c: ${SRCDIR}/snprintf.c
	-ln -s ${SRCDIR}/snprintf.c snprintf.c

undivert(3)

NROFF=	ifdef(`confNROFF', `confNROFF', `groff -Tascii')
MANDOC=	ifdef(`confMANDOC', `confMANDOC', `-mandoc')

rmail.0: rmail.8
	${NROFF} ${MANDOC} rmail.8 > rmail.0

INSTALL=ifdef(`confINSTALL', `confINSTALL', `install')
BINOWN=	ifdef(`confUBINOWN', `confUBINOWN', `bin')
BINGRP=	ifdef(`confUBINGRP', `confUBINGRP', `bin')
BINMODE=ifdef(`confUBINMODE', `confUBINMODE', `555')

MANOWN=	ifdef(`confMANOWN', `confMANOWN', `bin')
MANGRP=	ifdef(`confMANGRP', `confMANGRP', `bin')
MANMODE=ifdef(`confMANMODE', `confMANMODE', `444')

MANROOT=ifdef(`confMANROOT', `confMANROOT', `/usr/share/man/cat')
MAN8=	${MANROOT}ifdef(`confMAN8', `confMAN8', `8')
MAN8EXT=ifdef(`confMAN8EXT', `confMAN8EXT', `8')
MAN8SRC=ifdef(`confMAN8SRC', `confMAN8SRC', `0')

install: install-rmail install-docs

install-rmail: rmail
	${INSTALL} -c -o ${BINOWN} -g ${BINGRP} -m ${BINMODE} rmail ${BINDIR}

install-docs: rmail.0
ifdef(`confNO_MAN_INSTALL', `dnl',
`	${INSTALL} -c -o ${MANOWN} -g ${MANGRP} -m ${MANMODE} rmail.${MAN8SRC} ${MAN8}/rmail.${MAN8EXT}')

clean:
	rm -f ${OBJS} rmail rmail.0

################  Dependency scripts
include(confBUILDTOOLSDIR/M4/depend/ifdef(`confDEPEND_TYPE', `confDEPEND_TYPE',
`generic').m4)dnl
################  End of dependency scripts
