#if 0
drealmBBS - Bulletin Board System for Linux
Copyright (C) 1994, 1995, 1996  Inge Cubitt and Peter Jones

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The GNU General Public License should be in a file called COPYING.
#endif
/* */

/* ANSI headers */
#include <ctype.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
/* Non-ANSI headers */
/* This is only needed because of the stuff in drealm.h */
#include <unistd.h>

/* Local headers */
#include "drealm.h"
#include "drealmgen.h"
#include "mainfuncs.h"
#include "inputfuncs.h"
#include "configfuncs.h"
#include "setupfuncs.h"
#include "genfuncs.h"

char *Ustring[USTRINGCOUNT];
char *Mstring[MSTRINGCOUNT];
char Newareaflags[AFLAGMAX + 1];
char Newareamask[UFLAGMAX + 1];
char Newuserflags[UFLAGMAX + 1];
char Pvtmailmask[UFLAGMAX + 1];
char Pvtfilesmask[UFLAGMAX + 1];
char Extmailmask[UFLAGMAX + 1];


int uflagnames (void) {
/* CHECKED */
	int totalshift = 0;
	char result[MAINLINE];
	char temp[MAINLINE];
	FILE *FIL;
	char filename[MAINLINE + 100];
	int foundname = 0;
	int flagno = 11;

	strcpy(C.uflagnames[SILENT],"SILENT");
	strcpy(C.uflagnames[CHAIRMAN],"CHAIRMAN");
	strcpy(C.uflagnames[GAGGED],"GAGGED");
	strcpy(C.uflagnames[LIVE],"LIVE");
	strcpy(C.uflagnames[ABEND],"ABEND");
	strcpy(C.uflagnames[NODEGROUP],"NODEGROUP");
	strcpy(C.uflagnames[7],"RESERVED");
	strcpy(C.uflagnames[8],"RESERVED");
	strcpy(C.uflagnames[9],"RESERVED");
	strcpy(C.uflagnames[10],"RESERVED");

	sprintf(filename,"%s/config.uflags",C.configdir);
	if (FIL = fopen(filename,"r")) {
		for (flagno=11;flagno < (UFLAGMAX + 1);flagno++) {
			temp[0] = 0;
			foundname = 0;
			if (get_next_cfgfield (FIL,&totalshift,result, MAINLINE)) {
				sscanf(result, " %s ", temp);
				if (temp[0]) {
					foundname = 1;
				}
			}
			if (foundname) {
				strncpy(C.uflagnames[flagno],temp,10);
				C.uflagnames[flagno][10] = 0;
			} else {
				strcpy(C.uflagnames[flagno],"UNNAMED");
			}
		}
		fclose(FIL);
	} else {
		for (flagno=11;flagno < (UFLAGMAX + 1);flagno++) {
			strcpy(C.uflagnames[flagno],"UNNAMED");
		}
	}
	C.uflagnames[flagno][0] = 0;
	return 1;
}

int aflagnames (void) {
/* CHECKED */
	int totalshift = 0;
	char result[MAINLINE];
	char temp[MAINLINE];
	FILE *FIL;
	char filename[MAINLINE + 100];
	int flagno = 11;
	int foundname = 0;

	strcpy(C.aflagnames[AREATRUE],"AREATRUE");
	strcpy(C.aflagnames[SIGS],"SIGS");
	strcpy(C.aflagnames[ALIASES],"ALIASES");
	strcpy(C.aflagnames[READONLY],"READONLY");
	strcpy(C.aflagnames[PRIVATE],"PRIVATE");
	strcpy(C.aflagnames[MODERATED],"MODERATED");
	strcpy(C.aflagnames[7],"RESERVED");
	strcpy(C.aflagnames[8],"RESERVED");
	strcpy(C.aflagnames[9],"RESERVED");
	strcpy(C.aflagnames[10],"RESERVED");

	sprintf(filename,"%s/config.aflags",C.configdir);
	if (FIL = fopen(filename,"r")) {

		for (flagno=11;flagno < (AFLAGMAX + 1);flagno++) {
			temp[0] = 0;
			foundname = 0;
			if (get_next_cfgfield (FIL,&totalshift,result, MAINLINE)) {
				sscanf(result, " %s ", temp);
				if (temp[0]) {
					foundname = 1;
				}
			}
			if (foundname) {
				strncpy(C.aflagnames[flagno],temp,10);
				C.aflagnames[flagno][10] = 0;
			} else {
				strcpy(C.aflagnames[flagno],"UNNAMED");
			}
		}
		fclose(FIL);
	} else {
		for (flagno=11;flagno < (AFLAGMAX + 1);flagno++) {
			strcpy(C.aflagnames[flagno],"UNNAMED");
		}
	}
	C.aflagnames[flagno][0] = 0;
	return 1;
}

int cfgdrealm_read (void) {
/* CHECKED */
	FILE *CFG;
	int i;

	if (CFG = fopen(C.configfile,"r")) {
		i = cfgdrealm_parse(CFG);
		fclose(CFG);
		if (!i) {
			printf("Config file format error.\n");
			/*
			printf(Ustring[133],Ustring[231]);
			printf("\n");
			*/
		}
	} else {
		i = 0;
		printf("Cannot read config file\n");
		/*
		printf(Ustring[66],Ustring[231]);
		printf("\n");
		*/
	}
	return i;
}

int cfgdrealm_parse (FILE *CFG) {
/* LENGTHS CHECKED */
	char result[MAINLINE];
	int totalshift = 0;

/* bbs config */
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.bbsname=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.bbsshort=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.sysopname=strdup(result);

/* new user config */
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.admin) != 1) {
		run_err("Invalid value for C.admin");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.group) != 1) {
		run_err("Invalid value for C.group");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.public) != 1) {
		run_err("Invalid value for C.public");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.bbsshell=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.homedirs=strdup(result);

/* bbs directories */
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.users=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.privatefiles=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.maildirs=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.library=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.bin=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.configdir=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.maxfilename) != 1) {
		run_err("Invalid value for C.maxfilename");
		return 0;
	}
	if (C.maxfilename > 50) {
		C.maxfilename = 50;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.datadir=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.menus=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.areasdir=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.tmpdir=strdup(result);

/* path */
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.path=strdup(result);

/* area names */
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.startarea=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.newsarea=strdup(result);

/* new area flags */
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	strcpy(Newareaflags,result);
	C.newareaflags=(char *)malloc(AFLAGMAX + 2);
	C.newareaflags[0] = '#';
	strcpy(&C.newareaflags[1],result);
	C.newareaflags[AFLAGMAX + 1] = 0;

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.newarealevel) != 1) {
		run_err("Invalid value for C.newarealevel");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	strcpy(Newareamask,result);
	C.newareamask=(char *)malloc(UFLAGMAX + 2);
	C.newareamask[0] = '#';
	strcpy(&C.newareamask[1],result);
	C.newareamask[UFLAGMAX + 1] = 0;

/* new user flags */
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	strcpy(Newuserflags,result);
	C.newuserflags=(char *)malloc(UFLAGMAX + 2);
	C.newuserflags[0] = '#';
	strcpy(&C.newuserflags[1],result);
	C.newuserflags[UFLAGMAX + 1] = 0;

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.newuserlevel) != 1) {
		run_err("Invalid value for C.newuserlevel");
		return 0;
	}

/* external mail */
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if ((sscanf(result, " %d ", &C.mailmonitor) != 1) || ((C.mailmonitor != 0) && (C.mailmonitor != 1))) {
		run_err("Invalid value for C.mailmonitor");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.unixmailer=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.unixmaildir=strdup(result);

/* flags */
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if ((sscanf(result, " %d ", &C.autocreate) != 1) || ((C.autocreate != 0) && (C.autocreate != 1))) {
		run_err("Invalid value for C.autocreate");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if ((sscanf(result, " %d ", &C.sensitive) != 1) || ((C.sensitive != 0) && (C.sensitive != 1))) {
		run_err("Invalid value for C.sensitive");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if ((sscanf(result, " %d ", &C.commandstacking) != 1) || ((C.commandstacking != 0) && (C.commandstacking != 1))) {
		run_err("Invalid value for C.commandstacking");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if ((sscanf(result, " %d ", &C.quickreturn) != 1) || ((C.quickreturn != 0) && (C.quickreturn != 1))) {
		run_err("Invalid value for C.quickreturn");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if ((sscanf(result, " %d ", &C.uploadreport) != 1) || ((C.uploadreport != 0) && (C.uploadreport != 1))) {
		run_err("Invalid value for C.uploadreport");
		return 0;
	}

/* what to do with messages */
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.siglength) != 1) {
		run_err("Invalid value for C.siglength");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if ((sscanf(result, " %d ", &C.filesensitive) != 1) || ((C.filesensitive != 0) && (C.filesensitive != 1))) {
		run_err("Invalid value for C.filesensitive");
		return 0;
	}


	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.pvtmaillevel) != 1) {
		run_err("Invalid value for C.pvtmaillevel");
		return 0;
	}
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	strcpy(Pvtmailmask,result);
	C.pvtmailmask=(char *)malloc(UFLAGMAX + 2);
	C.pvtmailmask[0] = '#';
	strcpy(&C.pvtmailmask[1],result);
	C.pvtmailmask[UFLAGMAX + 1] = 0;


	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.pvtfileslevel) != 1) {
		run_err("Invalid value for C.pvtfileslevel");
		return 0;
	}
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	strcpy(Pvtfilesmask,result);
	C.pvtfilesmask=(char *)malloc(UFLAGMAX + 2);
	C.pvtfilesmask[0] = '#';
	strcpy(&C.pvtfilesmask[1],result);
	C.pvtfilesmask[UFLAGMAX + 1] = 0;


	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.extmaillevel) != 1) {
		run_err("Invalid value for C.extmaillevel");
		return 0;
	}
	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	strcpy(Extmailmask,result);
	C.extmailmask=(char *)malloc(UFLAGMAX + 2);
	C.extmailmask[0] = '#';
	strcpy(&C.extmailmask[1],result);
	C.extmailmask[UFLAGMAX + 1] = 0;


	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.sysoplevel) != 1) {
		run_err("Invalid value for C.sysoplevel");
		return 0;
	}


	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.displayname1=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.display1=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.displayname2=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.display2=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.displayname3=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.display3=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.editorname1=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.editor1=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.editorname2=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.editor2=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.editorname3=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.editor3=strdup(result);


	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.filter=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	numtostr(result);
	C.extras=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	tnt(result);
	C.awkname=strdup(result);

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.chatstyle) != 1) {
		run_err("Invalid value for C.chatstyle");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if ((sscanf(result, " %d ", &C.tp) != 1) || ((C.tp != 0) && (C.tp != 1))) {
		run_err("Invalid value for C.tp");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if ((sscanf(result, " %d ", &C.canchown) != 1) || ((C.canchown != 0) && (C.canchown != 1))) {
		run_err("Invalid value for C.canchown");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if ((sscanf(result, " %d ", &C.canlogin) != 1) || ((C.canlogin != 0) && (C.canlogin != 1))) {
		run_err("Invalid value for C.canlogin");
		return 0;
	}

	get_next_cfgfield (CFG,&totalshift,result,MAINLINE);
	if (sscanf(result, " %d ", &C.menucache) != 1) {
		run_err("Invalid value for C.menucache");
		return 0;
	}
	
	return 1;
}

int get_next_cfgfield (FILE *CFG, int *totalshift, char *result, size_t reslen) {
	unsigned int numread = 0;
	char temp[1024];

	/* get rid of the comments field */
	if (!(fseek(CFG,*totalshift,SEEK_SET))) {
		numread = fread(temp,1,1023,CFG);
		if (!numread) {
			errorlog("Unexpected end of CFG file");
			result[0] = 0;
			return 0;
		}
		temp[numread] = 0;
		*totalshift += strshift(temp,result,reslen,"::");
	} else {
		errorlog("Rare error reading CFG file (fseek failed)");
		result[0] = 0;
		return 0;
	}

	/* Find the real data */
	if (!(fseek(CFG,*totalshift,SEEK_SET))) {
		numread = fread(temp,1,1023,CFG);
		if (!numread) {
			errorlog("Unexpected end of CFG file");
			result[0] = 0;
			return 0;
		}
		temp[numread] = 0;
		*totalshift += strshift(temp,result,reslen,"::");
	} else {
		errorlog("Rare error reading CFG file (fseek failed)");
		result[0] = 0;
		return 0;
	}
	return 1;
}

