/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)talk.h	5.7 (Berkeley) 3/1/91
 *	$Id: talk.h,v 1.2 1993/08/01 18:07:57 mycroft Exp $
 */

#include <termios.h>
#include <curses.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <protocols/talkd.h>
#include <errno.h>
#include <syslog.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <paths.h>
#include <netinet/in.h>

extern	int sockt;
extern	int curses_initialized;
extern	int invitation_waiting;

extern	char *current_state;
extern	int current_line;

typedef struct xwin {
	WINDOW	*x_win;
	int	x_nlines;
	int	x_ncols;
	int	x_line;
	int	x_col;
	char	kill;
	char	cerase;
	char	werase;
} xwin_t;

extern	xwin_t my_win;
extern	xwin_t his_win;
extern	WINDOW *line_win;


/* Thomas Omerzu <omerzu@quantum.de>, 25.9.95 */

#ifdef OTALK
#define TALK_DAEM "to-otalkd"
#define TALK_PROG "otalk"
#define TALK_PROT "talk"
#define SWAPPED_AF_INET 0x0200	/* AF_INET Byteswapped */
#else
#define TALK_DAEM "to-ntalkd"
#define TALK_PROG "ntalk"
#define TALK_PROT "ntalk"
#endif


#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 256
#endif


/* ============ Function prototypes ============ */

/* ------------- talk ----------------- */

/* ctl.c */
void open_sockt(void);
void open_ctl(void);
void print_addr( struct sockaddr_in addr );

/* ctl_transact.c */
void ctl_transact(struct in_addr target, CTL_MSG msg,int type,CTL_RESPONSE *rp);

/* display.c */
void display( xwin_t *win, unsigned char *text, int size);

/* get_addrs.c */
void get_addrs( char *my_machine_name, char *his_machine_name);

/* get_names.c */
void get_names( int argc, char *argv[]);

/* init_disp.c */
void init_display(void);
void set_edit_chars(void);
void quit(void);

/* invite.c */
void invite_remote(void);
void send_delete(void);

/* io.c */
void talk(void);
void p_error(const char *string);
void message(const char *string);

/* look_up.c */
int check_local(void);

/* msgs.c */
void start_msgs(void);
void end_msgs(void);

/* talk.c */


/* ------------- talkd ----------------- */

/* announce.c */
int announce(CTL_MSG *request, const char *remote_machine, const char *uthost);

/* print.c */
void print_request( const char *cp, CTL_MSG *mp);
void print_response(const char *cp, CTL_RESPONSE *rp);

/* process.c */
void process_request( CTL_MSG *mp, CTL_RESPONSE *rp);

/* table.c */
CTL_MSG * find_match( CTL_MSG *request );
CTL_MSG * find_request( CTL_MSG *request );
void insert_table( CTL_MSG *request, CTL_RESPONSE *response);
int new_id(void);
int delete_invite(unsigned id_num);

/* talkd.c */

