#!/bin/bash

PATH=/usr/local/bin:/usr/bin:/bin:/usr/bin/X11
export PATH

# Sample ~/.talkd.sh script 
# for use with X-supporting talk daemons # e.g. to-talk-1.4
#
# Thomas Omerzu <omerzu@quantum.de> 21.5.97
# based on an idea by Dave Woodhouse <dwmw2@cam.ac.uk>
#
# Called with:
#		$1 = talk program (talk/ntalk)
#		$2 = name of requester
#		$3 = machine of requester
#		$4 = name of target
#		$5 = name of local user's tty (for tty fallback)

DATE=`/bin/date +'%H:%M'`
TALK=$1
FROM=$2
HOST=$3
TO=$4
TTY=$5

DISPLAY=":0.0"

# echo a beep to the users's tty
/bin/echo -n "\007" >$TTY


# alternatively, make a more distinctive sound
#	cat /usr/local/sounds/Oi_You.au >/dev/audio

# bring up an Xmessage asking whether to reply or not, and do so in an 
# xterm if asked

xmessage -display :0.0 -buttons No:3,Yes:2 \
	 -default Yes \
	 -title "Talk Request at $DATE" \
	 -nearmouse \
	 -file -  << ENDE
A $TALK request for $TO has arrived from:
 $FROM@$HOST
 Do you wish to respond now?
ENDE

case $? in
	2)  # Yes
	    xterm -display $DISPLAY \
		-fn 9x15bold \
		-title "$TALK $FROM@$HOST" \
		-e "$TALK" "$FROM@$HOST" &
	    exit 0
	    ;;
	3)  # No
	    exit 1
	    ;;
	*)  # Error: Probably xmessage failed due to lack of connect permission
	    /bin/echo "\007\r" >$TTY
	    /bin/echo "Message from Talk_Daemon at $DATE ...\r" >$TTY
	    /bin/echo "$TALK: warning: xmessage failed, fallback to tty announcement\r">$TTY
	    /bin/echo "$TALK: connection requested by $FROM@$HOST\r" >$TTY
	    /bin/echo "$TALK: respond with:  $TALK $FROM@$HOST\r" >$TTY
	    exit 0
	    
esac

