//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#include "swapmeter.h"
#include "xosview.h"
#include <fstream.h>


static const char MEMFILENAME[] = "/proc/meminfo";


SwapMeter::SwapMeter( XOSView *parent, int x, int y, int width, int height )
: FieldMeter( parent, x, y, width, height, 2, "SWAP", "USED/FREE" ){
  parent_->addResource( "swapUsedColor", NULL, "blue" );
  parent_->addResource( "swapFreeColor", NULL, "green2" );
  
  priority_ = 10;
}

SwapMeter::~SwapMeter( void ){
}

void SwapMeter::checkResources( void ){
  FieldMeter::checkResources();

  setfieldcolor( 0, parent_->getResource( "swapUsedColor" ) );
  setfieldcolor( 1, parent_->getResource( "swapFreeColor" ) );
}

void SwapMeter::checkevent( void ){
  getswapinfo();
  drawfields();
}

void SwapMeter::getswapinfo( void ){
  char buf[256];  
  ifstream meminfo( MEMFILENAME );

  if ( !meminfo ){
    cerr <<"Con not open file : " <<MEMFILENAME <<endl;
    exit( 1 );
  }

  meminfo.getline( buf, 256 );
  meminfo.getline( buf, 256 );  
  meminfo >>buf >>total_ >>fields_[0] >>fields_[1];

  if ( total_ == 0 ){
    total_ = 1;
    fields_[0] = 0;
    fields_[1] = 1;
  }

  used( (int)((100 * fields_[0]) / total_ ) );
}
