/* connection.h - Operations specific to FTP connection */

/****************************************************************************/

/* Command line processing (URL) */
void command_line_url(Main_CB *main_cb, char *url);

/* Allows user to quickly connect to a remote host */
void quick_connect(Widget w, XtPointer client_data, XtPointer call_data);

/* Reconnects to the host (used if connection becomes corrupt) */
void reconnect(Widget w, XtPointer client_data, XtPointer call_data);

/* Disconnect from the host */
void disconnect(Widget w, XtPointer client_data, XtPointer call_data);

/* Disconnects from the remote host and perform cleanup */
void do_kill_connection(Main_CB *main_cb);

/* Attempt login with login information.
 * returns 1 on success, 0 on failure
 */
int do_login(Main_CB *main_cb, char *hostname, char *login, char *password, 
	     char *directory, int port);

/****************************************************************************/




