#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "../common/common.h"
#include "misc.h"
#include "systems.h"



/* Checks to see what type of file 'query' is by lookup in the file opened
 * by listfp. Used to determine types of remote files on a unix host.
 * returns 0 if query is a regular file, 1 if query is a directory, and
 * 2 if query is a symlink.
 * size is modified to the size of the file (set to 0 if directory)
 */
int unix_is_directory_from_listfp(char *query, FILE *listfp, 
				  unsigned long int *size, time_t *mtime);

FileList *parse_unix_filelist(FILE *nlistfp, FILE *listfp, unsigned int
			      *num_files, int skip_hidden);

/****************************************************************************/

int system_can_resume(SystemType s_type)
{
  switch(s_type) {
  case UNIX:
  case WAR_FTPD:
  case FUNNY_AIX:
    return 1;
    break;
  case UNIX_LOOK: /* this could be anything :( */
    return 0;
    break;
  default:
    return 0;
    break;
  }
}

SystemType parse_system_type(char *response)
{
  if(strstr(response, "UNIX"))
    return UNIX;
  else
    if(strstr(response, "Windows_NT"))
      return WINDOWS_NT;
    else
      if(strstr(response, "WAR-FTPD"))
	return WAR_FTPD;
      else
	if(strstr(response, "UNKNOWN"))
	  return FUNNY_AIX;
	else
	  /* Something else */
	  return UNKNOWN;
}

int parse_working_directory(char *server_response, SiteInfo *site_info)
{
  char *begin, *end;
  
  switch(site_info->system_type) {
  case UNIX:
  case UNIX_LOOK:
  case WINDOWS_NT:
  case WAR_FTPD:
  case FUNNY_AIX:
    begin = strchr(server_response, '\"');
    begin++;
    
    /* - 25 should get us to the end of the dirname on normal wu-ftpd */
    if(!(end = strrchr(server_response, '\"')))
      return 0;
    /*
    end = &(server_response[strlen(server_response) - 25]);
    */
    *end = '\0';
    strcpy(site_info->directory, begin);
    return 1;
    break;
  default:
    /* no support for other system types as of yet */
    break;
  }
  return 0;
}


FileList *create_filelist_from_listfp_NA(FILE *nlistfp, FILE *listfp, 
					 unsigned int *num_files,
					 SystemType s_type,
					 int skip_hidden)
{  
  /* Currently only following systems supported */
  switch(s_type) {
  case UNIX:
  case UNIX_LOOK:
  case WINDOWS_NT:
  case WAR_FTPD:
  case FUNNY_AIX:
    return(parse_unix_filelist(nlistfp, listfp, num_files, skip_hidden));
    break;
  default:
    break;
  }
  return NULL;
}
/****************************************************************************/

FileList *parse_unix_filelist(FILE *nlistfp, FILE *listfp, unsigned int
			      *num_files, int skip_hidden)
{
  FileList *files;
  char *ch_ptr;
  unsigned long int size;
  char templine[LINE_MAX];
  int i = 0, directory, type;
  unsigned int numfiles = 0;
  time_t mtime;

  while(fgets(templine, sizeof(templine), nlistfp)) {
    if(skip_hidden && *templine == '.')
      continue;
    if(*templine == '\r' && !templine[1])
      continue;
    numfiles++;
  }
  numfiles += 2;  /* for . and .. */
  *num_files = numfiles;
  
  rewind(nlistfp);
  files = (FileList *) malloc(sizeof(FileList) * numfiles);
    
  if(!files) {
    puts("error mallocing filelist");
    exit(1);
  }

  /* Add the two dirs that are always present in a dir listing */
  add_filename(&files[i], "./", 1, 0, 0); i++;
  add_filename(&files[i], "../", 1, 0, 0); i++;

  while(fgets(templine, sizeof(templine), nlistfp)) {
    while((ch_ptr = strpbrk(templine, "\r\n")))
      *ch_ptr = '\0';

    if(skip_hidden && *templine == '.')
      continue;
    
    type = unix_is_directory_from_listfp(templine, listfp, &size, &mtime);
    directory = (type == 1);
    
    if(directory)
      strcat(templine, "/");
    add_filename(&files[i], templine, type, size, mtime);
    i++;
  }
  return files;
}

int unix_is_directory_from_listfp(char *query, FILE *listfp, 
				  unsigned long int *size, time_t *mtime)
{
  char templine[LINE_MAX];
  char *ch_ptr;
  int i;

  /* find in long listing */
  rewind(listfp);
  while(fgets(templine, sizeof(templine), listfp)) {
    while((ch_ptr = strpbrk(templine, "\n\r")))
      *ch_ptr = '\0';
    if(!strncmp(templine, "total", 5))
      continue;
    if(*templine == 'l' && (ch_ptr = strstr(templine, "->")))
      /* links */
      ch_ptr--;
    else
      ch_ptr = &templine[strlen(templine)];
    
    ch_ptr -= strlen(query);

    /* make sure it is exact match (well not really but good enough) */  
    if(*(ch_ptr-1) != ' ')
      continue;

    if(!strncmp(query, ch_ptr, strlen(query))) {
      /* found */
      ch_ptr--;
      for(i = 0; i < 4; i++) {
        while(*ch_ptr == ' ')
          ch_ptr--;
        while(*ch_ptr != ' ')
          ch_ptr--;
      }
      ch_ptr++;
      /* hopefully ch_ptr is at bytesize now */

      switch(*templine) {
      case 'd':
	*size = 0;
	break;
      case 'l':
	/* looks like its a link */
	*size = atol(ch_ptr);
	break;
      default:
	*size = atol(ch_ptr);
	break;
      }

      /* try time parsing */
      /* Get to beginning of time */
      while((*ch_ptr) && isdigit(*ch_ptr))
	ch_ptr++;
      ch_ptr++; /* past space */

      if(!(*ch_ptr))
	printf("error parsing time");
      else
	if(!convert_time(ch_ptr, mtime))
	  printf("error getting time");

      switch(*templine) {
      case 'd':
	return 1;
	break;
      case 'l':
	return 2;
	break;
      default:
	return 0;
	break;
      }
    }
  }
  return 0;
}                 
/****************************************************************************/


int convert_time(char *time_str, time_t *mtime)
{
  char work[30], *ch_ptr;
  /* month first */
  int number = 1;
  struct tm filetime;
  time_t junk;
  struct tm *cur_time;

  switch(*time_str) {
  case 'A':
    time_str++;
    switch(*time_str) {
    case 'p':
      /* april */
      filetime.tm_mon = 3;
      break;
    case 'u':
      /* august */
      filetime.tm_mon = 7;
      break;
    default:
      puts(time_str); return 0;
      break;
    }
    break;
  case 'D':
    /* december */
    filetime.tm_mon = 11;
    break;
  case 'F':
    /* feb */
    filetime.tm_mon = 1;
    break;
  case 'M':
    time_str++;
    switch(*time_str) {
    case 'a':
      time_str++;
      switch(*time_str) {
      case 'y':
	/* may */
	filetime.tm_mon = 4;
	break;
      case 'r':
	/* march */
	filetime.tm_mon = 2;
	break;
      default:
	puts(time_str); return 0;
	break;
      }
      break;
    default:
      puts(time_str); return 0;
      break;
    }
    break;
  case 'J':
    time_str++;
    switch(*time_str) {
    case 'a':
      /* jan */
      filetime.tm_mon = 0;
      break;
    case 'u':
      time_str++;
      switch(*time_str) {
      case 'l':
	/* july */
	filetime.tm_mon = 6;
	break;
      case 'n':
	/* june */
	filetime.tm_mon = 5;
	break;
      default:
	puts(time_str); return 0;
	break;
      }
      break;
    default:
      puts(time_str); return 0;
      break;
    }
    break;
  case 'N':
    /* nov */
    filetime.tm_mon = 10;
    break;
  case 'O':
    /* oct */
    filetime.tm_mon = 9;
    break;
  case 'S':
    /* sept */
    filetime.tm_mon = 8;
    break;
  default:
    puts(time_str); return 0;
    break;
  }

  /* now get day */

  while(isalpha(*time_str))
    time_str++;
  time_str++;

  if(!isspace(*time_str)) {
    number = (*time_str++ - '0') * 10;
    number += (*time_str++ - '0');
    filetime.tm_mday = number;
  }
  else {
    time_str++;
    number = (*time_str++ - '0');
    filetime.tm_mday = number;
  }

  /* now get time */
  
  while(isspace(*time_str))
    time_str++;

  strncpy(work, time_str, 5);
  work[5] = '\0';
  
  if(strchr(work, ':')) {
    /* its a time */
    ch_ptr = work;
    number = (*ch_ptr++ - '0') * 10;
    number += (*ch_ptr++ - '0');
    ch_ptr++; /* now past ':' */
    filetime.tm_hour = number;

    number = (*ch_ptr++ - '0') * 10;
    number += (*ch_ptr++ - '0');
    filetime.tm_min = number;

    /* it may be current year */
    junk = time(NULL);
    cur_time = localtime(&junk);

    filetime.tm_year = cur_time->tm_year;

    if(filetime.tm_mon > cur_time->tm_mon)
      /* it must be the year before ?? */
      filetime.tm_year--;

  }
  else {
    /* no time available */
    filetime.tm_hour = 0;
    filetime.tm_min = 0;
    
    /* year should be */
    ch_ptr = work;
    while(isspace(*ch_ptr))
      ch_ptr++;
    filetime.tm_year = atoi(ch_ptr) - 1900;
  }
  filetime.tm_sec = 0;
  filetime.tm_isdst = 0;
  /*
  printf("%d-%d-%d %2d:%2d\n", filetime.tm_mon + 1, filetime.tm_mday,
	 filetime.tm_year, filetime.tm_hour, filetime.tm_min);
	 */

  *mtime = mktime(&filetime);
  return 1;
}
