/* site_db.c - Site Manager database operations */

/***************************************************************************/

#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include "site_db.h"

/***************************************************************************/

typedef struct s_list {
  SiteInfo site;
  struct s_list *next;
} SiteInfoList;

SiteInfoList *list = NULL;

/***************************************************************************/

int SiteInfoList_traverse_list(SiteInfo *store_site, int reset)
{
  static SiteInfoList *where = NULL;
  
  if(reset) {
    where = list;
    return 1;
  }

  if(!where)
    return 0;
 
  /* Store record information */
  store_site->system_type = where->site.system_type;
  strcpy(store_site->login, where->site.login);
  strcpy(store_site->password, where->site.password);
  strcpy(store_site->hostname, where->site.hostname);
  strcpy(store_site->directory, where->site.directory);
  strcpy(store_site->comment, where->site.comment);
  strcpy(store_site->nickname, where->site.nickname);
  
  where = where->next;
  return 1;
}
/***************************************************************************/

int SiteInfoList_read_list(char *filename)
{
  FILE *fp;
  SiteInfo site;
  int i = 0;

  fp = fopen(filename, "r");
  if(!fp)
    return 0;
  SiteInfoList_destroy_list();

  while(fread(&site, sizeof(SiteInfo), 1, fp) == 1) {
    SiteInfoList_add_site(&site);
    i++;
  }
  if(!feof(fp))
    puts("not at end of file, sitelist file may be from older version");
  
  fclose(fp);
  return i;
}
/***************************************************************************/

void SiteInfoList_destroy_list(void)
{
  SiteInfoList *kill = NULL;

  while(list) {
    kill = list;
    list = list->next;
    free(kill);
  }
}
/***************************************************************************/

int SiteInfoList_add_site(SiteInfo *site)
{
  SiteInfoList *previous = NULL, *current = NULL, *next = NULL, *new = NULL;
  int retval;

  /* get to position where to insert */
  for(current = list; current; current = current->next) {
    retval = strcmp(site->nickname, current->site.nickname);
    if(retval == 0)
      /* already exists */
      return 0;
    if(retval < 0)
      break;
    previous = current;
  }
  
  new = (SiteInfoList *) calloc(1, sizeof(SiteInfoList));
  
  if(previous) {
    next = previous->next;
    previous->next = new;
    new->next = next;
  }
  else {
    next = list;
    new->next = next;
    list = new;
  }
  
  /* add the info */
  new->site.system_type = site->system_type;
  strcpy(new->site.login, site->login);
  strcpy(new->site.password, site->password);
  strcpy(new->site.hostname, site->hostname);
  strcpy(new->site.directory, site->directory);
  strcpy(new->site.comment, site->comment);
  strcpy(new->site.nickname, site->nickname);
  strcpy(new->site.port, site->port);
  return 1;
}
/***************************************************************************/

int SiteInfoList_find_site(char *nickname, SiteInfo *store_site)
{
  SiteInfoList *current;

  for(current = list; current; current = current->next) {
    if(!strcmp(nickname, current->site.nickname))
      break;
  }
  
  if(!current)
    return 0;
  
  store_site->system_type = current->site.system_type;
  strcpy(store_site->login, current->site.login);
  strcpy(store_site->password, current->site.password);
  strcpy(store_site->hostname, current->site.hostname);
  strcpy(store_site->directory, current->site.directory);
  strcpy(store_site->comment, current->site.comment);
  strcpy(store_site->nickname, current->site.nickname);
  strcpy(store_site->port, current->site.port);
  return 1;
}
/***************************************************************************/

int SiteInfoList_delete_site(char *nickname, char *full_site)
{
  SiteInfoList *current = NULL, *previous = NULL, *kill = NULL;

  for(current = list; current; current = current->next) {
    if(!nickname) {
      if(!strcmp(full_site, current->site.hostname))
	break;
    }
    else {
      if(!strcmp(nickname, current->site.nickname))
	break;
    }
    previous = current;
  }
  if(!current)
    /* not found */
    return 0;

  kill = current;
  if(previous)
    previous->next = current->next;
  else
    list = current->next;
  free(current);
  return 1;
}
/***************************************************************************/

int SiteInfoList_save_sites(char *filename)
{
  FILE *fp;
  SiteInfoList *current;

  fp = fopen(filename, "w");
  if(!fp) 
    return 0;

  for(current = list; current; current = current->next)
    fwrite(&(current->site), sizeof(SiteInfo), 1, fp);
    
  fclose(fp);
  return 1;
}
/***************************************************************************/
