#include "enlightenment.h"

void DoWindowButton(EWin *ewin, Window win, int btn, int mod, int wbtn) {
   int i,j;
   
   /* if it wasnt a left, middle or right mouse button... ignore it */
   if ((btn<1)||(btn>3)) return;
   /* if the subwindow clicked is a decoration subwindow.. ignore the click */
   if (cfg.subwin_type[wbtn]==0) return;
   /* flag the button as clicked ... */
   ewin->subwin_state[wbtn]=CLICKED;
   /* redraw the button */
   DrawButton(ewin,wbtn);
   /* set the event mode windowbutton pressed to this one */
   evmd.wbtn=wbtn;
   switch(cfg.subwin_action[wbtn][btn-1][mod].id) {
	case ACTION_MOVE:
		Do_RaiseWin(ewin);
		Do_MoveWin(ewin, win);
		return;
	case ACTION_RESIZE:
		Do_RaiseWin(ewin);
		Do_ResizeWin(ewin, win);
		return;
	case ACTION_ICONIFY:
		Do_IconifyWin(ewin);	
		break;
	case ACTION_KILL:
		Do_KillWin(ewin,0);
		break;
	case ACTION_RAISE:
		Do_RaiseWin(ewin);
		break;
	case ACTION_LOWER:
		Do_LowerWin(ewin);
		break;
	case ACTION_RAISE_LOWER:
		Do_RaiseLowerWin(ewin);
		break;
	case ACTION_MAX_HEIGHT:
		Do_RaiseWin(ewin);
		Do_MaxHeightWin(ewin);
		break;
	case ACTION_MAX_WIDTH:
		Do_RaiseWin(ewin);
		Do_MaxWidthWin(ewin);
		break;
	case ACTION_MAX_SIZE:
		Do_RaiseWin(ewin);
		Do_MaxSizeWin(ewin);
		break;
	case ACTION_CONFIGURE:
		Do_Configure();
		break;
	case ACTION_MENU:
		Do_MenuWin(ewin);
		break;
	case ACTION_EXEC:
		Do_Exec(cfg.subwin_action[wbtn][btn-1][mod].params);
		break;
	case ACTION_KILL_NASTY:
		Do_KillWin(ewin,1);
		break;
	case ACTION_STICKY:
		ewin->desk = (ewin->desk<0) ? desk.current : -1;
		break;
	case ACTION_DRAG:
                evmd.ewin=ewin;
                evmd.wbtn=wbtn;
                evmd.mode=MODE_NORMAL;
                DrawButton(ewin,wbtn);
                StartIconDrag(ewin);
		break;
        default:
		break;
   }
   evmd.ewin=ewin;
   evmd.wbtn=wbtn;
   evmd.mode=MODE_NORMAL;
   return;
}

void DoBaseMenu(Menu *m, int x, int y)
{
   int px,py;
   
   if (m) 
     {
	px=x-m->popup_x;
	py=y-m->popup_y;
	if (px<0) px=0;
	if (py<0) py=0;
	if (px+m->width>DisplayWidth(disp,screen)) 
	  px=DisplayWidth(disp,screen)-m->width-1;
	if (py+m->height>DisplayHeight(disp,screen)) 
	  py=DisplayHeight(disp,screen)-m->height-1;
	/* save the location in the menu structure */
	m->px = px;
	m->py = py;
	XMoveWindow(disp,m->win,m->px,m->py);
	ShowMenu(m);
	AddActiveMenuToList(m);
     }
}

void DoRootMenu(int btn, int mod, int x, int y)
{
   Menu *m;
   char s[256];
   
   sprintf(s,"root%i",btn);
   strcpy(evmd.mname,s);
   m=FindMenu(s);
   DoBaseMenu(m,x,y);
}

void Do_MoveWin(EWin *ewin, Window win)
{
   XEvent ev;
   int x,y;
   int sx,sy,d;
   Window w1,w2;
   
   if(evmd.mode!=MODE_NORMAL)
     return;
   evmd.ewin=ewin;
   if (cfg.move_mode==2)
     {
	evmd.mode=MODE_MOVE;
	Draw_Cursor(ewin, ewin->frame_x, ewin->frame_y, '+', 1);
	XGrabPointer(disp, win, True, ButtonMotionMask|PointerMotionMask|ButtonReleaseMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
	return;
     }
   else
     MoveLoop(ewin, win);
}

void Do_ResizeWin(EWin *ewin, Window win)
{
   XEvent ev;
   int x,y;
   int sx,sy,d;
   Window w1,w2;
   int wx,wy;
   int mode;
   int x1,y1,x2,y2;
   
/*   XQueryPointer(disp,root,&w1,&w2,&sx,&sy,&x,&y,&d);*/
/*   evmd.px=sx;*/
/*   evmd.py=sy;*/
   if(evmd.mode!=MODE_NORMAL) return;
   x1=ewin->frame_x;
   y1=ewin->frame_y;
   x2=ewin->client_width;
   y2=ewin->client_height;
   wx=evmd.px-x1;
   wy=evmd.py-y1;
   if ((wx<ewin->frame_width/2)&&(wy<ewin->frame_height/2)) mode=0;
   if ((wx>=ewin->frame_width/2)&&(wy<ewin->frame_height/2)) mode=1;
   if ((wx<ewin->frame_width/2)&&(wy>=ewin->frame_height/2)) mode=2;
   if ((wx>=ewin->frame_width/2)&&(wy>=ewin->frame_height/2)) mode=3;
   evmd.x1=x1;
   evmd.x2=x2;
   evmd.y1=y1;
   evmd.y2=y2;
   evmd.resize_mode=mode;
   evmd.ewin=ewin;
   if (cfg.resize_mode==2)
     {
	evmd.mode=MODE_RESIZE;
	Draw_Cursor(ewin, (ewin->client_width-ewin->base_width)/ewin->sizeinc_x, (ewin->client_height-ewin->base_height)/ewin->sizeinc_y, 'x', 1);
	XGrabPointer(disp, win, True, ButtonMotionMask|PointerMotionMask|ButtonReleaseMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
	return;
     }
   else
     ResizeLoop(ewin, win);
}

void Do_IconifyWin(EWin *ewin)
{
   struct itimerval tv1,tv2;
   struct sigaction sa;
   
   /* concurrency issues! wait for previous iconify requests to */
   /* be completeed by checking every 10th of a second to see if they */
   /* finished yet */
   if ((timer_mode < TIMER_ICONIFY)&&(timer_mode!=TIMER_INFOBOX)) {
      for (getitimer(ITIMER_REAL, &tv1);
	   tv1.it_value.tv_sec != 0 || tv1.it_value.tv_usec != 0
	   || tv1.it_interval.tv_sec != 0
	   || tv1.it_interval.tv_usec != 0;
	   getitimer(ITIMER_REAL, &tv1));
   }
/*   while (newicon.ewin) usleep(100000);
 *  if ((timer_mode < TIMER_ICONIFY)&&(timer_mode!=TIMER_INFOBOX)) {
 *     for (getitimer(ITIMER_REAL, &tv1); 
 *	   tv1.it_value.tv_sec != 0 || tv1.it_value.tv_usec != 0;
 *	   getitimer(ITIMER_REAL, &tv1)) usleep(100000);
 *  }
 */
   timer_mode = TIMER_ICONIFY;
   tv1.it_value.tv_sec=(unsigned long)(icfg.snapshot_time*1000 / 1000000);
   tv1.it_value.tv_usec=(long)(icfg.snapshot_time*1000 % 1000000);
   tv2.it_value.tv_sec=(unsigned long)(icfg.snapshot_time*1000 / 1000000);
   tv2.it_value.tv_usec=(long)(icfg.snapshot_time*1000 % 1000000);
   tv1.it_interval.tv_sec=0;
   tv1.it_interval.tv_usec=0;
   tv2.it_interval.tv_sec=0;
   tv2.it_interval.tv_usec=0;
   newicon.ewin=ewin;
   newicon.win=ewin->client_win;
   XRaiseWindow(disp,ewin->frame_win);
   setitimer(ITIMER_REAL,&tv1,&tv2);
   sa.sa_handler = Finish_Iconify;
   sa.sa_flags = 0;
   sigemptyset (&sa.sa_mask);
   sigaction(SIGALRM, &sa, (struct sigaction *)0);
}

void Do_KillWin(EWin *ewin, int nasty_kill)
{
   XClientMessageEvent xev;
   Atom atm[2];
   Window dummyw;
   int dummy;
   int wmdel;
   int num;
   Atom *prot;
   Atom dummya;
   int i;
   unsigned long dummyl,numl;
   
   prot=NULL;
   wmdel=0;
   if (!(ewin->state&ICONIFIED))
     {
	newicon.kill=nasty_kill+1;
	Do_IconifyWin(ewin);
	return;
     }
   atm[0]=XInternAtom(disp,"WM_DELETE_WINDOW",False);
   atm[1]=XInternAtom(disp,"WM_PROTOCOLS",False);
   /* work out if client wants to have the wm ask it to quit */
   if (!XGetWMProtocols (disp,ewin->client_win,&prot, &num))
     {
	/* have to work it out the hard way.. nasty client */
	XGetWindowProperty(disp,ewin->client_win, atm[1],0,10,False,atm[1],
			   &dummya,&dummy,&numl,&dummyl,
			   (unsigned char **)&prot);
	num=(int)numl;
     }
   /* check if it has a "delet me" flag set */
   if (prot)
     {
	for (i=0;i<num;i++)
	  {
	     if (prot[i]==atm[0]) wmdel=1;
	  }
     }
   if (prot) XFree(prot);
   if (wmdel)
     {
	/* delete */
	xev.type=ClientMessage;
	xev.window=ewin->client_win;
	xev.message_type=atm[1];
	xev.format=32;
	xev.data.l[0]=atm[0];
	xev.data.l[1]=CurrentTime;
	XSendEvent(disp,ewin->client_win,False,0,(XEvent *)&xev);
     }
   else
     {
	/* kill */
	XKillClient(disp,(XID)ewin->client_win);
     }
   if (nasty_kill)
     {
	/* kill */
	XKillClient(disp,(XID)ewin->client_win);
     }
   XSync(disp,False);
}

void Do_RaiseWin(EWin *ewin)
{
   Window *wl;
   int nc,nb;
   int i,j;
   struct blist *bptr;
   struct list *ptr;
   
   if(ewin->state&ICONIFIED) DeIconify(ewin);
   if((ewin->desk>=0) && (ewin->desk != desk.current)) ChangeToDesk(ewin->desk);
   if (ewin->top) return;
   ToFront(ewin);
   j=0;
   nc=global_l->num;
   nb=0;
   bptr=bl.first;
   while (bptr)
     {
	nb++;
	bptr=bptr->next;
     }
   wl=malloc(sizeof(Window)*(nc+nb+3+(MAX_DESKS*2)));
   bptr=bl.first;
   while (bptr)
     {
	if (bptr->bwin->above) wl[j++]=bptr->bwin->win;
	bptr=bptr->next;
     }
   if (icfg.level)
     {
	wl[j++]=icfg.left_win;
	wl[j++]=icfg.right_win;
	wl[j++]=icfg.bg_win;
     }
   for (i=0;i<MAX_DESKS;i++)
     {
	if (desk.di[i].above)
	  {
	     if (desk.di[i].win) wl[j++]=desk.di[i].win;
	     if (desk.di[i].root_win) wl[j++]=desk.di[i].root_win;
	  }
     }
   ptr=global_l->first;
   while (ptr)
     {
	wl[j++]=ptr->win->frame_win;
	ptr=ptr->next;
     }
   bptr=bl.first;
   while (bptr)
     {
	if (!bptr->bwin->above) wl[j++]=bptr->bwin->win;
	bptr=bptr->next;
     }
   if (!icfg.level)
     {
	wl[j++]=icfg.left_win;
	wl[j++]=icfg.right_win;
	wl[j++]=icfg.bg_win;
     }
   for (i=0;i<MAX_DESKS;i++)
     {
	if (!desk.di[i].above)
	  {
	     if (desk.di[i].win) wl[j++]=desk.di[i].win;
	     if (desk.di[i].root_win) wl[j++]=desk.di[i].root_win;
	  }
     }
   XRestackWindows(disp,wl,j);
   free(wl);
}

void Do_LowerWin(EWin *ewin)
{
   Window *wl;
   int nc,nb;
   int i,j;
   struct blist *bptr;
   struct list *ptr;
   
   ToBack(ewin);
   j=0;
   nc=global_l->num;
   nb=0;
   bptr=bl.first;
   while (bptr)
     {
	nb++;
	bptr=bptr->next;
     }
   wl=malloc(sizeof(Window)*(nc+nb+3+(MAX_DESKS*2)));
   bptr=bl.first;
   while (bptr)
     {
	if (bptr->bwin->above) wl[j++]=bptr->bwin->win;
	bptr=bptr->next;
     }
   if (icfg.level)
     {
	wl[j++]=icfg.left_win;
	wl[j++]=icfg.right_win;
	wl[j++]=icfg.bg_win;
     }
   for (i=0;i<MAX_DESKS;i++)
     {
	if (!desk.di[i].above)
	  {
	     if (desk.di[i].win) wl[j++]=desk.di[i].win;
	     if (desk.di[i].root_win) wl[j++]=desk.di[i].root_win;
	  }
     }
   ptr=global_l->first;
   while (ptr)
     {
	wl[j++]=ptr->win->frame_win;
	ptr=ptr->next;
     }
   bptr=bl.first;
   while (bptr)
     {
	if (!bptr->bwin->above) wl[j++]=bptr->bwin->win;
	bptr=bptr->next;
     }
   if (!icfg.level)
     {
	wl[j++]=icfg.left_win;
	wl[j++]=icfg.right_win;
	wl[j++]=icfg.bg_win;
     }
   for (i=0;i<MAX_DESKS;i++)
     {
	if (!desk.di[i].above)
	  {
	     if (desk.di[i].win) wl[j++]=desk.di[i].win;
	     if (desk.di[i].root_win) wl[j++]=desk.di[i].root_win;
	  }
     }
   XRestackWindows(disp,wl,j);
   free(wl);
}

void Do_RaiseLowerWin(EWin *ewin)
{
   if (ewin->top) Do_LowerWin(ewin);
   else Do_RaiseWin(ewin);
}

void Do_MaxHeightWin(EWin *ewin)
{
   int h;
   int y;
   
   if (ewin->lastop==OP_MAXHEIGHT)
     {
	h=ewin->prev_client_height;
	y=ewin->prev_frame_y;
	ewin->prev_client_height=ewin->client_height;
	ewin->prev_client_width=ewin->client_width;
	ewin->prev_frame_x=ewin->frame_x;
	ewin->prev_frame_y=ewin->frame_y;
     }
   else
     {
	ewin->prev_client_height=ewin->client_height;
	ewin->prev_client_width=ewin->client_width;
	ewin->prev_frame_x=ewin->frame_x;
	ewin->prev_frame_y=ewin->frame_y;
	h=DisplayHeight(disp,screen);
	h-=ewin->border_t;
	h-=ewin->border_b;
	while (((h-ewin->base_height)%ewin->sizeinc_y)>0) h--;
	while (((h-ewin->base_height)%ewin->sizeinc_y)<0) h++;
	y=0;
     }
   ModifyEWin(ewin,ewin->frame_x,y,ewin->client_width,h);
   ewin->lastop=OP_MAXHEIGHT;
}

void Do_MaxWidthWin(EWin *ewin)
{
   int w;
   int x;
   
   if (ewin->lastop==OP_MAXWIDTH)
     {
	w=ewin->prev_client_width;
	x=ewin->prev_frame_x;
	ewin->prev_client_height=ewin->client_height;
	ewin->prev_client_width=ewin->client_width;
	ewin->prev_frame_x=ewin->frame_x;
	ewin->prev_frame_y=ewin->frame_y;
     }
   else
     {
	ewin->prev_client_height=ewin->client_height;
	ewin->prev_client_width=ewin->client_width;
	ewin->prev_frame_x=ewin->frame_x;
	ewin->prev_frame_y=ewin->frame_y;
	w=DisplayWidth(disp,screen);
	w-=ewin->border_l;
	w-=ewin->border_r;
	while (((w-ewin->base_width)%ewin->sizeinc_x)>0) w--;
	while (((w-ewin->base_width)%ewin->sizeinc_x)<0) w++;
	x=0;
     }
   ModifyEWin(ewin,x,ewin->frame_y,w,ewin->client_height);
   ewin->lastop=OP_MAXWIDTH;
}

void Do_MaxSizeWin(EWin *ewin)
{
   int h;
   int y;
   int w;
   int x;
   
   if (ewin->lastop==OP_MAXSIZE)
     {
	h=ewin->prev_client_height;
	y=ewin->prev_frame_y;
	w=ewin->prev_client_width;
	x=ewin->prev_frame_x;
	ewin->prev_client_height=ewin->client_height;
	ewin->prev_client_width=ewin->client_width;
	ewin->prev_frame_x=ewin->frame_x;
	ewin->prev_frame_y=ewin->frame_y;
     }
   else
     {
	ewin->prev_client_height=ewin->client_height;
	ewin->prev_client_width=ewin->client_width;
	ewin->prev_frame_x=ewin->frame_x;
	ewin->prev_frame_y=ewin->frame_y;
	h=DisplayHeight(disp,screen);
	h-=ewin->border_t;
	h-=ewin->border_b;
	while (((h-ewin->base_height)%ewin->sizeinc_y)>0) h--;
	while (((h-ewin->base_height)%ewin->sizeinc_y)<0) h++;
	y=0;
	w=DisplayWidth(disp,screen);
	w-=ewin->border_l;
	w-=ewin->border_r;
	while (((w-ewin->base_width)%ewin->sizeinc_x)>0) w--;
	while (((w-ewin->base_width)%ewin->sizeinc_x)<0) w++;
	x=0;
     }
   ModifyEWin(ewin,x,y,w,h);
   ewin->lastop=OP_MAXSIZE;
}

void Do_Configure()
{
}

void Do_MenuWin(EWin *ewin)
{
}

void Do_Exec(char *line)
{
   char *args[2048];
   int i,j,k;
   char arg[1024];
   int inquote=0;
   int q1,q2;
   
   if (fork()) return;
   setsid();
   if (execl("/bin/sh","/bin/sh","-c",line,NULL)==-1) exit(100);
   exit(0);
}

void Do_Exit()
{
   char s[1024];
   
   if ((Theme_Path[0])&&(!nodel))
     {
	sprintf(s,"rm -rf %s",Theme_Path);
	system(s); 
     }
   XSetInputFocus(disp, PointerRoot, RevertToPointerRoot, CurrentTime);
   XSelectInput(disp, root, 0);
   MapClients(global_l);
   exit(0);
}

void Do_Restart()
{
   char s[2048];
   
   if ((Theme_Path[0])&&(!nodel))
     {
	sprintf(s,"rm -rf %s",Theme_Path);
	system(s); 
     }
   UnmapClients(0);
   XCloseDisplay(disp);
   sleep(1);
   if (Theme_Name[0]!=0)
     {
	sprintf(s,"%s -theme %s",argv1,Theme_Name);
	execl("/bin/sh","/bin/sh","-c",s,NULL);
     }
   else
     execl("/bin/sh","/bin/sh","-c",argv1,NULL);
   exit(100);
}

void Do_ChangeMouseFocus(char *newfocus) {

	if(!newfocus) {
		switch(cfg.focus_policy) {
			case PointerFocus:
				cfg.focus_policy = SloppyFocus;
				return;
			case SloppyFocus:
				cfg.focus_policy = ClickToFocus;
				return;
			case ClickToFocus:
				cfg.focus_policy = PointerFocus;
				return;
		}
	} else {
		if(!strcmp(newfocus,"click")) {
			cfg.focus_policy = ClickToFocus;
			return;
		} else if(!strcmp(newfocus,"sloppy")) {
			cfg.focus_policy = SloppyFocus;
			return;
		} else if(!strcmp(newfocus,"mouse")) {
			cfg.focus_policy = PointerFocus;
			return;
		}
	}
}

void Do_Restart_Theme(char *file)
{
   char s[1024];
   if ((Theme_Path[0])&&(!nodel))
     {
	sprintf(s,"rm -rf %s",Theme_Path);
	system(s); 
     }
   sprintf(s,"%s -theme %s",argv1,file);
   UnmapClients(0);
   XCloseDisplay(disp);
   sleep(1);
   execl("/bin/sh","/bin/sh","-c",s,NULL);
   exit(100);
}

void Do_MenuAction (char *PassedMenu, Window win) {

	/* created 07/20/97 by Mandrake (mandrake@mandrake.net) */

   	XWindowAttributes xwa;
	Menu *m;

       	evmd.mode=MODE_MENU;
	tmp_menu=NULL;
	m=FindMenu(PassedMenu);
	if (m) {
     		XGetWindowAttributes(disp,win,&xwa);
     		DoBaseMenu(m,xwa.x+(xwa.width/2),xwa.y+(xwa.height/2));
  	}

}

void DoButton(BWin *bwin, int btn, int mod) {
   
   /* if it wasnt a left, middle or right mouse button... ignore it */
   if ((btn<1)||(btn>3)) return;
   ButtonDraw(bwin);
   switch(bwin->action[btn-1][mod].id) {
	case ACTION_MENU: 
		Do_MenuAction(bwin->action[btn-1][mod].params,bwin->win);
		break;
	case ACTION_EXEC:
		Do_Exec(bwin->action[btn-1][mod].params);
		break;
	case ACTION_EXIT:
		Do_Exit();
		break;
	case ACTION_RESTART:
		Do_Restart();
		break;
	case ACTION_RESTART_THEME:
		Do_Restart_Theme(bwin->action[btn-1][mod].params);
		break;
	case ACTION_BACKGROUND:
		Do_Background(bwin->action[btn-1][mod].params);
		break;
	case ACTION_DESKTOP:
		Do_DesktopSwitch(bwin->action[btn-1][mod].params);
		break;
	case ACTION_MOUSEFOCUS:
		Do_ChangeMouseFocus(bwin->action[btn-1][mod].params);
		break;
	default:
		btmd.bwin=bwin;
		break;
   }
   return;
}

void Do_DesktopSwitch(char *desktop) {

	/* Added 07/20/97 by mandrake (mandrake@mandrake.net) */
	int n1;

	sscanf(desktop,"%i",&n1);
	ChangeToDesk(n1);

}


void Do_Background(char *background) {

	/* Added 07/20/97 by mandrake (mandrake@mandrake.net) */

	int n1,n2;
	char s[1024];

	sscanf(background,"%i %i %s",&n1,&n2,s);
	strcpy(desk.background[desk.current],s);
	if (desk.bg_pmap[desk.current])
  		XFreePixmap(disp,desk.bg_pmap[desk.current]);
	desk.bg_pmap[desk.current]=0;
	desk.bg_width[desk.current]=n1;
	desk.bg_height[desk.current]=n2;
	SetRoot();

}

void RunContents(int action_id, char *params) {
   /* Mandrake was here too.. And Raster */

   switch(action_id) {
    case ACTION_MOUSEFOCUS:
      Do_ChangeMouseFocus(params);
      break;
    case ACTION_EXEC:
      if (params) Do_Exec(params); 
      break;
    case ACTION_EXIT:
      Do_Exit();
      break;
    case ACTION_RESTART:
      Do_Restart();
      break;
    case ACTION_RESTART_THEME:
      if (params) Do_Restart_Theme(params);
      break;
    case ACTION_BACKGROUND: 
      if (params) Do_Background(params);
      break;
    case ACTION_DESKTOP:
      if (params) Do_DesktopSwitch(params);
      break;
    case ACTION_RAISE: 
      if (params) Do_RaiseFromMenu(params);
      break;
    case ACTION_CYCLE_NEXT: 
      CycleToNextWindow();
      break;
    case ACTION_CYCLE_PREV: 
      CycleToPreviousWindow();
      break;
    case ACTION_NEXT_DESK:
      NextDesk();
      break;
    case ACTION_PREV_DESK:
      PrevDesk();
      break;
     
   }
   return;
}

void DoMenu(Menu *m, int num) {

   if (!m) return;
   switch(m->items[num]->action.id) {
	case ACTION_EXEC:
		Do_Exec(m->items[num]->action.params); 
		break;
	case ACTION_EXIT:
		Do_Exit();
		break;
	case ACTION_RESTART:
		Do_Restart();
		break;
	case ACTION_RESTART_THEME:
		Do_Restart_Theme(m->items[num]->action.params);
		break;
	case ACTION_BACKGROUND: 
		Do_Background(m->items[num]->action.params);
		break;
	case ACTION_DESKTOP:
		Do_DesktopSwitch(m->items[num]->action.params);
		break;
	case ACTION_RAISE: 
		Do_RaiseFromMenu(m->items[num]->action.params);
		break;
	case ACTION_MOUSEFOCUS:
		Do_ChangeMouseFocus(m->items[num]->action.params);
		break;
   }
   return;
}

void Do_RaiseFromMenu(char *itemtoraise) {
	
   /* 07/24/97 modified to use window id by Troy Pesola (trp@cyberoptics.com)*/
   /* created 07/21/97 by mandrake (mandrake@mandrake.net) */
   /* code initially by Troy Pesola (trp@cyberoptics.net) */
   
   struct list *l;
   EWin *ewin;
   int x,y,i;
   XWindowAttributes xatt;
   Window wid;

   /* check if the param is a number */
   if (sscanf(itemtoraise,"%lu",&wid)==1) {
       /* get the EWin from the id */
       ewin = ListGetWinID(global_l, wid);
   }
   else ewin=NULL;

   if (!ewin) {
       /* search for a title if we still don't know which window */
       for (l=global_l->first; l; l=l->next) {
	   if (!strcmp(l->win->title,itemtoraise)) {
	       break;
	   }
       }
       ewin = (l)?l->win:NULL;
   }
   
   /* raise the window and warp the cursor */
   if (ewin) {
      for (i=0;i<cfg.num_subwins;i++)
	{
	   if (cfg.subwin_type[i]==2)
	     {
		XGetWindowAttributes(disp,ewin->subwins[i],&xatt);
		x=ewin->frame_x+xatt.x+(xatt.width/2);
		y=ewin->frame_y+xatt.y+(xatt.height/2);
		i=64;
	     }
	}
      XWarpPointer(disp,None,root,0,0,1,1,x,y);
      FocWin(ewin->client_win,1);
      Do_RaiseWin(ewin);
      evmd.ewin=ewin;
      evmd.wbtn=-1;
      evmd.mode=MODE_NORMAL;
   }
}

void CycleToNextWindow()
{
   struct list *l;
   EWin *ewin1;
   EWin *ewin2;
   int i,x,y;
   XWindowAttributes xatt;
   
   l=global_l->first;
   if (!l) return;
   if (!l->next) return;
   ewin1=l->win;
   ewin2=l->next->win;
   ToBack(ewin1);
   for (i=0;i<cfg.num_subwins;i++)
     {
	if (cfg.subwin_type[i]==2)
	  {
	     XGetWindowAttributes(disp,ewin2->subwins[i],&xatt);
	     x=ewin2->frame_x+xatt.x+(xatt.width/2);
	     y=ewin2->frame_y+xatt.y+(xatt.height/2);
	     i=64;
	  }
     }
   XWarpPointer(disp,None,root,0,0,1,1,x,y);
   FocWin(ewin2->client_win,1);
   Do_RaiseWin(ewin2);
}

void CycleToPreviousWindow()
{
   struct list *l;
   EWin *ewin2;
   int i,x,y;
   XWindowAttributes xatt;
   
   l=global_l->first;
   if (!l) return;
   if (!l->next) return;
   ewin2=global_l->last->win;
   for (i=0;i<cfg.num_subwins;i++)
     {
	if (cfg.subwin_type[i]==2)
	  {
	     XGetWindowAttributes(disp,ewin2->subwins[i],&xatt);
	     x=ewin2->frame_x+xatt.x+(xatt.width/2);
	     y=ewin2->frame_y+xatt.y+(xatt.height/2);
	     i=64;
	  }
     }
   XWarpPointer(disp,None,root,0,0,1,1,x,y);
   FocWin(ewin2->client_win,1);
   Do_RaiseWin(ewin2);
}

void DoIcon(Icon *icon, int btn, int mod) {
   int i,j;
   
   /* if it wasnt a left, middle or right mouse button... ignore it */
   if ((btn<1)||(btn>3)) return;
   switch(icfg.action[btn-1][mod].id) {
	case ACTION_ICONIFY:
		Do_RaiseWin(icon->ewin);
		break;
	case ACTION_KILL:
		Do_KillWin(icon->ewin,0);
		break;
	case ACTION_CONFIGURE:
		Do_Configure();
		break;
	case ACTION_MENU:
		Do_MenuWin(icon->ewin);
		break;
	case ACTION_EXEC:
		Do_Exec(icfg.action[btn-1][mod].params);
		break;
	case ACTION_KILL_NASTY:
		Do_KillWin(icon->ewin,1);
		break;
	case ACTION_DRAG:
                Do_RaiseWin(icon->ewin);
                StartIconDrag(icon->ewin);
		break;
   }
   return;
}

void ResizeLoop(EWin *ewin, Window win)
{
   GC gc;
   XGCValues gcv;
   XEvent xev;     
   int first;
   int sx,sy;
   Window w1,w2;
   int x,y,xx,yy;
   int d;
   int wx,wy;
   Window dummyw;
   int dummy;
   int col;
   
   if (depth>8) col=WhitePixel(disp,screen);
   else col=1;
   first=0;
   XGrabServer(disp);
   XGrabPointer(disp, win, True, ButtonMotionMask|PointerMotionMask|ButtonReleaseMask|ButtonPressMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
   gc=XCreateGC(disp,root,0,&gcv);
   XSetSubwindowMode(disp,gc,IncludeInferiors);
   XSetForeground(disp,gc,col);
   XSetFunction(disp,gc,GXxor);

   Draw_Cursor(ewin,(evmd.ewin->client_width-evmd.ewin->base_width)/evmd.ewin->sizeinc_x,(evmd.ewin->client_height-evmd.ewin->base_height)/evmd.ewin->sizeinc_y, 'x', 1);
   while (1)
     {
	XMaskEvent(disp,ButtonMotionMask|PointerMotionMask|ButtonReleaseMask,&xev);
        XQueryPointer(disp,root,&w1,&w2,&sx,&sy,&xx,&yy,&d);
	if (xev.type==ButtonRelease)
	  {
	     if (first)
	       {
		  XPutBackEvent(disp,&xev);
		  if (cfg.resize_mode==0)
		    {
		       XDrawRectangle(disp,root,gc,evmd.x1,evmd.y1,
				      evmd.x2+ewin->border_l+ewin->border_r,
				      evmd.y2+ewin->border_t+ewin->border_b);
		       XDrawRectangle(disp,root,gc,evmd.x1+ewin->border_l,
				      evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
		    }
		  else if (cfg.resize_mode==1) 
		    {
		       XFillRectangle(disp,root,gc,evmd.x1,evmd.y1,
				      evmd.x2+ewin->border_l+ewin->border_r,
				      evmd.y2+ewin->border_t+ewin->border_b);
		       XFillRectangle(disp,root,gc,evmd.x1+ewin->border_l,
				      evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
		    }
		  break;
	       }
	     else
	       {
		  XPutBackEvent(disp,&xev);
		  break;
	       }
	  }
	if (first)
	  {
	     if (cfg.resize_mode==0)
	       {
		  XDrawRectangle(disp,root,gc,evmd.x1,evmd.y1,
				 evmd.x2+ewin->border_l+ewin->border_r,
				 evmd.y2+ewin->border_t+ewin->border_b);
		  XDrawRectangle(disp,root,gc,evmd.x1+ewin->border_l,
				 evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
	       }
	     else if (cfg.resize_mode==1) 
	       {
		  XFillRectangle(disp,root,gc,evmd.x1,evmd.y1,
				 evmd.x2+ewin->border_l+ewin->border_r,
				 evmd.y2+ewin->border_t+ewin->border_b);
		  XFillRectangle(disp,root,gc,evmd.x1+ewin->border_l,
				 evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
	       }
	  }
	wx=sx-evmd.px;
	while ((wx%evmd.ewin->sizeinc_x)>0) wx--;
	while ((wx%evmd.ewin->sizeinc_x)<0) wx++;
	wy=sy-evmd.py;
	while ((wy%evmd.ewin->sizeinc_y)>0) wy--;
	while ((wy%evmd.ewin->sizeinc_y)<0) wy++;
	if ((wx!=0)||(wy!=0)) {
		switch(evmd.resize_mode) {
			case 0:
		  		if ((wx>0)&&(evmd.x2<wx)) wx=0;
		  		if ((wy>0)&&(evmd.y2<wy)) wy=0;
		  		evmd.x1+=wx;evmd.y1+=wy;
		  		evmd.x2-=wx;evmd.y2-=wy;
				break;
			case 1:
		  		if ((wx<0)&&(evmd.x2<-wx)) wx=0;
		  		if ((wy>0)&&(evmd.y2<wy)) wy=0;
		  		evmd.y1+=wy;
		  		evmd.x2+=wx;evmd.y2-=wy;
				break;
			case 2:
		  		if ((wx>0)&&(evmd.x2<wx)) wx=0;
		  		if ((wy<0)&&(evmd.y2<-wy)) wy=0;
		  		evmd.x1+=wx;
		  		evmd.x2-=wx;evmd.y2+=wy;
				break;
			case 3:
		  		if ((wx<0)&&(evmd.x2<-wx)) wx=0;
		  		if ((wy<0)&&(evmd.y2<-wy)) wy=0;
		  		evmd.x2+=wx;evmd.y2+=wy;
				break;
	     }
	     if (evmd.x2>evmd.ewin->max_width) evmd.x2=evmd.ewin->max_width;
	     if (evmd.x2<evmd.ewin->min_width) evmd.x2=evmd.ewin->min_width;
	     if (evmd.y2>evmd.ewin->max_height) evmd.y2=evmd.ewin->max_height;
	     if (evmd.y2<evmd.ewin->min_height) evmd.y2=evmd.ewin->min_height;
	}
	switch(cfg.resize_mode) {
		case 0:
	     		XDrawRectangle(disp,root,gc,evmd.x1,evmd.y1,
			    evmd.x2+ewin->border_l+ewin->border_r,
			    evmd.y2+ewin->border_t+ewin->border_b);
	     		XDrawRectangle(disp,root,gc,evmd.x1+ewin->border_l,
			    evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
			break;
		case 1:
	     		XFillRectangle(disp,root,gc,evmd.x1,evmd.y1,
			    evmd.x2+ewin->border_l+ewin->border_r,
			    evmd.y2+ewin->border_t+ewin->border_b);
	     		XFillRectangle(disp,root,gc,evmd.x1+ewin->border_l,
			    evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
			break;
	}
	first=1;
	Draw_Cursor(ewin,(evmd.x2-evmd.ewin->base_width)/evmd.ewin->sizeinc_x,(evmd.y2-evmd.ewin->base_height)/evmd.ewin->sizeinc_y, 'x', 0);
	XSync(disp,False);
	evmd.px+=wx;
	evmd.py+=wy;
     }
   XFreeGC(disp,gc);
   XUngrabServer(disp);
   Draw_Cursor(ewin, evmd.x1,evmd.y1, '+', 2);
   XUngrabPointer(disp, CurrentTime);
   ModifyEWin(evmd.ewin,evmd.x1,evmd.y1,evmd.x2,evmd.y2);
   XSync(disp,False);
/*   while (XCheckTypedEvent(disp,MotionNotify,&xev));*/
}

void MoveLoop(EWin *ewin, Window win)
{
   GC gc;
   XGCValues gcv;
   XEvent xev;     
   int first;
   int sx,sy;
   Window w1,w2;
   int x,y,xx,yy;
   int d;
   int wx,wy;
   Window dummyw;
   int dummy;
   int col;
   
   if (depth>8) col=WhitePixel(disp,screen);
   else col=1;
   first=0;
   XGrabServer(disp);
   XGrabPointer(disp, win, True, ButtonMotionMask|PointerMotionMask|ButtonReleaseMask|ButtonPressMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
   Draw_Cursor(ewin, ewin->frame_x, ewin->frame_y, '+', 1);
   gc=XCreateGC(disp,root,0,&gcv);
   XSetSubwindowMode(disp,gc,IncludeInferiors);
   XSetForeground(disp,gc,col);
   XSetFunction(disp,gc,GXxor);
   evmd.x1=ewin->frame_x;
   evmd.y1=ewin->frame_y;
   evmd.x2=ewin->client_width;
   evmd.y2=ewin->client_height;
   while (1)
     {
	XMaskEvent(disp,ButtonMotionMask|PointerMotionMask|ButtonReleaseMask,&xev);
        XQueryPointer(disp,root,&w1,&w2,&sx,&sy,&xx,&yy,&d);
	if (xev.type==ButtonRelease)
	  {
	     if (first)
	       {
		  XPutBackEvent(disp,&xev);
		  if (cfg.move_mode==0)
		    {
		       XDrawRectangle(disp,root,gc,evmd.x1,evmd.y1,
				      evmd.x2+ewin->border_l+ewin->border_r,
				      evmd.y2+ewin->border_t+ewin->border_b);
		       XDrawRectangle(disp,root,gc,evmd.x1+ewin->border_l,
				      evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
		    }
		  else if (cfg.move_mode==1) 
		    {
		       XFillRectangle(disp,root,gc,evmd.x1,evmd.y1,
				      evmd.x2+ewin->border_l+ewin->border_r,
				      evmd.y2+ewin->border_t+ewin->border_b);
		       XFillRectangle(disp,root,gc,evmd.x1+ewin->border_l,
				      evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
		    }
		  break;
	       }
	     else
	       {
		  XPutBackEvent(disp,&xev);
		  break;
	       }
	  }
	if (first)
	  {
	     if (cfg.move_mode==0)
	       {
		  XDrawRectangle(disp,root,gc,evmd.x1,evmd.y1,
				 evmd.x2+ewin->border_l+ewin->border_r,
				 evmd.y2+ewin->border_t+ewin->border_b);
		  XDrawRectangle(disp,root,gc,evmd.x1+ewin->border_l,
				 evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
	       }
	     else if (cfg.move_mode==1) 
	       {
		  XFillRectangle(disp,root,gc,evmd.x1,evmd.y1,
				 evmd.x2+ewin->border_l+ewin->border_r,
				 evmd.y2+ewin->border_t+ewin->border_b);
		  XFillRectangle(disp,root,gc,evmd.x1+ewin->border_l,
				 evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
	       }
	  }
        evmd.x1+=sx-evmd.px;
	evmd.y1+=sy-evmd.py;
	if (cfg.move_mode==0)
	  {
	     XDrawRectangle(disp,root,gc,evmd.x1,evmd.y1,
			    evmd.x2+ewin->border_l+ewin->border_r,
			    evmd.y2+ewin->border_t+ewin->border_b);
	     XDrawRectangle(disp,root,gc,evmd.x1+ewin->border_l,
			    evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
	  }
	else if (cfg.move_mode==1) 
	  {
	     XFillRectangle(disp,root,gc,evmd.x1,evmd.y1,
			    evmd.x2+ewin->border_l+ewin->border_r,
			    evmd.y2+ewin->border_t+ewin->border_b);
	     XFillRectangle(disp,root,gc,evmd.x1+ewin->border_l,
			    evmd.y1+ewin->border_t,evmd.x2,evmd.y2);
	  }
	first=1;
	Draw_Cursor(ewin, evmd.x1,evmd.y1, '+', 0);
	XSync(disp,False);
        evmd.px=sx;
	evmd.py=sy;
     }
   XFreeGC(disp,gc);
   XUngrabServer(disp);
   Draw_Cursor(ewin, evmd.x1,evmd.y1, '+', 2);
   XUngrabPointer(disp, CurrentTime);
   ModifyEWin(evmd.ewin,evmd.x1,evmd.y1,evmd.x2,evmd.y2);
   XSync(disp,False);
/*   while (XCheckTypedEvent(disp,MotionNotify,&xev));*/
}

void Draw_Cursor(EWin *ewin, int a, int b, char ch, int start)
{
   static Cursor cursor;
   static Pixmap pix, mask;
   static GC cursorgc;
   XGCValues gv;
   static XSetWindowAttributes attr;
   unsigned long msk;
   char font_string[512];
   char geom[32];
   static int height, width, ow, oh;
   static XColor col, col2;
   static XFontStruct *font;
   char *neg;
   int wid, hgt;
   
   if(start==1)
     {	
	sprintf(font_string,"-*-%s-%s-%s-*-*-%i-*-*-*-*-*-*-*",
		cfg.font,font_weight,font_slant,ccfg.num_size);
	font=XLoadQueryFont(disp,font_string);
	if (!font) return;
	height = font->max_bounds.ascent+font->max_bounds.descent + 2;
	width = 10*(font->max_bounds.rbearing-font->max_bounds.lbearing);
#ifdef BROKEN_XSERVER
	if (width>CURSOR_MAX_WIDTH) width=CURSOR_MAX_WIDTH;
	if (height>CURSOR_MAX_HEIGHT) height=CURSOR_MAX_HEIGHT;
#else
	XQueryBestCursor(disp,root,width,height,&wid,&hgt);
	if (width>wid) width=wid;
	if (height>hgt) height=hgt;
#endif
	pix = XCreatePixmap(disp, root, width, height, 1);
	mask = XCreatePixmap(disp, root, width, height, 1);
	msk = GCFont|GCForeground;
	gv.foreground=0;
	gv.font=font->fid;
	ow=0; oh=0;
	cursorgc=XCreateGC(disp, pix, msk, &gv);
        col.red=(ccfg.num_fg_r<<8)|ccfg.num_fg_r;
	col.green=(ccfg.num_fg_g<<8)|ccfg.num_fg_g;
	col.blue=(ccfg.num_fg_b<<8)|ccfg.num_fg_b;
	col2.red=(ccfg.num_bg_r<<8)|ccfg.num_bg_r;
	col2.green=(ccfg.num_bg_g<<8)|ccfg.num_bg_g;
	col2.blue=(ccfg.num_bg_b<<8)|ccfg.num_bg_b;
	XAllocColor(disp, root_cmap, &col);
	XAllocColor(disp, root_cmap, &col2);
	XFillRectangle(disp, mask, cursorgc, 0, 0, width, height);
	XFillRectangle(disp, pix, cursorgc, 0, 0, width, height);
     }
   else if (start==2) 
     {
	XFreeCursor(disp, cursor);
	XDefineCursor(disp, ewin->frame_win,None);
	XFreeGC(disp, cursorgc);
	XFreePixmap(disp, pix);
	XFreePixmap(disp, mask);
	XFreeFont(disp, font);
	return;
     }
   if(!font) return;
   if(ow!=a || oh!=b || start==1)
     {
	neg = "";
	if(a>=0 && ch == '+')
	  neg = "+";
	else if(ch == '+')
	  {
	     neg = "-";
	     a *= -1;
	  }
	if(b<0) 
	  {
	     ch = '-';
	     b *= -1;
	  }
	sprintf(geom, "%s%d%c%d", neg, a, ch, b);
	msk = strlen(geom);
	hgt = font->max_bounds.ascent;
	XSetForeground(disp, cursorgc, 1);
	XDrawString(disp, pix, cursorgc, 0, hgt, geom, msk);
	XDrawString(disp, pix, cursorgc, 0, hgt+2, geom, msk);
	XDrawString(disp, pix, cursorgc, 2, hgt, geom, msk);
	XDrawString(disp, pix, cursorgc, 2, hgt+2, geom, msk);
	
	XCopyArea(disp, pix, mask, cursorgc, 0, 0, width, height, 0, 0);
	
	XDrawString(disp, mask, cursorgc, 1, hgt+1, geom, msk);
	XSetForeground(disp, cursorgc, 0);
	XDrawString(disp, pix, cursorgc, 1, hgt+1, geom, msk);
	
	if (cursor) XFreeCursor(disp, cursor);
	cursor = XCreatePixmapCursor(disp, pix, mask, &col2, &col, 0, 0);
	msk = CWCursor;
	attr.cursor = cursor;
	XChangeWindowAttributes(disp, ewin->frame_win, msk, &attr);
	
	XFillRectangle(disp, mask, cursorgc, 0, 0, width, height);
	XFillRectangle(disp, pix, cursorgc, 0, 0, width, height);
	ow = (evmd.x2-evmd.ewin->base_width)/evmd.ewin->sizeinc_x;
	oh = (evmd.y2-evmd.ewin->base_height)/evmd.ewin->sizeinc_y;
     }
}
