/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.util.Hashtable;

class UNIXProcess
extends Process
implements Runnable {
    static Hashtable subprocs = null;
    private boolean isalive = false;
    private int exit_code;
    private FileDescriptor stdin_fd;
    private FileDescriptor stdout_fd;
    private FileDescriptor stderr_fd;
    private FileDescriptor sync_fd;
    int pid;
    private OutputStream stdin_stream;
    private InputStream raw_stdout;
    private InputStream raw_stderr;
    private ProcessInputStream piped_stdout_in;
    private ProcessInputStream piped_stderr_in;
    private PipedOutputStream piped_stdout_out;
    private PipedOutputStream piped_stderr_out;
    private int numReaders;

    private UNIXProcess() {
    }

    public native void run();

    private native int forkAndExec(String[] var1, String[] var2) throws IOException;

    private native void notifyReaders();

    private static void deadChild(int n, int n2) {
        UNIXProcess uNIXProcess = (UNIXProcess)subprocs.get(new Integer(n));
        if (uNIXProcess != null) {
            UNIXProcess uNIXProcess2 = uNIXProcess;
            synchronized (uNIXProcess2) {
                uNIXProcess.isalive = false;
                subprocs.remove(new Integer(n));
                uNIXProcess.exit_code = n2;
                uNIXProcess.notifyReaders();
                uNIXProcess.notifyAll();
                return;
            }
        }
    }

    synchronized int getNumReaders() throws InterruptedException {
        return this.numReaders;
    }

    synchronized void decrNumReaders() {
        if (--this.numReaders <= 0) {
            try {
                this.stdin_stream.close();
            }
            catch (IOException iOException) {}
            try {
                this.raw_stdout.close();
            }
            catch (IOException iOException) {}
            try {
                this.raw_stderr.close();
            }
            catch (IOException iOException) {}
        }
        this.notifyAll();
    }

    UNIXProcess(String[] stringArray, String[] stringArray2) throws IOException {
        this.stdin_fd = new FileDescriptor();
        this.stdout_fd = new FileDescriptor();
        this.stderr_fd = new FileDescriptor();
        this.sync_fd = new FileDescriptor();
        this.pid = this.forkAndExec(stringArray, stringArray2);
        this.isalive = true;
        SecurityManager.enablePrivilege("UniversalFdRead");
        SecurityManager.enablePrivilege("UniversalFdWrite");
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        this.stdin_stream = new BufferedOutputStream(new FileOutputStream(this.stdin_fd));
        this.raw_stdout = new FileInputStream(this.stdout_fd);
        this.raw_stderr = new FileInputStream(this.stderr_fd);
        this.piped_stdout_out = new PipedOutputStream();
        this.piped_stderr_out = new PipedOutputStream();
        this.piped_stdout_in = new ProcessInputStream(this, this.piped_stdout_out, this.raw_stdout);
        this.piped_stderr_in = new ProcessInputStream(this, this.piped_stderr_out, this.raw_stderr);
        Thread thread = new Thread(this.piped_stdout_in, "stdout reader pid=" + this.pid);
        Thread thread2 = new Thread(this.piped_stderr_in, "stderr reader pid=" + this.pid);
        this.numReaders = 2;
        thread.start();
        thread2.start();
        subprocs.put(new Integer(this.pid), this);
        FileOutputStream fileOutputStream = new FileOutputStream(this.sync_fd);
        fileOutputStream.write(65);
        fileOutputStream.close();
        SecurityManager.revertPrivilege();
    }

    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    public InputStream getInputStream() {
        return this.piped_stdout_in;
    }

    public InputStream getErrorStream() {
        return this.piped_stderr_in;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (this.isalive) {
            this.wait();
        }
        return this.exit_code;
    }

    public synchronized int exitValue() {
        if (this.isalive) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exit_code;
    }

    public native void destroy();

    static {
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        subprocs = new Hashtable();
        Thread thread = new Thread(new UNIXProcess(), "process reaper");
        thread.setDaemon(true);
        thread.start();
        SecurityManager.revertPrivilege();
    }
}

