/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPBERTagDecoder;

public class LDAPVirtualListControl
extends LDAPControl {
    public static final String VIRTUALLIST = "1.2.840.113556.1.4.319";
    private static final int TAG_BYINDEX = 0;
    private static final int TAG_BYFILTER = 1;
    private int m_beforeCount;
    private int m_afterCount;
    private int m_listIndex = -1;
    private int m_listSize = -1;

    LDAPVirtualListControl() {
        super(VIRTUALLIST, true, null);
    }

    public LDAPVirtualListControl(String string, int n, int n2) {
        super(VIRTUALLIST, true, null);
        this.m_value = this.createPageSpecification(string, n, n2);
    }

    public void setRange(int n, int n2, int n3) {
        this.m_beforeCount = n2;
        this.m_afterCount = n3;
        this.m_listIndex = n;
        this.m_value = this.createPageSpecification(this.m_listIndex, this.m_listSize, this.m_beforeCount, this.m_afterCount);
    }

    public int getListSize() {
        return this.m_listSize;
    }

    public int getBeforeCount() {
        return this.m_beforeCount;
    }

    public int getAfterCount() {
        return this.m_afterCount;
    }

    public LDAPVirtualListControl parseResponse() {
        LDAPVirtualListControl lDAPVirtualListControl = new LDAPVirtualListControl();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getValue());
        new BERSequence();
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        int[] nArray = new int[]{0};
        try {
            BERSequence bERSequence = (BERSequence)BERElement.getElement(jDAPBERTagDecoder, byteArrayInputStream, nArray);
            lDAPVirtualListControl.m_beforeCount = ((BERInteger)bERSequence.elementAt(0)).getValue();
            lDAPVirtualListControl.m_afterCount = ((BERInteger)bERSequence.elementAt(1)).getValue();
            BERTag bERTag = (BERTag)bERSequence.elementAt(2);
            if (bERTag.getType() != 128) {
                return null;
            }
            BERSequence bERSequence2 = (BERSequence)bERTag.getValue();
            lDAPVirtualListControl.m_listIndex = ((BERInteger)bERSequence2.elementAt(0)).getValue();
            lDAPVirtualListControl.m_listSize = ((BERInteger)bERSequence2.elementAt(1)).getValue();
        }
        catch (Throwable throwable) {
            return null;
        }
        return lDAPVirtualListControl;
    }

    public static LDAPVirtualListControl parseResponse(LDAPControl[] lDAPControlArray) {
        LDAPVirtualListControl lDAPVirtualListControl = null;
        int n = 0;
        while (lDAPControlArray != null && n < lDAPControlArray.length) {
            if (lDAPControlArray[n].getID().equals(VIRTUALLIST)) {
                lDAPVirtualListControl = (LDAPVirtualListControl)lDAPControlArray[n];
                break;
            }
            ++n;
        }
        if (lDAPVirtualListControl != null) {
            return lDAPVirtualListControl.parseResponse();
        }
        return null;
    }

    private byte[] createPageSpecification(String string, int n, int n2) {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BERInteger(n));
        bERSequence.addElement(new BERInteger(n2));
        bERSequence.addElement(new BERTag(129, new BEROctetString(string), true));
        return this.flattenBER(bERSequence);
    }

    private byte[] createPageSpecification(int n, int n2, int n3, int n4) {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BERInteger(n3));
        bERSequence.addElement(new BERInteger(n4));
        BERSequence bERSequence2 = new BERSequence();
        bERSequence2.addElement(new BERInteger(n));
        bERSequence2.addElement(new BERInteger(n2));
        bERSequence.addElement(new BERTag(128, bERSequence2, true));
        return this.flattenBER(bERSequence);
    }
}

