/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.TextField;
import java.awt.peer.TextFieldPeer;
import sun.awt.macos.ActionComponent;
import sun.awt.macos.InterfaceThread;
import sun.awt.macos.MComponentPeer;

public class MTextFieldPeer
extends MComponentPeer
implements TextFieldPeer,
ActionComponent {
    public MTextFieldPeer(TextField textField) {
        super(textField);
    }

    native void create(MComponentPeer var1);

    void initialize() {
        TextField textField = (TextField)this.target;
        this.setText(textField.getText());
        if (textField.echoCharIsSet()) {
            this.setEchoCharacter(textField.getEchoChar());
        }
        this.select(textField.getSelectionStart(), textField.getSelectionEnd());
        this.setEditable(textField.isEditable());
        super.initialize();
    }

    public void setBackground(Color color) {
        TextField textField = (TextField)this.target;
        if (textField.isEditable()) {
            color = color.brighter();
        }
        super.setBackground(color);
    }

    public native void setEditable(boolean var1);

    public native void select(int var1, int var2);

    public native int getSelectionStart();

    public native int getSelectionEnd();

    public native void setText(String var1);

    public native String getText();

    public native void setEchoCharacter(char var1);

    public Dimension minimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.stringWidth(((TextField)this.target).getText()) + 20, fontMetrics.getHeight() + 6);
    }

    public Dimension preferredSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.charWidth('0') * n + 20, fontMetrics.getHeight() + 6);
    }

    public void action() {
        this.target.postEvent(new Event(this.target, 1001, ((TextField)this.target).getText()));
    }

    public void action(boolean bl) {
        System.err.println("Internal AWT error");
    }

    public void action(int n) {
        System.err.println("Internal AWT error");
    }

    public void handleAction() {
        InterfaceThread.postInterfaceEvent(this.target);
    }
}

