/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ImageConsumer;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageInfoGrabber;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.InputStreamImageSource;

class ConsumerQueue {
    ImageConsumer consumer;
    Thread feeder;
    ImageDecoder decoder;
    ConsumerQueue next;
    boolean interested;
    Object securityContext;
    boolean secure;

    ConsumerQueue(InputStreamImageSource inputStreamImageSource, ImageConsumer imageConsumer) {
        this.consumer = imageConsumer;
        this.interested = true;
        if (imageConsumer instanceof ImageRepresentation) {
            ImageRepresentation imageRepresentation = (ImageRepresentation)imageConsumer;
            if (imageRepresentation.image.source != inputStreamImageSource) {
                throw new SecurityException("ImageRep added to wrong image source");
            }
            this.secure = true;
            return;
        }
        if (imageConsumer instanceof ImageInfoGrabber) {
            ImageInfoGrabber imageInfoGrabber = (ImageInfoGrabber)imageConsumer;
            if (imageInfoGrabber.image.source != inputStreamImageSource) {
                throw new SecurityException("ImageRep added to wrong image source");
            }
            this.secure = true;
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.securityContext = securityManager.getSecurityContext();
            return;
        }
        this.securityContext = null;
    }

    public String toString() {
        return "[" + this.consumer + " " + this.securityContext + "]";
    }
}

