/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import netscape.applet.AppletEvent;
import netscape.applet.NEvent;

class EventQueue {
    static final int MAX_EVENTS_NUMBER = 400;
    NEvent eventList = new AppletEvent(-1);
    int eventsCount = 0;

    public void destroy() {
        this.eventList = null;
    }

    public synchronized void sendEvent(NEvent nEvent) {
        this.eventList.appendElement(nEvent);
        this.notifyAll();
    }

    public synchronized void sendGUIEvent(NEvent nEvent) {
        if (this.eventsCount <= 400) {
            this.eventList.appendElement(nEvent);
            ++this.eventsCount;
            this.notifyAll();
        }
    }

    public synchronized NEvent getNextEvent() {
        NEvent nEvent = null;
        while (true) {
            if (!this.eventList.isEmptyList()) {
                nEvent = (NEvent)this.eventList.next;
                nEvent.remove();
                --this.eventsCount;
                break;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return nEvent;
            }
        }
        return nEvent;
    }

    public synchronized int getQueueSize() {
        return this.eventsCount;
    }

    public synchronized void removeEvents(Object object) {
        if (!this.eventList.isEmptyList()) {
            NEvent nEvent = (NEvent)this.eventList.next;
            while (nEvent != this.eventList) {
                if (object == nEvent.getTarget()) {
                    nEvent.remove();
                    --this.eventsCount;
                }
                nEvent = (NEvent)nEvent.next;
            }
        }
    }

    public synchronized void coalesceEvent(NEvent nEvent) {
        if (!this.eventList.isEmptyList()) {
            NEvent nEvent2 = (NEvent)this.eventList.next;
            while (nEvent2 != this.eventList) {
                if (nEvent.coalesce(nEvent2)) {
                    nEvent2.remove();
                    --this.eventsCount;
                    return;
                }
                nEvent2 = (NEvent)nEvent2.next;
            }
        }
    }
}

