/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class SimpleDateFormat
extends DateFormat {
    private String pattern;
    private DateFormatSymbols formatData;
    private static final int millisPerHour = 3600000;
    private static final int millisPerMinute = 60000;
    private static final String GMT_PLUS = "GMT+";
    private static final String GMT_MINUS = "GMT-";
    private static final String GMT = "GMT";

    public SimpleDateFormat() {
        this(3, 7, Locale.getDefault());
    }

    public SimpleDateFormat(String string) {
        this.pattern = string;
        this.formatData = new DateFormatSymbols();
        this.initialize(Locale.getDefault());
    }

    public SimpleDateFormat(String string, Locale locale) {
        this.pattern = string;
        this.formatData = new DateFormatSymbols(locale);
        this.initialize(locale);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.pattern = string;
        this.formatData = dateFormatSymbols;
        this.initialize(Locale.getDefault());
    }

    SimpleDateFormat(int n, int n2, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        this.formatData = new DateFormatSymbols(locale);
        String[] stringArray = resourceBundle.getStringArray("DateTimePatterns");
        if (n >= 0 && n2 >= 0) {
            Object[] objectArray = new Object[]{stringArray[n], stringArray[n2]};
            this.pattern = MessageFormat.format(stringArray[8], objectArray);
        } else if (n >= 0) {
            this.pattern = stringArray[n];
        } else if (n2 >= 0) {
            this.pattern = stringArray[n2];
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        this.initialize(locale);
    }

    private void initialize(Locale locale) {
        this.calendar = Calendar.getInstance((SimpleTimeZone)TimeZone.getTimeZone(this.formatData.zoneStrings[0][0]), locale);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        if (this.numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        this.numberFormat.setParseIntegerOnly(true);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.endIndex = 0;
        fieldPosition.beginIndex = 0;
        this.calendar.setTime(date);
        boolean bl = false;
        char c = '\u0000';
        int n = 0;
        int n2 = 0;
        while (n2 < this.pattern.length()) {
            char c2 = this.pattern.charAt(n2);
            if (bl) {
                if (c2 == '\'') {
                    bl = false;
                    if (n == 0) {
                        stringBuffer.append(c2);
                    } else {
                        n = 0;
                    }
                } else {
                    stringBuffer.append(c2);
                    ++n;
                }
            } else if (c2 == '\'') {
                bl = true;
                if (n > 0) {
                    stringBuffer.append(this.subFormat(c, n, stringBuffer.length(), fieldPosition));
                    n = 0;
                    c = '\u0000';
                }
            } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                if (c2 != c && n > 0) {
                    stringBuffer.append(this.subFormat(c, n, stringBuffer.length(), fieldPosition));
                    c = c2;
                    n = 1;
                } else {
                    if (c2 != c) {
                        c = c2;
                    }
                    ++n;
                }
            } else if (n > 0) {
                stringBuffer.append(this.subFormat(c, n, stringBuffer.length(), fieldPosition));
                stringBuffer.append(c2);
                c = '\u0000';
                n = 0;
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        if (n > 0) {
            stringBuffer.append(this.subFormat(c, n, stringBuffer.length(), fieldPosition));
        }
        return stringBuffer;
    }

    private String subFormat(char c, int n, int n2, FieldPosition fieldPosition) throws IllegalArgumentException {
        int n3 = 0;
        int n4 = -1;
        String string = "";
        n4 = "GyMdkHmsSEDFwWahKz".indexOf(c);
        if (n4 == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + c + "'");
        }
        switch (n4) {
            case 0: {
                n3 = this.calendar.get(0);
                string = this.formatData.eras[n3];
                break;
            }
            case 1: {
                n3 = this.calendar.get(1);
                if (n >= 4) {
                    string = this.zeroPaddingNumber(n3, 4, 10);
                    break;
                }
                string = this.zeroPaddingNumber(n3, 2, 2);
                break;
            }
            case 2: {
                n3 = this.calendar.get(2);
                if (n >= 4) {
                    string = this.formatData.months[n3];
                    break;
                }
                if (n == 3) {
                    string = this.formatData.shortMonths[n3];
                    break;
                }
                string = this.zeroPaddingNumber(n3 + 1, n, 10);
                break;
            }
            case 3: {
                n3 = this.calendar.get(5);
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 4: {
                n3 = this.calendar.get(11);
                if (n3 == 0) {
                    string = this.zeroPaddingNumber(this.calendar.getMaximum(11) + 1, n, 10);
                    break;
                }
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 5: {
                n3 = this.calendar.get(11);
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 6: {
                n3 = this.calendar.get(12);
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 7: {
                n3 = this.calendar.get(13);
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 8: {
                n3 = this.calendar.get(14);
                if (n > 3) {
                    n = 3;
                } else if (n == 2) {
                    n3 /= 10;
                } else if (n == 1) {
                    n3 /= 100;
                }
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 9: {
                n3 = this.calendar.get(7);
                if (n >= 4) {
                    string = this.formatData.weekdays[n3];
                    break;
                }
                string = this.formatData.shortWeekdays[n3];
                break;
            }
            case 10: {
                n3 = this.calendar.get(6);
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 11: {
                n3 = this.calendar.get(8);
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 12: {
                n3 = this.calendar.get(3);
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 13: {
                n3 = this.calendar.get(4);
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 14: {
                n3 = this.calendar.get(9);
                string = this.formatData.ampms[n3];
                break;
            }
            case 15: {
                n3 = this.calendar.get(10);
                if (n3 == 0) {
                    string = this.zeroPaddingNumber(this.calendar.getLeastMaximum(10) + 1, n, 10);
                    break;
                }
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 16: {
                n3 = this.calendar.get(10);
                string = this.zeroPaddingNumber(n3, n, 10);
                break;
            }
            case 17: {
                int n5 = this.formatData.getZoneIndex(this.calendar.getTimeZone().getID());
                if (n5 == -1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    n3 = this.calendar.get(15) + this.calendar.get(16);
                    if (n3 < 0) {
                        stringBuffer.append(GMT_MINUS);
                        n3 = -n3;
                    } else {
                        stringBuffer.append(GMT_PLUS);
                    }
                    stringBuffer.append(this.zeroPaddingNumber(n3 / 3600000, 2, 2));
                    stringBuffer.append(':');
                    stringBuffer.append(this.zeroPaddingNumber(n3 % 3600000 / 60000, 2, 2));
                    string = stringBuffer.toString();
                    break;
                }
                if (this.calendar.get(16) != 0) {
                    if (n >= 4) {
                        string = this.formatData.zoneStrings[n5][3];
                        break;
                    }
                    string = this.formatData.zoneStrings[n5][4];
                    break;
                }
                string = n >= 4 ? this.formatData.zoneStrings[n5][1] : this.formatData.zoneStrings[n5][2];
            }
        }
        if (fieldPosition.field == n4 && fieldPosition.beginIndex == 0 && fieldPosition.endIndex == 0) {
            fieldPosition.beginIndex = n2;
            fieldPosition.endIndex = n2 + string.length();
        }
        return string;
    }

    private String zeroPaddingNumber(long l, int n, int n2) {
        this.numberFormat.setMinimumIntegerDigits(n);
        this.numberFormat.setMaximumIntegerDigits(n2);
        return this.numberFormat.format(l);
    }

    public Date parse(String string, ParsePosition parsePosition) {
        int n;
        int n2 = n = parsePosition.index;
        this.calendar.clear();
        boolean bl = false;
        char c = '\u0000';
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.pattern.length()) {
            char c2 = this.pattern.charAt(n4);
            if (bl) {
                if (c2 == '\'') {
                    bl = false;
                    if (c == '\'') {
                        ++n;
                    }
                } else {
                    if (c2 != string.charAt(n)) {
                        parsePosition.index = n2;
                        return null;
                    }
                    ++n;
                    c = c2;
                }
            } else if (c2 == '\'') {
                bl = true;
                if (n3 > 0) {
                    if ((n = this.subParse(string, n, c, n3)) < 0) {
                        parsePosition.index = n2;
                        return null;
                    }
                    n3 = 0;
                }
                c = c2;
            } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                if (c2 != c && n3 > 0) {
                    if ((n = this.subParse(string, n, c, n3)) < 0) {
                        parsePosition.index = n2;
                        return null;
                    }
                    c = c2;
                    n3 = 1;
                } else {
                    if (c2 != c) {
                        c = c2;
                    }
                    ++n3;
                }
            } else if (n3 > 0) {
                if ((n = this.subParse(string, n, c, n3)) < 0) {
                    parsePosition.index = n2;
                    return null;
                }
                if (c2 != string.charAt(n)) {
                    parsePosition.index = n2;
                    return null;
                }
                ++n;
                n3 = 0;
                c = '\u0000';
            } else {
                if (c2 != string.charAt(n)) {
                    parsePosition.index = n2;
                    return null;
                }
                ++n;
            }
            ++n4;
        }
        if (n3 > 0 && (n = this.subParse(string, n, c, n3)) < 0) {
            parsePosition.index = n2;
            return null;
        }
        parsePosition.index = n;
        if (!this.calendar.isSet(1)) {
            this.calendar.set(1, 1970);
        }
        if (!this.calendar.isSet(2)) {
            this.calendar.set(2, 0);
        }
        if (!this.calendar.isSet(5)) {
            this.calendar.set(5, 1);
        }
        if (!this.calendar.isSet(11) && !this.calendar.isSet(10)) {
            this.calendar.set(11, 0);
        }
        if (!this.calendar.isSet(12)) {
            this.calendar.set(12, 0);
        }
        if (!this.calendar.isSet(13)) {
            this.calendar.set(13, 0);
        }
        if (!this.calendar.isSet(14)) {
            this.calendar.set(14, 0);
        }
        if (!this.calendar.isSet(0)) {
            this.calendar.set(0, 1);
        }
        return this.calendar.getTime();
    }

    private int matchString(String string, int n, int n2, String[] stringArray) {
        int n3 = 0;
        int n4 = stringArray.length;
        if (n2 == 7) {
            n3 = 1;
        }
        while (n3 < n4) {
            if (stringArray[n3].length() != 0 && string.regionMatches(true, n, stringArray[n3], 0, stringArray[n3].length())) break;
            ++n3;
        }
        if (n3 >= n4) {
            return -n;
        }
        this.calendar.set(n2, n3);
        return n + stringArray[n3].length();
    }

    private int subParse(String string, int n, char c, int n2) {
        int n3 = 0;
        ParsePosition parsePosition = new ParsePosition(0);
        int n4 = -1;
        n4 = "GyMdkHmsSEDFwWahKz".indexOf(c);
        if (n4 == -1) {
            return -n;
        }
        parsePosition.index = n;
        switch (n4) {
            case 0: {
                return this.matchString(string, n, 0, this.formatData.eras);
            }
            case 1: {
                if (n2 >= 4) {
                    n3 = (int)Integer.valueOf(string.substring(n, n + n2)).longValue();
                    this.calendar.set(1, n3);
                } else {
                    n3 = (int)Integer.valueOf(string.substring(n, n + 2)).longValue();
                    this.calendar.set(1, n3 + 1900);
                }
                return n + n2;
            }
            case 2: {
                if (n2 <= 2) {
                    this.calendar.set(2, this.numberFormat.parse(string, parsePosition).intValue() - 1);
                    return parsePosition.index;
                }
                int n5 = 0;
                n5 = this.matchString(string, n, 2, this.formatData.months);
                if (n5 > 0) {
                    return n5;
                }
                return this.matchString(string, n, 2, this.formatData.shortMonths);
            }
            case 3: {
                this.calendar.set(5, this.numberFormat.parse(string, parsePosition).intValue());
                return parsePosition.index;
            }
            case 4: {
                n3 = this.numberFormat.parse(string, parsePosition).intValue();
                if (n3 == this.calendar.getMaximum(11) + 1) {
                    this.calendar.set(11, 0);
                } else {
                    this.calendar.set(11, n3);
                }
                return parsePosition.index;
            }
            case 5: {
                this.calendar.set(11, this.numberFormat.parse(string, parsePosition).intValue());
                return parsePosition.index;
            }
            case 6: {
                this.calendar.set(12, this.numberFormat.parse(string, parsePosition).intValue());
                return parsePosition.index;
            }
            case 7: {
                this.calendar.set(13, this.numberFormat.parse(string, parsePosition).intValue());
                return parsePosition.index;
            }
            case 8: {
                this.calendar.set(14, this.numberFormat.parse(string, parsePosition).intValue());
                return parsePosition.index;
            }
            case 9: {
                int n6 = 0;
                n6 = this.matchString(string, n, 7, this.formatData.weekdays);
                if (n6 > 0) {
                    return n6;
                }
                return this.matchString(string, n, 7, this.formatData.shortWeekdays);
            }
            case 10: {
                this.calendar.set(6, this.numberFormat.parse(string, parsePosition).intValue());
                return parsePosition.index;
            }
            case 11: {
                this.calendar.set(8, this.numberFormat.parse(string, parsePosition).intValue());
                return parsePosition.index;
            }
            case 12: {
                this.calendar.set(3, this.numberFormat.parse(string, parsePosition).intValue());
                return parsePosition.index;
            }
            case 13: {
                this.calendar.set(4, this.numberFormat.parse(string, parsePosition).intValue());
                return parsePosition.index;
            }
            case 14: {
                return this.matchString(string, n, 9, this.formatData.ampms);
            }
            case 15: {
                n3 = this.numberFormat.parse(string, parsePosition).intValue();
                if (n3 == this.calendar.getLeastMaximum(10) + 1) {
                    this.calendar.set(10, 0);
                } else {
                    this.calendar.set(10, n3);
                }
                return parsePosition.index;
            }
            case 16: {
                this.calendar.set(10, this.numberFormat.parse(string, parsePosition).intValue());
                return parsePosition.index;
            }
            case 17: {
                int n7;
                int n8 = 0;
                while (n8 < this.formatData.zoneStrings.length) {
                    n7 = 1;
                    while (n7 <= 4) {
                        if (string.regionMatches(true, n, this.formatData.zoneStrings[n8][n7], 0, this.formatData.zoneStrings[n8][n7].length())) break;
                        ++n7;
                    }
                    if (n7 <= 4) {
                        this.calendar.set(15, TimeZone.getTimeZone(this.formatData.zoneStrings[n8][0]).getRawOffset());
                        if (n7 >= 3) {
                            this.calendar.set(16, 3600000);
                        }
                        return n + this.formatData.zoneStrings[n8][n7].length();
                    }
                    ++n8;
                }
                if (string.regionMatches(true, n, GMT, 0, GMT.length())) {
                    int n9;
                    this.calendar.set(16, 0);
                    parsePosition.index = n + GMT.length();
                    n7 = 0;
                    if (string.regionMatches(parsePosition.index, "+", 0, 1)) {
                        n9 = 1;
                    } else if (string.regionMatches(parsePosition.index, "-", 0, 1)) {
                        n9 = -1;
                    } else {
                        this.calendar.set(15, 0);
                        return parsePosition.index;
                    }
                    ++parsePosition.index;
                    Number number = this.numberFormat.parse(string, parsePosition);
                    if (number == null) {
                        return -n;
                    }
                    if (string.regionMatches(parsePosition.index, ":", 0, 1)) {
                        n7 = number.intValue() * 60;
                        ++parsePosition.index;
                        number = this.numberFormat.parse(string, parsePosition);
                        if (number == null) {
                            return -n;
                        }
                        n7 += number.intValue();
                    } else {
                        int n10 = number.intValue();
                        n7 = n10 < 24 ? n10 * 60 : n10 % 100 + n10 / 100 * 60;
                    }
                    this.calendar.set(15, n7 * 60000 * n9);
                    return parsePosition.index;
                }
                DecimalFormat decimalFormat = new DecimalFormat("+####;-####", new DecimalFormatSymbols(Locale.US));
                Number number = decimalFormat.parse(string, parsePosition);
                if (number == null) {
                    return -n;
                }
                int n11 = number.intValue();
                int n12 = 1;
                if (n11 < 0) {
                    n12 = -1;
                    n11 *= -1;
                }
                n11 = n11 < 24 ? (n11 *= 60) : n11 % 100 + n11 / 100 * 60;
                this.calendar.set(15, n11 * 60000 * n12);
                return parsePosition.index;
            }
        }
        return -n;
    }

    private String translatePattern(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl) {
                if (c == '\'') {
                    bl = false;
                }
            } else if (c == '\'') {
                bl = true;
            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                int n2 = string2.indexOf(c);
                if (n2 == -1) {
                    throw new IllegalArgumentException("Illegal pattern  character '" + c + "'");
                }
                c = string3.charAt(n2);
            }
            stringBuffer.append(c);
            ++n;
        }
        if (bl) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return stringBuffer.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKz", this.formatData.localPatternChars);
    }

    public void applyPattern(String string) {
        this.pattern = string;
    }

    public void applyLocalizedPattern(String string) {
        this.pattern = this.translatePattern(string, this.formatData.localPatternChars, "GyMdkHmsSEDFwWahKz");
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
    }

    public Object clone() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.clone();
        simpleDateFormat.formatData = (DateFormatSymbols)this.formatData.clone();
        return simpleDateFormat;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        return this.pattern.equals(simpleDateFormat.pattern) && this.formatData.equals(simpleDateFormat.formatData);
    }
}

