/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.Graphics;
import java.awt.Rectangle;
import netscape.application.Event;
import netscape.application.Rect;

class ApplicationEvent
extends Event {
    static final int GOT_FOCUS = -21;
    static final int LOST_FOCUS = -22;
    static final int UPDATE = -23;
    static final int RESIZE = -24;
    static final int STOP = -25;
    static final int APPLET_STOPPED = -26;
    static final int APPLET_STARTED = -27;
    static final int PRINT = -28;
    Object data;

    static ApplicationEvent newResizeEvent(int n, int n2) {
        ApplicationEvent applicationEvent = new ApplicationEvent();
        applicationEvent.type = -24;
        applicationEvent.data = new Rect(0, 0, n, n2);
        return applicationEvent;
    }

    static ApplicationEvent newUpdateEvent(Graphics graphics) {
        ApplicationEvent applicationEvent = new ApplicationEvent();
        Rectangle rectangle = graphics.getClipRect();
        applicationEvent.type = -23;
        applicationEvent.data = rectangle == null ? new Rect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE) : new Rect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return applicationEvent;
    }

    static ApplicationEvent newFocusEvent(boolean bl) {
        ApplicationEvent applicationEvent = new ApplicationEvent();
        applicationEvent.type = bl ? -21 : -22;
        return applicationEvent;
    }

    static ApplicationEvent newPrintEvent(Graphics graphics) {
        ApplicationEvent applicationEvent = new ApplicationEvent();
        applicationEvent.type = -28;
        applicationEvent.data = graphics;
        return applicationEvent;
    }

    public String toString() {
        String string;
        switch (this.type) {
            case -21: {
                string = "GotFocus";
                break;
            }
            case -22: {
                string = "LostFocus";
                break;
            }
            case -23: {
                string = "Update";
                break;
            }
            case -24: {
                string = "Resize";
                break;
            }
            case -25: {
                string = "Stop";
                break;
            }
            case -26: {
                string = "AppletStopped";
                break;
            }
            case -27: {
                string = "AppletStarted";
                break;
            }
            case -28: {
                string = "Print";
                break;
            }
            default: {
                string = "Unknown Type";
            }
        }
        return "ApplicationEvent: " + string;
    }

    Rect rect() {
        return (Rect)this.data;
    }

    Graphics graphics() {
        return (Graphics)this.data;
    }

    ApplicationEvent() {
    }
}

