@echo off
REM
REM Licensed Materials - Copyright 1998 Sun Microsystems, Inc., 
REM 901 San Antonio Road,REM Palo Alto, California 94303, U.S.A.
REM Property of IBM, 5639-G54, (c) Copyright IBM Corp. 1997, 1998 
REM
REM
REM This batch file will build the sample configuration bean.  
REM
REM Usage: build "<samplename>"
REM
REM where "<samplename>" is the name of the directory containing
REM the sample config code.  For example, EEPro100cfg.
REM

REM
REM error check
REM
if '%1'=='' goto oops

REM
REM Make the prereq directory structure
REM

:MAKEDIRS
echo Creating directories...
mkdir build
mkdir build\com
mkdir build\com\ibm
mkdir build\com\ibm\joscfg
mkdir build\com\ibm\joscfg\services
mkdir build\com\ibm\joscfg\services\mri
mkdir build\com\ibm\joscfg\%1
mkdir build\com\ibm\joscfg\%1\mri
mkdir build\META-JCT

REM
REM compile java files
REM
echo Compiling java files in services directory...
cd ..\services
javac *.java
cd ..\%1


REM
REM Copy the files into this new directory structure
REM

:COPYFILES
echo Copying files...
copy mri\* build\com\ibm\joscfg\%1\mri
copy service.properties build
copy MANIFEST.MF  build
copy MANIFEST.JCT build\META-JCT
xcopy ..\services\*.class build\com\ibm\joscfg\services /s
copy ..\services\mri\* build\com\ibm\joscfg\services\mri

REM
REM now create the jar file
REM

:BUILDIT
echo Building JAR file
cd build
jar cfm %1.jar MANIFEST.MF com/ibm/joscfg/%1/mri/* com/ibm/joscfg/services/* service.properties META-JCT/MANIFEST.JCT

:CLEAN
echo Cleaning up
cd ..
copy build\%1.jar .
rem rd /s /q build
deltree /Y build

echo Done...
goto done

REM
REM if there is an error in parameters, come here
REM
:oops
echo "Usage: build <samplename>"

:done
